/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.wmotables.service;

import edu.ucar.unidata.wmotables.domain.Table;
import edu.ucar.unidata.wmotables.domain.User;
import edu.ucar.unidata.wmotables.repository.TableDao;
import edu.ucar.unidata.wmotables.service.TableManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.beans.factory.annotation.Value;

public class TableManagerImpl
implements TableManager {
    private TableDao tableDao;
    @Value(value="${wmotables.home}")
    private String wmotablesHome;

    public void setTableDao(TableDao tableDao) {
        this.tableDao = tableDao;
    }

    @Override
    public Table lookupTable(int tableId) {
        return this.tableDao.lookupTable(tableId);
    }

    @Override
    public List<Table> getTableList() {
        return this.tableDao.getTableList();
    }

    @Override
    public List<Table> getTableList(int userId) {
        return this.tableDao.getTableList(userId);
    }

    @Override
    public List<Table> getTableList(User user) {
        return this.tableDao.getTableList(user);
    }

    @Override
    public int getTableCount() {
        return this.tableDao.getTableCount();
    }

    @Override
    public int getTableCount(int userId) {
        return this.tableDao.getTableCount(userId);
    }

    @Override
    public int getTableCount(User user) {
        return this.tableDao.getTableCount(user);
    }

    @Override
    public void toggleTableVisibility(Table table) {
        this.tableDao.toggleTableVisibility(table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createTable(Table table) throws IOException {
        File tableStashDir = new File(this.wmotablesHome + "/tables");
        if (!tableStashDir.exists() && !tableStashDir.mkdirs()) {
            throw new IOException("Unable to create the following directory: " + tableStashDir);
        }
        byte[] fileData = table.getFile().getFileItem().get();
        String md5 = DigestUtils.md5Hex((byte[])fileData);
        table.setMd5(md5);
        table.setDateCreated(new Date(System.currentTimeMillis()));
        table.setDateModified(new Date(System.currentTimeMillis()));
        this.tableDao.createTable(table);
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(new File(tableStashDir + "/" + md5));
            outputStream.write(fileData);
            outputStream.flush();
        }
        finally {
            outputStream.close();
        }
    }

    @Override
    public void updateTable(Table table) {
        table.setDateModified(new Date(System.currentTimeMillis()));
        this.tableDao.updateTable(table);
    }
}

