/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.wmotables.service;

import edu.ucar.unidata.wmotables.domain.Table;
import edu.ucar.unidata.wmotables.repository.TableDao;
import edu.ucar.unidata.wmotables.service.TableManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;

public class TableManagerImpl
implements TableManager {
    private TableDao tableDao;
    protected static Logger logger = Logger.getLogger(TableManagerImpl.class);
    @Value(value="${wmotables.home}")
    private String wmotablesHome;

    public void setTableDao(TableDao tableDao) {
        this.tableDao = tableDao;
    }

    @Override
    public Table lookupTable(int tableId) {
        return this.tableDao.lookupTable(tableId);
    }

    @Override
    public Table lookupTable(String checkSum) {
        return this.tableDao.lookupTable(checkSum);
    }

    @Override
    public List<Table> getTableList() {
        return this.tableDao.getTableList();
    }

    @Override
    public List<Table> getTableList(int userId) {
        return this.tableDao.getTableList(userId);
    }

    @Override
    public int getTableCount() {
        return this.tableDao.getTableCount();
    }

    @Override
    public int getTableCount(int userId) {
        return this.tableDao.getTableCount(userId);
    }

    @Override
    public void toggleTableVisibility(Table table) {
        this.tableDao.toggleTableVisibility(table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createTable(Table table) throws IOException {
        File tableStashDir = new File(this.wmotablesHome + "/tables/");
        if (!tableStashDir.exists() && !tableStashDir.mkdirs()) {
            throw new IOException("Unable to create the following directory: " + tableStashDir);
        }
        byte[] fileData = table.getFile().getFileItem().get();
        String checksum = DigestUtils.md5Hex((byte[])fileData);
        table.setChecksum(checksum);
        table.setDateCreated(new Date(System.currentTimeMillis()));
        table.setDateModified(new Date(System.currentTimeMillis()));
        this.tableDao.createTable(table);
        FileOutputStream outputStream = null;
        try {
            File file = new File(tableStashDir + "/" + table.getChecksum());
            outputStream = new FileOutputStream(file);
            outputStream.write(fileData);
            outputStream.flush();
        }
        finally {
            outputStream.close();
        }
    }

    @Override
    public void updateTable(Table table) {
        table.setDateModified(new Date(System.currentTimeMillis()));
        this.tableDao.updateTable(table);
    }

    @Override
    public void downloadTableFile(String action, Table table, HttpServletResponse response) throws RuntimeException {
        File tableFile = new File(this.wmotablesHome + "/tables/" + table.getChecksum());
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(tableFile);
            if (action.equals("view")) {
                response.setContentType(table.getMimeType());
            } else {
                response.setContentType("application/wmotables");
            }
            IOUtils.copy((InputStream)inputStream, (OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage());
            }
        }
    }
}

