/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.wmotables;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ApplicationInitialization
implements ServletContextListener {
    protected static Logger logger = Logger.getLogger(ApplicationInitialization.class);
    private static final String DEFAULT_HOME = System.getProperty("catalina.base") + "/content/wmotables";
    private static final String DEFAULT_DATABASE = "derby";
    private String wmotablesHome = null;
    private String databaseSelected = null;

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        try {
            File configFile = new File(servletContext.getRealPath("") + "/WEB-INF/classes/wmotables.properties");
            if (!configFile.exists()) {
                logger.info((Object)"Configuration file not provided.");
                logger.info((Object)("Using wmotables.home default: " + DEFAULT_HOME));
                this.wmotablesHome = DEFAULT_HOME;
                logger.info((Object)"Using wmotables.db default: derby");
                this.databaseSelected = DEFAULT_DATABASE;
            } else {
                String currentLine;
                logger.info((Object)"Reading configuration file.");
                BufferedReader reader = new BufferedReader(new FileReader(configFile));
                while ((currentLine = reader.readLine()) != null) {
                    String lineData = StringUtils.stripToNull((String)currentLine);
                    if (lineData == null) continue;
                    if (lineData.startsWith("wmotables.home")) {
                        this.wmotablesHome = StringUtils.removeStart((String)lineData, (String)"wmotables.home=");
                        logger.info((Object)("wmotables.home set to: " + this.wmotablesHome));
                    }
                    if (!lineData.startsWith("wmotables.db")) continue;
                    this.databaseSelected = StringUtils.removeStart((String)lineData, (String)"wmotables.db=");
                    logger.info((Object)("wmotables.db set to: " + this.databaseSelected));
                }
                if (this.wmotablesHome == null) {
                    logger.info((Object)"Configuration file does not contain wmotables.home information.");
                    logger.info((Object)("Using wmotables.home default: " + DEFAULT_HOME));
                    this.wmotablesHome = DEFAULT_HOME;
                }
                if (this.databaseSelected == null) {
                    logger.info((Object)"Configuration file does not contain wmotables.db information.");
                    logger.info((Object)"Using wmotables.db default: derby");
                    this.databaseSelected = DEFAULT_DATABASE;
                }
            }
            this.createDirectory(new File(this.wmotablesHome));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
        try {
            this.createDatabase(this.wmotablesHome, this.databaseSelected, servletContext);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (this.databaseSelected.equals(DEFAULT_DATABASE)) {
            String derbyUrl = "jdbc:derby:" + this.wmotablesHome + "/db/wmotables";
            try {
                DriverManager.getConnection(derbyUrl + ";shutdown=true");
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage());
            }
        }
    }

    public void createDirectory(File file) throws RuntimeException {
        if (!file.exists()) {
            logger.info((Object)"Creating wmotables.home...");
            if (!file.mkdirs()) {
                throw new RuntimeException("Unable to create the following directory: " + file);
            }
        }
    }

    public void createDatabase(String wmotablesHome, String databaseSelected, ServletContext servletContext) {
        if (databaseSelected.equals(DEFAULT_DATABASE)) {
            String derbyDriver = "org.apache.derby.jdbc.EmbeddedDriver";
            String derbyUrl = "jdbc:derby:" + wmotablesHome + "/db/wmotables";
            if (!new File(wmotablesHome + "/db/wmotables").exists()) {
                logger.info((Object)"Database does not exist yet.  Creating...");
                try {
                    this.createDirectory(new File(wmotablesHome + "/db"));
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage());
                }
                try {
                    ApplicationInitialization.createTables(derbyDriver, derbyUrl + ";create=true", null, null, servletContext);
                    DriverManager.getConnection(derbyUrl + ";shutdown=true");
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage());
                }
            } else {
                logger.info((Object)"Database already exists.");
                logger.info((Object)"Our work here is done.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createTables(String driver, String url, String username, String password, ServletContext servletContext) throws SQLException {
        Connection connection = null;
        Statement preparedStatement = null;
        String createUsersTableSQL = "CREATE TABLE users(userId INTEGER primary key not null GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1), userName VARCHAR(50) not null, password CHAR(32) not null, accessLevel INTEGER not null, emailAddress VARCHAR(75) not null, fullName VARCHAR(75) not null, center INTEGER not null, subCenter INTEGER not null, dateCreated TIMESTAMP not null, dateModified TIMESTAMP not null)";
        String createTablesTableSQL = "CREATE TABLE tables(tableId INTEGER primary key not null GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1), title VARCHAR(75) not null, description VARCHAR(255) not null, originalName VARCHAR(100) not null, masterVersion INTEGER, localVersion INTEGER not null, center INTEGER not null, subCenter INTEGER not null, mimeType VARCHAR(100) not null, tableType VARCHAR(100) not null, checkSum CHAR(32) not null, visibility INTEGER not null, userId INTEGER not null, dateCreated TIMESTAMP not null, dateModified TIMESTAMP not null)";
        String createCentersTableSQL = "CREATE TABLE centers(centerId INTEGER primary key not null, name VARCHAR(255) not null )";
        String createSubCentersTableSQL = "CREATE TABLE subCenters(subCenterId INTEGER primary key not null, centerId INTEGER not null, name VARCHAR(255) not null )";
        String insertAdminUserSQL = "INSERT INTO users (userName, password, accessLevel, emailAddress, fullName, center, subCenter, dateCreated, dateModified) VALUES (?,?,?,?,?,?,?,?,?)";
        String insertCentersSQL = "INSERT INTO centers (centerId, name) VALUES (?,?)";
        String insertSubCentersSQL = "INSERT INTO subCenters (subCenterId, centerId, name) VALUES (?,?,?)";
        try {
            connection = ApplicationInitialization.getDatabaseConnection(driver, url, username, password);
            preparedStatement = connection.prepareStatement(createUsersTableSQL);
            preparedStatement.executeUpdate();
            preparedStatement = connection.prepareStatement(createTablesTableSQL);
            preparedStatement.executeUpdate();
            preparedStatement = connection.prepareStatement(insertAdminUserSQL);
            preparedStatement.setString(1, "admin");
            preparedStatement.setString(2, "4cb9c8a8048fd02294477fcb1a41191a");
            preparedStatement.setInt(3, 2);
            preparedStatement.setString(4, "plaza@unidata.ucar.edu");
            preparedStatement.setString(5, "WMO Tables Admin");
            preparedStatement.setInt(6, 1);
            preparedStatement.setInt(7, 1);
            preparedStatement.setTimestamp(8, new Timestamp(System.currentTimeMillis()));
            preparedStatement.setTimestamp(9, new Timestamp(System.currentTimeMillis()));
            preparedStatement.executeUpdate();
            preparedStatement = connection.prepareStatement(createCentersTableSQL);
            preparedStatement.executeUpdate();
            preparedStatement = connection.prepareStatement(insertCentersSQL);
            Map<String, String> centers = ApplicationInitialization.getCenters(servletContext);
            for (Map.Entry<String, String> mapEntry : centers.entrySet()) {
                preparedStatement.setInt(1, new Integer(mapEntry.getKey()));
                preparedStatement.setString(2, mapEntry.getValue());
                preparedStatement.executeUpdate();
            }
            preparedStatement = connection.prepareStatement(createSubCentersTableSQL);
            preparedStatement.executeUpdate();
            preparedStatement = connection.prepareStatement(insertSubCentersSQL);
            Map<String, Map> subCenters = ApplicationInitialization.getSubCenters(servletContext);
            for (Map.Entry<String, Map> mapEntry : subCenters.entrySet()) {
                preparedStatement.setInt(1, new Integer(mapEntry.getKey()));
                Map map = mapEntry.getValue();
                for (Map.Entry mEntry : map.entrySet()) {
                    preparedStatement.setInt(2, new Integer((String)mEntry.getKey()));
                    preparedStatement.setString(3, (String)mEntry.getValue());
                }
                preparedStatement.executeUpdate();
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    private static Connection getDatabaseConnection(String driver, String url, String username, String password) {
        Connection connection = null;
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e.getMessage());
        }
        try {
            connection = username != null && password != null ? DriverManager.getConnection(url, username, password) : DriverManager.getConnection(url);
            return connection;
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            return connection;
        }
    }

    private static Map<String, String> getCenters(ServletContext servletContext) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            File centers = new File(servletContext.getRealPath("") + "/WEB-INF/classes/resources/centers.csv");
            if (centers.exists()) {
                String currentLine;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(centers));
                while ((currentLine = bufferedReader.readLine()) != null) {
                    String[] lineComponents = StringUtils.normalizeSpace((String)currentLine).split("; ");
                    map.put(lineComponents[0], lineComponents[1]);
                }
                bufferedReader.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
        return map;
    }

    private static Map<String, Map> getSubCenters(ServletContext servletContext) {
        HashMap<String, Map> map = new HashMap<String, Map>();
        try {
            File subcenters = new File(servletContext.getRealPath("") + "/WEB-INF/classes/resources/subcenters.csv");
            if (subcenters.exists()) {
                String currentLine;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(subcenters));
                while ((currentLine = bufferedReader.readLine()) != null) {
                    String[] lineComponents = StringUtils.normalizeSpace((String)currentLine).split("; ");
                    HashMap<String, String> m = new HashMap<String, String>();
                    m.put(lineComponents[0], lineComponents[2]);
                    map.put(lineComponents[1], m);
                }
                bufferedReader.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
        return map;
    }
}

