/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.wmotables.controller;

import edu.ucar.unidata.wmotables.domain.Table;
import edu.ucar.unidata.wmotables.domain.User;
import edu.ucar.unidata.wmotables.service.TableManager;
import edu.ucar.unidata.wmotables.service.UserManager;
import edu.ucar.unidata.wmotables.service.UserValidator;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.RecoverableDataAccessException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class UserController
implements HandlerExceptionResolver {
    protected static Logger logger = Logger.getLogger(UserController.class);
    @Resource(name="userManager")
    private UserManager userManager;
    @Resource(name="tableManager")
    private TableManager tableManager;
    @Autowired
    private UserValidator userValidator;

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.setValidator((Validator)this.userValidator);
    }

    @RequestMapping(value={"/user"}, method={RequestMethod.GET})
    public String listUsers(Model model) {
        List<User> users = this.userManager.getUserList();
        model.addAttribute("users", users);
        return "listUsers";
    }

    @RequestMapping(value={"/user/{userName}"}, method={RequestMethod.GET})
    public String viewUser(@PathVariable String userName, Model model) {
        try {
            User user = this.userManager.lookupUser(userName);
            model.addAttribute("user", (Object)user);
            List<Table> tables = this.tableManager.getTableList(user.getUserId());
            model.addAttribute("tables", tables);
            return "viewUser";
        }
        catch (RecoverableDataAccessException e) {
            model.addAttribute("error", (Object)e.getMessage());
            List<User> users = this.userManager.getUserList();
            model.addAttribute("users", users);
            return "listUsers";
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/user/create"}, method={RequestMethod.GET})
    public String createUser(Model model) {
        model.addAttribute("formAction", (Object)"create");
        model.addAttribute("user", (Object)new User());
        return "userForm";
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/user/create"}, method={RequestMethod.POST})
    public ModelAndView createUser(@Valid User user, BindingResult result, Model model) {
        if (result.hasErrors()) {
            model.addAttribute("formAction", (Object)"create");
            return new ModelAndView("userForm");
        }
        try {
            user.setPassword("changeme");
            this.userManager.createUser(user);
            user = this.userManager.lookupUser(user.getUserName());
            model.addAttribute("user", (Object)user);
            List<Table> tables = this.tableManager.getTableList(user.getUserId());
            model.addAttribute("tables", tables);
            return new ModelAndView((View)new RedirectView("/user/" + user.getUserName(), true));
        }
        catch (RecoverableDataAccessException e) {
            result.rejectValue("userName", "user.error", e.getMessage());
            model.addAttribute("formAction", (Object)"create");
            return new ModelAndView("userForm");
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or #userName == authentication.name")
    @RequestMapping(value={"/user/update/{userName}"}, method={RequestMethod.GET})
    public String updateUser(@PathVariable String userName, Model model) {
        User user = this.userManager.lookupUser(userName);
        model.addAttribute("user", (Object)user);
        model.addAttribute("formAction", (Object)"update");
        return "userForm";
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or #user.userName == authentication.name")
    @RequestMapping(value={"/user/update"}, method={RequestMethod.POST})
    public ModelAndView updateUser(@Valid User user, BindingResult result, Model model) {
        if (result.hasErrors()) {
            model.addAttribute("formAction", (Object)"update");
            return new ModelAndView("userForm");
        }
        try {
            this.userManager.updateUser(user);
            model.addAttribute("user", (Object)user);
            List<Table> tables = this.tableManager.getTableList(user.getUserId());
            model.addAttribute("tables", tables);
            return new ModelAndView((View)new RedirectView("/user/" + user.getUserName(), true));
        }
        catch (RecoverableDataAccessException e) {
            model.addAttribute("error", (Object)e.getMessage());
            model.addAttribute("formAction", (Object)"update");
            return new ModelAndView("userForm");
        }
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    @RequestMapping(value={"/user/delete"}, method={RequestMethod.POST})
    public ModelAndView deleteUser(User user, BindingResult result, Model model) {
        try {
            this.userManager.deleteUser(user.getUserId());
            List<User> users = this.userManager.getUserList();
            model.addAttribute("users", users);
            return new ModelAndView((View)new RedirectView("/user", true));
        }
        catch (RecoverableDataAccessException e) {
            model.addAttribute("error", (Object)e.getMessage());
            List<Table> tables = this.tableManager.getTableList(user.getUserId());
            model.addAttribute("tables", tables);
            return new ModelAndView((View)new RedirectView("/user" + user.getUserName(), true));
        }
    }

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception exception) {
        String message = "";
        ModelAndView modelAndView = new ModelAndView();
        HashMap<String, String> model = new HashMap<String, String>();
        if (exception instanceof AccessDeniedException) {
            message = exception.getMessage();
            modelAndView.setViewName("denied");
        } else {
            message = "An error has occurred: " + exception.getClass().getName() + ": " + exception.getMessage();
            modelAndView.setViewName("fatalError");
        }
        logger.error((Object)message);
        model.put("message", message);
        modelAndView.addAllObjects(model);
        return modelAndView;
    }
}

