/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.bufrvalidate;

import edu.ucar.unidata.bufrvalidate.UrlUploadBean;
import java.io.File;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.validation.BindException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractCommandController;
import org.springframework.web.servlet.view.RedirectView;
import ucar.nc2.util.DiskCache2;
import ucar.nc2.util.IO;
import ucar.unidata.util.StringUtil2;

public class BtUrlUploadController
extends AbstractCommandController {
    private DiskCache2 diskCache = null;

    public void setCache(DiskCache2 cache) {
        this.diskCache = cache;
    }

    protected ModelAndView handle(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) throws Exception {
        UrlUploadBean bean = (UrlUploadBean)command;
        String urlString = bean.getUrl();
        if (urlString == null || urlString.length() == 0) {
            response.sendError(400, "No url was specified");
            return null;
        }
        String filename = StringUtil2.replace((String)urlString, (String)"/", (String)"-");
        filename = StringUtil2.filter((String)filename, (String)".-_");
        String username = bean.getUsername();
        if (username == null) {
            username = "anon";
        }
        if ((username = username.trim()).length() == 0) {
            username = "anon";
        }
        String cacheName = username + "/" + filename;
        String redirectURL = "/validate/file";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("filename", cacheName);
        map.put("xml", bean.isXml());
        File dest = this.diskCache.getCacheFile(cacheName);
        try {
            IO.readURLtoFileWithExceptions((String)urlString, (File)dest);
        }
        catch (Exception e) {
            response.sendError(400, e.getMessage());
            return null;
        }
        return new ModelAndView((View)new RedirectView(redirectURL, true), map);
    }
}

