/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.wmotables.controller;

import edu.ucar.unidata.wmotables.domain.Table;
import edu.ucar.unidata.wmotables.domain.User;
import edu.ucar.unidata.wmotables.service.TableManager;
import edu.ucar.unidata.wmotables.service.TableValidator;
import edu.ucar.unidata.wmotables.service.UserManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.RecoverableDataAccessException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class TableController
implements HandlerExceptionResolver {
    protected static Logger logger = Logger.getLogger(TableController.class);
    @Resource(name="userManager")
    private UserManager userManager;
    @Resource(name="tableManager")
    private TableManager tableManager;
    @Value(value="${table.types}")
    private String tableTypeString;
    @Autowired
    private TableValidator tableValidator;
    private String authName;

    @InitBinder(value={"table"})
    public void initBinder(WebDataBinder binder) {
        binder.setValidator((Validator)this.tableValidator);
    }

    @RequestMapping(value={"/table"}, method={RequestMethod.GET})
    public String listAllTables(Model model) {
        List<Table> tables = this.tableManager.getTableList();
        model.addAttribute("tables", tables);
        HashMap<String, User> users = new HashMap<String, User>();
        for (Table table : tables) {
            User user = this.userManager.lookupUser(table.getUserId());
            users.put(new Integer(table.getUserId()).toString(), user);
        }
        model.addAttribute("users", users);
        return "listTables";
    }

    @RequestMapping(value={"/table/{checksum}"}, method={RequestMethod.GET})
    public String viewTable(@PathVariable String checksum, Model model) {
        try {
            Table table = this.tableManager.lookupTable(checksum);
            model.addAttribute("table", (Object)table);
            User user = this.userManager.lookupUser(table.getUserId());
            model.addAttribute("user", (Object)user);
            return "viewTable";
        }
        catch (RecoverableDataAccessException e) {
            model.addAttribute("error", (Object)e.getMessage());
            List<Table> tables = this.tableManager.getTableList();
            model.addAttribute("tables", tables);
            HashMap<String, User> users = new HashMap<String, User>();
            for (Table table : tables) {
                User user = this.userManager.lookupUser(table.getUserId());
                users.put(new Integer(table.getUserId()).toString(), user);
            }
            model.addAttribute("users", users);
            return "listTables";
        }
    }

    @RequestMapping(value={"/table/view/{checksum}"}, method={RequestMethod.GET})
    public void viewTableFile(@PathVariable String checksum, HttpServletResponse response) {
        Table table = this.tableManager.lookupTable(checksum);
        this.tableManager.downloadTableFile("view", table, response);
    }

    @RequestMapping(value={"/table/download/{checksum}"}, method={RequestMethod.GET})
    public void downloadTable(@PathVariable String checksum, HttpServletResponse response) {
        Table table = this.tableManager.lookupTable(checksum);
        this.tableManager.downloadTableFile("download", table, response);
    }

    @PreAuthorize(value="hasRole('ROLE_ADMIN') or #userName == authentication.name")
    @RequestMapping(value={"/table/create/{userName}"}, method={RequestMethod.GET})
    public String createTable(@PathVariable String userName, Model model) {
        model.addAttribute("table", (Object)new Table());
        User user = this.userManager.lookupUser(userName);
        model.addAttribute("user", (Object)user);
        model.addAttribute("formAction", (Object)"create");
        List<String> tableTypesList = this.getTableTypes();
        model.addAttribute("tableTypeList", tableTypesList);
        return "tableForm";
    }

    @RequestMapping(value={"/table/create"}, method={RequestMethod.POST})
    public ModelAndView createTable(@Valid Table table, BindingResult result, Model model) throws IOException, AccessDeniedException {
        User user = this.userManager.lookupUser(table.getUserId());
        this.tableValidator.validateFileSize(table.getFile(), (Errors)result);
        this.tableValidator.validateFileType(table.getMimeType(), (Errors)result);
        if (this.isAuthorized(user.getUserName())) {
            if (result.hasErrors()) {
                model.addAttribute("user", (Object)user);
                model.addAttribute("formAction", (Object)"create");
                List<String> tableTypesList = this.getTableTypes();
                model.addAttribute("tableTypeList", tableTypesList);
                return new ModelAndView("tableForm");
            }
            try {
                table.setVisibility(1);
                this.tableManager.createTable(table);
                model.addAttribute("table", (Object)table);
                model.addAttribute("user", (Object)user);
                return new ModelAndView((View)new RedirectView("/table/" + table.getChecksum(), true));
            }
            catch (RecoverableDataAccessException e) {
                model.addAttribute("error", (Object)e.getMessage());
                model.addAttribute("user", (Object)user);
                model.addAttribute("formAction", (Object)"create");
                List<String> tableTypesList = this.getTableTypes();
                model.addAttribute("tableTypeList", tableTypesList);
                return new ModelAndView("tableForm");
            }
        }
        throw new AccessDeniedException("User: " + this.getAuthName() + " is attempting to create under the user account: " + user.getUserName());
    }

    @RequestMapping(value={"/table/update/{checksum}"}, method={RequestMethod.GET})
    public String updateTable(@PathVariable String checksum, Model model) throws AccessDeniedException {
        Table table = this.tableManager.lookupTable(checksum);
        User user = this.userManager.lookupUser(table.getUserId());
        if (this.isAuthorized(user.getUserName())) {
            model.addAttribute("table", (Object)table);
            model.addAttribute("user", (Object)user);
            model.addAttribute("formAction", (Object)"update");
            List<String> tableTypesList = this.getTableTypes();
            model.addAttribute("tableTypeList", tableTypesList);
            return "tableForm";
        }
        throw new AccessDeniedException("User: " + this.getAuthName() + " is attempting to update a table that belongs to the user account: " + user.getUserName());
    }

    @RequestMapping(value={"/table/update"}, method={RequestMethod.POST})
    public ModelAndView updateTable(@Valid Table table, BindingResult result, Model model) throws AccessDeniedException {
        User user = this.userManager.lookupUser(table.getUserId());
        if (this.isAuthorized(user.getUserName())) {
            if (result.hasErrors()) {
                model.addAttribute("user", (Object)user);
                model.addAttribute("formAction", (Object)"update");
                List<String> tableTypesList = this.getTableTypes();
                model.addAttribute("tableTypeList", tableTypesList);
                return new ModelAndView("tableForm");
            }
            try {
                this.tableManager.updateTable(table);
                table = this.tableManager.lookupTable(table.getTableId());
                model.addAttribute("table", (Object)table);
                model.addAttribute("user", (Object)user);
                return new ModelAndView((View)new RedirectView("/table/" + table.getChecksum(), true));
            }
            catch (RecoverableDataAccessException e) {
                model.addAttribute("error", (Object)e.getMessage());
                model.addAttribute("user", (Object)user);
                model.addAttribute("formAction", (Object)"update");
                List<String> tableTypesList = this.getTableTypes();
                model.addAttribute("tableTypeList", tableTypesList);
                return new ModelAndView("tableForm");
            }
        }
        throw new AccessDeniedException("User: " + this.getAuthName() + " is attempting to update a table that belongs to the user account: " + user.getUserName());
    }

    @RequestMapping(value={"/table/hide"}, method={RequestMethod.POST})
    public ModelAndView hideTable(Table table, BindingResult result, Model model) throws AccessDeniedException {
        int visibility = table.getVisibility();
        User user = this.userManager.lookupUser((table = this.tableManager.lookupTable(table.getTableId())).getUserId());
        if (this.isAuthorized(user.getUserName())) {
            try {
                if (visibility == 1) {
                    table.setVisibility(0);
                } else {
                    table.setVisibility(1);
                }
                this.tableManager.toggleTableVisibility(table);
                model.addAttribute("table", (Object)table);
                model.addAttribute("user", (Object)user);
                return new ModelAndView((View)new RedirectView("/table/" + table.getChecksum(), true));
            }
            catch (RecoverableDataAccessException e) {
                model.addAttribute("error", (Object)e.getMessage());
                model.addAttribute("table", (Object)table);
                model.addAttribute("user", (Object)user);
                return new ModelAndView((View)new RedirectView("/table/" + table.getChecksum(), true));
            }
        }
        throw new AccessDeniedException("User: " + this.getAuthName() + " is attempting to hide a table that belongs to the user account: " + user.getUserName());
    }

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception exception) {
        String message = "";
        ModelAndView modelAndView = new ModelAndView();
        HashMap<String, String> model = new HashMap<String, String>();
        modelAndView.setViewName("fatalError");
        if (exception instanceof AccessDeniedException) {
            message = exception.getMessage();
            modelAndView.setViewName("denied");
        } else {
            message = exception instanceof NullPointerException ? "Problem with the tableStashDir argument during File creation.  Verify the wmotables.home value in the wmotables.properties file is correct: " + exception.getMessage() : (exception instanceof FileNotFoundException ? "Unable to create FileOutputStream for File: " + exception.getMessage() : (exception instanceof IOException ? "An IO error occured with the FileOutputStream for File: " + exception.getMessage() : (exception instanceof SecurityException ? "JVM security manager configuration conflict.  Unable to write File: " + exception.getMessage() : "An error has occurred: " + exception.getClass().getName() + ": " + exception.getMessage())));
        }
        logger.error((Object)message);
        model.put("message", message);
        modelAndView.addAllObjects(model);
        return modelAndView;
    }

    public boolean isAuthorized(String userName) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        String authName = auth.getName();
        if (authName.equals(userName)) {
            return true;
        }
        Collection authorities = auth.getAuthorities();
        for (GrantedAuthority grantedAuthority : authorities) {
            String authority = grantedAuthority.getAuthority();
            if (!authority.equals("ROLE_ADMIN")) continue;
            return true;
        }
        return false;
    }

    public String getAuthName() {
        return this.authName;
    }

    public void setAuthName(String authName) {
        this.authName = authName;
    }

    public List<String> getTableTypes() {
        String[] a = StringUtils.split((String)this.tableTypeString, (String)",");
        List<String> tableTypes = Arrays.asList(a);
        return tableTypes;
    }
}

