/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.wmotables.service;

import edu.ucar.unidata.wmotables.repository.UserDao;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class UserDetailsServiceImpl
implements UserDetailsService {
    protected static Logger logger = Logger.getLogger(UserDetailsServiceImpl.class);
    public UserDao userDao;

    public void setUserDao(UserDao userDao) {
        this.userDao = userDao;
    }

    public UserDetails loadUserByUsername(String userName) throws UsernameNotFoundException, DataAccessException {
        User userDetails = null;
        try {
            edu.ucar.unidata.wmotables.domain.User user = this.userDao.lookupUser(userName);
            String username = user.getUserName();
            String password = user.getPassword();
            boolean enabled = true;
            boolean accountNonExpired = true;
            boolean credentialsNonExpired = true;
            boolean accountNonLocked = true;
            Collection<GrantedAuthority> authorities = this.getAuthorities(user.getAccessLevel());
            userDetails = new User(username, password, enabled, accountNonExpired, credentialsNonExpired, accountNonLocked, authorities);
        }
        catch (DataAccessException e) {
            logger.error((Object)("DataAccessException: error in retrieving user: " + e.getMessage()));
        }
        catch (UsernameNotFoundException e) {
            logger.error((Object)("UsernameNotFoundException: error in retrieving user: " + e.getMessage()));
        }
        return userDetails;
    }

    public Collection<GrantedAuthority> getAuthorities(int access) {
        ArrayList<GrantedAuthority> authList = new ArrayList<GrantedAuthority>();
        if (access == 1) {
            authList.add((GrantedAuthority)new SimpleGrantedAuthority("ROLE_USER"));
        }
        if (access == 2) {
            authList.add((GrantedAuthority)new SimpleGrantedAuthority("ROLE_USER"));
            authList.add((GrantedAuthority)new SimpleGrantedAuthority("ROLE_ADMIN"));
        }
        return authList;
    }
}

