/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.wmotables.service;

import edu.ucar.unidata.wmotables.domain.User;
import edu.ucar.unidata.wmotables.repository.UserDao;
import edu.ucar.unidata.wmotables.service.UserManager;
import java.util.Date;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;

public class UserManagerImpl
implements UserManager {
    private UserDao userDao;

    public void setUserDao(UserDao userDao) {
        this.userDao = userDao;
    }

    @Override
    public User lookupUser(int userId) {
        return this.userDao.lookupUser(userId);
    }

    @Override
    public User lookupUser(String userName) {
        return this.userDao.lookupUser(userName);
    }

    @Override
    public List<User> getUserList() {
        return this.userDao.getUserList();
    }

    @Override
    public int getUserCount() {
        return this.userDao.getUserCount();
    }

    @Override
    public void deleteUser(int userId) {
        this.userDao.deleteUser(userId);
    }

    @Override
    public void deleteUser(String userName) {
        this.userDao.deleteUser(userName);
    }

    @Override
    public void createUser(User user) {
        String password = DigestUtils.md5Hex((String)user.getPassword());
        user.setPassword(password);
        user.setAccessLevel(1);
        Date now = new Date(System.currentTimeMillis());
        user.setDateCreated(now);
        user.setDateModified(now);
        this.userDao.createUser(user);
    }

    @Override
    public void updateUser(User user) {
        Date now = new Date(System.currentTimeMillis());
        user.setDateModified(now);
        this.userDao.updateUser(user);
    }

    @Override
    public void updatePassword(User user) {
        String password = DigestUtils.md5Hex((String)user.getPassword());
        user.setPassword(password);
        Date now = new Date(System.currentTimeMillis());
        user.setDateModified(now);
        this.userDao.updatePassword(user);
    }
}

