/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.wmotables.service;

import edu.ucar.unidata.wmotables.domain.User;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

@Component
public class UserValidator
implements Validator {
    protected static Logger logger = Logger.getLogger(UserValidator.class);
    private String[] NAUGHTY_STRINGS = new String[]{"<script>", "../", "javascript", "::", "&quot;", "fromcharCode", "%3", "$#", "alert(", ".js", ".source", "\\", "scriptlet", ".css", "binding:", ".htc", "vbscript", "mocha:", "livescript:", "base64", "\u0000", "xss:", "%77", "0x", "IS NULL;", "1;", "; --", "1=1"};
    private String[] NAUGHTY_CHARS = new String[]{"<", ">", "`", "^", "|", "}", "{"};
    private Pattern pattern;
    private Matcher matcher;
    private static final String EMAIL_PATTERN = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
    private static final String USER_NAME_PATTERN = "^[a-zA-Z0-9_-]{6,50}$";

    public boolean supports(Class clazz) {
        return User.class.equals((Object)clazz);
    }

    public void validate(Object obj, Errors errors) {
        User user = (User)obj;
        this.validateUserName(user.getUserName(), errors);
        this.validateFullName(user.getFullName(), errors);
        this.validateEmailAddress(user.getEmailAddress(), errors);
        this.validateCenter(user.getCenter(), errors);
        this.validateSubCenter(user.getSubCenter(), errors);
    }

    public void validateUserName(String input, Errors errors) {
        if (StringUtils.isBlank((CharSequence)input)) {
            errors.rejectValue("userName", "user.error", "User name is required!");
            return;
        }
        if (StringUtils.length((CharSequence)input) < 6 || StringUtils.length((CharSequence)input) > 50) {
            errors.rejectValue("userName", "user.error", "The user name must be between 6 and 50 characters in length.");
            return;
        }
        this.pattern = Pattern.compile(USER_NAME_PATTERN);
        this.matcher = this.pattern.matcher(input);
        if (!this.matcher.matches()) {
            errors.rejectValue("userName", "user.error", "Only alphanumeric characters, dashed and underscores are allowed. (Spaces are NOT allowed.)");
            return;
        }
    }

    public void validateFullName(String input, Errors errors) {
        if (StringUtils.isBlank((CharSequence)input)) {
            errors.rejectValue("fullName", "user.error", "Full user name is required!");
            return;
        }
        if (StringUtils.length((CharSequence)input) < 6 || StringUtils.length((CharSequence)input) > 75) {
            errors.rejectValue("fullName", "user.error", "The full user name must be between 6 and 75 characters in length.");
            return;
        }
        this.validateInput("fullName", input, errors);
    }

    public void validateCenter(int input, Errors errors) {
        if (StringUtils.isBlank((CharSequence)new Integer(input).toString())) {
            errors.rejectValue("center", "user.error", "User center is required!");
            return;
        }
    }

    public void validateSubCenter(int input, Errors errors) {
        if (StringUtils.isBlank((CharSequence)new Integer(input).toString())) {
            errors.rejectValue("subCenter", "user.error", "User sub center is required!");
            return;
        }
    }

    public void validateEmailAddress(String input, Errors errors) {
        if (StringUtils.isBlank((CharSequence)input)) {
            errors.rejectValue("emailAddress", "user.error", "User email address is required!");
            return;
        }
        this.pattern = Pattern.compile(EMAIL_PATTERN);
        this.matcher = this.pattern.matcher(input);
        if (!this.matcher.matches()) {
            errors.rejectValue("emailAddress", "user.error", "This is not a well-formed email address.");
            return;
        }
    }

    public void validateInput(String formField, String input, Errors errors) {
        String badChar = this.checkForNaughtyChars(input);
        if (badChar != null) {
            logger.warn((Object)("Bad value submitted for " + formField + " : " + badChar));
            errors.rejectValue(formField, "user.error", "Bad value submitted: " + badChar);
            return;
        }
        String badString = this.checkForNaughtyStrings(input);
        if (badString != null) {
            logger.warn((Object)("Bad value submitted for " + formField + " : " + badString));
            errors.rejectValue(formField, "user.error", "Bad value submitted: " + badString);
            return;
        }
    }

    public String checkForNaughtyStrings(String itemToCheck) {
        for (String item : this.NAUGHTY_STRINGS) {
            if (!StringUtils.contains((CharSequence)StringUtils.lowerCase((String)itemToCheck), (CharSequence)item)) continue;
            return item;
        }
        return null;
    }

    public String checkForNaughtyChars(String itemToCheck) {
        for (String item : this.NAUGHTY_CHARS) {
            if (!StringUtils.contains((CharSequence)itemToCheck, (CharSequence)item)) continue;
            return item;
        }
        return null;
    }
}

