/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.bufrvalidate;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Formatter;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.transform.XSLTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.iosp.bufr.DataDescriptor;
import ucar.nc2.iosp.bufr.Message;
import ucar.nc2.iosp.bufr.MessageScanner;
import ucar.nc2.iosp.bufr.writer.Bufr2Xml;
import ucar.nc2.util.DiskCache2;
import ucar.nc2.util.IO;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.StringUtil2;

public class BtServlet
extends HttpServlet {
    protected Logger log;
    private DiskCache2 cdmValidateCache = null;
    private DiskFileItemFactory factory;
    private File cacheDir;
    private long maxFileUploadSize = 20000000L;
    boolean allow = true;
    boolean deleteImmediately = true;
    protected String contentPath;
    private static final Pattern wmoPattern = Pattern.compile(".*([IJ]..... ....) .*");

    public void init() throws ServletException {
        this.log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        String cacheDirName = this.getInitParameter("CacheDir");
        int scourSecs = Integer.parseInt(this.getInitParameter("CacheScourSecs"));
        int maxAgeSecs = Integer.parseInt(this.getInitParameter("CacheMaxAgeSecs"));
        if (maxAgeSecs > 0) {
            this.deleteImmediately = false;
            this.cdmValidateCache = new DiskCache2(cacheDirName, false, maxAgeSecs / 60, scourSecs / 60);
        }
        this.cacheDir = new File(cacheDirName);
        this.cacheDir.mkdirs();
        this.factory = new DiskFileItemFactory(0, this.cacheDir);
    }

    public void destroy() {
        if (this.cdmValidateCache != null) {
            this.cdmValidateCache.exit();
        }
        super.destroy();
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (!this.allow) {
            res.sendError(403, "Service not supported");
            return;
        }
        String urlString = req.getParameter("URL");
        if (urlString != null) {
            try {
                URI uri = new URI(urlString);
                urlString = uri.toASCIIString();
            }
            catch (URISyntaxException e) {
                res.sendError(400, "URISyntaxException on URU parameter");
                return;
            }
            String xml = req.getParameter("xml");
            boolean wantXml = xml != null && xml.equals("true");
            try {
                this.processURL(req, res, urlString, null, wantXml);
                return;
            }
            catch (Exception e) {
                this.log.info("Validator processURL", (Throwable)e);
                res.sendError(400, e.getMessage());
                return;
            }
        }
        String path = req.getPathInfo();
        if (path.startsWith("/mess/")) {
            int messno;
            int pos = (path = path.substring(6)).lastIndexOf("/");
            if (pos < 0) {
                res.sendError(400, "no message number");
                return;
            }
            String cmd = path.substring(pos + 1);
            if ((pos = (path = path.substring(0, pos)).lastIndexOf("/")) < 0) {
                res.sendError(400, "no message number");
                return;
            }
            String mess = path.substring(pos + 1);
            try {
                messno = Integer.parseInt(mess);
            }
            catch (Exception e) {
                res.sendError(400, "illegal message number=" + mess);
                return;
            }
            String cacheName = path.substring(0, pos);
            File uploadedFile = new File(this.cacheDir + "/" + cacheName);
            if (!uploadedFile.exists()) {
                res.sendError(404, "file not found=" + cacheName);
                return;
            }
            if (cmd.equals("dds.txt")) {
                this.showMessDDS(res, uploadedFile, cacheName, messno);
            } else if (cmd.equals("data.txt")) {
                this.showMessData(res, uploadedFile, cacheName, messno);
            } else if (cmd.equals("bitCount.txt")) {
                this.showMessSize(res, uploadedFile, cacheName, messno);
            }
        }
        res.sendError(400, "GET request not understood");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showMessDDS(HttpServletResponse res, File file, String cacheName, int messno) throws IOException {
        try (Message m = null;){
            m = this.getBufrMessage(file, messno);
            if (m == null) {
                res.sendError(404, "message " + messno + " not found in " + cacheName);
                return;
            }
            res.setContentType("text/plain");
            ServletOutputStream out = res.getOutputStream();
            Formatter f = new Formatter((OutputStream)out);
            f.format("File %s message %d %n%n", cacheName, messno);
            if (!m.isTablesComplete()) {
                f.format(" MISSING DATA DESCRIPTORS= ", new Object[0]);
                m.showMissingFields(f);
                f.format("%n%n", new Object[0]);
            }
            m.dump(f);
            f.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showMessSize(HttpServletResponse res, File file, String cacheName, int messno) throws IOException {
        try (Message m = null;){
            m = this.getBufrMessage(file, messno);
            if (m == null) {
                res.sendError(404, "message " + messno + " not found in " + cacheName);
                return;
            }
            res.setContentType("text/plain");
            ServletOutputStream out = res.getOutputStream();
            Formatter f = new Formatter((OutputStream)out);
            f.format("File %s message %d %n%n", cacheName, messno);
            try {
                boolean ok;
                int nbitsCounted = m.calcTotalBits(f);
                int nbitsGiven = 8 * (m.dataSection.getDataLength() - 4);
                boolean bl = ok = Math.abs(m.getCountedDataBytes() - m.dataSection.getDataLength()) <= 1;
                if (!ok) {
                    f.format("*** BAD BIT COUNT %n", new Object[0]);
                }
                long last = m.dataSection.getDataPos() + (long)m.dataSection.getDataLength();
                DataDescriptor root = m.getRootDataDescriptor();
                f.format("Message nobs=%d compressed=%s vlen=%s countBits= %d givenBits=%d %n", m.getNumberDatasets(), m.dds.isCompressed(), root.isVarLength(), nbitsCounted, nbitsGiven);
                f.format(" countBits= %d givenBits=%d %n", nbitsCounted, nbitsGiven);
                f.format(" countBytes= %d dataSize=%d %n", m.getCountedDataBytes(), m.dataSection.getDataLength());
                f.format("%n", new Object[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                res.sendError(500, ex.getMessage());
            }
            f.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showMessData(HttpServletResponse res, File file, String cacheName, int messno) throws IOException {
        Message message = null;
        NetcdfDataset ncd = null;
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(file.getPath(), "r");
            MessageScanner scan = new MessageScanner(raf);
            int count = 0;
            while (scan.hasNext()) {
                message = scan.next();
                if (message == null) continue;
                if (count == messno) {
                    byte[] mbytes = scan.getMessageBytesFromLast(message);
                    NetcdfFile ncfile = null;
                    try {
                        ncfile = NetcdfFile.openInMemory((String)"test", (byte[])mbytes, (String)"ucar.nc2.iosp.bufr.BufrIosp");
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                    ncd = new NetcdfDataset(ncfile);
                    break;
                }
                ++count;
            }
            if (ncd == null) {
                res.sendError(404, "message " + messno + " not found in " + cacheName);
                return;
            }
            res.setContentType("text/plain");
            ServletOutputStream out = res.getOutputStream();
            new Bufr2Xml(message, ncd, (OutputStream)out, false);
            out.flush();
        }
        finally {
            if (ncd != null) {
                ncd.close();
            } else if (raf != null) {
                raf.close();
            }
        }
    }

    private Message getBufrMessage(File file, int messno) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(file.getPath(), "r");
        MessageScanner scan = new MessageScanner(raf);
        int count = 0;
        while (scan.hasNext()) {
            Message m = scan.next();
            if (m == null) continue;
            if (count == messno) {
                return m;
            }
            ++count;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetcdfDataset getBufrMessageAsDataset(File file, int messno) throws IOException {
        try (RandomAccessFile raf = null;){
            raf = new RandomAccessFile(file.getPath(), "r");
            MessageScanner scan = new MessageScanner(raf);
            int count = 0;
            while (scan.hasNext()) {
                Message m = scan.next();
                if (m == null) continue;
                if (count == messno) {
                    NetcdfDataset ncd;
                    byte[] mbytes = scan.getMessageBytesFromLast(m);
                    NetcdfFile ncfile = null;
                    try {
                        ncfile = NetcdfFile.openInMemory((String)"test", (byte[])mbytes, (String)"ucar.nc2.iosp.bufr.BufrIosp");
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                    NetcdfDataset netcdfDataset = ncd = new NetcdfDataset(ncfile);
                    return netcdfDataset;
                }
                ++count;
            }
        }
        return null;
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        List fileItems;
        if (!this.allow) {
            res.sendError(403, "Service not supported");
            return;
        }
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)req);
        if (!isMultipart) {
            res.sendError(400, "POST must be multipart");
            return;
        }
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)this.factory);
        upload.setSizeMax(this.maxFileUploadSize);
        try {
            fileItems = upload.parseRequest(req);
        }
        catch (FileUploadException e) {
            this.log.info("Validator FileUploadException", (Throwable)e);
            res.sendError(403, e.getMessage());
            return;
        }
        String username = null;
        boolean wantXml = false;
        for (FileItem item : fileItems) {
            if (!item.isFormField()) continue;
            if ("username".equals(item.getFieldName())) {
                username = item.getString();
            }
            if (!"xml".equals(item.getFieldName())) continue;
            wantXml = item.getString().equals("true");
        }
        for (FileItem item : fileItems) {
            if (item.isFormField()) continue;
            try {
                this.processUploadedFile(req, res, (DiskFileItem)item, username, wantXml);
                return;
            }
            catch (Exception e) {
                this.log.info("Validator processUploadedFile", (Throwable)e);
                res.sendError(400, e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUploadedFile(HttpServletRequest req, HttpServletResponse res, DiskFileItem item, String username, boolean wantXml) throws Exception {
        if (username == null || username.length() == 0) {
            username = "anon";
        }
        username = StringUtil2.filter((String)username, (String)"_");
        String filename = item.getName();
        filename = StringUtil2.replace((String)filename, (String)"/", (String)"-");
        filename = StringUtil2.filter((String)filename, (String)".-_");
        String cacheName = username + "/" + filename;
        File uploadedFile = new File(this.cacheDir + "/" + cacheName);
        uploadedFile.getParentFile().mkdirs();
        item.write(uploadedFile);
        try {
            Document doc = this.readBufr(uploadedFile, cacheName);
            this.showValidatorResults(res, doc, wantXml);
        }
        finally {
            if (this.deleteImmediately) {
                try {
                    uploadedFile.delete();
                }
                catch (Exception e) {
                    this.log.error("Uploaded File = " + uploadedFile.getPath() + " delete failed = " + e.getMessage());
                }
            }
        }
        if (req.getRemoteUser() == null) {
            // empty if block
        }
        this.log.info("Uploaded File = " + item.getName() + " sent to " + uploadedFile.getPath() + " size= " + uploadedFile.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processURL(HttpServletRequest req, HttpServletResponse res, String urls, String username, boolean wantXml) throws Exception {
        if (username == null || username.length() == 0) {
            username = "anon";
        }
        username = StringUtil2.filter((String)username, (String)"_");
        String filename = urls;
        filename = StringUtil2.replace((String)filename, (String)"/", (String)"-");
        filename = StringUtil2.filter((String)filename, (String)".-_");
        String cacheName = username + "/" + filename;
        File uploadedFile = new File(this.cacheDir + "/" + cacheName);
        uploadedFile.getParentFile().mkdirs();
        IO.readURLtoFile((String)urls, (File)uploadedFile);
        try {
            Document doc = this.readBufr(uploadedFile, cacheName);
            this.showValidatorResults(res, doc, wantXml);
        }
        finally {
            if (this.deleteImmediately) {
                try {
                    uploadedFile.delete();
                }
                catch (Exception e) {
                    this.log.error("Uploaded File = " + uploadedFile.getPath() + " delete failed = " + e.getMessage());
                }
            }
        }
        if (req.getRemoteUser() == null) {
            // empty if block
        }
        this.log.info("Uploaded File = " + urls + " sent to " + uploadedFile.getPath() + " size= " + uploadedFile.length());
    }

    private Document readBufr(File file, String cacheName) throws IOException {
        long start = System.nanoTime();
        RandomAccessFile raf = new RandomAccessFile(file.getPath(), "r");
        Element rootElem = new Element("bufrValidation");
        Document doc = new Document(rootElem);
        rootElem.setAttribute("fileName", cacheName);
        rootElem.setAttribute("fileSize", Long.toString(raf.length()));
        MessageScanner scan = new MessageScanner(raf);
        int count = 0;
        while (scan.hasNext()) {
            boolean ok;
            Message m = scan.next();
            if (m == null) continue;
            Element bufrMessage = new Element("bufrMessage").setAttribute("status", "ok");
            rootElem.addContent((Content)bufrMessage);
            bufrMessage.setAttribute("pos", Integer.toString(count));
            if (!m.isTablesComplete()) {
                bufrMessage.setAttribute("dds", "incomplete");
            } else {
                bufrMessage.setAttribute("dds", "ok");
            }
            int nbitsCounted = m.getTotalBits();
            int nbitsGiven = 8 * (m.dataSection.getDataLength() - 4);
            boolean bl = ok = Math.abs(m.getCountedDataBytes() - m.dataSection.getDataLength()) <= 1;
            if (ok) {
                bufrMessage.setAttribute("size", "ok");
            } else {
                bufrMessage.setAttribute("size", "fail");
                bufrMessage.addContent((Content)new Element("ByteCount").setText("countBytes " + m.getCountedDataBytes() + " != " + m.dataSection.getDataLength() + " dataSize"));
            }
            bufrMessage.addContent((Content)new Element("BitCount").setText("countBits " + nbitsCounted + " != " + nbitsGiven + " dataSizeBits"));
            bufrMessage.setAttribute("nobs", Integer.toString(m.getNumberDatasets()));
            bufrMessage.addContent((Content)new Element("WMOheader").setText(this.extractWMO(m.getHeader())));
            bufrMessage.addContent((Content)new Element("center").setText(m.getLookup().getCenterName()));
            bufrMessage.addContent((Content)new Element("category").setText(m.getLookup().getCategoryFullName()));
            bufrMessage.addContent((Content)new Element("date").setText(m.ids.getReferenceTime().toString()));
            ++count;
        }
        raf.close();
        rootElem.setAttribute("totalObs", Integer.toString(scan.getTotalObs()));
        return doc;
    }

    private String extractWMO(String header) {
        Matcher matcher = wmoPattern.matcher(header);
        if (!matcher.matches()) {
            this.log.warn("extractWMO failed= %s\n", (Object)header);
            return header;
        }
        return matcher.group(1);
    }

    private int showValidatorResults(HttpServletResponse res, Document doc, boolean wantXml) throws Exception {
        String infoString;
        if (wantXml) {
            XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
            infoString = fmt.outputString(doc);
            res.setContentLength(infoString.length());
            res.setContentType("text/xml; charset=iso-8859-1");
        } else {
            InputStream is = this.getXSLT();
            XSLTransformer transformer = new XSLTransformer(is);
            Document html = transformer.transform(doc);
            XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
            infoString = fmt.outputString(html);
            res.setContentType("text/html; charset=iso-8859-1");
        }
        res.setContentLength(infoString.length());
        ServletOutputStream out = res.getOutputStream();
        out.write(infoString.getBytes());
        out.flush();
        return infoString.length();
    }

    private InputStream getXSLT() {
        String resource;
        Class<?> c = ((Object)((Object)this)).getClass();
        InputStream is = c.getResourceAsStream(resource = "/resources/xsl/validation.xsl");
        if (null == is) {
            this.log.error("Cant load XSLT resource = " + resource);
        }
        return is;
    }
}

