/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.ABINnav;
import edu.wisc.ssec.mcidas.ABISnav;
import edu.wisc.ssec.mcidas.GEOSnav;
import edu.wisc.ssec.mcidas.GMSXnav;
import edu.wisc.ssec.mcidas.GOESnav;
import edu.wisc.ssec.mcidas.GVARnav;
import edu.wisc.ssec.mcidas.KALPnav;
import edu.wisc.ssec.mcidas.LAMBnav;
import edu.wisc.ssec.mcidas.MERCnav;
import edu.wisc.ssec.mcidas.MOLLnav;
import edu.wisc.ssec.mcidas.MSATnav;
import edu.wisc.ssec.mcidas.MSGTnav;
import edu.wisc.ssec.mcidas.MSGnav;
import edu.wisc.ssec.mcidas.McIDASException;
import edu.wisc.ssec.mcidas.PSnav;
import edu.wisc.ssec.mcidas.RADRnav;
import edu.wisc.ssec.mcidas.RECTnav;
import edu.wisc.ssec.mcidas.SINUnav;
import edu.wisc.ssec.mcidas.TANCnav;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public abstract class AREAnav
implements Serializable {
    static final long serialVersionUID = 2334637524537406773L;
    public static final double RADIANS_TO_DEGREES = 57.29577951308232;
    public static final double DEGREES_TO_RADIANS = Math.PI / 180;
    public static final int DMSP = 1145918032;
    public static final int GMSX = 1196249944;
    public static final int GOES = 1196377427;
    public static final int GEOS = 1195724627;
    public static final int GVAR = 1196835154;
    public static final int MOLL = 1297042508;
    public static final int MSAT = 1297301844;
    public static final int MSGT = 1297303380;
    public static final int MSG = 1297303328;
    public static final int POES = 1414091343;
    public static final int RADR = 1380009042;
    public static final int RECT = 1380270932;
    public static final int PS = 1347624992;
    public static final int MERC = 1296388675;
    public static final int TANC = 1413566019;
    public static final int SIN = 1397313056;
    public static final int LAMB = 1279348034;
    public static final int LALO = 1279347791;
    public static final int KALP = 1262570576;
    public static final int ABIS = 1094863187;
    public static final int ABIN = 1094863182;
    public static final int LL = 123;
    public static final int XY = 234;
    public final int indexLine = 1;
    public final int indexEle = 0;
    public final int indexLat = 0;
    public final int indexLon = 1;
    private boolean isLineFlipped = false;
    private float lineOffset = 0.0f;
    private float resLine = 1.0f;
    private float resElement = 1.0f;
    private float magLine = 1.0f;
    private float magElement = 1.0f;
    private float startLine = 0.0f;
    private float startElement = 0.0f;
    private float startImageLine = 0.0f;
    private float startImageElement = 0.0f;

    public abstract double[][] toLatLon(double[][] var1);

    public abstract double[][] toLinEle(double[][] var1);

    public float[][] toLatLon(float[][] linele) {
        return AREAnav.doubleToFloat(this.toLatLon(AREAnav.floatToDouble(linele)));
    }

    public float[][] toLinEle(float[][] latlon) {
        return AREAnav.doubleToFloat(this.toLinEle(AREAnav.floatToDouble(latlon)));
    }

    public void setRes(int resLine, int resElement) {
        this.resLine = resLine;
        this.resElement = resElement;
    }

    public void setRes(float resLine, float resElement) {
        this.resLine = resLine;
        this.resElement = resElement;
    }

    public void setMag(int magLine, int magElement) {
        this.magLine = magLine;
        this.magElement = magElement;
    }

    public void setMag(float magLine, float magElement) {
        this.magLine = magLine;
        this.magElement = magElement;
    }

    public void setStart(int startLine, int startElement) {
        this.startLine = startLine;
        this.startElement = startElement;
    }

    public void setImageStart(int startImageLine, int startImageElement) {
        this.startImageLine = startImageLine;
        this.startImageElement = startImageElement;
    }

    public void setFlipLineCoordinates(int line) {
        this.isLineFlipped = true;
        this.lineOffset = line;
    }

    public boolean isFlippedLineCoordinates() {
        return this.isLineFlipped;
    }

    public double[] getSubpoint() {
        return new double[]{Double.NaN, Double.NaN};
    }

    public double getLineOffset() {
        return this.lineOffset;
    }

    public double[][] areaCoordToImageCoord(double[][] linele) {
        return this.areaCoordToImageCoord(linele, (double[][])null);
    }

    public double[][] areaCoordToImageCoord(double[][] linele, double[][] newvals) {
        if (newvals == null) {
            newvals = new double[2][linele[0].length];
        }
        for (int i = 0; i < linele[0].length; ++i) {
            if (linele[1][i] == linele[1][i]) {
                double line = this.isLineFlipped ? (double)this.lineOffset - linele[1][i] : linele[1][i];
                newvals[1][i] = (double)this.startImageLine + (double)this.resLine * (line - (double)this.startLine) / (double)this.magLine;
            }
            if (linele[0][i] != linele[0][i]) continue;
            newvals[0][i] = (double)this.startImageElement + (double)this.resElement * (linele[0][i] - (double)this.startElement) / (double)this.magElement;
        }
        return newvals;
    }

    public double[][] imageCoordToAreaCoord(double[][] linele) {
        return this.imageCoordToAreaCoord(linele, (double[][])null);
    }

    public double[][] imageCoordToAreaCoord(double[][] linele, double[][] newvals) {
        if (newvals == null) {
            newvals = new double[2][linele[0].length];
        }
        for (int i = 0; i < linele[0].length; ++i) {
            if (linele[1][i] == linele[1][i]) {
                newvals[1][i] = (double)this.startLine + (double)this.magLine * (linele[1][i] - (double)this.startImageLine) / (double)this.resLine;
                if (this.isLineFlipped) {
                    newvals[1][i] = (double)this.lineOffset - newvals[1][i];
                }
            }
            if (linele[0][i] != linele[0][i]) continue;
            newvals[0][i] = (double)this.startElement + (double)this.magElement * (linele[0][i] - (double)this.startImageElement) / (double)this.resElement;
        }
        return newvals;
    }

    public float[][] areaCoordToImageCoord(float[][] linele) {
        return this.areaCoordToImageCoord(linele, (float[][])null);
    }

    public float[][] areaCoordToImageCoord(float[][] linele, float[][] newvals) {
        if (newvals == null) {
            newvals = new float[2][linele[0].length];
        }
        for (int i = 0; i < linele[0].length; ++i) {
            if (linele[1][i] == linele[1][i]) {
                float line = this.isLineFlipped ? this.lineOffset - linele[1][i] : linele[1][i];
                newvals[1][i] = this.startImageLine + this.resLine * (line - this.startLine) / this.magLine;
            }
            if (linele[0][i] != linele[0][i]) continue;
            newvals[0][i] = this.startImageElement + this.resElement * (linele[0][i] - this.startElement) / this.magElement;
        }
        return newvals;
    }

    public float[][] imageCoordToAreaCoord(float[][] linele) {
        return this.imageCoordToAreaCoord(linele, (float[][])null);
    }

    public float[][] imageCoordToAreaCoord(float[][] linele, float[][] newvals) {
        if (newvals == null) {
            newvals = new float[2][linele[0].length];
        }
        for (int i = 0; i < linele[0].length; ++i) {
            if (linele[1][i] == linele[1][i]) {
                newvals[1][i] = this.startLine + this.magLine * (linele[1][i] - this.startImageLine) / this.resLine;
                if (this.isLineFlipped) {
                    newvals[1][i] = this.lineOffset - newvals[1][i];
                }
            }
            if (linele[0][i] != linele[0][i]) continue;
            newvals[0][i] = this.startElement + this.magElement * (linele[0][i] - this.startImageElement) / this.resElement;
        }
        return newvals;
    }

    public static AREAnav makeAreaNav(int[] navBlock) throws McIDASException {
        return AREAnav.makeAreaNav(navBlock, null);
    }

    public static AREAnav makeAreaNav(int[] navBlock, int[] auxBlock) throws McIDASException {
        AREAnav anav = null;
        try {
            switch (navBlock[0]) {
                case 1196835154: {
                    anav = new GVARnav(navBlock);
                    break;
                }
                case 1297042508: {
                    anav = new MOLLnav(navBlock);
                    break;
                }
                case 1297301844: {
                    anav = new MSATnav(navBlock);
                    break;
                }
                case 1297303328: {
                    anav = new MSGnav(navBlock);
                    break;
                }
                case 1297303380: {
                    anav = new MSGTnav(navBlock);
                    break;
                }
                case 1380009042: {
                    anav = new RADRnav(navBlock);
                    break;
                }
                case 1380270932: {
                    anav = new RECTnav(navBlock);
                    break;
                }
                case 1196249944: {
                    anav = new GMSXnav(navBlock);
                    break;
                }
                case 1196377427: {
                    anav = new GOESnav(navBlock);
                    break;
                }
                case 1195724627: {
                    anav = new GEOSnav(navBlock);
                    break;
                }
                case 1347624992: {
                    anav = new PSnav(navBlock);
                    break;
                }
                case 1296388675: {
                    anav = new MERCnav(navBlock);
                    break;
                }
                case 1279348034: {
                    anav = new LAMBnav(navBlock);
                    break;
                }
                case 1413566019: {
                    anav = new TANCnav(navBlock);
                    break;
                }
                case 1397313056: {
                    anav = new SINUnav(navBlock);
                    break;
                }
                case 1279347791: {
                    String laloNavClassName = "edu.wisc.ssec.mcidas.LALOnav";
                    try {
                        Class<?> clazz = Class.forName(laloNavClassName);
                        Constructor<?> constructor = clazz.getConstructor(navBlock.getClass(), auxBlock.getClass());
                        Object obj = constructor.newInstance(navBlock, auxBlock);
                        if (obj instanceof AREAnav) {
                            anav = (AREAnav)obj;
                        }
                        break;
                    }
                    catch (ClassNotFoundException | NoSuchMethodException e) {
                        e.printStackTrace();
                        throw new McIDASException("The full VisAD jar is needed to read files that use Radar (RECT) type nav.");
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        e.printStackTrace();
                        throw new McIDASException("Unable to create a new instance of" + laloNavClassName + " via reflection. Check to make sure the version of visad you are using supports this class.");
                    }
                }
                case 1262570576: {
                    anav = new KALPnav(navBlock);
                    break;
                }
                case 1094863187: {
                    anav = new ABISnav(navBlock);
                    break;
                }
                case 1094863182: {
                    anav = new ABINnav(navBlock);
                    break;
                }
                default: {
                    throw new McIDASException("makeAreaNav: Unknown navigation type" + navBlock[0]);
                }
            }
        }
        catch (IllegalArgumentException excp) {
            throw new McIDASException("Wrong nav block passed to AREAnav module", excp);
        }
        return anav;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AREAnav) {
            AREAnav nav = (AREAnav)obj;
            return this.resLine == nav.resLine && this.resElement == nav.resElement && this.magLine == nav.magLine && this.magElement == nav.magElement && this.startLine == nav.startLine && this.startElement == nav.startElement && this.startImageLine == nav.startImageLine && this.startImageElement == nav.startImageElement && this.isLineFlipped == nav.isLineFlipped && this.lineOffset == nav.lineOffset;
        }
        return false;
    }

    public String toString() {
        String className = this.getClass().getName();
        int lastDot = className.lastIndexOf(46);
        className = className.substring(lastDot + 1);
        return className.substring(0, className.indexOf("nav"));
    }

    public boolean canApproximateWithSpline() {
        return true;
    }

    public static double[][] floatToDouble(float[][] value) {
        if (value == null) {
            return null;
        }
        double[][] val = new double[value.length][];
        for (int i = 0; i < value.length; ++i) {
            if (value[i] == null) {
                val[i] = null;
                continue;
            }
            val[i] = new double[value[i].length];
            for (int j = 0; j < value[i].length; ++j) {
                val[i][j] = value[i][j];
            }
        }
        return val;
    }

    public static float[][] doubleToFloat(double[][] value) {
        if (value == null) {
            return null;
        }
        float[][] val = new float[value.length][];
        for (int i = 0; i < value.length; ++i) {
            if (value[i] == null) {
                val[i] = null;
                continue;
            }
            val[i] = new float[value[i].length];
            for (int j = 0; j < value[i].length; ++j) {
                val[i][j] = (float)value[i][j];
            }
        }
        return val;
    }
}

