/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.AreaFile;
import edu.wisc.ssec.mcidas.AreaFileException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;

public final class AreaFileFactory {
    private AreaFileFactory() {
    }

    public static final int calStrToInt(String cal) {
        int ret = -1;
        String calType = cal.trim();
        if (calType.equalsIgnoreCase("temp")) {
            ret = 4;
        } else if (calType.equalsIgnoreCase("brit")) {
            ret = 5;
        } else if (calType.equalsIgnoreCase("rad")) {
            ret = 2;
        } else if (calType.equalsIgnoreCase("raw")) {
            ret = 1;
        } else if (calType.equalsIgnoreCase("refl")) {
            ret = 3;
        }
        return ret;
    }

    public static final String calIntToStr(int cal) {
        String ret = "raw";
        switch (cal) {
            case 3: {
                ret = "refl";
                break;
            }
            case 5: {
                ret = "brit";
                break;
            }
            case 2: {
                ret = "rad";
                break;
            }
            case 1: {
                ret = "raw";
                break;
            }
            case 4: {
                ret = "temp";
            }
        }
        return ret;
    }

    public static final String makeLocalQuery(int sl, int nl, int lm, int se, int ne, int em, int b) {
        return "?band=" + b + "&linele=" + sl + " " + se + "&size=" + nl + " " + ne + "&mag=" + lm + " " + em;
    }

    public static final String makeLocalQuery(int sl, int nl, int lm, int se, int ne, int em, int b, int c) {
        String ct = AreaFileFactory.calIntToStr(c);
        return "?band=" + b + "&linele=" + sl + " " + se + "&size=" + nl + " " + ne + "&mag=" + lm + " " + em + "&unit=" + ct;
    }

    public static final String makeLocalQuery(int sl, int nl, int lm, int se, int ne, int em, int b, String c) {
        return "?band=" + b + "&linele=" + sl + " " + se + "&size=" + nl + " " + ne + "&mag=" + lm + " " + em + "&unit=" + c;
    }

    public static final URL makeLocalSubsetURL(String fpath, int sl, int nl, int lm, int se, int ne, int em, int b, String u) throws MalformedURLException {
        String surl = "file://" + fpath + AreaFileFactory.makeLocalQuery(sl, nl, lm, se, ne, em, b, u);
        URL url = null;
        try {
            url = new URL(surl);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return url;
    }

    public static final AreaFile getAreaFileInstance(String src) throws AreaFileException {
        if (src.startsWith("adde://") && (src.endsWith("image?") || src.endsWith("imagedata?"))) {
            return new AreaFile(src);
        }
        AreaFile af = null;
        URL url = null;
        try {
            url = new URL(src);
            af = AreaFileFactory.getAreaFileInstance(url);
        }
        catch (MalformedURLException e) {
            af = new AreaFile(src);
        }
        return af;
    }

    public static final AreaFile getAreaFileInstance(URL url) throws AreaFileException {
        if (url.getProtocol().equalsIgnoreCase("file")) {
            AreaFile af = null;
            af = url.getQuery() == null ? new AreaFile(url) : new AreaFile(url.toString().split("\\?")[0]);
            String query = url.getQuery();
            if (query != null && query.contains("%")) {
                try {
                    query = url.toURI().getQuery();
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            if (query != null) {
                String whtspc = "(\\s)+";
                int startLine = 0;
                int numLines = af.getAreaDirectory().getLines();
                int lineMag = 1;
                int startElem = 0;
                int numEles = af.getAreaDirectory().getElements();
                int eleMag = 1;
                int band = -1;
                int calType = -1;
                boolean linele = false;
                boolean size = false;
                boolean mag = false;
                int availableLines = numLines;
                int availableEles = numEles;
                String[] props = query.split("&");
                block5: for (int i = 0; i < props.length; ++i) {
                    String[] kv = props[i].split("=");
                    if (kv[0].equalsIgnoreCase("mag")) {
                        lineMag = Integer.parseInt(kv[1].split("(\\s)+")[0]);
                        eleMag = Integer.parseInt(kv[1].split("(\\s)+")[1]);
                        mag = true;
                    }
                    if (kv[0].equalsIgnoreCase("size")) {
                        numLines = Integer.parseInt(kv[1].split("(\\s)+")[0]);
                        numEles = Integer.parseInt(kv[1].split("(\\s)+")[1]);
                        size = true;
                    }
                    if (kv[0].equalsIgnoreCase("band")) {
                        int bandIdx = -1;
                        int[] bands = af.getAreaDirectory().getBands();
                        if (band == -1) {
                            bandIdx = 0;
                        } else {
                            int j = 0;
                            while (i < bands.length) {
                                if (bands[j] == band) {
                                    bandIdx = j;
                                }
                                ++j;
                            }
                        }
                        band = bands[bandIdx];
                    }
                    if (kv[0].equalsIgnoreCase("linele")) {
                        String[] vals = kv[1].split("(\\s)+");
                        startLine = Integer.parseInt(vals[0]);
                        startElem = Integer.parseInt(vals[1]);
                        if (vals.length < 3 || !vals[2].equalsIgnoreCase("a")) {
                            // empty if block
                        }
                        availableLines -= startLine;
                        availableEles -= startElem;
                        linele = true;
                    }
                    if (!kv[0].equalsIgnoreCase("unit")) continue;
                    calType = AreaFileFactory.calStrToInt(kv[1]);
                    switch (calType) {
                        case -1: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            continue block5;
                        }
                        default: {
                            throw new AreaFileException("Unsupported calibration type: " + kv[1]);
                        }
                    }
                }
                if (mag) {
                    availableLines /= Math.abs(lineMag) == 0 ? 1 : Math.abs(lineMag);
                    availableEles /= Math.abs(eleMag) == 0 ? 1 : Math.abs(eleMag);
                    if (size) {
                        numLines = Math.min(availableLines, numLines);
                        numEles = Math.min(availableEles, numEles);
                    } else {
                        numLines = availableLines;
                        numEles = availableEles;
                    }
                }
                af = new AreaFile(url.getPath(), startLine, numLines, lineMag, startElem, numEles, eleMag, band);
                af.setCalType(calType);
            }
            return af;
        }
        return new AreaFile(url);
    }

    public static final AreaFile getAreaFileInstance(String fpath, int startLine, int numLines, int lineMag, int startElem, int numEles, int eleMag, int band) throws AreaFileException {
        return new AreaFile(fpath, startLine, numLines, lineMag, startElem, numEles, eleMag, band);
    }

    public static void copyAreaFile(String source, String outputFile) throws AreaFileException {
        AreaFileFactory.copyAreaFile(source, outputFile, false);
    }

    public static void copyAreaFile(String source, String outputFile, boolean verbose) throws AreaFileException {
        AreaFile area = AreaFileFactory.getAreaFileInstance(source);
        area.save(outputFile, verbose);
    }
}

