/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.AREAnav;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Objects;

public class KALPnav
extends AREAnav {
    private static final long serialVersionUID = 1L;
    private double h;
    private double a;
    private double rp;
    private double re;
    private double cdr;
    private double crd;
    private double lpsi2;
    private double deltax;
    private double deltay;
    private double sublat;
    private double sublon;
    private double cenlin;
    private double cenele;
    private double altitude;
    private boolean isEastPositive = true;

    public KALPnav(int[] iparms) {
        this(1, iparms);
    }

    public KALPnav(int ifunc, int[] iparms) {
        if (ifunc != 1) {
            ifunc = 1;
        }
        if (iparms[0] != 1262570576) {
            throw new IllegalArgumentException("Invalid navigation type" + iparms[0]);
        }
        this.altitude = (double)iparms[11] / 10000.0;
        this.h = this.altitude - 6378.155;
        this.re = 6378.155;
        this.a = 0.003367003367003367;
        this.rp = this.re / (1.0 + this.a);
        this.cdr = Math.PI / 180;
        this.crd = 57.29577951308232;
        this.lpsi2 = 1.0;
        this.deltax = (double)iparms[12] / 1.0E9;
        this.deltax *= this.crd;
        this.deltay = this.deltax;
        this.sublat = (double)iparms[10] / 10000.0;
        this.sublon = (double)iparms[6] / 10000.0;
        this.cenlin = (double)iparms[13] / 40.0;
        this.cenele = (double)iparms[14] / 40.0;
        if (iparms[13] == 0) {
            this.cenlin = 704.5;
            this.cenele = 704.5;
        }
    }

    @Override
    public float[][] toLatLon(float[][] linele) {
        int number = linele[0].length;
        float[][] latlon = new float[2][number];
        float[][] imglinele = this.areaCoordToImageCoord(linele);
        for (int point = 0; point < number; ++point) {
            double yk;
            double tany;
            double val2;
            double xele2 = (double)imglinele[0][point] / 4.0;
            double xlin2 = (double)imglinele[1][point] / 4.0;
            double x = this.cenele - xele2;
            double y = this.cenlin - xlin2;
            double xr = x;
            double yr = y;
            x = xr * this.lpsi2 * this.deltax * this.cdr;
            y = yr * this.lpsi2 * this.deltay * this.cdr;
            double rs = this.re + this.h;
            double tanx = Math.tan(x);
            double val1 = 1.0 + tanx * tanx;
            if (val1 * (val2 = 1.0 + (tany = Math.tan(y)) * tany * ((1.0 + this.a) * (1.0 + this.a))) > (yk = rs / this.re) * yk / (yk * yk - 1.0)) {
                latlon[1][point] = Float.NaN;
                latlon[0][point] = Float.NaN;
                continue;
            }
            double vmu = (rs - this.re * Math.sqrt(yk * yk - (yk * yk - 1.0) * val1 * val2)) / (val1 * val2);
            double cosrf = Math.cos(this.sublat * this.cdr);
            double sinrf = Math.sin(this.sublat * this.cdr);
            double xt = rs * cosrf + vmu * (tanx * sinrf - cosrf);
            double yt = rs * sinrf - vmu * (tanx * cosrf + sinrf);
            double zt = vmu * tany / Math.cos(x);
            double teta = Math.asin(zt / this.rp);
            double xfi = Math.atan(Math.tan(teta) * this.re / this.rp) * this.crd;
            double xla = -Math.atan(yt / xt) * this.crd;
            xla += this.sublon;
            if (this.isEastPositive) {
                xla = -xla;
            }
            latlon[0][point] = (float)xfi;
            latlon[1][point] = (float)xla;
        }
        return latlon;
    }

    @Override
    public float[][] toLinEle(float[][] latlon) {
        int number = latlon[0].length;
        float[][] linele = new float[2][number];
        for (int point = 0; point < number; ++point) {
            double r2;
            double x1 = latlon[0][point];
            double y1 = latlon[1][point];
            if (!this.isEastPositive) {
                y1 = -y1;
            }
            double xfi = x1 * this.cdr;
            double xla = (y1 += this.sublon) * this.cdr;
            double rom = this.re * this.rp / Math.sqrt(this.rp * this.rp * Math.cos(xfi) * Math.cos(xfi) + this.re * this.re * Math.sin(xfi) * Math.sin(xfi));
            double y = Math.sqrt(this.h * this.h + rom * rom - 2.0 * this.h * rom * Math.cos(xfi) * Math.cos(xla));
            double r1 = y * y + rom * rom;
            if (r1 > (r2 = this.h * this.h)) {
                linele[1][point] = Float.NaN;
                linele[0][point] = Float.NaN;
                continue;
            }
            double rs = this.re + this.h;
            double reph = this.re;
            double rpph = this.rp;
            double coslo = Math.cos(this.sublat * this.cdr);
            double sinlo = Math.sin(this.sublat * this.cdr);
            double teta = Math.atan(rpph / reph * Math.tan(xfi));
            double xt = reph * Math.cos(teta) * Math.cos(xla);
            double yt = reph * Math.cos(teta) * Math.sin(xla);
            double zt = rpph * Math.sin(teta);
            double px = Math.atan((coslo * (yt - rs * sinlo) - (xt - rs * coslo) * sinlo) / (sinlo * (yt - rs * sinlo) + (xt - rs * coslo) * coslo));
            double py = Math.atan(zt * ((Math.tan(px) * sinlo - coslo) / (xt - rs * coslo)) * Math.cos(px));
            double xr = (px *= this.crd) / (this.deltax * this.lpsi2);
            double yr = (py *= this.crd) / (this.deltay * this.lpsi2);
            xr = this.cenele - xr;
            yr = this.cenlin - yr;
            linele[1][point] = (float)(yr *= 4.0);
            linele[0][point] = (float)(xr *= 4.0);
        }
        return this.imageCoordToAreaCoord(linele, linele);
    }

    @Override
    public double[][] toLinEle(double[][] latlon) {
        int number = latlon[0].length;
        double[][] linele = new double[2][number];
        for (int point = 0; point < number; ++point) {
            double r2;
            double x1 = latlon[0][point];
            double y1 = latlon[1][point];
            if (!this.isEastPositive) {
                y1 = -y1;
            }
            double xfi = x1 * this.cdr;
            double xla = (y1 += this.sublon) * this.cdr;
            double rom = this.re * this.rp / Math.sqrt(this.rp * this.rp * Math.cos(xfi) * Math.cos(xfi) + this.re * this.re * Math.sin(xfi) * Math.sin(xfi));
            double y = Math.sqrt(this.h * this.h + rom * rom - 2.0 * this.h * rom * Math.cos(xfi) * Math.cos(xla));
            double r1 = y * y + rom * rom;
            if (r1 > (r2 = this.h * this.h)) {
                linele[1][point] = Double.NaN;
                linele[0][point] = Double.NaN;
                continue;
            }
            double rs = this.re + this.h;
            double reph = this.re;
            double rpph = this.rp;
            double coslo = Math.cos(this.sublat * this.cdr);
            double sinlo = Math.sin(this.sublat * this.cdr);
            double teta = Math.atan(rpph / reph * Math.tan(xfi));
            double xt = reph * Math.cos(teta) * Math.cos(xla);
            double yt = reph * Math.cos(teta) * Math.sin(xla);
            double zt = rpph * Math.sin(teta);
            double px = Math.atan((coslo * (yt - rs * sinlo) - (xt - rs * coslo) * sinlo) / (sinlo * (yt - rs * sinlo) + (xt - rs * coslo) * coslo));
            double py = Math.atan(zt * ((Math.tan(px) * sinlo - coslo) / (xt - rs * coslo)) * Math.cos(px));
            double xr = (px *= this.crd) / (this.deltax * this.lpsi2);
            double yr = (py *= this.crd) / (this.deltay * this.lpsi2);
            xr = this.cenele - xr;
            yr = this.cenlin - yr;
            linele[1][point] = yr *= 4.0;
            linele[0][point] = xr *= 4.0;
        }
        return this.imageCoordToAreaCoord(linele, linele);
    }

    @Override
    public double[][] toLatLon(double[][] linele) {
        int number = linele[0].length;
        double[][] latlon = new double[2][number];
        double[][] imglinele = this.areaCoordToImageCoord(linele);
        for (int point = 0; point < number; ++point) {
            double yk;
            double tany;
            double val2;
            double xele2 = imglinele[0][point] / 4.0;
            double xlin2 = imglinele[1][point] / 4.0;
            double x = this.cenele - xele2;
            double y = this.cenlin - xlin2;
            double xr = x;
            double yr = y;
            x = xr * this.lpsi2 * this.deltax * this.cdr;
            y = yr * this.lpsi2 * this.deltay * this.cdr;
            double rs = this.re + this.h;
            double tanx = Math.tan(x);
            double val1 = 1.0 + tanx * tanx;
            if (val1 * (val2 = 1.0 + (tany = Math.tan(y)) * tany * ((1.0 + this.a) * (1.0 + this.a))) > (yk = rs / this.re) * yk / (yk * yk - 1.0)) {
                latlon[1][point] = Double.NaN;
                latlon[0][point] = Double.NaN;
                continue;
            }
            double vmu = (rs - this.re * Math.sqrt(yk * yk - (yk * yk - 1.0) * val1 * val2)) / (val1 * val2);
            double cosrf = Math.cos(this.sublat * this.cdr);
            double sinrf = Math.sin(this.sublat * this.cdr);
            double xt = rs * cosrf + vmu * (tanx * sinrf - cosrf);
            double yt = rs * sinrf - vmu * (tanx * cosrf + sinrf);
            double zt = vmu * tany / Math.cos(x);
            double teta = Math.asin(zt / this.rp);
            double xfi = Math.atan(Math.tan(teta) * this.re / this.rp) * this.crd;
            double xla = -Math.atan(yt / xt) * this.crd;
            xla += this.sublon;
            if (this.isEastPositive) {
                xla = -xla;
            }
            latlon[0][point] = xfi;
            latlon[1][point] = xla;
        }
        return latlon;
    }

    public static void main(String[] args) {
        int[] navBlock = new int[800];
        int[] dirBlock = new int[64];
        DataInputStream dis = null;
        KALPnav kalp = null;
        String fileName = "KALPAREA";
        System.out.println("unit test of class KALP begin...");
        if (args.length > 0) {
            fileName = args[0];
        }
        try {
            dis = new DataInputStream(new BufferedInputStream(new FileInputStream(fileName), 2048));
        }
        catch (Exception e) {
            System.out.println("error creating DataInputStream: " + e);
            System.exit(0);
        }
        System.out.println("reading in, discarding directory words...");
        try {
            for (int i = 0; i < 64; ++i) {
                dirBlock[i] = dis.readInt();
            }
        }
        catch (IOException e) {
            System.out.println("error reading area file directory: " + e);
            System.exit(0);
        }
        System.out.println("reading in navigation words...");
        try {
            for (int i = 0; i < navBlock.length; ++i) {
                navBlock[i] = dis.readInt();
            }
        }
        catch (IOException e) {
            System.out.println("error reading area file navigation data: " + e);
            System.exit(0);
        }
        if (navBlock[0] != 1262570576) {
            System.out.println("error: not a KALP navigation block.");
            System.exit(0);
        }
        double[][] linEle = new double[2][1];
        double[][] latLon = new double[2][1];
        System.out.println("creating KALPnav object...");
        kalp = new KALPnav(navBlock);
        kalp.setImageStart(dirBlock[5], dirBlock[6]);
        System.out.println("####  ImageStart set to:" + dirBlock[5] + " " + dirBlock[6]);
        kalp.setRes(dirBlock[11], dirBlock[12]);
        System.out.println("####  ImageRes set to:" + dirBlock[11] + " " + dirBlock[12]);
        kalp.setStart(0, 0);
        System.out.println(" test of toLinEle...");
        Objects.requireNonNull(kalp);
        latLon[0][0] = 11.0;
        Objects.requireNonNull(kalp);
        latLon[1][0] = 50.0;
        linEle = kalp.toLinEle(latLon);
        StringBuilder stringBuilder = new StringBuilder().append("  answer is: ");
        Objects.requireNonNull(kalp);
        StringBuilder stringBuilder2 = stringBuilder.append(linEle[1][0]).append(", ");
        Objects.requireNonNull(kalp);
        System.out.println(stringBuilder2.append(linEle[0][0]).toString());
        latLon[0][0] = Double.NaN;
        latLon = kalp.toLatLon(linEle);
        System.out.println("testing inverse of 11N/50E");
        StringBuilder stringBuilder3 = new StringBuilder().append("  answer is: ");
        Objects.requireNonNull(kalp);
        StringBuilder stringBuilder4 = stringBuilder3.append(latLon[0][0]).append(", ");
        Objects.requireNonNull(kalp);
        System.out.println(stringBuilder4.append(latLon[1][0]).toString());
        System.out.println(" another test of toLinEle...");
        Objects.requireNonNull(kalp);
        latLon[0][0] = -20.0;
        Objects.requireNonNull(kalp);
        latLon[1][0] = 100.0;
        linEle = kalp.toLinEle(latLon);
        StringBuilder stringBuilder5 = new StringBuilder().append("  answer is: ");
        Objects.requireNonNull(kalp);
        StringBuilder stringBuilder6 = stringBuilder5.append(linEle[1][0]).append(", ");
        Objects.requireNonNull(kalp);
        System.out.println(stringBuilder6.append(linEle[0][0]).toString());
        latLon[0][0] = Double.NaN;
        latLon = kalp.toLatLon(linEle);
        System.out.println("testing inverse of 20S/100E");
        StringBuilder stringBuilder7 = new StringBuilder().append("  answer is: ");
        Objects.requireNonNull(kalp);
        StringBuilder stringBuilder8 = stringBuilder7.append(latLon[0][0]).append(", ");
        Objects.requireNonNull(kalp);
        System.out.println(stringBuilder8.append(latLon[1][0]).toString());
        System.out.println("unit test of class KALPnav end...");
    }
}

