/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Switch;
import javax.media.j3d.TransparencyAttributes;
import visad.BadMappingException;
import visad.BaseColorControl;
import visad.CachingCoordinateSystem;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.DisplayTupleType;
import visad.Field;
import visad.FieldImpl;
import visad.FlatField;
import visad.GraphicsModeControl;
import visad.Gridded2DSet;
import visad.GriddedSet;
import visad.ImageFlatField;
import visad.Integer1DSet;
import visad.InverseLinearScaledCS;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.LinearNDSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.Set;
import visad.ShadowFunctionOrSetType;
import visad.ShadowRealTupleType;
import visad.ShadowRealType;
import visad.ShadowType;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;
import visad.VisADQuadArray;
import visad.VisADTriangleStripArray;
import visad.bom.ImageRendererJ3D;
import visad.bom.Mosaic;
import visad.bom.SwitchNotify;
import visad.bom.Tile;
import visad.java3d.AVControlJ3D;
import visad.java3d.AnimationControlJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.ShadowFunctionTypeJ3D;
import visad.java3d.VisADImageNode;
import visad.java3d.VisADImageTile;

public class ShadowImageByRefFunctionTypeJ3D
extends ShadowFunctionTypeJ3D {
    private static final int MISSING1 = -128;
    private VisADImageNode imgNode = null;
    private VisADImageNode prevImgNode = null;
    private int prevDataWidth = -1;
    private int prevDataHeight = -1;
    private int prevNumImages = -1;
    private byte[][] scaled_Bytes;
    private float[][] scaled_Floats;
    private float[][] rset_scalarmap_lookup;
    private byte[][] itable;
    private byte[][] fast_table;
    private byte[][][] threeD_itable;
    private float[][] color_values;
    private boolean first_time;
    AnimationControlJ3D animControl = null;
    private boolean reuse = false;
    private boolean reuseImages = false;
    int[] inherited_values = null;
    ShadowFunctionOrSetType adaptedShadowType = null;
    int levelOfDifficulty = -1;
    boolean regen_colbytes = false;
    boolean regen_geom = false;
    boolean apply_alpha = false;

    public ShadowImageByRefFunctionTypeJ3D(MathType t, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        super(t, link, parent);
    }

    public ShadowImageByRefFunctionTypeJ3D(MathType t, DataDisplayLink link, ShadowType parent, int[] inherited_values, ShadowFunctionOrSetType adaptedShadowType, int levelOfDifficulty) throws VisADException, RemoteException {
        super(t, link, parent);
        this.inherited_values = inherited_values;
        this.adaptedShadowType = adaptedShadowType;
        this.levelOfDifficulty = levelOfDifficulty;
    }

    private Object[] findSpatialMapTicksAndCurrZValue(ShadowFunctionOrSetType MyAdaptedShadowType, DisplayImpl display, float[] default_values, float[] value_array, int[] valueToScalar, DataRenderer renderer, DataDisplayLink link, int valueArrayLength) throws VisADException, DisplayException {
        ShadowRealTupleType Domain2 = MyAdaptedShadowType.getDomain();
        ShadowRealType[] DomainComponents = MyAdaptedShadowType.getDomainComponents();
        ShadowRealTupleType domain_reference = Domain2.getReference();
        ShadowRealType[] DC = DomainComponents;
        if (domain_reference != null && domain_reference.getMappedDisplayScalar()) {
            DC = MyAdaptedShadowType.getDomainReferenceComponents();
        }
        int[] tuple_index = new int[3];
        TupleType spatial_tuple = null;
        boolean spatial_maps_check_ticks = false;
        for (int i = 0; i < DC.length; ++i) {
            DisplayRealType real;
            Enumeration maps = DC[i].getSelectedMapVector().elements();
            ScalarMap map = (ScalarMap)maps.nextElement();
            if (map.checkTicks(renderer, link)) {
                spatial_maps_check_ticks = true;
            }
            if ((spatial_tuple = (real = map.getDisplayScalar()).getTuple()) == null) {
                return null;
            }
            tuple_index[i] = real.getTupleIndex();
            if (!maps.hasMoreElements()) continue;
            return null;
        }
        tuple_index[2] = 3 - (tuple_index[0] + tuple_index[1]);
        DisplayRealType real = (DisplayRealType)spatial_tuple.getComponent(tuple_index[2]);
        int value2_index = display.getDisplayScalarIndex(real);
        float value2 = default_values[value2_index];
        for (int i = 0; i < valueArrayLength; ++i) {
            if (this.inherited_values[i] <= 0 || !real.equals(display.getDisplayScalar(valueToScalar[i]))) continue;
            value2 = value_array[i];
            break;
        }
        tuple_index = null;
        Object[] ret_values = new Object[]{spatial_maps_check_ticks, Float.valueOf(value2)};
        return ret_values;
    }

    private boolean findRadianceMapColorControlCheckTicks(ScalarMap cmap, ScalarMap[] cmaps, DataRenderer renderer, DataDisplayLink link) {
        boolean color_map_changed = false;
        if (cmap != null) {
            BaseColorControl cc = (BaseColorControl)cmap.getControl();
            color_map_changed = cmap.checkTicks(renderer, link) || cc.checkTicks(renderer, link);
        } else if (cmaps != null) {
            for (int i = 0; i < cmaps.length; ++i) {
                BaseColorControl cc = (BaseColorControl)cmaps[i].getControl();
                if (null != cc) {
                    if (!cc.checkTicks(renderer, link) && !cmaps[i].checkTicks(renderer, link)) continue;
                    color_map_changed = true;
                    break;
                }
                if (!cmaps[i].checkTicks(renderer, link)) continue;
                color_map_changed = true;
                break;
            }
        }
        return color_map_changed;
    }

    private void applyTexture(Shape3D shape, VisADImageTile tile, boolean apply_alpha, float constant_alpha) {
        Appearance app = shape.getAppearance();
        if (this.regen_colbytes && this.animControl == null) {
            this.imgNode.setCurrent(0);
        }
        if (apply_alpha) {
            TransparencyAttributes transp_attribs = app.getTransparencyAttributes();
            if (null == transp_attribs) {
                transp_attribs = new TransparencyAttributes();
                transp_attribs.setTransparencyMode(2);
                transp_attribs.setTransparency(constant_alpha);
                transp_attribs.setCapability(3);
                app.setTransparencyAttributes(transp_attribs);
            } else {
                transp_attribs.setTransparency(constant_alpha);
            }
        }
    }

    private void initRegenFlags(ImageRendererJ3D imgRenderer, ShadowFunctionOrSetType MyAdaptedShadowType, float constant_alpha, ScalarMap cmap, ScalarMap[] cmaps, Data data, DisplayImpl display, float[] default_values, float[] value_array, int[] valueToScalar, int valueArrayLength, DataDisplayLink link, int curved_size) throws BadMappingException, VisADException {
        int last_curve_size = imgRenderer.getLastCurveSize();
        float last_zaxis_value = imgRenderer.getLastZAxisValue();
        float last_alpha_value = imgRenderer.getLastAlphaValue();
        long last_data_hash_code = imgRenderer.getLastDataHashCode();
        long current_data_hash_code = data.hashCode();
        boolean last_adjust_projection_seam = imgRenderer.getLastAdjustProjectionSeam();
        boolean current_adjust_projection_seam = this.adaptedShadowType.getAdjustProjectionSeam();
        Object[] map_ticks_z_value = this.findSpatialMapTicksAndCurrZValue(MyAdaptedShadowType, display, default_values, value_array, valueToScalar, imgRenderer, link, valueArrayLength);
        if (null == map_ticks_z_value) {
            return;
        }
        float current_zaxis_value = Float.parseFloat(map_ticks_z_value[1].toString());
        if (-1 != last_curve_size && Float.isNaN(last_zaxis_value) && -1L == last_data_hash_code) {
            this.regen_colbytes = true;
            this.regen_geom = true;
            this.apply_alpha = true;
        } else {
            boolean data_hash_code_changed;
            boolean bl = data_hash_code_changed = current_data_hash_code != last_data_hash_code;
            if (data_hash_code_changed) {
                this.regen_colbytes = true;
                this.regen_geom = true;
                this.apply_alpha = true;
            } else {
                boolean projection_seam_changed;
                boolean spatial_maps_check_ticks = Boolean.parseBoolean(map_ticks_z_value[0].toString());
                boolean zaxis_value_changed = Float.compare(last_zaxis_value, current_zaxis_value) != 0;
                boolean curve_texture_value_change = last_curve_size != curved_size;
                boolean alpha_changed = Float.compare(constant_alpha, last_alpha_value) != 0;
                boolean radiancemap_colcontrol_check_ticks = this.findRadianceMapColorControlCheckTicks(cmap, cmaps, imgRenderer, link);
                boolean bl2 = projection_seam_changed = current_adjust_projection_seam != last_adjust_projection_seam;
                if (spatial_maps_check_ticks || zaxis_value_changed || curve_texture_value_change || projection_seam_changed) {
                    this.regen_geom = true;
                } else if (alpha_changed) {
                    this.apply_alpha = true;
                } else {
                    this.regen_colbytes = radiancemap_colcontrol_check_ticks ? true : true;
                }
            }
        }
        imgRenderer.setLastCurveSize(curved_size);
        imgRenderer.setLastZAxisValue(current_zaxis_value);
        imgRenderer.setLastAlphaValue(constant_alpha);
        imgRenderer.setLastAdjustProjectionSeam(current_adjust_projection_seam);
        imgRenderer.setLastDataHashCode(current_data_hash_code);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean doTransform(Object group, Data data, float[] value_array, float[] default_values, DataRenderer renderer) throws VisADException, RemoteException {
        Iterator iter;
        boolean curvedTexture;
        int color_length;
        DisplayImpl display;
        int cMapCurveSize;
        Node g;
        DataDisplayLink link = renderer.getLink();
        if (data.isMissing()) {
            ((ImageRendererJ3D)renderer).markMissingVisADBranch();
            return false;
        }
        if (this.levelOfDifficulty == -1) {
            this.levelOfDifficulty = this.getLevelOfDifficulty();
        }
        if (this.levelOfDifficulty == 6) {
            return false;
        }
        if (group instanceof BranchGroup && ((BranchGroup)group).numChildren() > 0 && (g = ((BranchGroup)group).getChild(0)) instanceof BranchGroup && ((BranchGroup)g).numChildren() > 0) {
            this.reuseImages = true;
        }
        int curved_size = (cMapCurveSize = (int)default_values[(display = this.getDisplay()).getDisplayScalarIndex(Display.CurvedSize)]) > 0 ? cMapCurveSize : display.getGraphicsModeControl().getCurvedSize();
        int valueArrayLength = display.getValueArrayLength();
        int[] valueToScalar = display.getValueToScalar();
        if (this.adaptedShadowType == null) {
            this.adaptedShadowType = (ShadowFunctionOrSetType)this.getAdaptedShadowType();
        }
        boolean anyContour = this.adaptedShadowType.getAnyContour();
        boolean anyFlow = this.adaptedShadowType.getAnyFlow();
        boolean anyShape = this.adaptedShadowType.getAnyShape();
        boolean anyText = this.adaptedShadowType.getAnyText();
        if (anyContour || anyFlow || anyShape || anyText) {
            throw new BadMappingException("no contour, flow, shape or text allowed");
        }
        FlatField imgFlatField = null;
        Set domain_set = ((Field)data).getDomainSet();
        ShadowRealType[] DomainComponents = this.adaptedShadowType.getDomainComponents();
        int numImages = 1;
        if (!this.adaptedShadowType.getIsTerminal()) {
            ScalarMap map;
            Vector domain_maps = DomainComponents[0].getSelectedMapVector();
            ScalarMap amap = null;
            if (domain_set.getDimension() == 1 && domain_maps.size() == 1 && Display.Animation.equals((map = (ScalarMap)domain_maps.elementAt(0)).getDisplayScalar())) {
                amap = map;
            }
            if (amap == null) {
                throw new BadMappingException("time must be mapped to Animation");
            }
            this.animControl = (AnimationControlJ3D)amap.getControl();
            numImages = domain_set.getLength();
            this.adaptedShadowType = (ShadowFunctionOrSetType)this.adaptedShadowType.getRange();
            DomainComponents = this.adaptedShadowType.getDomainComponents();
            imgFlatField = (FlatField)((FieldImpl)data).getSample(0);
        } else {
            imgFlatField = (FlatField)data;
        }
        ShadowRealType[] RangeComponents = this.adaptedShadowType.getRangeComponents();
        int rangesize = RangeComponents.length;
        if (rangesize != 1 && rangesize != 3) {
            throw new BadMappingException("image values must single or triple");
        }
        ScalarMap cmap = null;
        ScalarMap[] cmaps = null;
        int[] permute = new int[]{-1, -1, -1};
        boolean hasAlpha = false;
        if (rangesize == 1) {
            Vector mvector = RangeComponents[0].getSelectedMapVector();
            if (mvector.size() != 1) {
                throw new BadMappingException("image values must be mapped to RGB only");
            }
            cmap = (ScalarMap)mvector.elementAt(0);
            if (!Display.RGB.equals(cmap.getDisplayScalar())) {
                if (!Display.RGBA.equals(cmap.getDisplayScalar())) throw new BadMappingException("image values must be mapped to RGB or RGBA");
                hasAlpha = true;
            }
        } else {
            int i;
            cmaps = new ScalarMap[3];
            for (int i2 = 0; i2 < 3; ++i2) {
                Vector mvector = RangeComponents[i2].getSelectedMapVector();
                if (mvector.size() != 1) {
                    throw new BadMappingException("image values must be mapped to color only");
                }
                cmaps[i2] = (ScalarMap)mvector.elementAt(0);
                if (Display.Red.equals(cmaps[i2].getDisplayScalar())) {
                    permute[0] = i2;
                    continue;
                }
                if (Display.Green.equals(cmaps[i2].getDisplayScalar())) {
                    permute[1] = i2;
                    continue;
                }
                if (Display.Blue.equals(cmaps[i2].getDisplayScalar())) {
                    permute[2] = i2;
                    continue;
                }
                if (!Display.RGB.equals(cmaps[i2].getDisplayScalar())) throw new BadMappingException("image values must be mapped to Red, Green or Blue only");
                permute[i2] = i2;
            }
            if (permute[0] < 0 || permute[1] < 0 || permute[2] < 0) {
                throw new BadMappingException("image values must be mapped to Red, Green or Blue only");
            }
            int indx = -1;
            for (i = 0; i < 3; ++i) {
                if (!cmaps[i].getDisplayScalar().equals(Display.RGB)) continue;
                indx = i;
                break;
            }
            if (indx != -1) {
                for (i = 0; i < 3; ++i) {
                    if (i == indx || cmaps[i].getDisplayScalar().equals(Display.RGB)) continue;
                    throw new BadMappingException("image values must be mapped to (Red, Green, Blue) or (RGB,RGB,RGB) only");
                }
            }
        }
        float constant_alpha = default_values[display.getDisplayScalarIndex(Display.Alpha)];
        ImageRendererJ3D imgRenderer = (ImageRendererJ3D)renderer;
        int imageType = imgRenderer.getSuggestedBufImageType();
        if (imageType == 6) {
            color_length = 4;
            if (!hasAlpha) {
                color_length = 3;
                imageType = 5;
            }
        } else if (imageType == 5) {
            color_length = 3;
        } else if (imageType == 11) {
            color_length = 2;
        } else {
            if (imageType != 10) throw new VisADException("renderer returned unsupported image type");
            color_length = 1;
        }
        if (color_length == 4) {
            constant_alpha = Float.NaN;
        }
        this.regen_colbytes = false;
        this.regen_geom = false;
        this.apply_alpha = false;
        this.initRegenFlags((ImageRendererJ3D)renderer, this.adaptedShadowType, constant_alpha, cmap, cmaps, data, display, default_values, value_array, valueToScalar, valueArrayLength, link, curved_size);
        if (!this.reuseImages) {
            this.regen_geom = true;
            this.regen_colbytes = true;
            this.apply_alpha = true;
        }
        this.prevImgNode = ((ImageRendererJ3D)renderer).getImageNode();
        BranchGroup bgImages = null;
        if (!this.reuseImages || this.regen_colbytes && this.regen_geom) {
            BranchGroup branch = new BranchGroup();
            branch.setCapability(17);
            branch.setCapability(14);
            branch.setCapability(12);
            branch.setCapability(13);
            Switch swit = (Switch)this.makeSwitch();
            this.imgNode = new VisADImageNode();
            bgImages = new BranchGroup();
            bgImages.setCapability(17);
            bgImages.setCapability(14);
            bgImages.setCapability(12);
            bgImages.setCapability(13);
            swit.addChild((Node)bgImages);
            swit.setWhichChild(0);
            branch.addChild((Node)swit);
            this.imgNode.setBranch(branch);
            this.imgNode.setSwitch(swit);
            ((ImageRendererJ3D)renderer).setImageNode(this.imgNode);
            if (((BranchGroup)group).numChildren() > 0) {
                ((BranchGroup)group).setChild((Node)branch, 0);
            } else {
                ((BranchGroup)group).addChild((Node)branch);
            }
        } else {
            this.imgNode = ((ImageRendererJ3D)renderer).getImageNode();
            bgImages = (BranchGroup)this.imgNode.getSwitch().getChild(0);
        }
        GraphicsModeControl mode = (GraphicsModeControl)display.getGraphicsModeControl().clone();
        int[] valueToMap = display.getValueToMap();
        Vector MapVector = display.getMapVector();
        Unit[] dataUnits = null;
        CoordinateSystem dataCoordinateSystem = null;
        if (this.animControl != null) {
            SwitchNotify swit = new SwitchNotify(this.imgNode, numImages);
            this.animControl.addPair(swit, domain_set, renderer);
            ((AVControlJ3D)this.animControl).init();
        }
        domain_set = imgFlatField.getDomainSet();
        dataUnits = imgFlatField.getDomainUnits();
        dataCoordinateSystem = imgFlatField.getDomainCoordinateSystem();
        int domain_length = domain_set.getLength();
        int[] lengths = ((GriddedSet)domain_set).getLengths();
        int data_width = lengths[0];
        int data_height = lengths[1];
        this.imgNode.numImages = numImages;
        this.imgNode.data_width = data_width;
        this.imgNode.data_height = data_height;
        int texture_width_max = link.getDisplay().getDisplayRenderer().getTextureWidthMax();
        int texture_height_max = link.getDisplay().getDisplayRenderer().getTextureWidthMax();
        int texture_width = this.textureWidth(data_width);
        int texture_height = this.textureHeight(data_height);
        if (this.reuseImages && (this.prevImgNode.numImages != numImages || this.prevImgNode.data_width != data_width || this.prevImgNode.data_height != data_height)) {
            this.reuseImages = false;
        }
        if (this.reuseImages) {
            this.imgNode.numChildren = this.prevImgNode.numChildren;
            this.imgNode.imageTiles = this.prevImgNode.imageTiles;
        } else {
            Mosaic mosaic = new Mosaic(data_height, texture_height_max, data_width, texture_width_max);
            Iterator iter2 = mosaic.iterator();
            while (iter2.hasNext()) {
                Tile tile = (Tile)iter2.next();
                this.imgNode.addTile(new VisADImageTile(numImages, tile.height, tile.y_start, tile.width, tile.x_start));
            }
        }
        this.prevImgNode = this.imgNode;
        ShadowRealTupleType Domain2 = this.adaptedShadowType.getDomain();
        Unit[] domain_units = ((RealTupleType)Domain2.getType()).getDefaultUnits();
        float[] constant_color = null;
        if (!Domain2.getAllSpatial() || Domain2.getMultipleDisplayScalar()) {
            throw new BadMappingException("domain must be only spatial");
        }
        boolean isTextureMap = this.adaptedShadowType.getIsTextureMap() && (domain_set instanceof Linear2DSet || domain_set instanceof LinearNDSet && domain_set.getDimension() == 2) && domain_set.getManifoldDimension() == 2;
        boolean bl = curvedTexture = this.adaptedShadowType.getCurvedTexture() && !isTextureMap && curved_size > 0 && (domain_set instanceof Gridded2DSet || domain_set instanceof GriddedSet && domain_set.getDimension() == 2) && domain_set.getManifoldDimension() == 2;
        if (group instanceof BranchGroup) {
            ((ImageRendererJ3D)renderer).setBranchEarly((BranchGroup)group);
        }
        this.first_time = true;
        boolean branch_added = false;
        if (isTextureMap) {
            if (this.imgNode.getNumTiles() == 1) {
                VisADImageTile tile = this.imgNode.getTile(0);
                if (this.regen_colbytes) {
                    this.makeColorBytesDriver(imgFlatField, cmap, cmaps, constant_alpha, RangeComponents, color_length, domain_length, permute, data_width, data_height, imageType, tile, 0);
                }
                if (this.regen_geom) {
                    this.buildLinearTexture(bgImages, domain_set, dataUnits, domain_units, default_values, DomainComponents, valueArrayLength, this.inherited_values, valueToScalar, mode, constant_alpha, value_array, constant_color, display, tile);
                } else {
                    BranchGroup Branch_L1 = (BranchGroup)bgImages.getChild(0);
                    Shape3D shape = (Shape3D)Branch_L1.getChild(0);
                    this.applyTexture(shape, tile, this.apply_alpha, constant_alpha);
                }
            } else {
                BranchGroup branch = null;
                if (!this.reuseImages) {
                    branch = new BranchGroup();
                    branch.setCapability(17);
                    branch.setCapability(14);
                    branch.setCapability(12);
                    branch.setCapability(13);
                } else {
                    branch = (BranchGroup)bgImages.getChild(0);
                }
                int branch_tile_indx = 0;
                Iterator iter3 = this.imgNode.getTileIterator();
                while (iter3.hasNext()) {
                    VisADImageTile tile = (VisADImageTile)iter3.next();
                    if (this.regen_colbytes) {
                        this.makeColorBytesDriver(imgFlatField, cmap, cmaps, constant_alpha, RangeComponents, color_length, domain_length, permute, data_width, data_height, imageType, tile, 0);
                        this.first_time = false;
                    }
                    if (this.regen_geom) {
                        float[][] g00 = ((GriddedSet)domain_set).gridToValue(new float[][]{{tile.xStart}, {tile.yStart}});
                        float[][] g11 = ((GriddedSet)domain_set).gridToValue(new float[][]{{tile.xStart + tile.width - 1}, {tile.yStart + tile.height - 1}});
                        double x0 = g00[0][0];
                        double x1 = g11[0][0];
                        double y0 = g00[1][0];
                        double y1 = g11[1][0];
                        Linear2DSet dset = new Linear2DSet(x0, x1, tile.width, y0, y1, tile.height);
                        BranchGroup branch1 = null;
                        if (!this.reuseImages || this.regen_colbytes && this.regen_geom) {
                            branch1 = new BranchGroup();
                            branch1.setCapability(17);
                            branch1.setCapability(14);
                            branch1.setCapability(12);
                            branch1.setCapability(13);
                        } else {
                            branch1 = (BranchGroup)branch.getChild(branch_tile_indx);
                        }
                        this.buildLinearTexture(branch1, dset, dataUnits, domain_units, default_values, DomainComponents, valueArrayLength, this.inherited_values, valueToScalar, mode, constant_alpha, value_array, constant_color, display, tile);
                        if (!this.reuseImages || this.regen_colbytes && this.regen_geom) {
                            branch.addChild((Node)branch1);
                        }
                        g00 = null;
                        g11 = null;
                        dset = null;
                    } else {
                        BranchGroup branch1 = (BranchGroup)branch.getChild(branch_tile_indx);
                        BranchGroup branch2 = (BranchGroup)branch1.getChild(0);
                        Shape3D shape = (Shape3D)branch2.getChild(0);
                        this.applyTexture(shape, tile, this.apply_alpha, constant_alpha);
                    }
                    if (0 == branch_tile_indx && (!this.reuseImages || this.regen_colbytes && this.regen_geom)) {
                        if (bgImages.numChildren() > 0) {
                            bgImages.setChild((Node)branch, 0);
                        } else {
                            bgImages.addChild((Node)branch);
                        }
                    }
                    ++branch_tile_indx;
                }
            }
        } else {
            int[] lens;
            if (!curvedTexture) throw new BadMappingException("must be texture map or curved texture map");
            int[] domain_lens = lens = ((GriddedSet)domain_set).getLengths();
            if (this.imgNode.getNumTiles() == 1) {
                VisADImageTile tile = this.imgNode.getTile(0);
                if (this.regen_colbytes) {
                    this.makeColorBytesDriver(imgFlatField, cmap, cmaps, constant_alpha, RangeComponents, color_length, domain_length, permute, data_width, data_height, imageType, tile, 0);
                }
                if (this.regen_geom) {
                    this.buildCurvedTexture(bgImages, domain_set, dataUnits, domain_units, default_values, DomainComponents, valueArrayLength, this.inherited_values, valueToScalar, mode, constant_alpha, value_array, constant_color, display, curved_size, Domain2, dataCoordinateSystem, renderer, this.adaptedShadowType, new int[]{0, 0}, domain_lens[0], domain_lens[1], null, domain_lens[0], domain_lens[1], tile);
                } else {
                    BranchGroup Branch_L1 = (BranchGroup)bgImages.getChild(0);
                    Shape3D shape = (Shape3D)Branch_L1.getChild(0);
                    this.applyTexture(shape, tile, this.apply_alpha, constant_alpha);
                }
            } else {
                float[][] samples = ((GriddedSet)domain_set).getSamples(false);
                BranchGroup branch = null;
                if (!this.reuseImages || this.regen_colbytes && this.regen_geom) {
                    branch = new BranchGroup();
                    branch.setCapability(17);
                    branch.setCapability(14);
                    branch.setCapability(12);
                    branch.setCapability(13);
                } else {
                    branch = (BranchGroup)bgImages.getChild(0);
                }
                int branch_tile_indx = 0;
                iter = this.imgNode.getTileIterator();
                while (iter.hasNext()) {
                    BranchGroup branch1;
                    VisADImageTile tile = (VisADImageTile)iter.next();
                    if (this.regen_colbytes) {
                        this.makeColorBytesDriver(imgFlatField, cmap, cmaps, constant_alpha, RangeComponents, color_length, domain_length, permute, data_width, data_height, imageType, tile, 0);
                        this.first_time = false;
                    }
                    if (this.regen_geom) {
                        branch1 = null;
                        if (!this.reuseImages || this.regen_colbytes && this.regen_geom) {
                            branch1 = new BranchGroup();
                            branch1.setCapability(17);
                            branch1.setCapability(14);
                            branch1.setCapability(12);
                            branch1.setCapability(13);
                        } else {
                            branch1 = (BranchGroup)branch.getChild(branch_tile_indx);
                        }
                        this.buildCurvedTexture(branch1, null, dataUnits, domain_units, default_values, DomainComponents, valueArrayLength, this.inherited_values, valueToScalar, mode, constant_alpha, value_array, constant_color, display, curved_size, Domain2, dataCoordinateSystem, renderer, this.adaptedShadowType, new int[]{tile.xStart, tile.yStart}, tile.width, tile.height, samples, domain_lens[0], domain_lens[1], tile);
                        if (!this.reuseImages || this.regen_colbytes && this.regen_geom) {
                            branch.addChild((Node)branch1);
                        }
                    } else {
                        branch1 = (BranchGroup)branch.getChild(branch_tile_indx);
                        BranchGroup branch2 = (BranchGroup)branch1.getChild(0);
                        Shape3D shape = (Shape3D)branch2.getChild(0);
                        this.applyTexture(shape, tile, this.apply_alpha, constant_alpha);
                    }
                    if (0 == branch_tile_indx && (!this.reuseImages || this.regen_colbytes && this.regen_geom)) {
                        if (bgImages.numChildren() > 0) {
                            bgImages.setChild((Node)branch, 0);
                        } else {
                            bgImages.addChild((Node)branch);
                        }
                    }
                    ++branch_tile_indx;
                }
            }
        }
        for (int k = 1; k < numImages; ++k) {
            FlatField ff = (FlatField)((Field)data).getSample(k);
            CoordinateSystem dcs = ff.getDomainCoordinateSystem();
            GriddedSet domSet = (GriddedSet)ff.getDomainSet();
            int[] lens = domSet.getLengths();
            if (this.regen_colbytes && (lens[0] != data_width || lens[1] != data_height || !dcs.equals(dataCoordinateSystem))) {
                ff = (FlatField)ff.resample(imgFlatField.getDomainSet(), 100, 202);
            }
            this.first_time = true;
            this.scaled_Bytes = null;
            this.scaled_Floats = null;
            this.fast_table = null;
            this.rset_scalarmap_lookup = null;
            this.itable = null;
            this.threeD_itable = null;
            this.color_values = null;
            iter = this.imgNode.getTileIterator();
            while (iter.hasNext()) {
                VisADImageTile tile = (VisADImageTile)iter.next();
                if (!this.regen_colbytes) continue;
                this.makeColorBytesDriver(ff, cmap, cmaps, constant_alpha, RangeComponents, color_length, domain_length, permute, data_width, data_height, imageType, tile, k);
                this.first_time = false;
            }
        }
        cmaps = null;
        this.first_time = true;
        this.scaled_Bytes = null;
        this.scaled_Floats = null;
        this.fast_table = null;
        this.rset_scalarmap_lookup = null;
        this.itable = null;
        this.threeD_itable = null;
        this.color_values = null;
        this.ensureNotEmpty(bgImages);
        return false;
    }

    public void makeColorBytesDriver(Data imgFlatField, ScalarMap cmap, ScalarMap[] cmaps, float constant_alpha, ShadowRealType[] RangeComponents, int color_length, int domain_length, int[] permute, int data_width, int data_height, int imageType, VisADImageTile tile, int image_index) throws VisADException, RemoteException {
        BufferedImage image = null;
        byte[] byteData = null;
        int tile_width = tile.width;
        int tile_height = tile.height;
        int xStart = tile.xStart;
        int yStart = tile.yStart;
        int texture_width = this.textureWidth(tile_width);
        int texture_height = this.textureHeight(tile_height);
        if (!this.reuseImages) {
            image = this.createImageByRef(texture_width, texture_height, imageType);
            tile.setImage(image_index, image);
        } else {
            image = tile.getImage(image_index);
        }
        WritableRaster raster = image.getRaster();
        DataBuffer db = raster.getDataBuffer();
        byteData = ((DataBufferByte)db).getData();
        Arrays.fill(byteData, (byte)0);
        this.makeColorBytes(imgFlatField, cmap, cmaps, constant_alpha, RangeComponents, color_length, domain_length, permute, byteData, data_width, data_height, tile_width, tile_height, xStart, yStart, texture_width, texture_height);
    }

    public void makeColorBytes(Data data, ScalarMap cmap, ScalarMap[] cmaps, float constant_alpha, ShadowRealType[] RangeComponents, int color_length, int domain_length, int[] permute, byte[] byteData, int data_width, int data_height, int tile_width, int tile_height, int xStart, int yStart, int texture_width, int texture_height) throws VisADException, RemoteException {
        if (cmap != null) {
            BaseColorControl control = (BaseColorControl)cmap.getControl();
            float[][] table = control.getTable();
            Set rset = null;
            boolean is_default_unit = false;
            if (data instanceof FlatField) {
                RealType rtype;
                Unit def_unit;
                Set[] rsets;
                if (this.first_time) {
                    this.scaled_Bytes = ((FlatField)data).grabBytes();
                }
                if ((rsets = ((FlatField)data).getRangeSets()) != null) {
                    rset = rsets[0];
                }
                if ((def_unit = (rtype = (RealType)RangeComponents[0].getType()).getDefaultUnit()) == null) {
                    is_default_unit = true;
                } else {
                    Unit[][] data_units = ((FlatField)data).getRangeUnits();
                    Unit data_unit = data_units == null ? null : data_units[0][0];
                    is_default_unit = def_unit.equals(data_unit);
                }
            }
            if (table != null) {
                int y;
                byte[] bytes0;
                if (this.first_time) {
                    this.itable = new byte[table[0].length][4];
                    int c = (int)(255.0 * (double)(1.0f - constant_alpha));
                    int a = c < 0 ? 0 : (c > 255 ? 255 : c);
                    for (int j = 0; j < table[0].length; ++j) {
                        int b;
                        c = (int)(255.0 * (double)table[0][j]);
                        int r = c < 0 ? 0 : (c > 255 ? 255 : c);
                        c = (int)(255.0 * (double)table[1][j]);
                        int g = c < 0 ? 0 : (c > 255 ? 255 : c);
                        c = (int)(255.0 * (double)table[2][j]);
                        int n = c < 0 ? 0 : (b = c > 255 ? 255 : c);
                        if (color_length == 4) {
                            c = (int)(255.0 * (double)table[3][j]);
                            a = c < 0 ? 0 : (c > 255 ? 255 : c);
                        }
                        this.itable[j][0] = (byte)r;
                        this.itable[j][1] = (byte)g;
                        this.itable[j][2] = (byte)b;
                        this.itable[j][3] = (byte)a;
                    }
                }
                int tblEnd = table[0].length - 1;
                int table_scale = table[0].length;
                if (data instanceof ImageFlatField && this.scaled_Bytes != null && is_default_unit) {
                    if (this.first_time) {
                        this.scaled_Bytes[0] = cmap.scaleValues(this.scaled_Bytes[0], table_scale);
                    }
                    bytes0 = this.scaled_Bytes[0];
                    int k = 0;
                    int color_length_times_texture_width = texture_width * color_length;
                    for (y = 0; y < tile_height; ++y) {
                        int image_col_factor = (y + yStart) * data_width + xStart;
                        k = y * color_length_times_texture_width;
                        for (int x = 0; x < tile_width; ++x) {
                            int ndx;
                            int i = x + image_col_factor;
                            int j = bytes0[i] & 0xFF;
                            int n = j < 0 ? 0 : (ndx = j > tblEnd ? tblEnd : j);
                            if (color_length == 4) {
                                byteData[k] = this.itable[ndx][3];
                                byteData[k + 1] = this.itable[ndx][2];
                                byteData[k + 2] = this.itable[ndx][1];
                                byteData[k + 3] = this.itable[ndx][0];
                            }
                            if (color_length == 3) {
                                byteData[k] = this.itable[ndx][2];
                                byteData[k + 1] = this.itable[ndx][1];
                                byteData[k + 2] = this.itable[ndx][0];
                            }
                            if (color_length == 1) {
                                byteData[k] = this.itable[ndx][0];
                            }
                            k += color_length;
                        }
                    }
                } else if (this.scaled_Bytes != null && this.scaled_Bytes[0] != null && is_default_unit && rset != null && rset instanceof Linear1DSet) {
                    if (this.first_time) {
                        double first = ((Linear1DSet)rset).getFirst();
                        double step = ((Linear1DSet)rset).getStep();
                        double[] so = new double[2];
                        double[] da = new double[2];
                        double[] di = new double[2];
                        cmap.getScale(so, da, di);
                        double scale = so[0];
                        double offset = so[1];
                        float mult = (float)((double)table_scale * scale * step);
                        float add = (float)((double)table_scale * (offset + scale * first));
                        this.fast_table = new byte[256][];
                        for (int j = 0; j < 256; ++j) {
                            int index = j - 1;
                            if (index < 0) continue;
                            int k = (int)(add + mult * (float)index);
                            int ndx = k < 0 ? 0 : (k > tblEnd ? tblEnd : k);
                            this.fast_table[j] = this.itable[ndx];
                        }
                    }
                    bytes0 = this.scaled_Bytes[0];
                    int k = 0;
                    int color_length_times_texture_width = texture_width * color_length;
                    for (y = 0; y < tile_height; ++y) {
                        int image_col_factor = (y + yStart) * data_width + xStart;
                        k = y * color_length_times_texture_width;
                        for (int x = 0; x < tile_width; ++x) {
                            int i = x + image_col_factor;
                            int ndx = bytes0[i] - -128;
                            if (color_length == 4) {
                                byteData[k] = this.itable[ndx][3];
                                byteData[k + 1] = this.itable[ndx][2];
                                byteData[k + 2] = this.itable[ndx][1];
                                byteData[k + 3] = this.itable[ndx][0];
                            }
                            if (color_length == 3) {
                                byteData[k] = this.itable[ndx][2];
                                byteData[k + 1] = this.itable[ndx][1];
                                byteData[k + 2] = this.itable[ndx][0];
                            }
                            if (color_length == 1) {
                                byteData[k] = this.itable[ndx][0];
                            }
                            k += color_length;
                        }
                    }
                } else {
                    if (this.first_time) {
                        this.scaled_Bytes = null;
                        this.scaled_Floats = ((Field)data).getFloats(false);
                        if (rset instanceof Integer1DSet) {
                            this.rset_scalarmap_lookup = new float[1][rset.getLength()];
                            for (int i = 0; i < this.rset_scalarmap_lookup[0].length; ++i) {
                                this.rset_scalarmap_lookup[0][i] = i;
                            }
                            this.rset_scalarmap_lookup[0] = cmap.scaleValues(this.rset_scalarmap_lookup[0], false);
                        } else {
                            this.scaled_Floats[0] = cmap.scaleValues(this.scaled_Floats[0]);
                        }
                    }
                    float[] values0 = this.scaled_Floats[0];
                    int k = 0;
                    int color_length_times_texture_width = texture_width * color_length;
                    int image_col_offset = yStart * data_width + xStart;
                    int image_col_factor = 0;
                    for (int y2 = 0; y2 < tile_height; ++y2) {
                        image_col_factor = y2 * data_width + image_col_offset;
                        k = y2 * color_length_times_texture_width;
                        for (int x = 0; x < tile_width; ++x) {
                            int i = x + image_col_factor;
                            if (!Float.isNaN(values0[i])) {
                                int ndx;
                                int j = 0;
                                j = null != this.rset_scalarmap_lookup && null != this.rset_scalarmap_lookup[0] ? (int)((float)table_scale * this.rset_scalarmap_lookup[0][(int)values0[i]]) : (int)((float)table_scale * values0[i]);
                                int n = j < 0 ? 0 : (ndx = j > tblEnd ? tblEnd : j);
                                if (color_length == 4) {
                                    byteData[k] = this.itable[ndx][3];
                                    byteData[k + 1] = this.itable[ndx][2];
                                    byteData[k + 2] = this.itable[ndx][1];
                                    byteData[k + 3] = this.itable[ndx][0];
                                }
                                if (color_length == 3) {
                                    byteData[k] = this.itable[ndx][2];
                                    byteData[k + 1] = this.itable[ndx][1];
                                    byteData[k + 2] = this.itable[ndx][0];
                                }
                                if (color_length == 1) {
                                    byteData[k] = this.itable[ndx][0];
                                }
                            }
                            k += color_length;
                        }
                    }
                }
            } else {
                int c;
                if (this.first_time) {
                    this.scaled_Bytes = null;
                    this.itable = null;
                    this.scaled_Floats = ((Field)data).getFloats(false);
                    this.scaled_Floats[0] = cmap.scaleValues(this.scaled_Floats[0]);
                    this.color_values = control.lookupValues(this.scaled_Floats[0]);
                }
                int a = (c = (int)(255.0 * (double)(1.0f - constant_alpha))) < 0 ? 0 : (c > 255 ? 255 : c);
                int k = 0;
                int color_length_times_texture_width = texture_width * color_length;
                int image_col_offset = yStart * data_width + xStart;
                int image_col_factor = 0;
                for (int y = 0; y < tile_height; ++y) {
                    image_col_factor = y * data_width + image_col_offset;
                    k = y * color_length_times_texture_width;
                    for (int x = 0; x < tile_width; ++x) {
                        int i = x + image_col_factor;
                        if (!Float.isNaN(this.scaled_Floats[0][i])) {
                            int b;
                            c = (int)(255.0 * (double)this.color_values[0][i]);
                            int r = c < 0 ? 0 : (c > 255 ? 255 : c);
                            c = (int)(255.0 * (double)this.color_values[1][i]);
                            int g = c < 0 ? 0 : (c > 255 ? 255 : c);
                            c = (int)(255.0 * (double)this.color_values[2][i]);
                            int n = c < 0 ? 0 : (b = c > 255 ? 255 : c);
                            if (color_length == 4) {
                                c = (int)(255.0 * (double)this.color_values[3][i]);
                                int n2 = c < 0 ? 0 : (a = c > 255 ? 255 : c);
                            }
                            if (color_length == 4) {
                                byteData[k] = (byte)a;
                                byteData[k + 1] = (byte)b;
                                byteData[k + 2] = (byte)g;
                                byteData[k + 3] = (byte)r;
                            }
                            if (color_length == 3) {
                                byteData[k] = (byte)b;
                                byteData[k + 1] = (byte)g;
                                byteData[k + 2] = (byte)r;
                            }
                            if (color_length == 1) {
                                byteData[k] = (byte)b;
                            }
                        }
                        k += color_length;
                    }
                }
            }
        } else if (cmaps != null) {
            int b;
            int g;
            int r;
            int c;
            int map_indx;
            Set[] rsets = null;
            if (data instanceof ImageFlatField && this.first_time) {
                this.scaled_Bytes = ((FlatField)data).grabBytes();
            }
            if (data instanceof FlatField) {
                rsets = ((FlatField)data).getRangeSets();
            }
            boolean isRGBRGBRGB = cmaps[0].getDisplayScalar() == Display.RGB && cmaps[1].getDisplayScalar() == Display.RGB && cmaps[2].getDisplayScalar() == Display.RGB;
            boolean tableEnd = false;
            if (this.first_time && isRGBRGBRGB) {
                this.threeD_itable = new byte[cmaps.length][][];
                for (map_indx = 0; map_indx < cmaps.length; ++map_indx) {
                    BaseColorControl basecolorcontrol = (BaseColorControl)cmaps[map_indx].getControl();
                    float[][] color_table = basecolorcontrol.getTable();
                    this.threeD_itable[map_indx] = new byte[color_table[0].length][3];
                    for (int table_indx = 0; table_indx < this.threeD_itable[map_indx].length; ++table_indx) {
                        c = (int)(255.0 * (double)color_table[0][table_indx]);
                        r = c < 0 ? 0 : (c > 255 ? 255 : c);
                        c = (int)(255.0 * (double)color_table[1][table_indx]);
                        g = c < 0 ? 0 : (c > 255 ? 255 : c);
                        c = (int)(255.0 * (double)color_table[2][table_indx]);
                        b = c < 0 ? 0 : (c > 255 ? 255 : c);
                        this.threeD_itable[map_indx][table_indx][0] = (byte)r;
                        this.threeD_itable[map_indx][table_indx][1] = (byte)g;
                        this.threeD_itable[map_indx][table_indx][2] = (byte)b;
                    }
                }
            }
            if (this.scaled_Bytes != null) {
                if (cmaps[0].getDisplayScalar() == Display.RGB && cmaps[1].getDisplayScalar() == Display.RGB && cmaps[2].getDisplayScalar() == Display.RGB) {
                    map_indx = 0;
                    for (map_indx = 0; map_indx < cmaps.length; ++map_indx) {
                        int table_length = this.threeD_itable[0].length;
                        int color_indx = permute[map_indx];
                        if (this.first_time) {
                            this.scaled_Bytes[color_indx] = cmaps[color_indx].scaleValues(this.scaled_Bytes[color_indx], table_length);
                        }
                        int domainLength = this.scaled_Bytes[color_indx].length;
                        int tblEnd = table_length - 1;
                        int data_indx = 0;
                        int texture_index = 0;
                        int image_col_offset = yStart * data_width + xStart;
                        int image_col_factor = 0;
                        for (int y = 0; y < tile_height; ++y) {
                            image_col_factor = y * data_width + image_col_offset;
                            for (int x = 0; x < tile_width; ++x) {
                                data_indx = x + image_col_factor;
                                texture_index = x + y * texture_width;
                                int j = this.scaled_Bytes[color_indx][data_indx] & 0xFF;
                                int ndx = j < 0 ? 0 : (j > tblEnd ? tblEnd : j);
                                byteData[(texture_index *= color_length) + (color_length - color_indx - 1)] = this.threeD_itable[map_indx][ndx][map_indx];
                            }
                        }
                    }
                } else {
                    int data_indx = 0;
                    int texture_index = 0;
                    boolean offset = false;
                    c = 0;
                    if (color_length == 4) {
                        c = (int)(255.0 * (double)(1.0f - constant_alpha));
                    }
                    int color_length_times_texture_width = color_length * texture_width;
                    int image_col_offset = yStart * data_width + xStart;
                    int image_col_factor = 0;
                    for (int y = 0; y < tile_height; ++y) {
                        image_col_factor = y * data_width + image_col_offset;
                        texture_index = y * color_length_times_texture_width;
                        for (int x = 0; x < tile_width; ++x) {
                            data_indx = x + image_col_factor;
                            if (color_length == 4) {
                                byteData[texture_index] = (byte)c;
                                byteData[texture_index + 1] = this.scaled_Bytes[2][data_indx];
                                byteData[texture_index + 2] = this.scaled_Bytes[1][data_indx];
                                byteData[texture_index + 3] = this.scaled_Bytes[0][data_indx];
                            } else {
                                byteData[texture_index] = this.scaled_Bytes[2][data_indx];
                                byteData[texture_index + 1] = this.scaled_Bytes[1][data_indx];
                                byteData[texture_index + 2] = this.scaled_Bytes[0][data_indx];
                            }
                            texture_index += color_length;
                        }
                    }
                }
            } else {
                if (this.first_time) {
                    float[][] values = ((Field)data).getFloats(false);
                    this.scaled_Floats = new float[3][];
                    for (int i = 0; i < this.scaled_Floats.length; ++i) {
                        if (rsets != null) {
                            if (rsets[permute[i]] instanceof Integer1DSet) {
                                if (null == this.rset_scalarmap_lookup) {
                                    this.rset_scalarmap_lookup = new float[3][];
                                }
                                this.rset_scalarmap_lookup[i] = new float[rsets[permute[i]].getLength()];
                                for (int j = 0; j < this.rset_scalarmap_lookup[i].length; ++j) {
                                    this.rset_scalarmap_lookup[i][j] = j;
                                }
                                this.rset_scalarmap_lookup[i] = cmaps[permute[i]].scaleValues(this.rset_scalarmap_lookup[i], false);
                                this.scaled_Floats[i] = values[permute[i]];
                                continue;
                            }
                            this.scaled_Floats[i] = cmaps[permute[i]].scaleValues(values[permute[i]]);
                            continue;
                        }
                        this.scaled_Floats[i] = cmaps[permute[i]].scaleValues(values[permute[i]]);
                    }
                }
                int a = (c = (int)(255.0 * (double)(1.0f - constant_alpha))) < 0 ? 0 : (c > 255 ? 255 : c);
                boolean m = false;
                int[] RGB_tableEnd = null;
                if (isRGBRGBRGB) {
                    RGB_tableEnd = new int[this.threeD_itable.length];
                    for (int indx = 0; indx < this.threeD_itable.length; ++indx) {
                        RGB_tableEnd[indx] = this.threeD_itable[indx].length - 1;
                    }
                }
                int k = 0;
                int color_length_times_texture_width = color_length * texture_width;
                int image_col_offset = yStart * data_width + xStart;
                int image_col_factor = 0;
                for (int y = 0; y < tile_height; ++y) {
                    image_col_factor = y * data_width + image_col_offset;
                    k = y * color_length_times_texture_width;
                    for (int x = 0; x < tile_width; ++x) {
                        int i = x + image_col_factor;
                        if (!(Float.isNaN(this.scaled_Floats[0][i]) || Float.isNaN(this.scaled_Floats[1][i]) || Float.isNaN(this.scaled_Floats[2][i]))) {
                            r = 0;
                            g = 0;
                            b = 0;
                            if (isRGBRGBRGB) {
                                int indx = -1;
                                indx = this.rset_scalarmap_lookup != null && this.rset_scalarmap_lookup[0] != null ? (int)((float)RGB_tableEnd[0] * this.rset_scalarmap_lookup[0][(int)this.scaled_Floats[0][i]]) : (int)((float)RGB_tableEnd[0] * this.scaled_Floats[0][i]);
                                indx = indx < 0 ? 0 : (indx > RGB_tableEnd[0] ? RGB_tableEnd[0] : indx);
                                r = this.threeD_itable[0][indx][0];
                                indx = this.rset_scalarmap_lookup != null && this.rset_scalarmap_lookup[1] != null ? (int)((float)RGB_tableEnd[1] * this.rset_scalarmap_lookup[1][(int)this.scaled_Floats[1][i]]) : (int)((float)RGB_tableEnd[1] * this.scaled_Floats[1][i]);
                                indx = indx < 0 ? 0 : (indx > RGB_tableEnd[1] ? RGB_tableEnd[1] : indx);
                                g = this.threeD_itable[1][indx][1];
                                indx = this.rset_scalarmap_lookup != null && this.rset_scalarmap_lookup[2] != null ? (int)((float)RGB_tableEnd[2] * this.rset_scalarmap_lookup[2][(int)this.scaled_Floats[2][i]]) : (int)((float)RGB_tableEnd[2] * this.scaled_Floats[2][i]);
                                indx = indx < 0 ? 0 : (indx > RGB_tableEnd[2] ? RGB_tableEnd[2] : indx);
                                b = this.threeD_itable[2][indx][2];
                            } else {
                                c = this.rset_scalarmap_lookup != null && this.rset_scalarmap_lookup[0] != null ? (int)(255.0 * (double)this.rset_scalarmap_lookup[0][(int)this.scaled_Floats[0][i]]) : (int)(255.0 * (double)this.scaled_Floats[0][i]);
                                r = c < 0 ? 0 : (c > 255 ? 255 : c);
                                c = this.rset_scalarmap_lookup != null && this.rset_scalarmap_lookup[1] != null ? (int)(255.0 * (double)this.rset_scalarmap_lookup[1][(int)this.scaled_Floats[1][i]]) : (int)(255.0 * (double)this.scaled_Floats[1][i]);
                                g = c < 0 ? 0 : (c > 255 ? 255 : c);
                                c = this.rset_scalarmap_lookup != null && this.rset_scalarmap_lookup[2] != null ? (int)(255.0 * (double)this.rset_scalarmap_lookup[2][(int)this.scaled_Floats[2][i]]) : (int)(255.0 * (double)this.scaled_Floats[2][i]);
                                int n = c < 0 ? 0 : (b = c > 255 ? 255 : c);
                            }
                            if (color_length == 4) {
                                byteData[k] = (byte)a;
                                byteData[k + 1] = (byte)b;
                                byteData[k + 2] = (byte)g;
                                byteData[k + 3] = (byte)r;
                            }
                            if (color_length == 3) {
                                byteData[k] = (byte)b;
                                byteData[k + 1] = (byte)g;
                                byteData[k + 2] = (byte)r;
                            }
                            if (color_length == 1) {
                                byteData[k] = (byte)b;
                            }
                        }
                        k += color_length;
                    }
                }
                RGB_tableEnd = null;
            }
        } else {
            throw new BadMappingException("cmap == null and cmaps == null ??");
        }
    }

    public void buildCurvedTexture(Object group, Set domain_set, Unit[] dataUnits, Unit[] domain_units, float[] default_values, ShadowRealType[] DomainComponents, int valueArrayLength, int[] inherited_values, int[] valueToScalar, GraphicsModeControl mode, float constant_alpha, float[] value_array, float[] constant_color, DisplayImpl display, int curved_size, ShadowRealTupleType Domain2, CoordinateSystem dataCoordinateSystem, DataRenderer renderer, ShadowFunctionOrSetType adaptedShadowType, int[] start, int lenX, int lenY, float[][] samples, int bigX, int bigY, VisADImageTile tile) throws VisADException, DisplayException {
        RealTupleType ref;
        float[] coordinates = null;
        float[] texCoords = null;
        int data_width = 0;
        int data_height = 0;
        int texture_width = 1;
        int texture_height = 1;
        int[] lengths = null;
        if (dataCoordinateSystem instanceof CachingCoordinateSystem) {
            dataCoordinateSystem = ((CachingCoordinateSystem)dataCoordinateSystem).getCachedCoordinateSystem();
        }
        lengths = domain_set != null ? ((GriddedSet)domain_set).getLengths() : new int[]{lenX, lenY};
        data_width = lengths[0];
        data_height = lengths[1];
        texture_width = this.textureWidth(data_width);
        texture_height = this.textureHeight(data_height);
        ShadowRealTupleType domain_reference = Domain2.getReference();
        ShadowRealType[] DC = DomainComponents;
        if (domain_reference != null && domain_reference.getMappedDisplayScalar()) {
            ref = (RealTupleType)domain_reference.getType();
            renderer.setEarthSpatialData(Domain2, domain_reference, ref, ref.getDefaultUnits(), (RealTupleType)Domain2.getType(), new CoordinateSystem[]{dataCoordinateSystem}, domain_units);
            DC = adaptedShadowType.getDomainReferenceComponents();
        } else {
            ref = domain_reference == null ? null : (RealTupleType)domain_reference.getType();
            Unit[] ref_units = ref == null ? null : ref.getDefaultUnits();
            renderer.setEarthSpatialData(Domain2, domain_reference, ref, ref_units, (RealTupleType)Domain2.getType(), new CoordinateSystem[]{dataCoordinateSystem}, domain_units);
        }
        int[] tuple_index = new int[3];
        int[] spatial_value_indices = new int[]{-1, -1, -1};
        ScalarMap[] spatial_maps = new ScalarMap[3];
        DisplayTupleType spatial_tuple = null;
        for (int i = 0; i < DC.length; ++i) {
            Enumeration maps = DC[i].getSelectedMapVector().elements();
            ScalarMap map = (ScalarMap)maps.nextElement();
            DisplayRealType real = map.getDisplayScalar();
            spatial_tuple = real.getTuple();
            if (spatial_tuple == null) {
                throw new DisplayException("texture with bad tuple: ShadowImageFunctionTypeJ3D.doTransform");
            }
            tuple_index[i] = real.getTupleIndex();
            spatial_value_indices[tuple_index[i]] = map.getValueIndex();
            spatial_maps[tuple_index[i]] = map;
            if (!maps.hasMoreElements()) continue;
            throw new DisplayException("texture with multiple spatial: ShadowImageFunctionTypeJ3D.doTransform");
        }
        tuple_index[2] = 3 - (tuple_index[0] + tuple_index[1]);
        DisplayRealType real = (DisplayRealType)spatial_tuple.getComponent(tuple_index[2]);
        int value2_index = display.getDisplayScalarIndex(real);
        float value2 = default_values[value2_index];
        for (int i = 0; i < valueArrayLength; ++i) {
            if (inherited_values[i] <= 0 || !real.equals(display.getDisplayScalar(valueToScalar[i]))) continue;
            value2 = value_array[i];
            break;
        }
        boolean useLinearTexture = false;
        double[] scale = null;
        double[] offset = null;
        CoordinateSystem coord = null;
        if (spatial_tuple.equals(Display.DisplaySpatialCartesianTuple)) {
            renderer.setEarthSpatialDisplay(null, spatial_tuple, display, spatial_value_indices, default_values, null);
        } else {
            coord = spatial_tuple.getCoordinateSystem();
            if (coord instanceof CachingCoordinateSystem) {
                coord = ((CachingCoordinateSystem)coord).getCachedCoordinateSystem();
            }
            if (coord instanceof InverseLinearScaledCS) {
                InverseLinearScaledCS invCS = (InverseLinearScaledCS)((Object)coord);
                useLinearTexture = invCS.getInvertedCoordinateSystem().equals(dataCoordinateSystem);
                scale = invCS.getScale();
                offset = invCS.getOffset();
            }
            renderer.setEarthSpatialDisplay(coord, spatial_tuple, display, spatial_value_indices, default_values, null);
        }
        if (useLinearTexture) {
            float scaleX = (float)scale[0];
            float scaleY = (float)scale[1];
            float offsetX = (float)offset[0];
            float offsetY = (float)offset[1];
            float[][] xyCoords = null;
            if (domain_set != null) {
                xyCoords = ShadowImageByRefFunctionTypeJ3D.getBounds(domain_set, data_width, data_height, scaleX, offsetX, scaleY, offsetY);
            } else {
                int indx0 = start[0] + start[1] * bigX;
                int indx1 = start[0] + (start[1] + lenY - 1) * bigX;
                int indx2 = start[0] + lenX - 1 + (start[1] + lenY - 1) * bigX;
                int indx3 = start[0] + lenX - 1 + start[1] * bigX;
                float x0 = samples[0][indx0];
                float y0 = samples[1][indx0];
                float x1 = samples[0][indx1];
                float y1 = samples[1][indx1];
                float x2 = samples[0][indx2];
                float y2 = samples[1][indx2];
                float x3 = samples[0][indx3];
                float y3 = samples[1][indx3];
                xyCoords = new float[2][4];
                xyCoords[0][0] = (x0 - offsetX) / scaleX;
                xyCoords[1][0] = (y0 - offsetY) / scaleY;
                xyCoords[0][1] = (x1 - offsetX) / scaleX;
                xyCoords[1][1] = (y1 - offsetY) / scaleY;
                xyCoords[0][2] = (x2 - offsetX) / scaleX;
                xyCoords[1][2] = (y2 - offsetY) / scaleY;
                xyCoords[0][3] = (x3 - offsetX) / scaleX;
                xyCoords[1][3] = (y3 - offsetY) / scaleY;
            }
            coordinates = new float[12];
            coordinates[tuple_index[0]] = xyCoords[0][0];
            coordinates[tuple_index[1]] = xyCoords[1][0];
            coordinates[tuple_index[2]] = value2;
            coordinates[3 + tuple_index[0]] = xyCoords[0][1];
            coordinates[3 + tuple_index[1]] = xyCoords[1][1];
            coordinates[3 + tuple_index[2]] = value2;
            coordinates[6 + tuple_index[0]] = xyCoords[0][2];
            coordinates[6 + tuple_index[1]] = xyCoords[1][2];
            coordinates[6 + tuple_index[2]] = value2;
            coordinates[9 + tuple_index[0]] = xyCoords[0][3];
            coordinates[9 + tuple_index[1]] = xyCoords[1][3];
            coordinates[9 + tuple_index[2]] = value2;
            this.adjustZ(coordinates);
            texCoords = new float[8];
            float ratiow = (float)data_width / (float)texture_width;
            float ratioh = (float)data_height / (float)texture_height;
            boolean yUp = true;
            this.setTexCoords(texCoords, ratiow, ratioh, yUp);
            VisADQuadArray qarray = new VisADQuadArray();
            qarray.vertexCount = 4;
            qarray.coordinates = coordinates;
            qarray.texCoords = texCoords;
            if (!this.reuseImages || this.regen_colbytes && this.regen_geom) {
                BufferedImage image = tile.getImage(0);
                this.textureToGroup(group, qarray, image, mode, constant_alpha, constant_color, texture_width, texture_height, true, true, tile);
            } else {
                int num_children = ((BranchGroup)group).numChildren();
                if (num_children > 0) {
                    BranchGroup branch1 = (BranchGroup)((BranchGroup)group).getChild(0);
                    Shape3D shape = (Shape3D)branch1.getChild(0);
                    shape.setGeometry((Geometry)((DisplayImplJ3D)display).makeGeometry(qarray));
                }
                if (this.animControl == null) {
                    this.imgNode.setCurrent(0);
                }
            }
        } else {
            int len;
            int i;
            int size = (data_width + data_height) / 2;
            curved_size = Math.max(1, Math.min(curved_size, size / 32));
            int nwidth = 2 + (data_width - 1) / curved_size;
            int nheight = 2 + (data_height - 1) / curved_size;
            int nn = nwidth * nheight;
            int[] is = new int[nwidth];
            int[] js = new int[nheight];
            for (int i2 = 0; i2 < nwidth; ++i2) {
                is[i2] = Math.min(i2 * curved_size, data_width - 1);
            }
            for (int j = 0; j < nheight; ++j) {
                js[j] = Math.min(j * curved_size, data_height - 1);
            }
            int k = 0;
            float[][] spline_domain = null;
            if (domain_set == null) {
                spline_domain = new float[2][nn];
                int kk = 0;
                int ndx = 0;
                int col_factor = 0;
                for (int j = 0; j < nheight; ++j) {
                    col_factor = (start[1] + js[j]) * bigX;
                    for (int i3 = 0; i3 < nwidth; ++i3) {
                        ndx = start[0] + is[i3] + col_factor;
                        spline_domain[0][kk] = samples[0][ndx];
                        spline_domain[1][kk] = samples[1][ndx];
                        ++kk;
                    }
                }
            } else {
                int[] indices = new int[nn];
                k = 0;
                for (int j = 0; j < nheight; ++j) {
                    int col_factor = data_width * js[j];
                    for (i = 0; i < nwidth; ++i) {
                        indices[k] = is[i] + col_factor;
                        ++k;
                    }
                }
                spline_domain = domain_set.indexToValue(indices);
                indices = null;
            }
            spline_domain = Unit.convertTuple(spline_domain, dataUnits, domain_units, false);
            if (domain_reference != null && domain_reference.getMappedDisplayScalar()) {
                RealTupleType ref2 = (RealTupleType)domain_reference.getType();
                spline_domain = CoordinateSystem.transformCoordinates(ref2, null, ref2.getDefaultUnits(), null, (RealTupleType)Domain2.getType(), dataCoordinateSystem, domain_units, null, spline_domain);
            }
            Object spatial_values = new float[3][];
            spatial_values[tuple_index[0]] = spline_domain[0];
            spatial_values[tuple_index[1]] = spline_domain[1];
            for (int i4 = 0; i4 < 3; ++i4) {
                if (spatial_maps[i4] == null) continue;
                spatial_values[i4] = spatial_maps[i4].scaleValues(spatial_values[i4], false);
            }
            if (!spatial_tuple.equals(Display.DisplaySpatialCartesianTuple)) {
                spatial_values = coord.toReference((float[][])spatial_values);
            }
            boolean isSpherical = spatial_tuple.equals(Display.DisplaySpatialSphericalTuple);
            boolean spatial_all_select = true;
            if (isSpherical) {
                for (i = 0; i < nn; ++i) {
                    if (!Float.isNaN(spatial_values[0][i]) && !Float.isNaN(spatial_values[1][i]) && !Float.isNaN(spatial_values[2][i])) continue;
                    spatial_all_select = false;
                    break;
                }
            } else if (Float.isNaN(value2)) {
                spatial_all_select = false;
            } else {
                for (i = 0; i < nn; ++i) {
                    if (!Float.isNaN(spatial_values[0][i]) && !Float.isNaN(spatial_values[1][i])) continue;
                    spatial_all_select = false;
                    break;
                }
            }
            VisADTriangleStripArray tarray = new VisADTriangleStripArray();
            tarray.stripVertexCounts = new int[nheight - 1];
            Arrays.fill(tarray.stripVertexCounts, 2 * nwidth);
            tarray.vertexCount = len = (nheight - 1) * (2 * nwidth);
            tarray.coordinates = new float[3 * len];
            tarray.texCoords = new float[2 * len];
            int m = 0;
            k = 0;
            int kt = 0;
            float y_coord = 0.0f;
            float y_coord2 = 0.0f;
            float x_coord = 0.0f;
            for (int j = 0; j < nheight - 1; ++j) {
                y_coord = 0 == j ? (0.5f + (float)js[j]) / (float)texture_height : y_coord2;
                y_coord2 = (0.5f + (float)js[j + 1]) / (float)texture_height;
                for (int i5 = 0; i5 < nwidth; ++i5) {
                    tarray.coordinates[k++] = spatial_values[0][m];
                    tarray.coordinates[k++] = spatial_values[1][m];
                    tarray.coordinates[k++] = value2;
                    tarray.coordinates[k++] = spatial_values[0][m + nwidth];
                    tarray.coordinates[k++] = spatial_values[1][m + nwidth];
                    tarray.coordinates[k++] = value2;
                    x_coord = (0.5f + (float)is[i5]) / (float)texture_width;
                    tarray.texCoords[kt++] = x_coord;
                    tarray.texCoords[kt++] = y_coord;
                    tarray.texCoords[kt++] = x_coord;
                    tarray.texCoords[kt++] = y_coord2;
                    ++m;
                }
            }
            is = null;
            js = null;
            spatial_values[0] = null;
            spatial_values[1] = null;
            spatial_values[2] = null;
            spatial_values = null;
            spline_domain[0] = null;
            spline_domain[1] = null;
            spline_domain = null;
            if (!spatial_all_select) {
                tarray = (VisADTriangleStripArray)tarray.removeMissing();
            }
            if (adaptedShadowType.getAdjustProjectionSeam()) {
                tarray = (VisADTriangleStripArray)tarray.adjustLongitude(renderer);
                tarray = (VisADTriangleStripArray)tarray.adjustSeam(renderer);
            }
            if (!this.reuseImages || this.regen_colbytes && this.regen_geom) {
                BufferedImage image = tile.getImage(0);
                this.textureToGroup(group, tarray, image, mode, constant_alpha, constant_color, texture_width, texture_height, true, true, tile);
            } else {
                int num_children = ((BranchGroup)group).numChildren();
                if (num_children > 0) {
                    BranchGroup branch1 = (BranchGroup)((BranchGroup)group).getChild(0);
                    Shape3D shape = (Shape3D)branch1.getChild(0);
                    shape.setGeometry((Geometry)((DisplayImplJ3D)display).makeGeometry(tarray));
                }
                if (this.animControl == null) {
                    this.imgNode.setCurrent(0);
                }
            }
        }
        tuple_index = null;
    }

    public void buildLinearTexture(Object group, Set domain_set, Unit[] dataUnits, Unit[] domain_units, float[] default_values, ShadowRealType[] DomainComponents, int valueArrayLength, int[] inherited_values, int[] valueToScalar, GraphicsModeControl mode, float constant_alpha, float[] value_array, float[] constant_color, DisplayImpl display, VisADImageTile tile) throws VisADException, DisplayException {
        float[] coordinates = null;
        float[] texCoords = null;
        Object normals = null;
        int data_width = 0;
        int data_height = 0;
        int texture_width = 1;
        int texture_height = 1;
        Linear1DSet X = null;
        Linear1DSet Y = null;
        if (domain_set instanceof Linear2DSet) {
            X = ((Linear2DSet)domain_set).getX();
            Y = ((Linear2DSet)domain_set).getY();
        } else {
            X = ((LinearNDSet)domain_set).getLinear1DComponent(0);
            Y = ((LinearNDSet)domain_set).getLinear1DComponent(1);
        }
        float[][] limits = new float[2][2];
        limits[0][0] = (float)X.getFirst();
        limits[0][1] = (float)X.getLast();
        limits[1][0] = (float)Y.getFirst();
        limits[1][1] = (float)Y.getLast();
        data_width = X.getLength();
        data_height = Y.getLength();
        texture_width = this.textureWidth(data_width);
        texture_height = this.textureHeight(data_height);
        float half_width = 0.5f / (float)(data_width - 1);
        float half_height = 0.5f / (float)(data_height - 1);
        half_width = (limits[0][1] - limits[0][0]) * half_width;
        half_height = (limits[1][1] - limits[1][0]) * half_height;
        float[] fArray = limits[0];
        fArray[0] = fArray[0] - half_width;
        float[] fArray2 = limits[0];
        fArray2[1] = fArray2[1] + half_width;
        float[] fArray3 = limits[1];
        fArray3[0] = fArray3[0] - half_height;
        float[] fArray4 = limits[1];
        fArray4[1] = fArray4[1] + half_height;
        limits = Unit.convertTuple(limits, dataUnits, domain_units);
        int[] tuple_index = new int[3];
        if (DomainComponents.length != 2) {
            throw new DisplayException("texture domain dimension != 2:ShadowFunctionOrSetType.doTransform");
        }
        for (int i = 0; i < DomainComponents.length; ++i) {
            Enumeration maps = DomainComponents[i].getSelectedMapVector().elements();
            ScalarMap map = (ScalarMap)maps.nextElement();
            limits[i] = map.scaleValues(limits[i]);
            DisplayRealType real = map.getDisplayScalar();
            DisplayTupleType tuple = real.getTuple();
            if (tuple == null || !tuple.equals(Display.DisplaySpatialCartesianTuple)) {
                throw new DisplayException("texture with bad tuple: ShadowFunctionOrSetType.doTransform");
            }
            tuple_index[i] = real.getTupleIndex();
            if (!maps.hasMoreElements()) continue;
            throw new DisplayException("texture with multiple spatial: ShadowFunctionOrSetType.doTransform");
        }
        tuple_index[2] = 3 - (tuple_index[0] + tuple_index[1]);
        DisplayRealType real = (DisplayRealType)Display.DisplaySpatialCartesianTuple.getComponent(tuple_index[2]);
        int value2_index = display.getDisplayScalarIndex(real);
        float value2 = default_values[value2_index];
        for (int i = 0; i < valueArrayLength; ++i) {
            if (inherited_values[i] <= 0 || !real.equals(display.getDisplayScalar(valueToScalar[i]))) continue;
            value2 = value_array[i];
            break;
        }
        coordinates = new float[12];
        coordinates[tuple_index[0]] = limits[0][0];
        coordinates[tuple_index[1]] = limits[1][0];
        coordinates[tuple_index[2]] = value2;
        coordinates[3 + tuple_index[0]] = limits[0][0];
        coordinates[3 + tuple_index[1]] = limits[1][1];
        coordinates[3 + tuple_index[2]] = value2;
        coordinates[6 + tuple_index[0]] = limits[0][1];
        coordinates[6 + tuple_index[1]] = limits[1][1];
        coordinates[6 + tuple_index[2]] = value2;
        coordinates[9 + tuple_index[0]] = limits[0][1];
        coordinates[9 + tuple_index[1]] = limits[1][0];
        coordinates[9 + tuple_index[2]] = value2;
        this.adjustZ(coordinates);
        texCoords = new float[8];
        float ratiow = (float)data_width / (float)texture_width;
        float ratioh = (float)data_height / (float)texture_height;
        boolean yUp = true;
        this.setTexCoords(texCoords, ratiow, ratioh, yUp);
        VisADQuadArray qarray = new VisADQuadArray();
        qarray.vertexCount = 4;
        qarray.coordinates = coordinates;
        qarray.texCoords = texCoords;
        if (!this.reuseImages || this.regen_colbytes && this.regen_geom) {
            BufferedImage image = tile.getImage(0);
            this.textureToGroup(group, qarray, image, mode, constant_alpha, constant_color, texture_width, texture_height, true, true, tile);
        } else {
            int num_children = ((BranchGroup)group).numChildren();
            if (num_children > 0) {
                BranchGroup branch1 = (BranchGroup)((BranchGroup)group).getChild(0);
                Shape3D shape = (Shape3D)branch1.getChild(0);
                shape.setGeometry((Geometry)((DisplayImplJ3D)display).makeGeometry(qarray));
            }
            if (this.animControl == null) {
                this.imgNode.setCurrent(0);
            }
        }
    }

    public BufferedImage createImageByRef(int texture_width, int texture_height, int imageType) {
        return new BufferedImage(texture_width, texture_height, imageType);
    }

    public static float[][] getBounds(Set domain_set, float data_width, float data_height, float scaleX, float offsetX, float scaleY, float offsetY) throws VisADException {
        float[][] xyCoords = new float[2][4];
        float[][] coords0 = ((GriddedSet)domain_set).gridToValue(new float[][]{{0.0f}, {0.0f}});
        float[][] coords1 = ((GriddedSet)domain_set).gridToValue(new float[][]{{0.0f}, {data_height - 1.0f}});
        float[][] coords2 = ((GriddedSet)domain_set).gridToValue(new float[][]{{data_width - 1.0f}, {data_height - 1.0f}});
        float[][] coords3 = ((GriddedSet)domain_set).gridToValue(new float[][]{{data_width - 1.0f}, {0.0f}});
        float x0 = coords0[0][0];
        float y0 = coords0[1][0];
        float x1 = coords1[0][0];
        float y1 = coords1[1][0];
        float x2 = coords2[0][0];
        float y2 = coords2[1][0];
        float x3 = coords3[0][0];
        float y3 = coords3[1][0];
        xyCoords[0][0] = (x0 - offsetX) / scaleX;
        xyCoords[1][0] = (y0 - offsetY) / scaleY;
        xyCoords[0][1] = (x1 - offsetX) / scaleX;
        xyCoords[1][1] = (y1 - offsetY) / scaleY;
        xyCoords[0][2] = (x2 - offsetX) / scaleX;
        xyCoords[1][2] = (y2 - offsetY) / scaleY;
        xyCoords[0][3] = (x3 - offsetX) / scaleX;
        xyCoords[1][3] = (y3 - offsetY) / scaleY;
        return xyCoords;
    }
}

