/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.AREAnav;

public final class MOLLnav
extends AREAnav {
    private boolean isEastPositive = true;
    private double drad;
    private double decc;
    private double[] tlat = new double[101];
    private double[] t = new double[101];
    private double[][] coef = new double[4][101];
    private double[] lattbl = new double[91];
    private double xrow;
    private double xcol;
    private double rpix;
    private double xqlon;
    private int itype;
    private int iwest;
    private int icord;
    private double asq = 4.068383348E7;
    private double bsq = 4.041033018E7;
    private double ab = 4.054685122E7;
    private double ecc = 0.081992;
    private double eccsqr = 0.00672265;
    private int kwest = -1;
    private int kcord = 0;
    private final int KMPP = 1263358032;
    private final int PPMK = 1347439947;

    public MOLLnav(int[] iparms) throws IllegalArgumentException {
        int j;
        double u;
        int i;
        if (iparms[0] != 1297042508) {
            throw new IllegalArgumentException("Invalid navigation type" + iparms[0]);
        }
        this.itype = 2;
        this.xrow = iparms[1];
        this.xcol = iparms[2];
        this.xqlon = iparms[4];
        double r = this.drad = (double)iparms[6] / 1000.0;
        if (iparms[14] == 1263358032 || iparms[14] == 1347439947) {
            double res = iparms[3];
            this.rpix = 0.7071 * r / res;
        } else {
            this.rpix = iparms[3];
        }
        this.decc = (double)iparms[7] / 1000000.0;
        this.iwest = iparms[9];
        if (this.iwest >= 0) {
            this.iwest = 1;
        }
        this.icord = iparms[8];
        this.asq = this.drad * this.drad;
        this.ecc = this.decc;
        this.eccsqr = this.ecc * this.ecc;
        double dpole = Math.sqrt(this.asq * (1.0 - this.eccsqr));
        this.bsq = dpole * dpole;
        this.ab = this.drad * dpole;
        if (this.iwest < 0) {
            this.kwest = 1;
        }
        if (this.icord < 0) {
            this.kcord = -1;
        }
        for (i = 0; i < this.tlat.length; ++i) {
            double x = (double)i / 100.0;
            if (x >= 1.0) {
                this.t[i] = 1.0;
                this.tlat[i] = 90.00021045914971;
                continue;
            }
            this.t[i] = x;
            this.tlat[i] = Math.asin((Math.asin(x) + x * Math.sqrt(1.0 - x * x)) / 1.5708) / (Math.PI / 180);
        }
        int n = 100;
        int m = n - 1;
        for (i = 0; i < n; ++i) {
            double s;
            double z;
            double w;
            double t1;
            if (i != 0) {
                t1 = (this.t[i + 1] - this.t[i - 1]) / (this.tlat[i + 1] - this.tlat[i - 1]);
            } else {
                w = (this.t[1] + this.t[2]) / 2.0;
                z = (this.tlat[1] + this.tlat[2]) / 2.0;
                t1 = (w - this.t[0]) / (z - this.tlat[0]);
                t1 = 2.0 * (this.t[1] - this.t[0]) / (this.tlat[1] - this.tlat[0]) - t1;
            }
            if (i != m) {
                s = (this.t[i + 2] - this.t[i]) / (this.tlat[i + 2] - this.tlat[i]);
            } else {
                w = (this.t[n - 1] + this.t[n - 2]) / 2.0;
                z = (this.tlat[n - 1] + this.tlat[n - 2]) / 2.0;
                s = (this.t[n] - w) / (this.tlat[n] - z);
                s = 2.0 * (this.t[n] - this.t[n - 1]) / (this.tlat[n] - this.tlat[n - 1]) - s;
            }
            u = this.t[i + 1];
            double v = this.t[i];
            w = (this.tlat[i + 1] + this.tlat[i]) / 2.0;
            z = (this.tlat[i + 1] - this.tlat[i]) / 2.0;
            double zs = z * z;
            double zq = z * zs;
            double ws = w * w;
            double wq = w * ws;
            double aa = 0.5 * (u + v) - 0.25 * z * (s - t1);
            double ba = 0.75 * (u - v) / z - 0.25 * (s + t1);
            double ca = 0.25 * (s - t1) / z;
            double da = 0.25 * (s + t1) / zs - 0.25 * (u - v) / zq;
            this.coef[0][i] = aa - ba * w + ca * ws - da * wq;
            this.coef[1][i] = ba - 2.0 * ca * w + 3.0 * da * ws;
            this.coef[2][i] = ca - 3.0 * da * w;
            this.coef[3][i] = da;
        }
        for (j = 0; j < 4; ++j) {
            this.coef[j][n] = this.coef[j][n - 1];
        }
        i = 0;
        for (int l = 0; l < 91; ++l) {
            u = l;
            if (i >= n - 1) {
                i = 0;
            }
            if (u < this.tlat[i] || u > this.tlat[i + 1]) {
                i = 0;
                j = n;
                do {
                    int k;
                    if (u < this.tlat[k = (i + j) / 2]) {
                        j = k;
                    }
                    if (!(u >= this.tlat[k])) continue;
                    i = k;
                } while (j > i + 1);
            }
            this.lattbl[l] = this.coef[0][i] + u * (this.coef[1][i] + u * (this.coef[2][i] + u * this.coef[3][i]));
        }
    }

    @Override
    public double[][] toLatLon(double[][] linele) {
        int number = linele[0].length;
        double[][] latlon = new double[2][number];
        double[][] imglinele = this.areaCoordToImageCoord(linele);
        for (int point = 0; point < number; ++point) {
            double xlon;
            double xlat;
            double xlin = imglinele[1][point];
            double xele = imglinele[0][point];
            double xldif = Math.abs(xlin - this.xrow) / this.rpix;
            double xedif = (this.xcol - xele) / this.rpix;
            if (xlin != xlin || xele != xele || xldif > 1.0) {
                xlat = Double.NaN;
                xlon = Double.NaN;
            } else {
                double w = Math.sqrt(1.0 - xldif * xldif);
                if (w == 0.0 || Math.abs(xedif / w) > 2.0) {
                    xlat = Double.NaN;
                    xlon = Double.NaN;
                } else {
                    xlat = Math.asin((Math.asin(xldif) + xldif * w) / 1.5708) / (Math.PI / 180);
                    if (xlin > this.xrow) {
                        xlat = -xlat;
                    }
                    xlon = -90.0 * (xedif / w);
                    if ((xlon = this.xqlon - xlon) > 180.0) {
                        xlon -= 360.0;
                    }
                    if (xlon < -180.0) {
                        xlon += 360.0;
                    }
                    if (this.itype == 1) {
                        double ylat = Math.PI / 180 * xlat;
                        if (this.kcord >= 0) {
                            ylat = Math.atan2(this.bsq * Math.sin(ylat), this.asq * Math.cos(ylat));
                        }
                        double ylon = (double)this.kwest * (Math.PI / 180) * xlon;
                        double snlt = Math.sin(ylat);
                        double cslt = Math.cos(ylat);
                        double csln = Math.cos(ylon);
                        double snln = Math.sin(ylon);
                        double tnlt = Math.pow(snlt / cslt, 2.0);
                        double r = this.ab * Math.sqrt((1.0 + tnlt) / (this.bsq + this.asq * tnlt));
                        xlat = r * cslt * csln;
                        xlon = r * cslt * snln;
                    }
                }
            }
            if (this.isEastPositive) {
                xlon = -xlon;
            }
            latlon[0][point] = xlat;
            latlon[1][point] = xlon;
        }
        return latlon;
    }

    @Override
    public double[][] toLinEle(double[][] latlon) {
        int number = latlon[0].length;
        double[][] linele = new double[2][number];
        for (int point = 0; point < number; ++point) {
            double xlin;
            double xele;
            double xlon;
            double xlat = latlon[0][point];
            double d = xlon = this.isEastPositive ? -latlon[1][point] : latlon[1][point];
            if (Double.isNaN(xlat) || Double.isNaN(xlon) || Math.abs(xlat) > 90.0) {
                xele = Double.NaN;
                xlin = Double.NaN;
            } else {
                double xedif;
                int isign = -1;
                if (xlat < 0.0) {
                    isign = 1;
                }
                int ilat = (int)Math.abs(xlat);
                double flat = Math.abs(xlat) - (double)ilat;
                double t = this.lattbl[ilat];
                if (ilat != 90) {
                    t += flat * (this.lattbl[ilat + 1] - this.lattbl[ilat]);
                }
                double t2 = Math.max(0.0, 1.0 - t * t);
                double w = Math.sqrt(t2);
                double diff_lon = xlon - this.xqlon;
                if (diff_lon < -180.0) {
                    diff_lon += 360.0;
                }
                if (diff_lon > 180.0) {
                    diff_lon -= 360.0;
                }
                if (Math.abs(xedif = w * diff_lon / 90.0) > 2.0) {
                    xele = Double.NaN;
                    xlin = Double.NaN;
                } else {
                    xele = this.xcol - xedif * this.rpix;
                    xlin = (double)isign * t * this.rpix + this.xrow;
                }
            }
            linele[1][point] = xlin;
            linele[0][point] = xele;
        }
        return this.imageCoordToAreaCoord(linele, linele);
    }

    @Override
    public float[][] toLatLon(float[][] linele) {
        int number = linele[0].length;
        float[][] latlon = new float[2][number];
        float[][] imglinele = this.areaCoordToImageCoord(linele);
        for (int point = 0; point < number; ++point) {
            double xlon;
            double xlat;
            double xlin = imglinele[1][point];
            double xele = imglinele[0][point];
            double xldif = Math.abs(xlin - this.xrow) / this.rpix;
            double xedif = (this.xcol - xele) / this.rpix;
            if (xlin != xlin || xele != xele || xldif > 1.0) {
                xlat = Double.NaN;
                xlon = Double.NaN;
            } else {
                double w = Math.sqrt(1.0 - xldif * xldif);
                if (w == 0.0 || Math.abs(xedif / w) > 2.0) {
                    xlat = Double.NaN;
                    xlon = Double.NaN;
                } else {
                    xlat = Math.asin((Math.asin(xldif) + xldif * w) / 1.5708) / (Math.PI / 180);
                    if (xlin > this.xrow) {
                        xlat = -xlat;
                    }
                    xlon = -90.0 * (xedif / w);
                    if ((xlon = this.xqlon - xlon) > 180.0) {
                        xlon -= 360.0;
                    }
                    if (xlon < -180.0) {
                        xlon += 360.0;
                    }
                    if (this.itype == 1) {
                        double ylat = Math.PI / 180 * xlat;
                        if (this.kcord >= 0) {
                            ylat = Math.atan2(this.bsq * Math.sin(ylat), this.asq * Math.cos(ylat));
                        }
                        double ylon = (double)this.kwest * (Math.PI / 180) * xlon;
                        double snlt = Math.sin(ylat);
                        double cslt = Math.cos(ylat);
                        double csln = Math.cos(ylon);
                        double snln = Math.sin(ylon);
                        double tnlt = Math.pow(snlt / cslt, 2.0);
                        double r = this.ab * Math.sqrt((1.0 + tnlt) / (this.bsq + this.asq * tnlt));
                        xlat = r * cslt * csln;
                        xlon = r * cslt * snln;
                    }
                }
            }
            if (this.isEastPositive) {
                xlon = -xlon;
            }
            latlon[0][point] = (float)xlat;
            latlon[1][point] = (float)xlon;
        }
        return latlon;
    }

    @Override
    public float[][] toLinEle(float[][] latlon) {
        int number = latlon[0].length;
        float[][] linele = new float[2][number];
        for (int point = 0; point < number; ++point) {
            double xlin;
            double xele;
            double xlon;
            double xlat = latlon[0][point];
            double d = xlon = this.isEastPositive ? (double)(-latlon[1][point]) : (double)latlon[1][point];
            if (Double.isNaN(xlat) || Double.isNaN(xlon) || Math.abs(xlat) > 90.0) {
                xele = Double.NaN;
                xlin = Double.NaN;
            } else {
                double xedif;
                int isign = -1;
                if (xlat < 0.0) {
                    isign = 1;
                }
                int ilat = (int)Math.abs(xlat);
                double flat = Math.abs(xlat) - (double)ilat;
                double t = this.lattbl[ilat];
                if (ilat != 90) {
                    t += flat * (this.lattbl[ilat + 1] - this.lattbl[ilat]);
                }
                double t2 = Math.max(0.0, 1.0 - t * t);
                double w = Math.sqrt(t2);
                double diff_lon = xlon - this.xqlon;
                if (diff_lon < -180.0) {
                    diff_lon += 360.0;
                }
                if (diff_lon > 180.0) {
                    diff_lon -= 360.0;
                }
                if (Math.abs(xedif = w * diff_lon / 90.0) > 2.0) {
                    xele = Double.NaN;
                    xlin = Double.NaN;
                } else {
                    xele = this.xcol - xedif * this.rpix;
                    xlin = (double)isign * t * this.rpix + this.xrow;
                }
            }
            linele[1][point] = (float)xlin;
            linele[0][point] = (float)xele;
        }
        return this.imageCoordToAreaCoord(linele, linele);
    }
}

