/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas.adde;

import edu.wisc.ssec.mcidas.AreaDirectory;
import edu.wisc.ssec.mcidas.AreaDirectoryList;
import edu.wisc.ssec.mcidas.McIDASException;
import edu.wisc.ssec.mcidas.adde.ReadTextFile;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;

public class AddeServerInfo {
    private String[] serverList;
    private String selectedServer = null;
    private boolean hasServers = false;
    private String dataType = null;
    private String[] bandNames;
    private boolean hasBandNames = false;
    private String selectedGroup = null;
    private boolean hasGroup = false;
    private String selectedDataset = null;
    private boolean hasDataset = false;
    private AreaDirectory[][] dirs;
    private Vector table;
    private Vector groups;
    private String status = "OK";
    private String userproj = null;
    private String DATEFORMAT = "yyyy-MM-dd / HH:mm:ss";
    private boolean debug = false;
    private boolean isArchive = false;
    private String archiveDate = null;

    public AddeServerInfo() {
        this(null);
    }

    public AddeServerInfo(String[] l) {
        String[] list = l;
        if (list == null) {
            list = new String[]{"adde.unidata.ucar.edu", "adde.ssec.wisc.edu", "unidata2.ssec.wisc.edu", "uwamrc.ssec.wisc.edu"};
        }
        this.serverList = new String[list.length];
        for (int i = 0; i < list.length; ++i) {
            this.serverList[i] = list[i];
        }
        this.hasServers = true;
    }

    public String[] getServerList() {
        if (this.hasServers) {
            return this.serverList;
        }
        return null;
    }

    public String getSelectedServer() {
        return this.selectedServer;
    }

    public int setSelectedServer(String s, String type) {
        this.selectedServer = s.trim();
        int istatus = 0;
        this.dataType = type.trim();
        this.groups = new Vector();
        this.status = "Failed to get PUBLIC.SRV file from from server " + s + ".";
        try {
            int num;
            String req = "adde://" + this.selectedServer + "/text?file=PUBLIC.SRV";
            if (this.userproj != null) {
                String req2;
                req = req2 = req + "&" + this.userproj + "&version=1";
            }
            if (this.debug) {
                System.out.println("Req:" + req);
            }
            ReadTextFile rtf = new ReadTextFile(req);
            if (this.debug) {
                System.out.println("Status from RTF=" + rtf.getStatus());
            }
            if (rtf.getStatusCode() == -3) {
                return -1;
            }
            if (!rtf.getStatus().equals("OK")) {
                req = "adde://" + this.selectedServer + "/text?file=RESOLV.SRV";
                if (this.userproj != null) {
                    String req2;
                    req = req2 = req + "&" + this.userproj + "&version=1";
                }
                if (this.debug) {
                    System.out.println("2ndReq:" + req);
                }
                rtf = new ReadTextFile(req);
                if (this.debug) {
                    System.out.println("Status from 2ndRTF=" + rtf.getStatus());
                }
            }
            this.table = rtf.getText();
            this.status = "Failed to locate required information on server " + s + ".";
            for (int i = 0; i < this.table.size(); ++i) {
                String a = (String)this.table.elementAt(i);
                if (this.debug) {
                    System.out.println("Table: " + a);
                }
                StringTokenizer st = new StringTokenizer(a, ",");
                num = st.countTokens();
                String[] tok = new String[num];
                String[] val = new String[num];
                int indexType = -1;
                int indexN1 = -1;
                int indexN2 = -1;
                int indexK = -1;
                int indexC = -1;
                for (int j = 0; j < num; ++j) {
                    String p = st.nextToken();
                    int x = p.indexOf("=");
                    if (x < 0) continue;
                    tok[j] = p.substring(0, x);
                    val[j] = p.substring(x + 1).trim();
                    if (tok[j].equalsIgnoreCase("type")) {
                        indexType = j;
                    }
                    if (tok[j].equalsIgnoreCase("N1")) {
                        indexN1 = j;
                    }
                    if (tok[j].equalsIgnoreCase("N2")) {
                        indexN2 = j;
                    }
                    if (tok[j].equalsIgnoreCase("K")) {
                        indexK = j;
                    }
                    if (!tok[j].equalsIgnoreCase("C")) continue;
                    indexC = j;
                }
                if (this.debug) {
                    System.out.println("indexType = " + indexType + " dataType=" + this.dataType + " indexN1,N2,C=" + indexN1 + " " + indexN2 + " " + indexC);
                }
                if (indexType < 0 || !val[indexType].equalsIgnoreCase(this.dataType) || indexN1 < 0 || indexN2 < 0) continue;
                if (indexC < 0) {
                    indexC = indexN2;
                }
                boolean hit = false;
                for (int j = 0; j < this.groups.size(); ++j) {
                    Vector vg = (Vector)this.groups.elementAt(j);
                    String g = (String)vg.elementAt(0);
                    if (!g.equalsIgnoreCase(val[indexN1])) continue;
                    hit = true;
                    Vector v = (Vector)vg.elementAt(1);
                    v.addElement(val[indexN2]);
                    v = (Vector)vg.elementAt(2);
                    v.addElement(val[indexC]);
                    if (vg.size() < 4) continue;
                    v = (Vector)vg.elementAt(3);
                    v.addElement(val[indexK]);
                }
                if (hit) continue;
                Vector<Object> v = new Vector<Object>();
                v.addElement(val[indexN1]);
                Vector<String> v2 = new Vector<String>();
                v2.addElement(val[indexN2]);
                Vector<String> v3 = new Vector<String>();
                v3.addElement(val[indexC]);
                Vector<String> v4 = null;
                if (indexK > 0) {
                    v4 = new Vector<String>();
                    v4.addElement(val[indexK]);
                }
                v.addElement(v2);
                v.addElement(v3);
                if (v4 != null) {
                    v.addElement(v4);
                }
                this.groups.addElement(v);
            }
            String reqBand = "adde://" + this.selectedServer + "/text?file=SATBAND";
            if (this.userproj != null) {
                String reqBand2;
                reqBand = reqBand2 = reqBand + "&" + this.userproj + "&version=1";
            }
            if (this.debug) {
                System.out.println("ReqBand:" + reqBand);
            }
            ReadTextFile rtfBand = new ReadTextFile(reqBand);
            if (this.debug) {
                System.out.println("Status from RTFBand=" + rtfBand.getStatus());
            }
            Vector vBand = null;
            if (rtfBand.getStatus().equals("OK")) {
                vBand = rtfBand.getText();
                num = vBand.size();
                this.bandNames = new String[num];
                for (int i = 0; i < num; ++i) {
                    this.bandNames[i] = (String)vBand.elementAt(i);
                    if (!this.debug) continue;
                    System.out.println("band = " + this.bandNames[i]);
                }
                this.hasBandNames = true;
            }
            this.status = "ADDE group & dataset information retrieved from server " + s + ".";
            istatus = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -2;
        }
        return istatus;
    }

    public String[] getGroupList() {
        int num = this.groups.size();
        String[] sg = new String[num];
        for (int i = 0; i < num; ++i) {
            Vector v = (Vector)this.groups.elementAt(i);
            sg[i] = (String)v.elementAt(0);
        }
        this.status = "List of groups on server " + this.selectedServer + " obtained.";
        return sg;
    }

    public String[] getDatasetList() {
        int num = this.groups.size();
        boolean autoUpcase = Boolean.getBoolean("adde.auto-upcase");
        for (int i = 0; i < num; ++i) {
            Vector v = (Vector)this.groups.elementAt(i);
            String g = (String)v.elementAt(0);
            boolean match = autoUpcase ? g.equalsIgnoreCase(this.selectedGroup) : g.equals(this.selectedGroup);
            if (!match) continue;
            Vector ds = (Vector)v.elementAt(1);
            int numds = ds.size();
            String[] sdl = new String[numds];
            for (int j = 0; j < numds; ++j) {
                sdl[j] = (String)ds.elementAt(j);
            }
            this.status = "Dataset list for server " + this.selectedServer + " and group " + this.selectedGroup + " obtained.";
            return sdl;
        }
        this.status = "Dataset list for server " + this.selectedServer + " and group " + this.selectedGroup + " not found.";
        return null;
    }

    public String[] getDatasetListDescriptions() {
        boolean autoUpcase = Boolean.getBoolean("adde.auto-upcase");
        int num = this.groups.size();
        for (int i = 0; i < num; ++i) {
            Vector v = (Vector)this.groups.elementAt(i);
            String g = (String)v.elementAt(0);
            boolean match = autoUpcase ? g.equalsIgnoreCase(this.selectedGroup) : g.equals(this.selectedGroup);
            if (!match) continue;
            Vector dsd = (Vector)v.elementAt(2);
            int numdsd = dsd.size();
            String[] sdld = new String[numdsd];
            for (int j = 0; j < numdsd; ++j) {
                sdld[j] = (String)dsd.elementAt(j);
            }
            this.status = "Dataset list for server " + this.selectedServer + " and group " + this.selectedGroup + " obtained.";
            return sdld;
        }
        this.status = "Dataset list for server " + this.selectedServer + " and group " + this.selectedGroup + " not found.";
        return null;
    }

    public String[] getDateTimeList() {
        this.status = "Trying to get date-times for " + this.selectedGroup + " from server " + this.selectedServer;
        if (!this.hasGroup || !this.hasDataset) {
            return null;
        }
        StringBuffer addeCmdBuff = new StringBuffer("adde://" + this.selectedServer + "/imagedir?group=" + this.selectedGroup);
        addeCmdBuff.append("&descr=");
        addeCmdBuff.append(this.selectedDataset);
        if (this.userproj != null) {
            addeCmdBuff.append("&" + this.userproj);
        }
        addeCmdBuff.append("&pos=all&version=1");
        if (this.isArchive && this.archiveDate != null) {
            addeCmdBuff.append("&DAY=" + this.archiveDate);
        }
        if (this.debug) {
            System.out.println("cmd:" + addeCmdBuff.toString());
        }
        String[] times = new String[]{"No data available"};
        try {
            AreaDirectoryList adir = new AreaDirectoryList(addeCmdBuff.toString());
            this.dirs = adir.getSortedDirs();
            int numTimes = this.dirs.length;
            times = new String[numTimes];
            SimpleDateFormat sdf = new SimpleDateFormat();
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            sdf.applyPattern(this.DATEFORMAT);
            for (int i = 0; i < numTimes; ++i) {
                times[i] = sdf.format(this.dirs[i][0].getNominalTime(), new StringBuffer(), new FieldPosition(0)).toString();
            }
        }
        catch (McIDASException e) {
            this.status = "Error getting times";
        }
        return times;
    }

    public String getFileFormat() {
        int num = this.groups.size();
        boolean autoUpcase = Boolean.getBoolean("adde.auto-upcase");
        for (int i = 0; i < num; ++i) {
            Vector ffv;
            String ff;
            Vector v = (Vector)this.groups.elementAt(i);
            String g = (String)v.elementAt(0);
            boolean match = autoUpcase ? g.equalsIgnoreCase(this.selectedGroup) : g.equals(this.selectedGroup);
            if (!match) continue;
            if (this.debug) {
                System.out.println("VECTOR SIZE: " + v.size());
            }
            if (v.size() < 4 || (ff = (String)(ffv = (Vector)v.elementAt(3)).elementAt(0)) == null) continue;
            this.status = "File Format for server " + this.selectedServer + " and group " + this.selectedGroup + " obtained.";
            return ff;
        }
        this.status = "File Format for server " + this.selectedServer + " and group " + this.selectedGroup + " not found.";
        return null;
    }

    public AreaDirectory[][] getAreaDirectories() {
        return this.dirs;
    }

    public void setSelectedGroup(String g) {
        this.selectedGroup = g;
        this.hasGroup = true;
    }

    public void setSelectedDataset(String d) {
        this.selectedDataset = d;
        this.hasDataset = true;
    }

    public void setIsArchive(boolean flag) {
        this.isArchive = flag;
    }

    public boolean getIsArchive() {
        return this.isArchive;
    }

    public void setArchiveDate(String d) {
        this.archiveDate = d;
    }

    public String getArchiveDate() {
        return this.archiveDate;
    }

    public String[] getBandNames() {
        if (this.hasBandNames) {
            return this.bandNames;
        }
        return null;
    }

    public String getRequestString(int reqestType) {
        return null;
    }

    public void setUserIDandProjString(String up) {
        this.userproj = up;
    }

    public String getStatus() {
        return this.status;
    }

    public static void main(String[] args) {
        System.out.println("AddeServerInfo unit test begin...");
        AddeServerInfo asi = new AddeServerInfo();
        asi.setUserIDandProjString("user=ZZZZ&proj=YYYY");
        int sstat = asi.setSelectedServer("some-server.ssec.wisc.edu", "image");
        System.out.println("Status = " + asi.getStatus() + " code=" + sstat);
        String[] a = asi.getGroupList();
        System.out.println("Status = " + asi.getStatus());
        for (int i = 0; i < a.length; ++i) {
            System.out.println("group = " + a[i]);
            asi.setSelectedGroup(a[i]);
            System.out.println(" File Format: " + asi.getFileFormat());
            String[] b = asi.getDatasetList();
            String[] c = asi.getDatasetListDescriptions();
            for (int k = 0; k < b.length; ++k) {
                System.out.println("    " + b[k] + " == " + c[k]);
                if (i != 0 || k != 0) continue;
                asi.setSelectedDataset(b[k]);
                String[] dt = asi.getDateTimeList();
                for (int m = 0; m < dt.length; ++m) {
                    System.out.println("DateTime = " + dt[m]);
                }
            }
        }
        System.out.println("Status = " + asi.getStatus());
    }
}

