/*
 * Decompiled with CFR 0.152.
 */
package ucar.multiarray;

import java.io.IOException;
import java.lang.reflect.Array;
import ucar.multiarray.ConcreteIndexMap;
import ucar.multiarray.MultiArrayImpl;
import ucar.multiarray.MultiArrayProxy;

public class FlattenMap
extends ConcreteIndexMap {
    private int position_;

    public FlattenMap(int position) {
        this.init(new IMap(), new LengthsMap());
        this.position_ = position;
    }

    public FlattenMap(ConcreteIndexMap prev, int position) {
        this.link(prev, new IMap(), new LengthsMap());
        this.position_ = position;
    }

    public static void main(String[] args) {
        int[] shape = new int[]{32, 48, 64};
        MultiArrayImpl delegate = new MultiArrayImpl(Integer.TYPE, shape);
        int size = MultiArrayImpl.numberOfElements(shape);
        for (int ii = 0; ii < size; ++ii) {
            Array.setInt(delegate.storage, ii, ii);
        }
        FlattenMap im = new FlattenMap(1);
        MultiArrayProxy ma = new MultiArrayProxy(delegate, im);
        try {
            System.out.println("Rank  " + ma.getRank());
            int[] lengths = ma.getLengths();
            System.out.println("Shape { " + lengths[0] + ", " + lengths[1] + " }");
            System.out.println(ma.getInt(new int[]{0, 0}));
            System.out.println(ma.getInt(new int[]{0, 1}));
            System.out.println(ma.getInt(new int[]{0, 63}));
            System.out.println(ma.getInt(new int[]{0, 64}));
            System.out.println(ma.getInt(new int[]{0, 3071}));
            System.out.println(ma.getInt(new int[]{1, 0}));
        }
        catch (IOException ee) {
            // empty catch block
        }
    }

    private class LengthsMap
    extends ConcreteIndexMap.ZZMap {
        private LengthsMap() {
        }

        public synchronized int get(int key) {
            if (key < FlattenMap.this.position_) {
                return super.get(key);
            }
            if (key == FlattenMap.this.position_) {
                return super.get(key) * super.get(key + 1);
            }
            return super.get(key + 1);
        }

        public synchronized int size() {
            return super.size() - 1;
        }

        int superGet(int key) {
            return super.get(key);
        }
    }

    private class IMap
    extends ConcreteIndexMap.ZZMap {
        private int length_;
        private int value_;

        private IMap() {
        }

        public synchronized int get(int key) {
            if (key < FlattenMap.this.position_) {
                return super.get(key);
            }
            if (key == FlattenMap.this.position_) {
                this.length_ = ((LengthsMap)FlattenMap.this.lengthsMap_).superGet(key + 1);
                int got = super.get(key);
                this.value_ = got % this.length_;
                return got / this.length_;
            }
            if (key == FlattenMap.this.position_ + 1) {
                return this.value_;
            }
            return super.get(key - 1);
        }

        public synchronized int size() {
            return super.size() + 1;
        }
    }
}

