/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.GriddedSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.Linear3DSet;
import visad.LinearSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.Unit;
import visad.VisADException;

public class LinearNDSet
extends GriddedSet
implements LinearSet {
    Linear1DSet[] L;
    private boolean cacheSamples = false;

    public LinearNDSet(MathType type, Linear1DSet[] l) throws VisADException {
        this(type, l, null, null, null);
    }

    public LinearNDSet(MathType type, double[] firsts, double[] lasts, int[] lengths) throws VisADException {
        this(type, LinearNDSet.get_linear1d_array(type, firsts, lasts, lengths, null), null, null, null);
    }

    public LinearNDSet(MathType type, double[] firsts, double[] lasts, int[] lengths, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, firsts, lasts, lengths, coord_sys, units, errors, false);
    }

    public LinearNDSet(MathType type, double[] firsts, double[] lasts, int[] lengths, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean cache) throws VisADException {
        this(type, LinearNDSet.get_linear1d_array(type, firsts, lasts, lengths, units), coord_sys, units, errors, cache);
    }

    public LinearNDSet(MathType type, Linear1DSet[] l, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, l, coord_sys, units, errors, false);
    }

    public LinearNDSet(MathType type, Linear1DSet[] l, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean cache) throws VisADException {
        super(type, null, LinearNDSet.get_lengths(l), coord_sys, LinearNDSet.units_array_linear1d(l, units), errors);
        if (this.DomainDimension != this.ManifoldDimension) {
            throw new SetException("LinearNDSet: DomainDimension != ManifoldDimension");
        }
        this.L = LinearNDSet.linear1d_array_units(l, units);
        for (int j = 0; j < this.DomainDimension; ++j) {
            this.Low[j] = this.L[j].getLowX();
            this.Hi[j] = this.L[j].getHiX();
            if (this.SetErrors[j] == null) continue;
            this.SetErrors[j] = new ErrorEstimate(this.SetErrors[j].getErrorValue(), (double)(this.Low[j] + this.Hi[j]) / 2.0, this.Length, this.SetErrors[j].getUnit());
        }
        this.cacheSamples = cache;
    }

    private static int[] get_lengths(Linear1DSet[] l) throws VisADException {
        int[] lengths = new int[l.length];
        for (int j = 0; j < l.length; ++j) {
            lengths[j] = l[j].getLength();
        }
        return lengths;
    }

    public static LinearSet create(MathType type, double[] firsts, double[] lasts, int[] lengths) throws VisADException {
        return LinearNDSet.create(type, firsts, lasts, lengths, null, null, null);
    }

    public static LinearSet create(MathType type, double[] firsts, double[] lasts, int[] lengths, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        switch (firsts.length) {
            case 1: {
                return new Linear1DSet(type, firsts[0], lasts[0], lengths[0], coord_sys, units, errors);
            }
            case 2: {
                return new Linear2DSet(type, firsts[0], lasts[0], lengths[0], firsts[1], lasts[1], lengths[1], coord_sys, units, errors);
            }
            case 3: {
                return new Linear3DSet(type, firsts[0], lasts[0], lengths[0], firsts[1], lasts[1], lengths[1], firsts[2], lasts[2], lengths[2], coord_sys, units, errors);
            }
        }
        return new LinearNDSet(type, firsts, lasts, lengths, coord_sys, units, errors);
    }

    static Linear1DSet[] linear1d_array_units(Linear1DSet[] sets, Unit[] units) throws VisADException {
        if (units == null) {
            return sets;
        }
        int n = sets.length;
        if (units.length != n) {
            throw new SetException("units and sets lengths don't match");
        }
        Linear1DSet[] ss = new Linear1DSet[n];
        for (int i = 0; i < n; ++i) {
            Unit[] su = sets[i].getSetUnits();
            if (units[i] == null || units[i].equals(su[0])) {
                ss[i] = sets[i];
                continue;
            }
            CoordinateSystem cs = sets[i].getCoordinateSystem();
            double first = sets[i].getFirst();
            double last = sets[i].getLast();
            if (su[0] != null) {
                first = units[i].toThis(first, su[0]);
                last = units[i].toThis(last, su[0]);
            }
            su = new Unit[]{units[i]};
            ss[i] = new Linear1DSet(sets[i].getType(), first, last, sets[i].getLength(), sets[i].getCoordinateSystem(), su, sets[i].getSetErrors());
        }
        return ss;
    }

    static Unit[] units_array_linear1d(Linear1DSet[] sets, Unit[] units) throws VisADException {
        int n = sets.length;
        Unit[] newu = new Unit[n];
        if (units != null && units.length != n) {
            throw new SetException("units and sets lengths don't match");
        }
        for (int i = 0; i < n; ++i) {
            if (units != null && units[i] != null) {
                newu[i] = units[i];
                continue;
            }
            Unit[] su = sets[i].getSetUnits();
            if (su == null) continue;
            newu[i] = su[0];
        }
        return newu;
    }

    static Linear1DSet[] get_linear1d_array(MathType type, double[] firsts, double[] lasts, int[] lengths, Unit[] units) throws VisADException {
        type = Set.adjustType(type);
        int len = lengths.length;
        if (len != firsts.length || len != lasts.length) {
            throw new SetException("LinearNDSet: array dimensions don't match");
        }
        Linear1DSet[] l = new Linear1DSet[len];
        for (int j = 0; j < len; ++j) {
            RealType[] types = new RealType[]{(RealType)((SetType)type).getDomain().getComponent(j)};
            SetType set_type = new SetType(new RealTupleType(types));
            Unit[] us = new Unit[]{null};
            if (units != null && units.length > j) {
                us[0] = units[j];
            }
            l[j] = new Linear1DSet((MathType)set_type, firsts[j], lasts[j], lengths[j], null, us, null);
        }
        return l;
    }

    static Linear1DSet[] get_linear1d_array(MathType type, double first1, double last1, int length1, double first2, double last2, int length2, Unit[] units) throws VisADException {
        double[] firsts = new double[]{first1, first2};
        double[] lasts = new double[]{last1, last2};
        int[] lengths = new int[]{length1, length2};
        return LinearNDSet.get_linear1d_array(type, firsts, lasts, lengths, units);
    }

    static Linear1DSet[] get_linear1d_array(MathType type, double first1, double last1, int length1, double first2, double last2, int length2, double first3, double last3, int length3, Unit[] units) throws VisADException {
        double[] firsts = new double[]{first1, first2, first3};
        double[] lasts = new double[]{last1, last2, last3};
        int[] lengths = new int[]{length1, length2, length3};
        return LinearNDSet.get_linear1d_array(type, firsts, lasts, lengths, units);
    }

    @Override
    public float[][] indexToValue(int[] index) throws VisADException {
        int j;
        int dim = this.getDimension();
        int length = index.length;
        int[][] indexN = new int[dim][length];
        float[][] values = new float[dim][];
        int[] lengthN = new int[dim];
        for (j = 0; j < dim; ++j) {
            lengthN[j] = this.L[j].getLength();
        }
        for (int i = 0; i < length; ++i) {
            int j2;
            int k = index[i];
            if (0 <= k && k < this.Length) {
                for (j2 = 0; j2 < dim - 1; ++j2) {
                    indexN[j2][i] = k % lengthN[j2];
                    k /= lengthN[j2];
                }
                indexN[dim - 1][i] = k;
                continue;
            }
            for (j2 = 0; j2 < dim; ++j2) {
                indexN[j2][i] = -1;
            }
        }
        for (j = 0; j < dim; ++j) {
            float[][] vals = this.L[j].indexToValue(indexN[j]);
            values[j] = vals[0];
        }
        return values;
    }

    @Override
    public float[][] gridToValue(float[][] grid) throws VisADException {
        int j;
        if (grid.length != this.DomainDimension) {
            throw new SetException("LinearNDSet.gridToValue: grid dimension " + grid.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        if (this.Length > 1) {
            for (j = 0; j < this.DomainDimension; ++j) {
                if (this.Lengths[j] >= 2) continue;
                throw new SetException("LinearNDSet.gridToValue: requires all grid dimensions to be > 1");
            }
        }
        int length = grid[0].length;
        float[][][] gridJ = new float[this.DomainDimension][1][];
        float[][][] valueJ = new float[this.DomainDimension][][];
        for (j = 0; j < this.DomainDimension; ++j) {
            gridJ[j][0] = grid[j];
            valueJ[j] = this.L[j].gridToValue(gridJ[j]);
        }
        float[][] value = new float[this.DomainDimension][];
        for (j = 0; j < this.DomainDimension; ++j) {
            value[j] = valueJ[j][0];
        }
        return value;
    }

    @Override
    public float[][] valueToGrid(float[][] value) throws VisADException {
        int j;
        if (value.length != this.DomainDimension) {
            throw new SetException("LinearNDSet.valueToGrid: value dimension " + value.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        if (this.Length > 1) {
            for (j = 0; j < this.DomainDimension; ++j) {
                if (this.Lengths[j] >= 2) continue;
                throw new SetException("LinearNDSet.valueToGrid: requires all grid dimensions to be > 1");
            }
        }
        int length = value[0].length;
        float[][][] valueJ = new float[this.DomainDimension][1][];
        float[][][] gridJ = new float[this.DomainDimension][][];
        for (j = 0; j < this.DomainDimension; ++j) {
            valueJ[j][0] = value[j];
            gridJ[j] = this.L[j].valueToGrid(valueJ[j]);
        }
        float[][] grid = new float[this.DomainDimension][];
        for (j = 0; j < this.DomainDimension; ++j) {
            grid[j] = gridJ[j][0];
        }
        return grid;
    }

    @Override
    public boolean isMissing() {
        return false;
    }

    public double[] getFirsts() throws VisADException {
        double[] firsts = new double[this.L.length];
        for (int j = 0; j < firsts.length; ++j) {
            firsts[j] = this.L[j].getFirst();
        }
        return firsts;
    }

    public double[] getLasts() throws VisADException {
        double[] lasts = new double[this.L.length];
        for (int j = 0; j < lasts.length; ++j) {
            lasts[j] = this.L[j].getLast();
        }
        return lasts;
    }

    @Override
    public float[][] getSamples(boolean copy) throws VisADException {
        float[][] mySamples = this.getMySamples();
        if (mySamples != null) {
            return copy ? Set.copyFloats(mySamples) : mySamples;
        }
        float[][] samples = this.makeSamples();
        if (this.cacheSamples) {
            this.setMySamples(samples);
            return copy ? Set.copyFloats(samples) : samples;
        }
        return samples;
    }

    private float[][] makeSamples() throws VisADException {
        int n = this.getLength();
        int[] indices = new int[n];
        for (int i = 0; i < n; ++i) {
            indices[i] = i;
        }
        return this.indexToValue(indices);
    }

    @Override
    public boolean equals(Object set) {
        if (!(set instanceof LinearNDSet) || set == null) {
            return false;
        }
        if (this == set) {
            return true;
        }
        if (!this.equalUnitAndCS((Set)set)) {
            return false;
        }
        if (this.DomainDimension != ((LinearNDSet)set).getDimension()) {
            return false;
        }
        for (int j = 0; j < this.DomainDimension; ++j) {
            if (this.L[j].equals(((LinearNDSet)set).getLinear1DComponent(j))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (!this.hashCodeSet) {
            this.hashCode = this.unitAndCSHashCode();
            for (int i = 0; i < this.DomainDimension; ++i) {
                this.hashCode ^= this.L[i].hashCode();
            }
            this.hashCodeSet = true;
        }
        return this.hashCode;
    }

    @Override
    public Linear1DSet getLinear1DComponent(int i) {
        return this.L[i];
    }

    @Override
    public Object cloneButType(MathType type) throws VisADException {
        Linear1DSet[] l = new Linear1DSet[this.DomainDimension];
        for (int j = 0; j < this.DomainDimension; ++j) {
            l[j] = (Linear1DSet)this.L[j].clone();
        }
        return new LinearNDSet(type, l, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors, this.cacheSamples);
    }

    @Override
    public String longString(String pre) throws VisADException {
        String s = pre + "LinearNDSet: Dimension = " + this.DomainDimension + " Length = " + this.Length + "\n";
        for (int j = 0; j < this.DomainDimension; ++j) {
            s = s + pre + "  Dimension " + j + ": Length = " + this.L[j].getLength() + " Range = " + this.L[j].getFirst() + " to " + this.L[j].getLast() + "\n";
        }
        return s;
    }

    public static void main(String[] args) throws VisADException {
        RealTupleType type = new RealTupleType(RealType.Generic, RealType.Generic);
        double[] firsts = new double[]{0.0, 0.0};
        double[] lasts = new double[]{3.0, 3.0};
        int[] lengths = new int[]{4, 4};
        LinearNDSet set = new LinearNDSet((MathType)type, firsts, lasts, lengths);
        float[][] values = set.getSamples();
        int n = values.length;
        int m = values[0].length;
        for (int j = 0; j < m; ++j) {
            for (int i = 0; i < n; ++i) {
                System.out.println("values[" + i + "][" + j + "] = " + values[i][j]);
            }
        }
    }
}

