/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.Arrays;
import visad.FlatField;
import visad.FlowInfo;
import visad.FunctionType;
import visad.GriddedSet;
import visad.Real;
import visad.RealTuple;
import visad.ShadowType;
import visad.TrajectoryManager;
import visad.VisADException;

public class Trajectory {
    TrajectoryManager trajMan;
    float[] startPts = new float[3];
    int[] startCell;
    float[] cellWeights;
    int[][] indices = new int[1][];
    float[][] weights = new float[1][];
    float[] uVecPath = new float[]{Float.NaN, Float.NaN, Float.NaN};
    int[] guess3D = new int[]{-1, -1, -1};
    int[] guess2D = new int[]{-1, -1};
    byte[] startColor;
    byte[] stopColor;
    float[] stopPts = new float[3];
    float[][] startPts2D = new float[2][1];
    float[][] startPts3D = new float[3][1];
    public int initialTimeIndex = 0;
    public int currentTimeIndex = 0;
    public double initialTime = 0.0;
    public double currentTime = 0.0;
    boolean offGrid = false;
    int clrDim;
    GriddedSet spatial_set;
    int manifoldDimension;
    int npairs = 0;
    int[] indexes = new int[60];
    float[] lastPtD = null;
    float[] lastPtC = null;
    float[] lastPtDD = null;
    float[] lastPtCC = null;
    float[][] circleXYZ;
    float[][] last_circleXYZ;
    float[][] lastFwdFace;
    float[] lastCntr;
    double[] lastMinDistPt = new double[3];
    float last_cellTerrain = Float.NaN;
    static float[][] circle;
    boolean conserveColor = false;

    public Trajectory(TrajectoryManager trajMan, float startX, float startY, float startZ, int[] startCell, float[] cellWeights, byte[] startColor, double initialTime) {
        this.startPts[0] = startX;
        this.startPts[1] = startY;
        this.startPts[2] = startZ;
        this.startCell = startCell;
        this.cellWeights = cellWeights;
        this.indices[0] = startCell;
        this.weights[0] = cellWeights;
        this.clrDim = startColor.length;
        this.stopColor = new byte[this.clrDim];
        this.startColor = new byte[this.clrDim];
        this.startColor[0] = startColor[0];
        this.startColor[1] = startColor[1];
        this.startColor[2] = startColor[2];
        if (this.clrDim == 4) {
            this.startColor[3] = startColor[3];
        }
        this.initialTime = initialTime;
        this.trajMan = trajMan;
        this.conserveColor = trajMan.conserveColor;
    }

    public void forward(FlowInfo info, float[][] flow_values, byte[][] color_values, GriddedSet spatial_set, FlatField terrain, int direction, float timeStep) throws VisADException, RemoteException {
        if (this.offGrid) {
            return;
        }
        this.clrDim = color_values.length;
        float[] intrpClr = new float[this.clrDim];
        this.spatial_set = spatial_set;
        this.manifoldDimension = spatial_set.getManifoldDimension();
        float[][] flowLoc = new float[3][1];
        float[][] flowVec = new float[3][1];
        float[] intrpFlow = new float[3];
        if (this.indices[0] != null) {
            Arrays.fill(intrpFlow, 0.0f);
            Arrays.fill(intrpClr, 0.0f);
            for (int j = 0; j < this.indices[0].length; ++j) {
                int idx = this.indices[0][j];
                flowLoc[0][0] = info.spatial_values[0][idx];
                flowLoc[1][0] = info.spatial_values[1][idx];
                flowLoc[2][0] = info.spatial_values[2][idx];
                flowVec[0][0] = flow_values[0][idx];
                flowVec[1][0] = flow_values[1][idx];
                flowVec[2][0] = flow_values[2][idx];
                float[][] del = TrajectoryManager.computeDisplacement(info, flowLoc, flowVec, timeStep);
                intrpFlow[0] = intrpFlow[0] + this.weights[0][j] * (float)direction * del[0][0];
                intrpFlow[1] = intrpFlow[1] + this.weights[0][j] * (float)direction * del[1][0];
                intrpFlow[2] = intrpFlow[2] + this.weights[0][j] * (float)direction * del[2][0];
                if (this.conserveColor) continue;
                intrpClr[0] = intrpClr[0] + this.weights[0][j] * ShadowType.byteToFloat(color_values[0][idx]);
                intrpClr[1] = intrpClr[1] + this.weights[0][j] * ShadowType.byteToFloat(color_values[1][idx]);
                intrpClr[2] = intrpClr[2] + this.weights[0][j] * ShadowType.byteToFloat(color_values[2][idx]);
                if (this.clrDim != 4) continue;
                intrpClr[3] = intrpClr[3] + this.weights[0][j] * ShadowType.byteToFloat(color_values[3][idx]);
            }
            this.stopPts[0] = this.startPts[0] + intrpFlow[0];
            this.stopPts[1] = this.startPts[1] + intrpFlow[1];
            this.stopPts[2] = this.startPts[2] + intrpFlow[2];
            if (!this.conserveColor) {
                this.stopColor[0] = ShadowType.floatToByte(intrpClr[0]);
                this.stopColor[1] = ShadowType.floatToByte(intrpClr[1]);
                this.stopColor[2] = ShadowType.floatToByte(intrpClr[2]);
                if (this.clrDim == 4) {
                    this.stopColor[3] = ShadowType.floatToByte(intrpClr[3]);
                }
            } else {
                this.stopColor[0] = this.startColor[0];
                this.stopColor[1] = this.startColor[1];
                this.stopColor[2] = this.startColor[2];
                if (this.clrDim == 4) {
                    this.stopColor[3] = this.startColor[3];
                }
            }
            if (this.manifoldDimension == 2) {
                float[][] pts2D = new float[2][1];
                pts2D[0][0] = this.stopPts[0];
                pts2D[1][0] = this.stopPts[1];
                spatial_set.valueToInterp(pts2D, this.indices, this.weights, this.guess2D);
            } else if (this.manifoldDimension == 3) {
                float[][] pts3D = new float[3][1];
                pts3D[0][0] = this.stopPts[0];
                pts3D[1][0] = this.stopPts[1];
                pts3D[2][0] = this.stopPts[2];
                spatial_set.valueToInterp(pts3D, this.indices, this.weights, this.guess3D);
                if (terrain != null) {
                    this.adjustFlowAtTerrain(terrain, color_values);
                }
            }
            if (this.indices[0] == null) {
                this.offGrid = true;
            } else {
                this.addPair(this.startPts, this.stopPts, this.startColor, this.stopColor);
                this.uVecPath[0] = this.stopPts[0] - this.startPts[0];
                this.uVecPath[1] = this.stopPts[1] - this.startPts[1];
                this.uVecPath[2] = this.stopPts[2] - this.startPts[2];
                float mag = (float)Math.sqrt(this.uVecPath[0] * this.uVecPath[0] + this.uVecPath[1] * this.uVecPath[1] + this.uVecPath[2] * this.uVecPath[2]);
                this.uVecPath[0] = this.uVecPath[0] / mag;
                this.uVecPath[1] = this.uVecPath[1] / mag;
                this.uVecPath[2] = this.uVecPath[2] / mag;
                this.update();
            }
        }
    }

    public void forwardRK4(FlowInfo info, float[][] flow_values, float[][] flow_valuesB, float[][] flow_valuesC, byte[][] color_values, GriddedSet spatial_set, FlatField terrain, int direction, float timeStep) throws VisADException, RemoteException {
        if (this.offGrid) {
            return;
        }
        this.clrDim = color_values.length;
        float[] intrpClr = new float[this.clrDim];
        this.spatial_set = spatial_set;
        this.manifoldDimension = spatial_set.getManifoldDimension();
        float[][] flowLoc = new float[3][1];
        float[][] flowVec = new float[3][1];
        float[] intrpFlow = new float[3];
        float[] k1 = new float[3];
        float[] k2 = new float[3];
        float[] k3 = new float[3];
        float[] k4 = new float[3];
        float[] xyz = new float[3];
        if (this.indices[0] != null) {
            float[][] del;
            int idx;
            Arrays.fill(intrpFlow, 0.0f);
            Arrays.fill(intrpClr, 0.0f);
            k1[0] = 0.0f;
            k1[1] = 0.0f;
            k1[2] = 0.0f;
            for (int j = 0; j < this.indices[0].length; ++j) {
                int idx2 = this.indices[0][j];
                flowLoc[0][0] = info.spatial_values[0][idx2];
                flowLoc[1][0] = info.spatial_values[1][idx2];
                flowLoc[2][0] = info.spatial_values[2][idx2];
                flowVec[0][0] = flow_values[0][idx2];
                flowVec[1][0] = flow_values[1][idx2];
                flowVec[2][0] = flow_values[2][idx2];
                float[][] del2 = TrajectoryManager.computeDisplacement(info, flowLoc, flowVec, timeStep);
                k1[0] = k1[0] + this.weights[0][j] * (float)direction * del2[0][0];
                k1[1] = k1[1] + this.weights[0][j] * (float)direction * del2[1][0];
                k1[2] = k1[2] + this.weights[0][j] * (float)direction * del2[2][0];
            }
            xyz[0] = this.startPts[0] + k1[0] / 2.0f;
            xyz[1] = this.startPts[1] + k1[1] / 2.0f;
            xyz[2] = this.startPts[2] + k1[2] / 2.0f;
            int[][] indicesK = new int[1][];
            float[][] weightsK = new float[1][];
            if (this.manifoldDimension == 2) {
                float[][] pts2D = new float[2][1];
                pts2D[0][0] = xyz[0];
                pts2D[1][0] = xyz[1];
                spatial_set.valueToInterp(pts2D, indicesK, weightsK, this.guess2D);
            } else if (this.manifoldDimension == 3) {
                float[][] pts3D = new float[3][1];
                pts3D[0][0] = xyz[0];
                pts3D[1][0] = xyz[1];
                pts3D[2][0] = xyz[2];
                spatial_set.valueToInterp(pts3D, indicesK, weightsK, this.guess3D);
            }
            if (indicesK[0] != null) {
                k2[0] = 0.0f;
                k2[1] = 0.0f;
                k2[2] = 0.0f;
                for (int j = 0; j < indicesK[0].length; ++j) {
                    idx = indicesK[0][j];
                    flowLoc[0][0] = info.spatial_values[0][idx];
                    flowLoc[1][0] = info.spatial_values[1][idx];
                    flowLoc[2][0] = info.spatial_values[2][idx];
                    flowVec[0][0] = flow_valuesB[0][idx];
                    flowVec[1][0] = flow_valuesB[1][idx];
                    flowVec[2][0] = flow_valuesB[2][idx];
                    del = TrajectoryManager.computeDisplacement(info, flowLoc, flowVec, timeStep);
                    k2[0] = k2[0] + weightsK[0][j] * (float)direction * del[0][0];
                    k2[1] = k2[1] + weightsK[0][j] * (float)direction * del[1][0];
                    k2[2] = k2[2] + weightsK[0][j] * (float)direction * del[2][0];
                }
            }
            xyz[0] = this.startPts[0] + k2[0] / 2.0f;
            xyz[1] = this.startPts[1] + k2[1] / 2.0f;
            xyz[2] = this.startPts[2] + k2[2] / 2.0f;
            indicesK = new int[1][];
            weightsK = new float[1][];
            if (this.manifoldDimension == 2) {
                float[][] pts2D = new float[2][1];
                pts2D[0][0] = xyz[0];
                pts2D[1][0] = xyz[1];
                spatial_set.valueToInterp(pts2D, indicesK, weightsK, this.guess2D);
            } else if (this.manifoldDimension == 3) {
                float[][] pts3D = new float[3][1];
                pts3D[0][0] = xyz[0];
                pts3D[1][0] = xyz[1];
                pts3D[2][0] = xyz[2];
                spatial_set.valueToInterp(pts3D, indicesK, weightsK, this.guess3D);
            }
            if (indicesK[0] != null) {
                k3[0] = 0.0f;
                k3[1] = 0.0f;
                k3[2] = 0.0f;
                for (int j = 0; j < indicesK[0].length; ++j) {
                    idx = indicesK[0][j];
                    flowLoc[0][0] = info.spatial_values[0][idx];
                    flowLoc[1][0] = info.spatial_values[1][idx];
                    flowLoc[2][0] = info.spatial_values[2][idx];
                    flowVec[0][0] = flow_valuesB[0][idx];
                    flowVec[1][0] = flow_valuesB[1][idx];
                    flowVec[2][0] = flow_valuesB[2][idx];
                    del = TrajectoryManager.computeDisplacement(info, flowLoc, flowVec, timeStep);
                    k3[0] = k3[0] + weightsK[0][j] * (float)direction * del[0][0];
                    k3[1] = k3[1] + weightsK[0][j] * (float)direction * del[1][0];
                    k3[2] = k3[2] + weightsK[0][j] * (float)direction * del[2][0];
                }
            }
            xyz[0] = this.startPts[0] + k3[0];
            xyz[1] = this.startPts[1] + k3[1];
            xyz[2] = this.startPts[2] + k3[2];
            indicesK = new int[1][];
            weightsK = new float[1][];
            if (this.manifoldDimension == 2) {
                float[][] pts2D = new float[2][1];
                pts2D[0][0] = xyz[0];
                pts2D[1][0] = xyz[1];
                spatial_set.valueToInterp(pts2D, indicesK, weightsK, this.guess2D);
            } else if (this.manifoldDimension == 3) {
                float[][] pts3D = new float[3][1];
                pts3D[0][0] = xyz[0];
                pts3D[1][0] = xyz[1];
                pts3D[2][0] = xyz[2];
                spatial_set.valueToInterp(pts3D, indicesK, weightsK, this.guess3D);
            }
            if (indicesK[0] != null) {
                k4[0] = 0.0f;
                k4[1] = 0.0f;
                k4[2] = 0.0f;
                for (int j = 0; j < indicesK[0].length; ++j) {
                    idx = indicesK[0][j];
                    flowLoc[0][0] = info.spatial_values[0][idx];
                    flowLoc[1][0] = info.spatial_values[1][idx];
                    flowLoc[2][0] = info.spatial_values[2][idx];
                    flowVec[0][0] = flow_valuesC[0][idx];
                    flowVec[1][0] = flow_valuesC[1][idx];
                    flowVec[2][0] = flow_valuesC[2][idx];
                    del = TrajectoryManager.computeDisplacement(info, flowLoc, flowVec, timeStep);
                    k4[0] = k4[0] + weightsK[0][j] * (float)direction * del[0][0];
                    k4[1] = k4[1] + weightsK[0][j] * (float)direction * del[1][0];
                    k4[2] = k4[2] + weightsK[0][j] * (float)direction * del[2][0];
                }
            }
            this.stopPts[0] = this.startPts[0] + 0.16666667f * k1[0] + 0.33333334f * k2[0] + 0.33333334f * k3[0] + 0.16666667f * k4[0];
            this.stopPts[1] = this.startPts[1] + 0.16666667f * k1[1] + 0.33333334f * k2[1] + 0.33333334f * k3[1] + 0.16666667f * k4[1];
            this.stopPts[2] = this.startPts[2] + 0.16666667f * k1[2] + 0.33333334f * k2[2] + 0.33333334f * k3[2] + 0.16666667f * k4[2];
            xyz[0] = this.stopPts[0];
            xyz[1] = this.stopPts[1];
            xyz[2] = this.stopPts[2];
            if (this.manifoldDimension == 2) {
                float[][] pts2D = new float[2][1];
                pts2D[0][0] = xyz[0];
                pts2D[1][0] = xyz[1];
                spatial_set.valueToInterp(pts2D, this.indices, this.weights, this.guess2D);
            } else if (this.manifoldDimension == 3) {
                float[][] pts3D = new float[3][1];
                pts3D[0][0] = xyz[0];
                pts3D[1][0] = xyz[1];
                pts3D[2][0] = xyz[2];
                spatial_set.valueToInterp(pts3D, this.indices, this.weights, this.guess3D);
                if (terrain != null) {
                    this.adjustFlowAtTerrain(terrain, color_values);
                }
            }
            if (this.indices[0] != null) {
                if (!this.conserveColor) {
                    for (int j = 0; j < this.indices[0].length; ++j) {
                        idx = this.indices[0][j];
                        intrpClr[0] = intrpClr[0] + this.weights[0][j] * ShadowType.byteToFloat(color_values[0][idx]);
                        intrpClr[1] = intrpClr[1] + this.weights[0][j] * ShadowType.byteToFloat(color_values[1][idx]);
                        intrpClr[2] = intrpClr[2] + this.weights[0][j] * ShadowType.byteToFloat(color_values[2][idx]);
                        if (this.clrDim != 4) continue;
                        intrpClr[3] = intrpClr[3] + this.weights[0][j] * ShadowType.byteToFloat(color_values[3][idx]);
                    }
                    this.stopColor[0] = ShadowType.floatToByte(intrpClr[0]);
                    this.stopColor[1] = ShadowType.floatToByte(intrpClr[1]);
                    this.stopColor[2] = ShadowType.floatToByte(intrpClr[2]);
                    if (this.clrDim == 4) {
                        this.stopColor[3] = ShadowType.floatToByte(intrpClr[3]);
                    }
                } else {
                    this.stopColor[0] = this.startColor[0];
                    this.stopColor[1] = this.startColor[1];
                    this.stopColor[2] = this.startColor[2];
                    if (this.clrDim == 4) {
                        this.stopColor[3] = this.startColor[3];
                    }
                }
            }
            if (this.indices[0] == null) {
                this.offGrid = true;
            } else {
                this.addPair(this.startPts, this.stopPts, this.startColor, this.stopColor);
                this.uVecPath[0] = this.stopPts[0] - this.startPts[0];
                this.uVecPath[1] = this.stopPts[1] - this.startPts[1];
                this.uVecPath[2] = this.stopPts[2] - this.startPts[2];
                float mag = (float)Math.sqrt(this.uVecPath[0] * this.uVecPath[0] + this.uVecPath[1] * this.uVecPath[1] + this.uVecPath[2] * this.uVecPath[2]);
                this.uVecPath[0] = this.uVecPath[0] / mag;
                this.uVecPath[1] = this.uVecPath[1] / mag;
                this.uVecPath[2] = this.uVecPath[2] / mag;
                this.update();
            }
        }
    }

    private void addPair(float[] startPt, float[] stopPt, byte[] startColor, byte[] stopColor) {
        this.indexes[this.npairs] = this.trajMan.getCoordinateCount();
        this.trajMan.addPair(startPt, stopPt, startColor, stopColor);
        ++this.npairs;
        int clrDim = startColor.length;
        if (this.indexes.length == this.npairs) {
            int[] tmp = new int[this.npairs + 40];
            System.arraycopy(this.indexes, 0, tmp, 0, this.npairs);
            this.indexes = tmp;
        }
    }

    private void update() throws VisADException {
        this.startPts[0] = this.stopPts[0];
        this.startPts[1] = this.stopPts[1];
        this.startPts[2] = this.stopPts[2];
        this.startColor[0] = this.stopColor[0];
        this.startColor[1] = this.stopColor[1];
        this.startColor[2] = this.stopColor[2];
        if (this.clrDim == 4) {
            this.startColor[3] = this.stopColor[3];
        }
        this.startCell = this.indices[0];
        this.cellWeights = this.weights[0];
        if (this.indices[0] == null) {
            this.offGrid = true;
        }
    }

    private void adjustFlowAtTerrain(FlatField terrain, byte[][] color_values) throws VisADException, RemoteException {
        float[] intrpClr = new float[this.clrDim];
        if (terrain != null && this.indices[0] != null) {
            int[] lens = this.spatial_set.getLengths();
            float[][] spatial_values = this.spatial_set.getSamples(false);
            int dir = spatial_values[2][0] < spatial_values[2][lens[0] * lens[1]] ? 1 : -1;
            float parcelHgt = this.stopPts[2];
            float parcelX = this.stopPts[0];
            float parcelY = this.stopPts[1];
            RealTuple xy = new RealTuple(((FunctionType)terrain.getType()).getDomain(), new double[]{parcelX, parcelY});
            float cellTerrain = (float)((Real)terrain.evaluate(xy, 101, 202)).getValue();
            float diff = parcelHgt - cellTerrain;
            if (diff < 0.0f) {
                float zUp = this.stopPts[2] - diff + 0.0015f;
                if (!Float.isNaN(this.last_cellTerrain) && (double)Math.abs(this.last_cellTerrain - cellTerrain) < 5.0E-4) {
                    zUp = this.startPts[2];
                }
                float[][] pts3D = new float[3][1];
                pts3D[0][0] = this.stopPts[0];
                pts3D[1][0] = this.stopPts[1];
                pts3D[2][0] = zUp;
                this.spatial_set.valueToInterp(pts3D, this.indices, this.weights, this.guess3D);
                if (this.indices[0] != null) {
                    this.stopPts[2] = zUp;
                    if (!this.conserveColor) {
                        Arrays.fill(intrpClr, 0.0f);
                        for (int k = 0; k < this.indices[0].length; ++k) {
                            int idx = this.indices[0][k];
                            intrpClr[0] = intrpClr[0] + this.weights[0][k] * ShadowType.byteToFloat(color_values[0][idx]);
                            intrpClr[1] = intrpClr[1] + this.weights[0][k] * ShadowType.byteToFloat(color_values[1][idx]);
                            intrpClr[2] = intrpClr[2] + this.weights[0][k] * ShadowType.byteToFloat(color_values[2][idx]);
                            if (this.clrDim != 4) continue;
                            intrpClr[3] = intrpClr[3] + this.weights[0][k] * ShadowType.byteToFloat(color_values[3][idx]);
                        }
                        this.stopColor[0] = ShadowType.floatToByte(intrpClr[0]);
                        this.stopColor[1] = ShadowType.floatToByte(intrpClr[1]);
                        this.stopColor[2] = ShadowType.floatToByte(intrpClr[2]);
                        if (this.clrDim == 4) {
                            this.stopColor[3] = ShadowType.floatToByte(intrpClr[3]);
                        }
                    } else {
                        this.stopColor[0] = this.startColor[0];
                        this.stopColor[1] = this.startColor[1];
                        this.stopColor[2] = this.startColor[2];
                        if (this.clrDim == 4) {
                            this.stopColor[3] = this.startColor[3];
                        }
                    }
                }
            }
            this.last_cellTerrain = cellTerrain;
        }
    }

    public void makeCylinderStrip(int q, float[] uvecPath, float[] uvecPathNext, float[] pt0, float[] pt1, byte[][] clr0, byte[][] clr1, float size, int npts, float[] coords, byte[] colors, float[] normls, float[] elbowCoords, byte[] elbowColors, float[] elbowNormals, int[] vertCnt, int[] elbowVertCnt, int[] elbowStrips, int[] elbowStripCnt) {
        int clrDim = clr0.length;
        float[] cntr = new float[3];
        boolean doElbow = true;
        double[] planeNormal = new double[3];
        if (q == this.npairs - 1) {
            planeNormal[0] = uvecPath[0];
            planeNormal[1] = uvecPath[1];
            planeNormal[2] = uvecPath[2];
            doElbow = false;
        } else {
            planeNormal = TrajectoryManager.getBisectPlaneNormal(uvecPath, uvecPathNext);
        }
        double[] bisectPlaneCoeffs = TrajectoryManager.getPlaneCoeffsFromNormalAndPoint(planeNormal, new double[]{pt1[0], pt1[1], pt1[2]});
        if (this.circleXYZ == null) {
            this.circleXYZ = new float[3][npts];
        }
        if (this.last_circleXYZ == null) {
            this.last_circleXYZ = new float[3][npts];
        }
        if (q == 0) {
            float[] norm = new float[]{0.0f, 0.0f, 1.0f};
            float[][] ptsXYZ = Trajectory.makeCircle(size, uvecPath, norm, npts, pt0);
            this.last_circleXYZ = new float[3][npts];
            System.arraycopy(ptsXYZ[0], 0, this.last_circleXYZ[0], 0, npts);
            System.arraycopy(ptsXYZ[1], 0, this.last_circleXYZ[1], 0, npts);
            System.arraycopy(ptsXYZ[2], 0, this.last_circleXYZ[2], 0, npts);
            this.lastCntr = new float[3];
            this.lastCntr[0] = pt0[0];
            this.lastCntr[1] = pt0[1];
            this.lastCntr[2] = pt0[2];
            if (this.lastFwdFace == null) {
                this.lastFwdFace = new float[3][npts];
            } else {
                Trajectory.makeCylinderSegment(this.lastFwdFace, pt0, clr0, this.last_circleXYZ, pt0, clr0, elbowCoords, elbowNormals, elbowColors, elbowVertCnt);
                int n = elbowStripCnt[0];
                elbowStripCnt[0] = n + 1;
                elbowStrips[n] = npts * 2;
            }
        } else {
            double[] coeffs = TrajectoryManager.getPlaneCoeffsFromNormalAndPoint(new double[]{uvecPath[0], uvecPath[1], uvecPath[2]}, this.lastMinDistPt);
            double[] P = TrajectoryManager.getLinePlaneIntersect(coeffs, new double[]{uvecPath[0], uvecPath[1], uvecPath[2]}, new double[]{pt0[0], pt0[1], pt0[2]});
            float[] Pf = new float[]{(float)P[0], (float)P[1], (float)P[2]};
            this.lastCntr[0] = (float)P[0];
            this.lastCntr[1] = (float)P[1];
            this.lastCntr[2] = (float)P[2];
            float[] norm = new float[]{0.0f, 0.0f, 1.0f};
            float[][] ptsXYZ = Trajectory.makeCircle(size, uvecPath, norm, npts, this.lastCntr);
            this.last_circleXYZ = new float[3][npts];
            System.arraycopy(ptsXYZ[0], 0, this.last_circleXYZ[0], 0, npts);
            System.arraycopy(ptsXYZ[1], 0, this.last_circleXYZ[1], 0, npts);
            System.arraycopy(ptsXYZ[2], 0, this.last_circleXYZ[2], 0, npts);
        }
        double minDist = Double.MAX_VALUE;
        double[] minDistPt = new double[3];
        for (int k = 0; k < npts; ++k) {
            double delz;
            double dely;
            double[] pt = new double[]{this.last_circleXYZ[0][k], this.last_circleXYZ[1][k], this.last_circleXYZ[2][k]};
            double[] dArray = new double[]{uvecPath[0], uvecPath[1], uvecPath[2]};
            double[] P = TrajectoryManager.getLinePlaneIntersect(bisectPlaneCoeffs, dArray, pt);
            double delx = pt[0] - P[0];
            double dist = Math.sqrt(delx * delx + (dely = pt[1] - P[1]) * dely + (delz = pt[2] - P[2]) * delz);
            if (!(dist < minDist)) continue;
            minDist = dist;
            minDistPt[0] = P[0];
            minDistPt[1] = P[1];
            minDistPt[2] = P[2];
            int n = k;
        }
        this.lastMinDistPt[0] = minDistPt[0];
        this.lastMinDistPt[1] = minDistPt[1];
        this.lastMinDistPt[2] = minDistPt[2];
        double[] coeffs = q == this.npairs - 1 ? TrajectoryManager.getPlaneCoeffsFromNormalAndPoint(new double[]{uvecPath[0], uvecPath[1], uvecPath[2]}, new double[]{pt1[0], pt1[1], pt1[2]}) : TrajectoryManager.getPlaneCoeffsFromNormalAndPoint(new double[]{uvecPath[0], uvecPath[1], uvecPath[2]}, minDistPt);
        for (int k = 0; k < npts; ++k) {
            double[] pt = new double[]{this.last_circleXYZ[0][k], this.last_circleXYZ[1][k], this.last_circleXYZ[2][k]};
            double[] P = TrajectoryManager.getLinePlaneIntersect(coeffs, new double[]{uvecPath[0], uvecPath[1], uvecPath[2]}, pt);
            this.circleXYZ[0][k] = (float)P[0];
            this.circleXYZ[1][k] = (float)P[1];
            this.circleXYZ[2][k] = (float)P[2];
        }
        double[] P = TrajectoryManager.getLinePlaneIntersect(coeffs, new double[]{uvecPath[0], uvecPath[1], uvecPath[2]}, new double[]{pt0[0], pt0[1], pt0[2]});
        cntr[0] = (float)P[0];
        cntr[1] = (float)P[1];
        cntr[2] = (float)P[2];
        Trajectory.makeCylinderSegment(this.last_circleXYZ, this.lastCntr, clr0, this.circleXYZ, cntr, clr1, coords, normls, colors, vertCnt);
        coeffs = TrajectoryManager.getPlaneCoeffsFromNormalAndPoint(new double[]{uvecPathNext[0], uvecPathNext[1], uvecPathNext[2]}, minDistPt);
        P = TrajectoryManager.getLinePlaneIntersect(coeffs, new double[]{uvecPathNext[0], uvecPathNext[1], uvecPathNext[2]}, new double[]{pt1[0], pt1[1], pt1[2]});
        float[] Pfnext = new float[]{(float)P[0], (float)P[1], (float)P[2]};
        this.lastCntr[0] = (float)P[0];
        this.lastCntr[1] = (float)P[1];
        this.lastCntr[2] = (float)P[2];
        float[] norm = new float[]{0.0f, 0.0f, 1.0f};
        float[][] ptsXYZ = Trajectory.makeCircle(size, uvecPathNext, norm, npts, this.lastCntr);
        System.arraycopy(ptsXYZ[0], 0, this.last_circleXYZ[0], 0, npts);
        System.arraycopy(ptsXYZ[1], 0, this.last_circleXYZ[1], 0, npts);
        System.arraycopy(ptsXYZ[2], 0, this.last_circleXYZ[2], 0, npts);
        if (doElbow) {
            Trajectory.makeCylinderSegment(this.circleXYZ, cntr, clr1, this.last_circleXYZ, this.lastCntr, clr1, elbowCoords, elbowNormals, elbowColors, elbowVertCnt);
            int n = elbowStripCnt[0];
            elbowStripCnt[0] = n + 1;
            elbowStrips[n] = npts * 2;
        }
        System.arraycopy(this.circleXYZ[0], 0, this.lastFwdFace[0], 0, npts);
        System.arraycopy(this.circleXYZ[1], 0, this.lastFwdFace[1], 0, npts);
        System.arraycopy(this.circleXYZ[2], 0, this.lastFwdFace[2], 0, npts);
    }

    public static float[][] makeCircle(float radius, float[] uvec, float[] norm, int npts, float[] center) {
        float[] trj_x_norm_x_trj;
        if (circle == null) {
            circle = new float[2][npts];
            float intrvl = (float)Math.PI * 2 / (float)(npts - 1);
            for (int i = 0; i < npts; ++i) {
                Trajectory.circle[0][i] = (float)Math.cos(intrvl * (float)i);
                Trajectory.circle[1][i] = (float)Math.sin(intrvl * (float)i);
            }
        }
        float[] norm_x_trj = TrajectoryManager.AxB(norm, uvec);
        float[] T = trj_x_norm_x_trj = TrajectoryManager.AxB(uvec, norm_x_trj);
        float[] S = norm_x_trj;
        float[][] ptsXYZ = new float[3][npts];
        for (int k = 0; k < npts; ++k) {
            float s = radius * circle[0][k];
            float t = radius * circle[1][k];
            ptsXYZ[0][k] = center[0] + s * S[0] + t * T[0];
            ptsXYZ[1][k] = center[1] + s * S[1] + t * T[1];
            ptsXYZ[2][k] = center[2] + s * S[2] + t * T[2];
        }
        return ptsXYZ;
    }

    public static void makeCylinderSegment(float[][] last_circleXYZ, float[] pt0, byte[][] clr0, float[][] circleXYZ, float[] pt1, byte[][] clr1, float[] coords, float[] normls, byte[] colors, int[] vcnt_a) {
        int clrDim = clr0.length;
        int npts = last_circleXYZ[0].length;
        int vcnt = vcnt_a[0];
        for (int k = 0; k < npts; ++k) {
            float x = last_circleXYZ[0][k];
            float y = last_circleXYZ[1][k];
            float z = last_circleXYZ[2][k];
            float delx = x - pt0[0];
            float dely = y - pt0[1];
            float delz = z - pt0[2];
            float mag = (float)Math.sqrt(delx * delx + dely * dely + delz * delz);
            int idx = vcnt * 3;
            int cidx = vcnt * clrDim;
            normls[idx] = delx / mag;
            coords[idx++] = x;
            normls[idx] = dely / mag;
            coords[idx++] = y;
            normls[idx] = delz / mag;
            coords[idx++] = z;
            if (clrDim == 3) {
                colors[cidx++] = clr0[0][0];
                colors[cidx++] = clr0[1][0];
                colors[cidx++] = clr0[2][0];
            } else {
                colors[cidx++] = clr0[0][0];
                colors[cidx++] = clr0[1][0];
                colors[cidx++] = clr0[2][0];
                colors[cidx++] = clr0[3][0];
            }
            ++vcnt;
            x = circleXYZ[0][k];
            y = circleXYZ[1][k];
            z = circleXYZ[2][k];
            delx = x - pt1[0];
            dely = y - pt1[1];
            delz = z - pt1[2];
            mag = (float)Math.sqrt(delx * delx + dely * dely + delz * delz);
            normls[idx] = delx / mag;
            coords[idx++] = x;
            normls[idx] = dely / mag;
            coords[idx++] = y;
            normls[idx] = delz / mag;
            coords[idx++] = z;
            if (clrDim == 3) {
                colors[cidx++] = clr1[0][0];
                colors[cidx++] = clr1[1][0];
                colors[cidx++] = clr1[2][0];
            } else {
                colors[cidx++] = clr1[0][0];
                colors[cidx++] = clr1[1][0];
                colors[cidx++] = clr1[2][0];
                colors[cidx++] = clr1[3][0];
            }
            ++vcnt;
        }
        vcnt_a[0] = vcnt;
    }
}

