/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import visad.BaseColorControl;
import visad.CommonUnit;
import visad.ControlListener;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayImpl;
import visad.FieldImpl;
import visad.FlatField;
import visad.FlowControl;
import visad.FlowInfo;
import visad.FunctionType;
import visad.Gridded1DDoubleSet;
import visad.Gridded1DSet;
import visad.Gridded2DSet;
import visad.Gridded3DSet;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.ListenForRemove;
import visad.MathType;
import visad.NoneInterpolator;
import visad.ProjectionControl;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarMapListener;
import visad.Set;
import visad.SetType;
import visad.ShadowType;
import visad.Trajectory;
import visad.TrajectoryParams;
import visad.Unit;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADLineArray;
import visad.VisADPointArray;
import visad.VisADTriangleArray;
import visad.VisADTriangleStripArray;
import visad.data.text.TextAdapter;
import visad.util.CubicInterpolator;
import visad.util.Interpolator;
import visad.util.LinearInterpolator;
import visad.util.Util;

public class TrajectoryManager {
    static float[][] circle;
    private int coordCnt = 0;
    private int colorCnt = 0;
    private int vertCnt = 0;
    private int totNpairs = 0;
    private int dataDomainLength;
    private float[] coordinates = null;
    private byte[] colors = null;
    private int clrDim = 3;
    private int numSpatialPts;
    private boolean[] markGrid;
    private int[] markGridTime;
    private int cnt = 0;
    public static boolean doStartOffset;
    public static int[] o_j;
    public static int[] o_i;
    float[][] startPts;
    double[] startTimes;
    byte[][] startClrs;
    public static final int LINE = 0;
    public static final int RIBBON = 1;
    public static final int CYLINDER = 2;
    public static final int DEFORM_RIBBON = 3;
    public static final int POINT = 4;
    public static final int TRACER = 5;
    public static final int TRACER_POINT = 6;
    public static final String PPOP_TRAJECTORY_START_POINTS_FILE = "visad.trajectory.startPointsFile";
    public static final String PPOP_TRAJECTORY_START_POINTS_FILE_1 = "visad.trajectory.startPointsFile1";
    public static final String PPOP_TRAJECTORY_START_POINTS_FILE_2 = "visad.trajectory.startPointsFile2";
    public static final String PROP_TRAJECTORY_PARAM_FILE_1 = "visad.trajectory.paramFile1";
    public static final String PROP_TRAJECTORY_PARAM_FILE_2 = "visad.trajectory.paramFile2";
    public static final String PROP_TRAJECTORY_TERRAIN_FILE = "visad.trajectory.terrainFile";
    double trajVisibilityTimeWindow;
    double trajRefreshInterval;
    double trajLifetime;
    boolean manualIntrpPts;
    boolean trajDoIntrp = true;
    boolean trajCachingEnabled = false;
    boolean trcrStreamingEnabled;
    boolean saveTracerLocations;
    float trcrSize = 1.0f;
    boolean trcrEnabled;
    boolean terrainFollowEnabled;
    int numIntrpPts;
    int trajSkip;
    TrajectoryParams.SmoothParams smoothParams;
    TrajectoryParams.Method method;
    int direction;
    int trajForm = 0;
    float cylWidth = 0.01f;
    float ribbonWidthFac = 1.0f;
    int zStart = 0;
    int zSkip = 0;
    float[] intrpU;
    float[] intrpV;
    float[] intrpW;
    float[] intrpU_1;
    float[] intrpV_1;
    float[] intrpW_1;
    float[] intrpU_2;
    float[] intrpV_2;
    float[] intrpW_2;
    Interpolator uInterp;
    Interpolator vInterp;
    Interpolator wInterp;
    float[][] values0;
    float[][] values1;
    float[][] values2;
    float[][] values3;
    float[][] values0_last;
    RealTupleType startPointType = Display.DisplaySpatialCartesianTuple;
    ScalarMap altToZ;
    ArrayList<FlowInfo> flowInfoList;
    ArrayList<Trajectory> trajectories;
    FlatField terrain = null;
    Gridded1DSet anim1DdomainSet;
    CoordinateSystem dspCoordSys;
    public FieldImpl tracerLocations;
    double timeStepScaleFactor;
    boolean conserveColor;
    public static HashMap<FlowControl, ControlListener> scaleChangeListeners;
    public static HashMap<ScalarMap, ScalarMapListener> removeListeners;

    public TrajectoryManager(DataRenderer renderer, TrajectoryParams trajParams, ArrayList<FlowInfo> flowInfoList, int dataDomainLength, double time) throws VisADException {
        this(renderer, trajParams, flowInfoList, dataDomainLength, time, null, null, null);
    }

    public TrajectoryManager(DataRenderer renderer, TrajectoryParams trajParams, ArrayList<FlowInfo> flowInfoList, int dataDomainLength, double time, ScalarMap altToZ, CoordinateSystem dspCoordSys, Gridded1DSet anim1DdomainSet) throws VisADException {
        this.flowInfoList = flowInfoList;
        this.anim1DdomainSet = anim1DdomainSet;
        this.dspCoordSys = dspCoordSys;
        FlowInfo info = flowInfoList.get(0);
        this.dataDomainLength = dataDomainLength;
        this.trajVisibilityTimeWindow = trajParams.getTrajVisibilityTimeWindow();
        this.trajLifetime = this.trajRefreshInterval = trajParams.getTrajRefreshInterval();
        this.manualIntrpPts = trajParams.getManualIntrpPts();
        this.numIntrpPts = trajParams.getNumIntrpPts();
        this.trajSkip = trajParams.getStartSkip();
        this.smoothParams = trajParams.getSmoothParams();
        this.method = trajParams.getMethod();
        this.direction = trajParams.getDirection();
        this.startPts = trajParams.getStartPoints();
        this.trcrSize = trajParams.getMarkerSize();
        this.trcrEnabled = trajParams.getMarkerEnabled();
        this.trajCachingEnabled = trajParams.getCachingEnabled();
        this.trcrStreamingEnabled = trajParams.getTracerStreamingEnabled();
        this.terrainFollowEnabled = trajParams.getTerrainFollowing();
        this.trajForm = trajParams.getTrajectoryForm();
        this.cylWidth = trajParams.getCylinderWidth();
        this.ribbonWidthFac = trajParams.getRibbonWidthFactor();
        this.zStart = trajParams.getZStartIndex();
        this.zSkip = trajParams.getZStartSkip();
        this.startPointType = trajParams.getStartType();
        this.saveTracerLocations = trajParams.getSaveTracerLocations();
        this.timeStepScaleFactor = trajParams.getTimeStepScaleFactor();
        this.conserveColor = trajParams.getConserveColor();
        this.altToZ = altToZ;
        if (this.terrainFollowEnabled) {
            this.terrain = TrajectoryManager.getTerrainFromDisk();
            if (this.terrain == null) {
                this.terrain = trajParams.getTerrain();
            }
        }
        if (this.terrain != null) {
            this.terrain = (FlatField)this.terrain.clone();
            altToZ.scaleValues(this.terrain.getFloats(false)[0], false);
        }
        Gridded3DSet spatial_set0 = (Gridded3DSet)info.spatial_set;
        GriddedSet spatialSetTraj = TrajectoryManager.makeSpatialSetTraj(spatial_set0);
        if (this.terrain != null) {
            this.terrain = TrajectoryManager.terrainToSpatial(this.terrain, spatialSetTraj, dspCoordSys);
        }
        if (trajParams.getSaveTracerLocations()) {
            FunctionType ftype = new FunctionType(((SetType)anim1DdomainSet.getType()).getDomain(), new FunctionType(RealType.Generic, RealTupleType.LatitudeLongitudeAltitude));
            this.tracerLocations = new FieldImpl(ftype, anim1DdomainSet);
        }
        byte[][] color_values = info.getColorValues();
        if (info.trajColors != null) {
            color_values = info.trajColors;
        }
        this.clrDim = color_values.length;
        this.numSpatialPts = spatial_set0.getLength();
        this.markGrid = new boolean[this.numSpatialPts];
        this.markGridTime = new int[this.numSpatialPts];
        Arrays.fill(this.markGrid, false);
        Arrays.fill(this.markGridTime, 0);
        this.startClrs = new byte[this.clrDim][];
        double[][] tmp = new double[1][];
        if (this.startPts == null) {
            try {
                this.startPts = this.getStartPointsFromFile(renderer, altToZ, this.startClrs, tmp, info.which);
                this.startTimes = tmp[0];
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.startPts == null) {
            float[][] flowVals = TrajectoryManager.convertFlowUnit(info.getFlowValues(), info.flow_units);
            float[][] vec = ShadowType.adjustFlowToEarth(info.which, flowVals, spatial_set0.getSamples(false), 1.0f, renderer);
            this.startPts = new float[3][];
            this.getStartPointsFromDomain(this.trajForm, this.trajSkip, this.zStart, this.zSkip, spatial_set0, color_values, this.startPts, this.startClrs, vec, this.ribbonWidthFac);
        } else if (this.startClrs[0] == null) {
            int[] clrIdxs = spatialSetTraj.getManifoldDimension() == 2 ? spatialSetTraj.valueToIndex(new float[][]{this.startPts[0], this.startPts[1]}) : spatialSetTraj.valueToIndex(this.startPts);
            int num = clrIdxs.length;
            this.startClrs[0] = new byte[num];
            this.startClrs[1] = new byte[num];
            this.startClrs[2] = new byte[num];
            if (this.clrDim == 4) {
                this.startClrs[3] = new byte[num];
            }
            for (int i = 0; i < num; ++i) {
                int clrIdx = clrIdxs[i];
                if (clrIdx < 0) continue;
                this.startClrs[0][i] = color_values[0][clrIdx];
                this.startClrs[1][i] = color_values[1][clrIdx];
                this.startClrs[2][i] = color_values[2][clrIdx];
                if (this.clrDim != 4) continue;
                this.startClrs[3][i] = color_values[3][clrIdx];
            }
        }
        this.intrpU = new float[this.numSpatialPts];
        this.intrpV = new float[this.numSpatialPts];
        this.intrpW = new float[this.numSpatialPts];
        if (this.method == TrajectoryParams.Method.HySplit) {
            this.intrpU_1 = new float[this.numSpatialPts];
            this.intrpV_1 = new float[this.numSpatialPts];
            this.intrpW_1 = new float[this.numSpatialPts];
        } else if (this.method == TrajectoryParams.Method.RK4) {
            this.intrpU_1 = new float[this.numSpatialPts];
            this.intrpV_1 = new float[this.numSpatialPts];
            this.intrpW_1 = new float[this.numSpatialPts];
            this.intrpU_2 = new float[this.numSpatialPts];
            this.intrpV_2 = new float[this.numSpatialPts];
            this.intrpW_2 = new float[this.numSpatialPts];
        }
        if (trajParams.getInterpolationMethod() == TrajectoryParams.InterpolationMethod.Cubic) {
            this.uInterp = new CubicInterpolator(this.numSpatialPts);
            this.vInterp = new CubicInterpolator(this.numSpatialPts);
            this.wInterp = new CubicInterpolator(this.numSpatialPts);
        } else if (trajParams.getInterpolationMethod() == TrajectoryParams.InterpolationMethod.Linear) {
            this.uInterp = new LinearInterpolator(this.numSpatialPts);
            this.vInterp = new LinearInterpolator(this.numSpatialPts);
            this.wInterp = new LinearInterpolator(this.numSpatialPts);
        } else if (trajParams.getInterpolationMethod() == TrajectoryParams.InterpolationMethod.None) {
            this.uInterp = new NoneInterpolator(this.numSpatialPts);
            this.vInterp = new NoneInterpolator(this.numSpatialPts);
            this.wInterp = new NoneInterpolator(this.numSpatialPts);
        }
        if (!this.trajDoIntrp) {
            this.numIntrpPts = 1;
        }
        this.values0 = null;
        this.values1 = null;
        this.values2 = null;
        this.values3 = null;
        this.values0_last = null;
        this.trajectories = new ArrayList();
        Arrays.fill(this.markGrid, false);
        this.makeTrajectories((double)this.direction * time, this.startPts, this.startTimes, this.startClrs, spatialSetTraj);
    }

    public void addPair(float[] startPt, float[] stopPt, byte[] startColor, byte[] stopColor) {
        this.coordinates[this.coordCnt++] = startPt[0];
        this.coordinates[this.coordCnt++] = startPt[1];
        this.coordinates[this.coordCnt++] = startPt[2];
        ++this.vertCnt;
        this.coordinates[this.coordCnt++] = stopPt[0];
        this.coordinates[this.coordCnt++] = stopPt[1];
        this.coordinates[this.coordCnt++] = stopPt[2];
        ++this.vertCnt;
        ++this.totNpairs;
        int clrDim = startColor.length;
        this.colors[this.colorCnt++] = startColor[0];
        this.colors[this.colorCnt++] = startColor[1];
        this.colors[this.colorCnt++] = startColor[2];
        if (clrDim == 4) {
            this.colors[this.colorCnt++] = startColor[3];
        }
        this.colors[this.colorCnt++] = stopColor[0];
        this.colors[this.colorCnt++] = stopColor[1];
        this.colors[this.colorCnt++] = stopColor[2];
        if (clrDim == 4) {
            this.colors[this.colorCnt++] = stopColor[3];
        }
    }

    public int getCoordinateCount() {
        return this.coordCnt;
    }

    public int getColorCount() {
        return this.colorCnt;
    }

    public int getNumberOfTrajectories() {
        return this.trajectories.size();
    }

    public static int getNumIntrpPts(FlowInfo info, float maxSpd, double timeStep) throws VisADException {
        float[][] del = TrajectoryManager.computeDisplacement(info, new float[][]{{0.0f}, {0.0f}, {0.0f}}, new float[][]{{maxSpd}, {0.0f}, {0.0f}}, (float)timeStep);
        double intrvl = (double)del[0][0] / 0.1;
        int numIntrpPts = intrvl < 2.0 ? 2 : (int)intrvl;
        return numIntrpPts;
    }

    public static float[][] computeDisplacement(FlowInfo info, float[][] spatial_values, float[][] flow_values, float timeStep) throws VisADException {
        return ShadowType.adjustFlowToEarth(info.which, flow_values, spatial_values, info.flowScale, info.renderer, false, true, timeStep);
    }

    public VisADGeometryArray[] computeTrajectories(int k, double timeAccum, double[] times, double[] timeSteps) throws VisADException, RemoteException {
        FlowInfo flwInfo;
        int i = this.direction < 0 ? this.dataDomainLength - 1 - k : k;
        VisADGeometryArray array = null;
        VisADGeometryArray[] arrays = null;
        FlowInfo info = this.flowInfoList.get(0);
        byte[][] color_values = info.getColorValues();
        Gridded3DSet spatial_set = (Gridded3DSet)info.spatial_set;
        GriddedSet spatialSetTraj = TrajectoryManager.makeSpatialSetTraj(spatial_set);
        if (!this.manualIntrpPts && this.trajDoIntrp) {
            this.numIntrpPts = TrajectoryManager.getNumIntrpPts(info, 50.0f, timeSteps[i]);
        }
        float timeStep = (float)timeSteps[i] / (float)this.numIntrpPts;
        timeStep = (float)((double)timeStep * this.timeStepScaleFactor);
        if (!this.trajDoIntrp && this.method == TrajectoryParams.Method.RK4) {
            timeStep *= 2.0f;
        }
        if (timeAccum >= this.trajRefreshInterval) {
            this.trajectories = new ArrayList();
            Arrays.fill(this.markGrid, false);
            this.makeTrajectories((double)this.direction * times[i], this.startPts, this.startTimes, this.startClrs, spatialSetTraj);
        } else if (this.trcrStreamingEnabled) {
            Arrays.fill(this.markGrid, false);
            this.makeTrajectories((double)this.direction * times[i], this.startPts, null, this.startClrs, spatialSetTraj);
        } else if (this.startTimes != null) {
            Arrays.fill(this.markGrid, false);
            this.makeTrajectories((double)this.direction * times[i], this.startPts, this.startTimes, this.startClrs, spatialSetTraj);
        }
        if (this.trajForm == 4) {
            array = this.makePointGeometry();
        }
        double x0 = (double)this.direction * (double)i;
        double x1 = (double)this.direction * (double)(i + this.direction * 1);
        double x2 = (double)this.direction * (double)(i + this.direction * 2);
        double x3 = (double)this.direction * (double)(i + this.direction * 3);
        if (k == 0) {
            flwInfo = this.flowInfoList.get(0);
            this.values0 = TrajectoryManager.convertFlowUnit(flwInfo.getFlowValues(), flwInfo.flow_units);
            flwInfo = this.flowInfoList.get(1);
            this.values1 = TrajectoryManager.convertFlowUnit(flwInfo.getFlowValues(), flwInfo.flow_units);
            flwInfo = this.flowInfoList.get(2);
            this.values2 = TrajectoryManager.convertFlowUnit(flwInfo.getFlowValues(), flwInfo.flow_units);
        }
        if (k < this.dataDomainLength - 3) {
            flwInfo = this.flowInfoList.get(3);
            this.values3 = TrajectoryManager.convertFlowUnit(flwInfo.getFlowValues(), flwInfo.flow_units);
        }
        if (this.values0_last != null) {
            this.values0 = TrajectoryManager.smooth(this.values0_last, this.values0, this.values1, this.smoothParams);
        }
        this.values1 = TrajectoryManager.smooth(this.values0, this.values1, this.values2, this.smoothParams);
        this.values2 = TrajectoryManager.smooth(this.values1, this.values2, this.values3, this.smoothParams);
        if (k < this.dataDomainLength - 2) {
            this.uInterp.next(x0, x1, x2, this.values0[0], this.values1[0], this.values2[0]);
            this.vInterp.next(x0, x1, x2, this.values0[1], this.values1[1], this.values2[1]);
            this.wInterp.next(x0, x1, x2, this.values0[2], this.values1[2], this.values2[2]);
        }
        int numTrajectories = this.trajectories.size();
        this.reset();
        if (this.saveTracerLocations) {
            float[] xyz = new float[3];
            if (numTrajectories > 1) {
                Integer1DSet set = new Integer1DSet(numTrajectories);
                FieldImpl field = new FieldImpl(new FunctionType(RealType.Generic, RealTupleType.LatitudeLongitudeAltitude), set);
                for (int j = 0; j < set.getLength(); ++j) {
                    float[] startPt = this.trajectories.get((int)j).startPts;
                    float[][] lonlatZ = this.dspCoordSys.fromReference(new float[][]{{startPt[0]}, {startPt[1]}, {startPt[2]}});
                    float lat = lonlatZ[0][0];
                    float lon = lonlatZ[1][0];
                    if (lon > 180.0f) {
                        lon -= 360.0f;
                    }
                    float alt = this.altToZ.inverseScaleValues(lonlatZ[2])[0];
                    field.setSample(j, (Data)new RealTuple(RealTupleType.LatitudeLongitudeAltitude, new double[]{lat, lon, alt}));
                }
                this.tracerLocations.setSample(i, (Data)field);
            }
        }
        for (int ti = 0; ti < this.numIntrpPts; ++ti) {
            double dst = (x1 - x0) / (double)this.numIntrpPts;
            double xt = x0 + dst * (double)ti;
            this.updateInterpolators();
            this.uInterp.interpolate(xt, this.intrpU);
            this.vInterp.interpolate(xt, this.intrpV);
            this.wInterp.interpolate(xt, this.intrpW);
            if (this.method == TrajectoryParams.Method.RK4) {
                double step = dst;
                if (!this.trajDoIntrp) {
                    step = 2.0 * dst;
                }
                if (k == this.dataDomainLength - 2 && ti > this.numIntrpPts - 2) continue;
                this.uInterp.interpolate(xt + step / 2.0, this.intrpU_1);
                this.vInterp.interpolate(xt + step / 2.0, this.intrpV_1);
                this.wInterp.interpolate(xt + step / 2.0, this.intrpW_1);
                this.uInterp.interpolate(xt + step, this.intrpU_2);
                this.vInterp.interpolate(xt + step, this.intrpV_2);
                this.wInterp.interpolate(xt + step, this.intrpW_2);
                for (int t = 0; t < numTrajectories; ++t) {
                    Trajectory traj = this.trajectories.get(t);
                    traj.currentTimeIndex = this.direction * i;
                    traj.currentTime = (double)this.direction * times[i];
                    traj.forwardRK4(info, new float[][]{this.intrpU, this.intrpV, this.intrpW}, new float[][]{this.intrpU_1, this.intrpV_1, this.intrpW_1}, new float[][]{this.intrpU_2, this.intrpV_2, this.intrpW_2}, color_values, spatialSetTraj, this.terrain, this.direction, timeStep);
                }
                continue;
            }
            if (this.method == TrajectoryParams.Method.HySplit) {
                this.uInterp.interpolate(xt + dst, this.intrpU_1);
                this.vInterp.interpolate(xt + dst, this.intrpV_1);
                this.wInterp.interpolate(xt + dst, this.intrpW_1);
                this.intrpU = TrajectoryManager.mean(this.intrpU, this.intrpU_1);
                this.intrpV = TrajectoryManager.mean(this.intrpV, this.intrpV_1);
                this.intrpW = TrajectoryManager.mean(this.intrpW, this.intrpW_1);
            }
            for (int t = 0; t < numTrajectories; ++t) {
                Trajectory traj = this.trajectories.get(t);
                traj.currentTimeIndex = this.direction * i;
                traj.currentTime = (double)this.direction * times[i];
                traj.forward(info, new float[][]{this.intrpU, this.intrpV, this.intrpW}, color_values, spatialSetTraj, this.terrain, this.direction, timeStep);
            }
        }
        this.preClean();
        this.values0_last = this.values0;
        this.values0 = this.values1;
        this.values1 = this.values2;
        this.values2 = this.values3;
        switch (this.trajForm) {
            case 0: {
                array = this.makeGeometry();
                this.clean();
                break;
            }
            case 1: {
                array = this.makeFixedWidthRibbon();
                this.clean();
                break;
            }
            case 2: {
                arrays = this.makeCylinder();
                this.clean();
                break;
            }
            case 3: {
                array = this.makeDeformableRibbon();
                this.cleanDefStrp();
                break;
            }
            case 4: {
                this.clean();
                break;
            }
            case 5: {
                this.clean();
                break;
            }
            case 6: {
                this.clean();
            }
        }
        if (arrays == null) {
            arrays = new VisADGeometryArray[]{array};
        }
        return arrays;
    }

    public void makeTrajectories(double time, float[][] startPts, double[] startTimes, byte[][] color_values, GriddedSet spatial_set) throws VisADException {
        int num = startPts[0].length;
        this.clrDim = color_values.length;
        int manifoldDimension = spatial_set.getManifoldDimension();
        int[][] indices = new int[num][];
        float[][] weights = new float[num][];
        if (manifoldDimension == 2) {
            spatial_set.valueToInterp(new float[][]{startPts[0], startPts[1]}, indices, weights);
        } else if (manifoldDimension == 3) {
            spatial_set.valueToInterp(new float[][]{startPts[0], startPts[1], startPts[2]}, indices, weights);
        }
        for (int k = 0; k < num; ++k) {
            float startX = startPts[0][k];
            float startY = startPts[1][k];
            float startZ = startPts[2][k];
            byte[] startColor = new byte[this.clrDim];
            startColor[0] = color_values[0][k];
            startColor[1] = color_values[1][k];
            startColor[2] = color_values[2][k];
            if (this.clrDim == 4) {
                startColor[3] = color_values[3][k];
            }
            if (indices[k] == null || startTimes != null && (startTimes == null || !(startTimes[k] <= time))) continue;
            Trajectory traj = new Trajectory(this, startX, startY, startZ, indices[k], weights[k], startColor, time);
            this.trajectories.add(traj);
        }
    }

    public void reset() {
        int numTrajectories = this.trajectories.size();
        int maxNumVerts = numTrajectories * this.numIntrpPts;
        this.coordCnt = 0;
        this.colorCnt = 0;
        this.vertCnt = 0;
        this.totNpairs = 0;
        if (this.coordinates == null || this.coordinates.length != 3 * (maxNumVerts *= 2)) {
            this.coordinates = new float[3 * maxNumVerts];
        }
        if (this.colors == null || this.colors.length != this.clrDim * maxNumVerts) {
            this.colors = new byte[this.clrDim * maxNumVerts];
        }
        Arrays.fill(this.coordinates, Float.NaN);
        Arrays.fill(this.colors, (byte)0);
        for (int k = 0; k < this.trajectories.size(); ++k) {
            Trajectory traj = this.trajectories.get(k);
            traj.npairs = 0;
        }
    }

    public void checkTime(int timeIdx) {
        for (int k = 0; k < this.markGridTime.length; ++k) {
            if (timeIdx - this.markGridTime[k] <= 4) continue;
            this.markGridTime[k] = timeIdx;
            this.markGrid[k] = false;
        }
    }

    public void preClean() {
        ArrayList<Trajectory> newList = new ArrayList<Trajectory>();
        for (Trajectory traj : this.trajectories) {
            if (traj.npairs <= 0) continue;
            newList.add(traj);
        }
        this.trajectories = newList;
    }

    public void clean() {
        ArrayList<Trajectory> newList = new ArrayList<Trajectory>();
        for (Trajectory traj : this.trajectories) {
            if (traj.offGrid || !(traj.currentTime - traj.initialTime < this.trajLifetime)) continue;
            newList.add(traj);
        }
        this.trajectories = newList;
    }

    public void cleanDefStrp() {
        Iterator<Trajectory> iter = this.trajectories.iterator();
        ArrayList<Trajectory> removeList = new ArrayList<Trajectory>();
        while (iter.hasNext()) {
            int idxB;
            int idxA;
            Trajectory traj = iter.next();
            if (!traj.offGrid && !(traj.currentTime - traj.initialTime > this.trajLifetime)) continue;
            int idx = this.trajectories.indexOf(traj);
            if (idx % 2 == 0) {
                idxA = idx;
                idxB = idx + 1;
            } else {
                idxB = idx;
                idxA = idx - 1;
            }
            removeList.add(this.trajectories.get(idxA));
            removeList.add(this.trajectories.get(idxB));
        }
        for (int t = 0; t < removeList.size(); ++t) {
            this.trajectories.remove(removeList.get(t));
        }
    }

    public void updateInterpolators() {
        boolean[] needed = new boolean[this.numSpatialPts];
        Arrays.fill(needed, false);
        for (int k = 0; k < this.trajectories.size(); ++k) {
            Trajectory traj = this.trajectories.get(k);
            if (traj.offGrid) continue;
            int[] cell = traj.startCell;
            for (int t = 0; t < cell.length; ++t) {
                needed[cell[t]] = true;
            }
        }
        this.uInterp.update(needed);
        this.vInterp.update(needed);
        this.wInterp.update(needed);
    }

    public static GriddedSet makeSpatialSetTraj(Gridded3DSet spatial_set) throws VisADException {
        int manifoldDim = spatial_set.getManifoldDimension();
        int[] lens = spatial_set.getLengths();
        float[][] setLocs = spatial_set.getSamples(false);
        GriddedSet spatialSetTraj = manifoldDim == 2 ? new Gridded2DSet((MathType)RealTupleType.SpatialCartesian2DTuple, new float[][]{setLocs[0], setLocs[1]}, lens[0], lens[1]) : spatial_set;
        return spatialSetTraj;
    }

    private static FlatField getTerrainFromDisk() {
        try {
            String filename = System.getProperty(PROP_TRAJECTORY_TERRAIN_FILE, null);
            if (filename == null) {
                return null;
            }
            File file = new File(filename);
            if (!file.exists()) {
                System.out.println("Specified terrain file does not exist: " + filename);
                return null;
            }
            FileInputStream fis = new FileInputStream(file);
            ObjectInputStream ois = new ObjectInputStream(fis);
            FlatField fld = (FlatField)ois.readObject();
            fis.close();
            return fld;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static FlatField terrainToSpatial(FlatField terrain, GriddedSet spatialSet, CoordinateSystem dspCoordSys) throws VisADException {
        RealTupleType domain = ((FunctionType)terrain.getType()).getDomain();
        MathType range = ((FunctionType)terrain.getType()).getRange();
        CoordinateSystem coordSys = domain.getCoordinateSystem();
        RealTupleType reference = coordSys.getReference();
        Gridded2DSet domSet = (Gridded2DSet)terrain.getDomainSet();
        float[][] grdVals = domSet.getSamples(false);
        float[][] refVals = coordSys.toReference(grdVals);
        float[][] dspVals = dspCoordSys.toReference(refVals);
        RealType[] rTypes = dspCoordSys.getReference().getRealComponents();
        RealTupleType dspXY = new RealTupleType(rTypes[0], rTypes[1]);
        int[] lens = domSet.getLengths();
        Gridded2DSet set = new Gridded2DSet(dspXY, dspVals, lens[0], lens[1], null, null, null, false, false);
        FlatField tffld = new FlatField(new FunctionType(dspXY, range), set);
        try {
            tffld.setSamples(terrain.getFloats(false), false);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return tffld;
    }

    public void getStartPointsFromDomain(int trajForm, int skip, int zstart, int zskip, Gridded3DSet spatial_set, byte[][] color_values, float[][] startPts, byte[][] startClrs, float[][] flowValues, float ribbonWidthFac) throws VisADException {
        int manifoldDim = spatial_set.getManifoldDimension();
        int[] lens = spatial_set.getLengths();
        int lenX = lens[0];
        int lenY = lens[1];
        if (manifoldDim == 3) {
            int lenZ = lens[2];
            if (zskip <= 0) {
                zskip = 1;
            }
            this.getStartPointsFromDomain3D(trajForm, skip, zstart, zskip, spatial_set.getSamples(false), lenX, lenY, lenZ, color_values, startPts, startClrs, flowValues, ribbonWidthFac);
        } else if (manifoldDim == 2) {
            this.getStartPointsFromDomain2D(trajForm, skip, spatial_set.getSamples(false), lenX, lenY, color_values, startPts, startClrs, flowValues, ribbonWidthFac);
        }
    }

    public void getStartPointsFromDomain3D(int trajForm, int skip, int zstart, int skipZ, float[][] locs, int lenX, int lenY, int lenZ, byte[][] color_values, float[][] startPts, byte[][] startClrs, float[][] flowValues, float ribbonWidthFac) throws VisADException {
        int len2D = lenX * lenY;
        float[][] locs2D = new float[3][len2D];
        float[][] pts = new float[3][];
        int clrDim = startClrs.length;
        byte[][] clrs2D = new byte[clrDim][len2D];
        byte[][] clrs = new byte[clrDim][];
        int lenA = 0;
        for (int k = zstart; k < lenZ; k += skipZ) {
            System.arraycopy(locs[0], k * len2D, locs2D[0], 0, len2D);
            System.arraycopy(locs[1], k * len2D, locs2D[1], 0, len2D);
            System.arraycopy(locs[2], k * len2D, locs2D[2], 0, len2D);
            System.arraycopy(color_values[0], k * len2D, clrs2D[0], 0, len2D);
            System.arraycopy(color_values[1], k * len2D, clrs2D[1], 0, len2D);
            System.arraycopy(color_values[2], k * len2D, clrs2D[2], 0, len2D);
            if (clrDim == 4) {
                System.arraycopy(color_values[3], k * len2D, clrs2D[3], 0, len2D);
            }
            this.getStartPointsFromDomain2D(trajForm, skip, locs2D, lenX, lenY, clrs2D, pts, clrs, flowValues, ribbonWidthFac);
            int lenB = pts[0].length;
            float[][] tmpPts = new float[3][lenA + lenB];
            byte[][] tmpClrs = new byte[clrDim][lenA + lenB];
            if (lenA > 0) {
                System.arraycopy(startPts[0], 0, tmpPts[0], 0, lenA);
                System.arraycopy(startPts[1], 0, tmpPts[1], 0, lenA);
                System.arraycopy(startPts[2], 0, tmpPts[2], 0, lenA);
                System.arraycopy(startClrs[0], 0, tmpClrs[0], 0, lenA);
                System.arraycopy(startClrs[1], 0, tmpClrs[1], 0, lenA);
                System.arraycopy(startClrs[2], 0, tmpClrs[2], 0, lenA);
                if (clrDim == 4) {
                    System.arraycopy(startClrs[3], 0, tmpClrs[3], 0, lenA);
                }
            }
            System.arraycopy(pts[0], 0, tmpPts[0], lenA, lenB);
            System.arraycopy(pts[1], 0, tmpPts[1], lenA, lenB);
            System.arraycopy(pts[2], 0, tmpPts[2], lenA, lenB);
            System.arraycopy(clrs[0], 0, tmpClrs[0], lenA, lenB);
            System.arraycopy(clrs[1], 0, tmpClrs[1], lenA, lenB);
            System.arraycopy(clrs[2], 0, tmpClrs[2], lenA, lenB);
            if (clrDim == 4) {
                System.arraycopy(clrs[3], 0, tmpClrs[3], lenA, lenB);
            }
            startPts[0] = tmpPts[0];
            startPts[1] = tmpPts[1];
            startPts[2] = tmpPts[2];
            startClrs[0] = tmpClrs[0];
            startClrs[1] = tmpClrs[1];
            startClrs[2] = tmpClrs[2];
            if (clrDim == 4) {
                startClrs[3] = tmpClrs[3];
            }
            lenA = startPts[0].length;
        }
    }

    public void getStartPointsFromDomain2D(int trajForm, int skip, float[][] setLocs, int lenX, int lenY, byte[][] color_values, float[][] startPts, byte[][] startClrs, float[][] flowValues, float ribbonWidthFac) throws VisADException {
        int clrDim = color_values.length;
        int m = 0;
        if (doStartOffset) {
            m = this.cnt % 4;
            ++this.cnt;
        }
        int jA = 1 + o_j[m] * (skip / 2);
        int jB = lenY - skip;
        int iA = 1 + o_i[m] * (skip / 2);
        int iB = lenX - skip;
        int numJ = 1 + (jB - 1 - jA) / skip;
        int numI = 1 + (iB - 1 - iA) / skip;
        int num = numJ * numI;
        if (trajForm == 3) {
            num *= 2;
        }
        startPts[0] = new float[num];
        startPts[1] = new float[num];
        startPts[2] = new float[num];
        startClrs[0] = new byte[num];
        startClrs[1] = new byte[num];
        startClrs[2] = new byte[num];
        if (clrDim == 4) {
            startClrs[3] = new byte[num];
        }
        float[] norm = new float[]{0.0f, 0.0f, 1.0f};
        float[] traj = new float[3];
        float width = ribbonWidthFac * 0.006f;
        num = 0;
        for (int j = 1 + o_j[m] * (skip / 2); j < lenY - skip; j += skip) {
            for (int i = 1 + o_i[m] * (skip / 2); i < lenX - skip; i += skip) {
                int k = j * lenX + i;
                if (trajForm == 3) {
                    float u = flowValues[0][k];
                    float v = flowValues[1][k];
                    traj[0] = u;
                    traj[1] = v;
                    traj[2] = 0.0f;
                    float mag = (float)Math.sqrt(u * u + v * v);
                    traj[0] = traj[0] / mag;
                    traj[1] = traj[1] / mag;
                    float[] norm_x_traj = TrajectoryManager.AxB(norm, traj);
                    if (this.markGrid[k]) continue;
                    startPts[0][num] = width * norm_x_traj[0] + setLocs[0][k];
                    startPts[1][num] = width * norm_x_traj[1] + setLocs[1][k];
                    startPts[2][num] = width * norm_x_traj[2] + setLocs[2][k];
                    startClrs[0][num] = color_values[0][k];
                    startClrs[1][num] = color_values[1][k];
                    startClrs[2][num] = color_values[2][k];
                    if (clrDim == 4) {
                        startClrs[3][num] = color_values[3][k];
                    }
                    startPts[0][++num] = -width * norm_x_traj[0] + setLocs[0][k];
                    startPts[1][num] = -width * norm_x_traj[1] + setLocs[1][k];
                    startPts[2][num] = -width * norm_x_traj[2] + setLocs[2][k];
                    startClrs[0][num] = color_values[0][k];
                    startClrs[1][num] = color_values[1][k];
                    startClrs[2][num] = color_values[2][k];
                    if (clrDim == 4) {
                        startClrs[3][num] = color_values[3][k];
                    }
                    ++num;
                    continue;
                }
                if (this.markGrid[k]) continue;
                startPts[0][num] = setLocs[0][k];
                startPts[1][num] = setLocs[1][k];
                startPts[2][num] = setLocs[2][k];
                startClrs[0][num] = color_values[0][k];
                startClrs[1][num] = color_values[1][k];
                startClrs[2][num] = color_values[2][k];
                if (clrDim == 4) {
                    startClrs[3][num] = color_values[3][k];
                }
                ++num;
            }
        }
    }

    public static float[][] convertFlowUnit(float[][] values, Unit[] units) throws VisADException {
        Unit meterPerSecond = CommonUnit.meterPerSecond;
        float[] valsX = values[0];
        if (Unit.canConvert(units[0], meterPerSecond)) {
            valsX = meterPerSecond.toThis(values[0], units[0]);
        }
        float[] valsY = values[1];
        if (Unit.canConvert(units[1], meterPerSecond)) {
            valsY = meterPerSecond.toThis(values[1], units[1]);
        }
        float[] valsZ = values[2];
        if (Unit.canConvert(units[2], meterPerSecond)) {
            valsZ = meterPerSecond.toThis(values[2], units[2]);
        }
        return new float[][]{valsX, valsY, valsZ};
    }

    public static float[][] smooth(float[][] values0, float[][] values1, float[][] values2, TrajectoryParams.SmoothParams smoothParams) {
        if (smoothParams.equals((Object)TrajectoryParams.SmoothParams.NONE)) {
            return values1;
        }
        float w0 = smoothParams.w0;
        float w1 = smoothParams.w1;
        float w2 = smoothParams.w2;
        int numPts = values0[0].length;
        float[][] new_values = new float[3][numPts];
        for (int k = 0; k < numPts; ++k) {
            new_values[0][k] = w0 * values0[0][k] + w1 * values1[0][k] + w2 * values2[0][k];
            new_values[1][k] = w0 * values0[1][k] + w1 * values1[1][k] + w2 * values2[1][k];
            new_values[2][k] = w0 * values0[2][k] + w1 * values1[2][k] + w2 * values2[2][k];
        }
        return new_values;
    }

    public static float[][] mean(float[][] values0, float[][] values1) {
        int numPts = values0[0].length;
        float[][] meanValues = new float[3][numPts];
        for (int k = 0; k < numPts; ++k) {
            meanValues[0][k] = (values0[0][k] + values1[0][k]) / 2.0f;
            meanValues[1][k] = (values0[1][k] + values1[1][k]) / 2.0f;
            meanValues[2][k] = (values0[2][k] + values1[2][k]) / 2.0f;
        }
        return meanValues;
    }

    public static float[] mean(float[] values0, float[] values1) {
        int numPts = values0.length;
        float[] meanValues = new float[numPts];
        for (int k = 0; k < numPts; ++k) {
            meanValues[k] = (values0[k] + values1[k]) / 2.0f;
        }
        return meanValues;
    }

    public void setListener(ProjectionControl pCntrl, ControlListener listener, FlowControl flowCntrl) {
        if (scaleChangeListeners.containsKey(flowCntrl)) {
            ControlListener value = scaleChangeListeners.get(flowCntrl);
            pCntrl.removeControlListener(value);
            scaleChangeListeners.put(flowCntrl, listener);
        } else {
            scaleChangeListeners.put(flowCntrl, listener);
        }
        pCntrl.addControlListener(listener);
    }

    public static double[] getTimeSteps(Gridded1DSet timeSet) throws VisADException {
        double[] timePts = timeSet instanceof Gridded1DDoubleSet ? timeSet.getDoubles()[0] : Set.floatToDouble(timeSet.getSamples())[0];
        double[] timeSteps = new double[timePts.length];
        Unit[] setUnits = timeSet.getSetUnits();
        timePts = CommonUnit.secondsSinceTheEpoch.toThis(timePts, setUnits[0]);
        for (int t = 0; t < timePts.length - 1; ++t) {
            timeSteps[t] = timePts[t + 1] - timePts[t];
        }
        timeSteps[timePts.length - 1] = timeSteps[timePts.length - 2];
        return timeSteps;
    }

    public static double[] getTimes(Gridded1DSet timeSet) throws VisADException {
        double[] timePts = timeSet instanceof Gridded1DDoubleSet ? timeSet.getDoubles()[0] : Set.floatToDouble(timeSet.getSamples())[0];
        Unit[] setUnits = timeSet.getSetUnits();
        timePts = CommonUnit.secondsSinceTheEpoch.toThis(timePts, setUnits[0]);
        return timePts;
    }

    public static VisADGeometryArray scaleGeometry(VisADGeometryArray array, ArrayList<float[]> anchors, float scale) {
        VisADGeometryArray scldArray = null;
        int nShapes = anchors.size();
        int numVertsPerShape = array.vertexCount / nShapes;
        if (array instanceof VisADTriangleStripArray) {
            scldArray = new VisADTriangleStripArray();
            scldArray.coordinates = new float[3 * array.vertexCount];
            scldArray.colors = array.colors;
            scldArray.normals = array.normals;
            scldArray.vertexCount = array.vertexCount;
            scldArray.stripVertexCounts = ((VisADTriangleStripArray)array).stripVertexCounts;
        } else {
            scldArray = new VisADTriangleArray();
            scldArray.coordinates = new float[3 * array.vertexCount];
            scldArray.colors = array.colors;
            scldArray.normals = array.normals;
            scldArray.vertexCount = array.vertexCount;
        }
        for (int k = 0; k < nShapes; ++k) {
            float[] ancrPt = anchors.get(k);
            for (int t = 0; t < numVertsPerShape; ++t) {
                int idx = k * numVertsPerShape * 3 + 3 * t;
                float x0 = array.coordinates[idx];
                float y0 = array.coordinates[idx + 1];
                float z0 = array.coordinates[idx + 2];
                float x1 = (x0 - ancrPt[0]) * scale;
                float y1 = (y0 - ancrPt[1]) * scale;
                float z1 = (z0 - ancrPt[2]) * scale;
                scldArray.coordinates[idx] = x1 + ancrPt[0];
                scldArray.coordinates[idx + 1] = y1 + ancrPt[1];
                scldArray.coordinates[idx + 2] = z1 + ancrPt[2];
            }
        }
        return scldArray;
    }

    public static float[] AxB(float[] A, float[] B) {
        return TrajectoryManager.AxB(A, B, true);
    }

    public static float[] AxB(float[] A, float[] B, boolean unit) {
        float[] axb = new float[]{A[1] * B[2] - A[2] * B[1], -(A[0] * B[2] - A[2] * B[0]), A[0] * B[1] - A[1] * B[0]};
        if (unit) {
            float mag = (float)Math.sqrt(axb[0] * axb[0] + axb[1] * axb[1] + axb[2] * axb[2]);
            axb[0] = axb[0] / mag;
            axb[1] = axb[1] / mag;
            axb[2] = axb[2] / mag;
        }
        return axb;
    }

    public static float AdotB(float[] A, float[] B) {
        float ab = A[0] * B[0] + A[1] * B[1] + A[2] * B[2];
        return ab;
    }

    public static float vecMag(float[] vec) {
        float x = vec[0];
        float y = vec[1];
        float z = vec[2];
        return (float)Math.sqrt(x * x + y * y + z * z);
    }

    public static double vecMag(double[] vec) {
        double x = vec[0];
        double y = vec[1];
        double z = vec[2];
        return Math.sqrt(x * x + y * y + z * z);
    }

    public static double[] getPlaneCoeffsFromNormalAndPoint(double[] normal, double[] pt) {
        double[] coeffs = new double[4];
        double a = normal[0];
        double b = normal[1];
        double c = normal[2];
        double d = -(a * pt[0] + b * pt[1] + c * pt[2]);
        coeffs[0] = a;
        coeffs[1] = b;
        coeffs[2] = c;
        coeffs[3] = d;
        return coeffs;
    }

    public static double[] getBisectPlaneNormal(float[] uvecA, float[] uvecB) {
        if (Util.isApproximatelyEqual(uvecA[0], uvecB[0]) && Util.isApproximatelyEqual(uvecA[1], uvecB[1]) && Util.isApproximatelyEqual(uvecA[2], uvecB[2])) {
            return new double[]{uvecA[0], uvecA[1], uvecA[2]};
        }
        float[] uA = new float[]{-uvecA[0], -uvecA[1], -uvecA[2]};
        float[] uAxuB = TrajectoryManager.AxB(uA, uvecB);
        float delx = uvecB[0] - uA[0];
        float dely = uvecB[1] - uA[1];
        float delz = uvecB[2] - uA[2];
        float xp = uA[0] + (delx /= 2.0f);
        float yp = uA[1] + (dely /= 2.0f);
        float zp = uA[2] + (delz /= 2.0f);
        float mag = (float)Math.sqrt(xp * xp + yp * yp + zp * zp);
        float[] planeNormal = TrajectoryManager.AxB(uAxuB, new float[]{xp /= mag, yp /= mag, zp /= mag});
        return new double[]{planeNormal[0], planeNormal[1], planeNormal[2]};
    }

    public static double[] getLinePlaneIntersect(double[] planeCoeffs, double[] uVecLine, double[] linePt) {
        return TrajectoryManager.getLinePlaneIntersect(planeCoeffs[0], planeCoeffs[1], planeCoeffs[2], planeCoeffs[3], uVecLine, linePt);
    }

    public static double[] getLinePlaneIntersect(double a, double b, double c, double d, double[] uVecLine, double[] linePt) {
        double[] P = new double[3];
        double t = -(d + a * linePt[0] + b * linePt[1] + c * linePt[2]) / (a * uVecLine[0] + b * uVecLine[1] + c * uVecLine[2]);
        P[0] = linePt[0] + t * uVecLine[0];
        P[1] = linePt[1] + t * uVecLine[1];
        P[2] = linePt[2] + t * uVecLine[2];
        return P;
    }

    public static double[] getRotatedVecInPlane(double[] T, double[] S, double[] P, double[] V, double theta, double[] rotV) {
        if (rotV == null) {
            rotV = new double[3];
        }
        if (P == null) {
            P = new double[]{0.0, 0.0, 0.0};
        }
        double s = V[0] * Math.cos(theta) - V[1] * Math.sin(theta);
        double t = V[0] * Math.sin(theta) + V[1] * Math.cos(theta);
        double x = P[0] + s * S[0] + t * T[0];
        double y = P[1] + s * S[1] + t * T[1];
        double z = P[2] + s * S[2] + t * T[2];
        rotV[0] = x;
        rotV[1] = y;
        rotV[2] = z;
        return rotV;
    }

    public VisADGeometryArray makeGeometry() {
        VisADLineArray array = new VisADLineArray();
        float[] newCoords = new float[this.coordCnt];
        byte[] newColors = new byte[this.colorCnt];
        System.arraycopy(this.coordinates, 0, newCoords, 0, newCoords.length);
        System.arraycopy(this.colors, 0, newColors, 0, newColors.length);
        array.coordinates = newCoords;
        array.colors = newColors;
        array.vertexCount = this.vertCnt;
        return array;
    }

    public VisADGeometryArray makeFixedWidthRibbon() {
        VisADTriangleArray array = new VisADTriangleArray();
        int ntrajs = this.trajectories.size();
        int num = this.totNpairs * 6;
        float[] newCoords = new float[num * 3 * 2];
        byte[] newColors = new byte[num * this.clrDim * 2];
        float[] newNormals = new float[num * 3 * 2];
        float[] uvecPath = new float[3];
        float[] ptA = new float[3];
        float[] ptB = new float[3];
        float[] ptC = new float[3];
        float[] ptD = new float[3];
        float[] ptAA = new float[3];
        float[] ptBB = new float[3];
        float[] ptCC = new float[3];
        float[] ptDD = new float[3];
        float[] norm = new float[]{0.0f, 0.0f, 1.0f};
        int numVert = 0;
        int a0 = -1;
        int a1 = -1;
        float width = this.ribbonWidthFac * 0.006f;
        for (int t = 0; t < ntrajs; ++t) {
            Trajectory traj = this.trajectories.get(t);
            for (int k = 0; k < traj.npairs; ++k) {
                byte b1;
                byte g1;
                byte r1;
                byte b0;
                byte g0;
                byte r0;
                int i = traj.indexes[k];
                int ci = 2 * this.clrDim * i / 6;
                float x0 = this.coordinates[i];
                float y0 = this.coordinates[i + 1];
                float z0 = this.coordinates[i + 2];
                float x1 = this.coordinates[i + 3];
                float y1 = this.coordinates[i + 4];
                float z1 = this.coordinates[i + 5];
                if (this.clrDim == 3) {
                    r0 = this.colors[ci];
                    g0 = this.colors[ci + 1];
                    b0 = this.colors[ci + 2];
                    r1 = this.colors[ci + 3];
                    g1 = this.colors[ci + 4];
                    b1 = this.colors[ci + 5];
                } else {
                    r0 = this.colors[ci];
                    g0 = this.colors[ci + 1];
                    b0 = this.colors[ci + 2];
                    a0 = this.colors[ci + 3];
                    r1 = this.colors[ci + 4];
                    g1 = this.colors[ci + 5];
                    b1 = this.colors[ci + 6];
                    a1 = this.colors[ci + 7];
                }
                float mag = (x1 - x0) * (x1 - x0) + (y1 - y0) * (y1 - y0) + (z1 - z0) * (z1 - z0);
                mag = (float)Math.sqrt(mag);
                uvecPath[0] = (x1 - x0) / mag;
                uvecPath[1] = (y1 - y0) / mag;
                uvecPath[2] = (z1 - z0) / mag;
                float[] norm_x_trj = TrajectoryManager.AxB(norm, uvecPath);
                float[] trj_x_norm_x_trj = TrajectoryManager.AxB(uvecPath, norm_x_trj);
                if (k == 0) {
                    if (traj.lastPtC == null) {
                        ptA[0] = width * norm_x_trj[0] + x0;
                        ptA[1] = width * norm_x_trj[1] + y0;
                        ptA[2] = width * norm_x_trj[2] + z0;
                        ptB[0] = -width * norm_x_trj[0] + x0;
                        ptB[1] = -width * norm_x_trj[1] + y0;
                        ptB[2] = -width * norm_x_trj[2] + z0;
                        ptAA[0] = width * trj_x_norm_x_trj[0] + x0;
                        ptAA[1] = width * trj_x_norm_x_trj[1] + y0;
                        ptAA[2] = width * trj_x_norm_x_trj[2] + z0;
                        ptBB[0] = -width * trj_x_norm_x_trj[0] + x0;
                        ptBB[1] = -width * trj_x_norm_x_trj[1] + y0;
                        ptBB[2] = -width * trj_x_norm_x_trj[2] + z0;
                    } else {
                        ptA[0] = traj.lastPtD[0];
                        ptA[1] = traj.lastPtD[1];
                        ptA[2] = traj.lastPtD[2];
                        ptB[0] = traj.lastPtC[0];
                        ptB[1] = traj.lastPtC[1];
                        ptB[2] = traj.lastPtC[2];
                        ptAA[0] = traj.lastPtDD[0];
                        ptAA[1] = traj.lastPtDD[1];
                        ptAA[2] = traj.lastPtDD[2];
                        ptBB[0] = traj.lastPtCC[0];
                        ptBB[1] = traj.lastPtCC[1];
                        ptBB[2] = traj.lastPtCC[2];
                    }
                } else {
                    ptA[0] = ptD[0];
                    ptA[1] = ptD[1];
                    ptA[2] = ptD[2];
                    ptB[0] = ptC[0];
                    ptB[1] = ptC[1];
                    ptB[2] = ptC[2];
                    ptAA[0] = ptDD[0];
                    ptAA[1] = ptDD[1];
                    ptAA[2] = ptDD[2];
                    ptBB[0] = ptCC[0];
                    ptBB[1] = ptCC[1];
                    ptBB[2] = ptCC[2];
                }
                ptD[0] = width * norm_x_trj[0] + x1;
                ptD[1] = width * norm_x_trj[1] + y1;
                ptD[2] = width * norm_x_trj[2] + z1;
                ptC[0] = -width * norm_x_trj[0] + x1;
                ptC[1] = -width * norm_x_trj[1] + y1;
                ptC[2] = -width * norm_x_trj[2] + z1;
                ptDD[0] = width * trj_x_norm_x_trj[0] + x1;
                ptDD[1] = width * trj_x_norm_x_trj[1] + y1;
                ptDD[2] = width * trj_x_norm_x_trj[2] + z1;
                ptCC[0] = -width * trj_x_norm_x_trj[0] + x1;
                ptCC[1] = -width * trj_x_norm_x_trj[1] + y1;
                ptCC[2] = -width * trj_x_norm_x_trj[2] + z1;
                if (traj.lastPtD == null) {
                    traj.lastPtC = new float[]{ptC[0], ptC[1], ptC[2]};
                    traj.lastPtD = new float[]{ptD[0], ptD[1], ptD[2]};
                    traj.lastPtCC = new float[]{ptCC[0], ptCC[1], ptCC[2]};
                    traj.lastPtDD = new float[]{ptDD[0], ptDD[1], ptDD[2]};
                } else {
                    traj.lastPtC[0] = ptC[0];
                    traj.lastPtC[1] = ptC[1];
                    traj.lastPtC[2] = ptC[2];
                    traj.lastPtD[0] = ptD[0];
                    traj.lastPtD[1] = ptD[1];
                    traj.lastPtD[2] = ptD[2];
                    traj.lastPtCC[0] = ptCC[0];
                    traj.lastPtCC[1] = ptCC[1];
                    traj.lastPtCC[2] = ptCC[2];
                    traj.lastPtDD[0] = ptDD[0];
                    traj.lastPtDD[1] = ptDD[1];
                    traj.lastPtDD[2] = ptDD[2];
                }
                int idx = numVert * 3;
                int cidx = numVert * this.clrDim;
                newCoords[idx] = ptA[0];
                newCoords[idx + 1] = ptA[1];
                newCoords[idx + 2] = ptA[2];
                newColors[cidx] = r0;
                newColors[cidx + 1] = g0;
                newColors[cidx + 2] = b0;
                if (this.clrDim == 4) {
                    newColors[cidx + 3] = a0;
                }
                newNormals[idx] = 0.0f;
                newNormals[idx + 1] = 0.0f;
                newNormals[idx + 2] = 1.0f;
                idx = ++numVert * 3;
                cidx = numVert * this.clrDim;
                newCoords[idx] = ptB[0];
                newCoords[idx + 1] = ptB[1];
                newCoords[idx + 2] = ptB[2];
                newColors[cidx] = r0;
                newColors[cidx + 1] = g0;
                newColors[cidx + 2] = b0;
                if (this.clrDim == 4) {
                    newColors[cidx + 3] = a0;
                }
                newNormals[idx] = 0.0f;
                newNormals[idx + 1] = 0.0f;
                newNormals[idx + 2] = 1.0f;
                idx = ++numVert * 3;
                cidx = numVert * this.clrDim;
                newCoords[idx] = ptC[0];
                newCoords[idx + 1] = ptC[1];
                newCoords[idx + 2] = ptC[2];
                newColors[cidx] = r1;
                newColors[cidx + 1] = g1;
                newColors[cidx + 2] = b1;
                if (this.clrDim == 4) {
                    newColors[cidx + 3] = a1;
                }
                newNormals[idx] = 0.0f;
                newNormals[idx + 1] = 0.0f;
                newNormals[idx + 2] = 1.0f;
                idx = ++numVert * 3;
                cidx = numVert * this.clrDim;
                newCoords[idx] = ptAA[0];
                newCoords[idx + 1] = ptAA[1];
                newCoords[idx + 2] = ptAA[2];
                newColors[cidx] = r0;
                newColors[cidx + 1] = g0;
                newColors[cidx + 2] = b0;
                if (this.clrDim == 4) {
                    newColors[cidx + 3] = a0;
                }
                newNormals[idx] = norm_x_trj[0];
                newNormals[idx + 1] = norm_x_trj[1];
                newNormals[idx + 2] = norm_x_trj[2];
                idx = ++numVert * 3;
                cidx = numVert * this.clrDim;
                newCoords[idx] = ptBB[0];
                newCoords[idx + 1] = ptBB[1];
                newCoords[idx + 2] = ptBB[2];
                newColors[cidx] = r0;
                newColors[cidx + 1] = g0;
                newColors[cidx + 2] = b0;
                if (this.clrDim == 4) {
                    newColors[cidx + 3] = a0;
                }
                newNormals[idx] = norm_x_trj[0];
                newNormals[idx + 1] = norm_x_trj[1];
                newNormals[idx + 2] = norm_x_trj[2];
                idx = ++numVert * 3;
                cidx = numVert * this.clrDim;
                newCoords[idx] = ptCC[0];
                newCoords[idx + 1] = ptCC[1];
                newCoords[idx + 2] = ptCC[2];
                newColors[cidx] = r1;
                newColors[cidx + 1] = g1;
                newColors[cidx + 2] = b1;
                if (this.clrDim == 4) {
                    newColors[cidx + 3] = a1;
                }
                newNormals[idx] = norm_x_trj[0];
                newNormals[idx + 1] = norm_x_trj[1];
                newNormals[idx + 2] = norm_x_trj[2];
                idx = ++numVert * 3;
                cidx = numVert * this.clrDim;
                newCoords[idx] = ptC[0];
                newCoords[idx + 1] = ptC[1];
                newCoords[idx + 2] = ptC[2];
                newColors[cidx] = r1;
                newColors[cidx + 1] = g1;
                newColors[cidx + 2] = b1;
                if (this.clrDim == 4) {
                    newColors[cidx + 3] = a1;
                }
                newNormals[idx] = 0.0f;
                newNormals[idx + 1] = 0.0f;
                newNormals[idx + 2] = 1.0f;
                idx = ++numVert * 3;
                cidx = numVert * this.clrDim;
                newCoords[idx] = ptA[0];
                newCoords[idx + 1] = ptA[1];
                newCoords[idx + 2] = ptA[2];
                newColors[cidx] = r0;
                newColors[cidx + 1] = g0;
                newColors[cidx + 2] = b0;
                if (this.clrDim == 4) {
                    newColors[cidx + 3] = a0;
                }
                newNormals[idx] = 0.0f;
                newNormals[idx + 1] = 0.0f;
                newNormals[idx + 2] = 1.0f;
                idx = ++numVert * 3;
                cidx = numVert * this.clrDim;
                newCoords[idx] = ptD[0];
                newCoords[idx + 1] = ptD[1];
                newCoords[idx + 2] = ptD[2];
                newColors[cidx] = r1;
                newColors[cidx + 1] = g1;
                newColors[cidx + 2] = b1;
                if (this.clrDim == 4) {
                    newColors[cidx + 3] = a1;
                }
                newNormals[idx] = 0.0f;
                newNormals[idx + 1] = 0.0f;
                newNormals[idx + 2] = 1.0f;
                idx = ++numVert * 3;
                cidx = numVert * this.clrDim;
                newCoords[idx] = ptCC[0];
                newCoords[idx + 1] = ptCC[1];
                newCoords[idx + 2] = ptCC[2];
                newColors[cidx] = r1;
                newColors[cidx + 1] = g1;
                newColors[cidx + 2] = b1;
                if (this.clrDim == 4) {
                    newColors[cidx + 3] = a1;
                }
                newNormals[idx] = norm_x_trj[0];
                newNormals[idx + 1] = norm_x_trj[1];
                newNormals[idx + 2] = norm_x_trj[2];
                idx = ++numVert * 3;
                cidx = numVert * this.clrDim;
                newCoords[idx] = ptAA[0];
                newCoords[idx + 1] = ptAA[1];
                newCoords[idx + 2] = ptAA[2];
                newColors[cidx] = r0;
                newColors[cidx + 1] = g0;
                newColors[cidx + 2] = b0;
                if (this.clrDim == 4) {
                    newColors[cidx + 3] = a0;
                }
                newNormals[idx] = norm_x_trj[0];
                newNormals[idx + 1] = norm_x_trj[1];
                newNormals[idx + 2] = norm_x_trj[2];
                idx = ++numVert * 3;
                cidx = numVert * this.clrDim;
                newCoords[idx] = ptDD[0];
                newCoords[idx + 1] = ptDD[1];
                newCoords[idx + 2] = ptDD[2];
                newColors[cidx] = r1;
                newColors[cidx + 1] = g1;
                newColors[cidx + 2] = b1;
                if (this.clrDim == 4) {
                    newColors[cidx + 3] = a1;
                }
                newNormals[idx] = norm_x_trj[0];
                newNormals[idx + 1] = norm_x_trj[1];
                newNormals[idx + 2] = norm_x_trj[2];
                ++numVert;
            }
        }
        array.coordinates = newCoords;
        array.normals = newNormals;
        array.colors = newColors;
        array.vertexCount = numVert;
        return array;
    }

    public VisADGeometryArray[] makeCylinder() {
        VisADTriangleStripArray array = new VisADTriangleStripArray();
        VisADTriangleStripArray elbowArray = new VisADTriangleStripArray();
        VisADTriangleArray coneArray = new VisADTriangleArray();
        int ntrajs = this.trajectories.size();
        int numSides = 20;
        int numv = this.totNpairs * (numSides + 1) * 2;
        float[] coords = new float[numv * 3];
        byte[] newColors = new byte[numv * this.clrDim];
        float[] normals = new float[numv * 3];
        int[] strips = new int[this.totNpairs];
        float[] coneCoords = new float[ntrajs * (numSides + 1) * 3 * 3];
        byte[] coneColors = new byte[ntrajs * (numSides + 1) * 3 * this.clrDim];
        float[] coneNormals = new float[ntrajs * (numSides + 1) * 3 * 3];
        float[] elbowCoords = new float[numv * 3];
        byte[] elbowColors = new byte[numv * this.clrDim];
        float[] elbowNormals = new float[numv * 3];
        int[] elbowStrips = new int[this.totNpairs];
        float[] uvecPath = new float[3];
        float[] uvecPathNext = new float[3];
        byte[][] clr0 = new byte[this.clrDim][1];
        byte[][] clr1 = new byte[this.clrDim][1];
        float[] pt0 = new float[3];
        float[] pt1 = new float[3];
        float[][] basePts = new float[3][numSides + 1];
        int[] idx = new int[]{0};
        int[] elbowIdx = new int[]{0};
        int strpCnt = 0;
        int[] elbowStrpCnt = new int[]{0};
        int[] coneIdx = new int[]{0};
        int a0 = -1;
        int a1 = -1;
        for (int t = 0; t < ntrajs; ++t) {
            Trajectory traj = this.trajectories.get(t);
            for (int k = 0; k < traj.npairs; ++k) {
                byte b1;
                byte g1;
                byte r1;
                byte b0;
                byte g0;
                byte r0;
                int i = traj.indexes[k];
                int ci = 2 * this.clrDim * i / 6;
                float x0 = this.coordinates[i];
                float y0 = this.coordinates[i + 1];
                float z0 = this.coordinates[i + 2];
                float x1 = this.coordinates[i + 3];
                float y1 = this.coordinates[i + 4];
                float z1 = this.coordinates[i + 5];
                float mag = (x1 - x0) * (x1 - x0) + (y1 - y0) * (y1 - y0) + (z1 - z0) * (z1 - z0);
                mag = (float)Math.sqrt(mag);
                uvecPath[0] = (x1 - x0) / mag;
                uvecPath[1] = (y1 - y0) / mag;
                uvecPath[2] = (z1 - z0) / mag;
                if (k < traj.npairs - 1) {
                    i = traj.indexes[k + 1];
                    float x2 = this.coordinates[i];
                    float y2 = this.coordinates[i + 1];
                    float z2 = this.coordinates[i + 2];
                    float x3 = this.coordinates[i + 3];
                    float y3 = this.coordinates[i + 4];
                    float z3 = this.coordinates[i + 5];
                    mag = (x3 - x2) * (x3 - x2) + (y3 - y2) * (y3 - y2) + (z3 - z2) * (z3 - z2);
                    mag = (float)Math.sqrt(mag);
                    uvecPathNext[0] = (x3 - x2) / mag;
                    uvecPathNext[1] = (y3 - y2) / mag;
                    uvecPathNext[2] = (z3 - z2) / mag;
                } else {
                    uvecPathNext[0] = uvecPath[0];
                    uvecPathNext[1] = uvecPath[1];
                    uvecPathNext[2] = uvecPath[2];
                }
                if (this.clrDim == 3) {
                    r0 = this.colors[ci];
                    g0 = this.colors[ci + 1];
                    b0 = this.colors[ci + 2];
                    r1 = this.colors[ci + 3];
                    g1 = this.colors[ci + 4];
                    b1 = this.colors[ci + 5];
                } else {
                    r0 = this.colors[ci];
                    g0 = this.colors[ci + 1];
                    b0 = this.colors[ci + 2];
                    a0 = this.colors[ci + 3];
                    r1 = this.colors[ci + 4];
                    g1 = this.colors[ci + 5];
                    b1 = this.colors[ci + 6];
                    a1 = this.colors[ci + 7];
                }
                pt0[0] = x0;
                pt0[1] = y0;
                pt0[2] = z0;
                pt1[0] = x1;
                pt1[1] = y1;
                pt1[2] = z1;
                clr0[0][0] = r0;
                clr0[1][0] = g0;
                clr0[2][0] = b0;
                if (this.clrDim == 4) {
                    clr0[3][0] = a0;
                }
                clr1[0][0] = r1;
                clr1[1][0] = g1;
                clr1[2][0] = b1;
                if (this.clrDim == 4) {
                    clr1[3][0] = a1;
                }
                traj.makeCylinderStrip(k, uvecPath, uvecPathNext, pt0, pt1, clr0, clr1, this.cylWidth, numSides + 1, coords, newColors, normals, elbowCoords, elbowColors, elbowNormals, idx, elbowIdx, elbowStrips, elbowStrpCnt);
                strips[strpCnt++] = (numSides + 1) * 2;
            }
            if (traj.npairs <= 0) continue;
            float vFac = (float)((double)this.cylWidth / 0.01);
            float[] vertex = new float[]{pt1[0] + uvecPath[0] * 0.006f * vFac, pt1[1] + uvecPath[1] * 0.006f * vFac, pt1[2] + uvecPath[2] * 0.006f * vFac};
            this.makeCone(traj.last_circleXYZ, vertex, clr0, coneCoords, coneColors, coneNormals, coneIdx);
        }
        array.coordinates = coords;
        array.normals = normals;
        array.colors = newColors;
        array.vertexCount = idx[0];
        array.stripVertexCounts = strips;
        coneArray.coordinates = coneCoords;
        coneArray.normals = coneNormals;
        coneArray.colors = coneColors;
        coneArray.vertexCount = coneIdx[0];
        if (elbowIdx[0] < elbowCoords.length / 3) {
            float[] tmp = new float[elbowIdx[0] * 3];
            System.arraycopy(elbowCoords, 0, tmp, 0, tmp.length);
            elbowCoords = tmp;
            tmp = new float[elbowIdx[0] * 3];
            System.arraycopy(elbowNormals, 0, tmp, 0, tmp.length);
            elbowNormals = tmp;
            byte[] btmp = new byte[elbowIdx[0] * this.clrDim];
            System.arraycopy(elbowColors, 0, btmp, 0, btmp.length);
            elbowColors = btmp;
        }
        if (elbowStrpCnt[0] < elbowStrips.length) {
            int[] tmp = new int[elbowStrpCnt[0]];
            System.arraycopy(elbowStrips, 0, tmp, 0, tmp.length);
            elbowStrips = tmp;
        }
        elbowArray.coordinates = elbowCoords;
        elbowArray.normals = elbowNormals;
        elbowArray.colors = elbowColors;
        elbowArray.vertexCount = elbowCoords.length / 3;
        elbowArray.stripVertexCounts = elbowStrips;
        return new VisADGeometryArray[]{array, coneArray, elbowArray};
    }

    public void makeCone(float[][] basePts, float[] vertex, byte[][] color, float[] coords, byte[] colors, float[] normals, int[] vertCnt) {
        int nPts = basePts[0].length;
        float[] ptA = new float[3];
        float[] ptB = new float[3];
        float[] AV = new float[3];
        float[] BV = new float[3];
        int vcnt = vertCnt[0];
        int idx = 3 * vcnt;
        int cidx = this.clrDim * vcnt;
        for (int k = 0; k < nPts; ++k) {
            int ia = k;
            int ib = k == nPts - 1 ? 0 : k + 1;
            ptA[0] = basePts[0][ia];
            ptA[1] = basePts[1][ia];
            ptA[2] = basePts[2][ia];
            ptB[0] = basePts[0][ib];
            ptB[1] = basePts[1][ib];
            ptB[2] = basePts[2][ib];
            AV[0] = ptA[0] - vertex[0];
            AV[1] = ptA[1] - vertex[1];
            AV[2] = ptA[2] - vertex[2];
            BV[0] = ptB[0] - vertex[0];
            BV[1] = ptB[1] - vertex[1];
            BV[2] = ptB[2] - vertex[2];
            float[] norm = TrajectoryManager.AxB(AV, BV);
            float mag = (float)Math.sqrt(norm[0] * norm[0] + norm[1] * norm[1] + norm[2] * norm[2]);
            norm[0] = norm[0] / mag;
            norm[1] = norm[1] / mag;
            norm[2] = norm[2] / mag;
            normals[idx] = norm[0];
            coords[idx++] = ptA[0];
            normals[idx] = norm[1];
            coords[idx++] = ptA[1];
            normals[idx] = norm[2];
            coords[idx++] = ptA[2];
            colors[cidx++] = color[0][0];
            colors[cidx++] = color[1][0];
            colors[cidx++] = color[2][0];
            if (this.clrDim == 4) {
                colors[cidx++] = color[3][0];
            }
            ++vcnt;
            normals[idx] = norm[0];
            coords[idx++] = ptB[0];
            normals[idx] = norm[1];
            coords[idx++] = ptB[1];
            normals[idx] = norm[2];
            coords[idx++] = ptB[2];
            colors[cidx++] = color[0][0];
            colors[cidx++] = color[1][0];
            colors[cidx++] = color[2][0];
            if (this.clrDim == 4) {
                colors[cidx++] = color[3][0];
            }
            ++vcnt;
            normals[idx] = norm[0];
            coords[idx++] = vertex[0];
            normals[idx] = norm[1];
            coords[idx++] = vertex[1];
            normals[idx] = norm[2];
            coords[idx++] = vertex[2];
            colors[cidx++] = color[0][0];
            colors[cidx++] = color[1][0];
            colors[cidx++] = color[2][0];
            if (this.clrDim == 4) {
                colors[cidx++] = color[3][0];
            }
            ++vcnt;
        }
        vertCnt[0] = vcnt;
    }

    public VisADGeometryArray makeDeformableRibbon() {
        VisADTriangleArray array = new VisADTriangleArray();
        int ntrajs = this.trajectories.size();
        int ntris = this.totNpairs / 2 * 2;
        int num = ntris * 3;
        float[] newCoords = new float[num * 3];
        Arrays.fill(newCoords, Float.NaN);
        byte[] newColors = new byte[num * this.clrDim];
        float[] newNormals = new float[num * 3];
        float[] A0 = new float[3];
        float[] A1 = new float[3];
        float[] B0 = new float[3];
        float[] B1 = new float[3];
        int aa0 = -1;
        int aa1 = -1;
        int ba0 = -1;
        int ba1 = -1;
        int numVerts = 0;
        for (int k = 0; k < ntrajs / 2; ++k) {
            int t = k * 2;
            Trajectory trajA = this.trajectories.get(t);
            Trajectory trajB = this.trajectories.get(t + 1);
            int npairs = Math.min(trajA.npairs, trajB.npairs);
            for (int n = 0; n < npairs; ++n) {
                byte bb1;
                byte bg1;
                byte br1;
                byte bb0;
                byte bg0;
                byte br0;
                byte ab1;
                byte ag1;
                byte ar1;
                byte ab0;
                byte ag0;
                byte ar0;
                int ia = trajA.indexes[n];
                int ib = trajB.indexes[n];
                int cia = 2 * this.clrDim * ia / 6;
                int cib = 2 * this.clrDim * ib / 6;
                A0[0] = this.coordinates[ia];
                A0[1] = this.coordinates[ia + 1];
                A0[2] = this.coordinates[ia + 2];
                A1[0] = this.coordinates[ia + 3];
                A1[1] = this.coordinates[ia + 4];
                A1[2] = this.coordinates[ia + 5];
                B0[0] = this.coordinates[ib];
                B0[1] = this.coordinates[ib + 1];
                B0[2] = this.coordinates[ib + 2];
                B1[0] = this.coordinates[ib + 3];
                B1[1] = this.coordinates[ib + 4];
                B1[2] = this.coordinates[ib + 5];
                if (this.clrDim == 3) {
                    ar0 = this.colors[cia];
                    ag0 = this.colors[cia + 1];
                    ab0 = this.colors[cia + 2];
                    ar1 = this.colors[cia + 3];
                    ag1 = this.colors[cia + 4];
                    ab1 = this.colors[cia + 5];
                } else {
                    ar0 = this.colors[cia];
                    ag0 = this.colors[cia + 1];
                    ab0 = this.colors[cia + 2];
                    aa0 = this.colors[cia + 3];
                    ar1 = this.colors[cia + 4];
                    ag1 = this.colors[cia + 5];
                    ab1 = this.colors[cia + 6];
                    aa1 = this.colors[cia + 7];
                }
                if (this.clrDim == 3) {
                    br0 = this.colors[cib];
                    bg0 = this.colors[cib + 1];
                    bb0 = this.colors[cib + 2];
                    br1 = this.colors[cib + 3];
                    bg1 = this.colors[cib + 4];
                    bb1 = this.colors[cib + 5];
                } else {
                    br0 = this.colors[cib];
                    bg0 = this.colors[cib + 1];
                    bb0 = this.colors[cib + 2];
                    ba0 = this.colors[cib + 3];
                    br1 = this.colors[cib + 4];
                    bg1 = this.colors[cib + 5];
                    bb1 = this.colors[cib + 6];
                    ba1 = this.colors[cib + 7];
                }
                int idx = numVerts * 3;
                int cidx = numVerts * this.clrDim;
                newCoords[idx] = A0[0];
                newCoords[idx + 1] = A0[1];
                newCoords[idx + 2] = A0[2];
                newColors[cidx] = ar0;
                newColors[cidx + 1] = ag0;
                newColors[cidx + 2] = ab0;
                if (this.clrDim == 4) {
                    newColors[cidx + 3] = aa0;
                }
                idx = ++numVerts * 3;
                cidx = numVerts * this.clrDim;
                newCoords[idx] = B0[0];
                newCoords[idx + 1] = B0[1];
                newCoords[idx + 2] = B0[2];
                newColors[cidx] = br0;
                newColors[cidx + 1] = bg0;
                newColors[cidx + 2] = bb0;
                if (this.clrDim == 4) {
                    newColors[cidx + 3] = ba0;
                }
                idx = ++numVerts * 3;
                cidx = numVerts * this.clrDim;
                newCoords[idx] = B1[0];
                newCoords[idx + 1] = B1[1];
                newCoords[idx + 2] = B1[2];
                newColors[cidx] = br1;
                newColors[cidx + 1] = bg1;
                newColors[cidx + 2] = bb1;
                if (this.clrDim == 4) {
                    newColors[cidx + 3] = ba1;
                }
                idx = ++numVerts * 3;
                cidx = numVerts * this.clrDim;
                newCoords[idx] = B1[0];
                newCoords[idx + 1] = B1[1];
                newCoords[idx + 2] = B1[2];
                newColors[cidx] = br1;
                newColors[cidx + 1] = bg1;
                newColors[cidx + 2] = bb1;
                if (this.clrDim == 4) {
                    newColors[cidx + 3] = ba1;
                }
                idx = ++numVerts * 3;
                cidx = numVerts * this.clrDim;
                newCoords[idx] = A1[0];
                newCoords[idx + 1] = A1[1];
                newCoords[idx + 2] = A1[2];
                newColors[cidx] = ar1;
                newColors[cidx + 1] = ag1;
                newColors[cidx + 2] = ab1;
                if (this.clrDim == 4) {
                    newColors[cidx + 3] = aa1;
                }
                idx = ++numVerts * 3;
                cidx = numVerts * this.clrDim;
                newCoords[idx] = A0[0];
                newCoords[idx + 1] = A0[1];
                newCoords[idx + 2] = A0[2];
                newColors[cidx] = ar0;
                newColors[cidx + 1] = ag0;
                newColors[cidx + 2] = ab0;
                if (this.clrDim == 4) {
                    newColors[cidx + 3] = aa0;
                }
                ++numVerts;
            }
        }
        float[] coords = new float[numVerts * 3];
        byte[] colors = new byte[numVerts * this.clrDim];
        System.arraycopy(newCoords, 0, coords, 0, coords.length);
        System.arraycopy(newColors, 0, colors, 0, colors.length);
        array.coordinates = coords;
        array.colors = colors;
        array.vertexCount = numVerts;
        return array;
    }

    public VisADGeometryArray makePointGeometry() {
        int numTrajs = this.trajectories.size();
        float[] allCoords = new float[3 * numTrajs];
        byte[] allColors = new byte[3 * numTrajs];
        for (int k = 0; k < numTrajs; ++k) {
            Trajectory traj = this.trajectories.get(k);
            int idx = k * 3;
            float x = traj.startPts[0];
            float y = traj.startPts[1];
            float z = traj.startPts[2];
            allCoords[idx] = x;
            allCoords[idx + 1] = y;
            allCoords[idx + 2] = z;
            byte r = traj.startColor[0];
            byte g = traj.startColor[1];
            byte b = traj.startColor[2];
            allColors[idx] = r;
            allColors[idx + 1] = g;
            allColors[idx + 2] = b;
        }
        VisADPointArray array = new VisADPointArray();
        array.vertexCount = numTrajs;
        array.coordinates = allCoords;
        array.colors = allColors;
        return array;
    }

    public VisADGeometryArray makeTracerGeometry(ArrayList<float[]> anchors, VisADTriangleStripArray tsarray, float trcrSize, double[] scale) {
        int numTrajs = this.trajectories.size();
        VisADTriangleStripArray array = new VisADTriangleStripArray();
        float[] coords = tsarray.coordinates;
        float[] normals = tsarray.normals;
        int[] stripVertexCounts = tsarray.stripVertexCounts;
        int numVerts = coords.length / 3;
        int numStrips = stripVertexCounts.length;
        float[] allCoords = new float[3 * numVerts * numTrajs];
        float[] allNormals = new float[3 * numVerts * numTrajs];
        int[] allStrips = new int[numTrajs * numStrips];
        byte[] allColors = new byte[3 * numVerts * numTrajs];
        for (int k = 0; k < numTrajs; ++k) {
            Trajectory traj = this.trajectories.get(k);
            float xpos = traj.startPts[0];
            float ypos = traj.startPts[1];
            float zpos = traj.startPts[2];
            int idx = k * 3 * numVerts;
            for (int i = 0; i < numVerts; ++i) {
                int t = 3 * i;
                allCoords[idx] = trcrSize * coords[t] + xpos;
                allCoords[idx + 1] = (float)(scale[0] / scale[1]) * trcrSize * coords[t + 1] + ypos;
                allCoords[idx + 2] = (float)(scale[0] / scale[2]) * trcrSize * coords[t + 2] + zpos;
                allNormals[idx] = normals[t];
                allNormals[idx + 1] = normals[t + 1];
                allNormals[idx + 2] = normals[t + 2];
                allColors[idx] = traj.startColor[0];
                allColors[idx + 1] = traj.startColor[1];
                allColors[idx + 2] = traj.startColor[2];
                idx += 3;
            }
            System.arraycopy(stripVertexCounts, 0, allStrips, k * numStrips, numStrips);
            float[] anchrPts = new float[]{xpos, ypos, zpos};
            anchors.add(anchrPts);
        }
        array.coordinates = allCoords;
        array.colors = allColors;
        array.normals = allNormals;
        array.vertexCount = numVerts * numTrajs;
        array.stripVertexCounts = allStrips;
        return array;
    }

    public VisADGeometryArray makeTracerGeometryArrow(ArrayList<float[]> anchors, int direction, float trcrSize, double[] scale, boolean fill) {
        int numTrajs = this.trajectories.size();
        float[] allCoords = new float[36 * numTrajs];
        byte[] allColors = new byte[36 * numTrajs];
        double barblen = 0.02 * (double)trcrSize;
        float[] norm = new float[]{0.0f, 0.0f, 1.0f};
        float[] trj_u = new float[3];
        for (int k = 0; k < numTrajs; ++k) {
            VisADGeometryArray array;
            byte[] colors;
            float[] coords;
            int numVerts;
            int numPts;
            if (!fill) {
                numPts = 8;
                numVerts = numPts * 1;
                coords = new float[3 * numVerts];
                colors = new byte[3 * numVerts];
                array = new VisADLineArray();
            } else {
                numPts = 12;
                numVerts = numPts * 1;
                coords = new float[3 * numVerts];
                colors = new byte[3 * numVerts];
                array = new VisADTriangleArray();
            }
            Trajectory traj = this.trajectories.get(k);
            trj_u[0] = traj.uVecPath[0];
            trj_u[1] = traj.uVecPath[1];
            trj_u[2] = traj.uVecPath[2];
            float[] endPt = new float[]{traj.startPts[0], traj.startPts[1], traj.startPts[2]};
            float[] norm_x_trj = new float[]{norm[1] * trj_u[2] - norm[2] * trj_u[1], -(norm[0] * trj_u[2] - norm[2] * trj_u[0]), norm[0] * trj_u[1] - norm[1] * trj_u[0]};
            float mag = (float)Math.sqrt(norm_x_trj[0] * norm_x_trj[0] + norm_x_trj[1] * norm_x_trj[1] + norm_x_trj[2] * norm_x_trj[2]);
            norm_x_trj[0] = norm_x_trj[0] / mag;
            norm_x_trj[1] = norm_x_trj[1] / mag;
            norm_x_trj[2] = norm_x_trj[2] / mag;
            float[] norm_x_trj_x_trj = new float[]{norm_x_trj[1] * trj_u[2] - norm_x_trj[2] * trj_u[1], -(norm_x_trj[0] * trj_u[2] - norm_x_trj[2] * trj_u[0]), norm_x_trj[0] * trj_u[1] - norm_x_trj[1] * trj_u[0]};
            mag = (float)Math.sqrt(norm_x_trj_x_trj[0] * norm_x_trj_x_trj[0] + norm_x_trj_x_trj[1] * norm_x_trj_x_trj[1] + norm_x_trj_x_trj[2] * norm_x_trj_x_trj[2]);
            norm_x_trj_x_trj[0] = norm_x_trj_x_trj[0] / mag;
            norm_x_trj_x_trj[1] = norm_x_trj_x_trj[1] / mag;
            norm_x_trj_x_trj[2] = norm_x_trj_x_trj[2] / mag;
            float[] ptOnPath = new float[3];
            float len = (float)(barblen * Math.cos(0.3839724354387525));
            ptOnPath[0] = -len * trj_u[0];
            ptOnPath[1] = -len * trj_u[1];
            ptOnPath[2] = -len * trj_u[2];
            ptOnPath[0] = ptOnPath[0] + endPt[0];
            ptOnPath[1] = ptOnPath[1] + endPt[1];
            ptOnPath[2] = ptOnPath[2] + endPt[2];
            float[] barbPtA = new float[3];
            float[] barbPtB = new float[3];
            float[] barbPtC = new float[3];
            float[] barbPtD = new float[3];
            len = (float)(barblen * Math.sin(0.3839724354387525));
            barbPtA[0] = len * norm_x_trj[0];
            barbPtA[1] = len * norm_x_trj[1];
            barbPtA[2] = len * norm_x_trj[2];
            barbPtB[0] = -len * norm_x_trj[0];
            barbPtB[1] = -len * norm_x_trj[1];
            barbPtB[2] = -len * norm_x_trj[2];
            barbPtA[0] = barbPtA[0] + ptOnPath[0];
            barbPtA[1] = barbPtA[1] + ptOnPath[1];
            barbPtA[2] = barbPtA[2] + ptOnPath[2];
            barbPtB[0] = barbPtB[0] + ptOnPath[0];
            barbPtB[1] = barbPtB[1] + ptOnPath[1];
            barbPtB[2] = barbPtB[2] + ptOnPath[2];
            len = (float)((double)len * (scale[0] / scale[2]));
            barbPtC[0] = len * norm_x_trj_x_trj[0];
            barbPtC[1] = len * norm_x_trj_x_trj[1];
            barbPtC[2] = len * norm_x_trj_x_trj[2];
            barbPtD[0] = -len * norm_x_trj_x_trj[0];
            barbPtD[1] = -len * norm_x_trj_x_trj[1];
            barbPtD[2] = -len * norm_x_trj_x_trj[2];
            barbPtC[0] = barbPtC[0] + ptOnPath[0];
            barbPtC[1] = barbPtC[1] + ptOnPath[1];
            barbPtC[2] = barbPtC[2] + ptOnPath[2];
            barbPtD[0] = barbPtD[0] + ptOnPath[0];
            barbPtD[1] = barbPtD[1] + ptOnPath[1];
            barbPtD[2] = barbPtD[2] + ptOnPath[2];
            int t = 0;
            int c = 0;
            coords[t] = traj.startPts[0];
            coords[++t] = traj.startPts[1];
            coords[++t] = traj.startPts[2];
            colors[c] = traj.startColor[0];
            colors[++c] = traj.startColor[1];
            colors[++c] = traj.startColor[2];
            coords[++t] = barbPtA[0];
            coords[++t] = barbPtA[1];
            coords[++t] = barbPtA[2];
            colors[++c] = traj.startColor[0];
            colors[++c] = traj.startColor[1];
            colors[++c] = traj.startColor[2];
            if (fill) {
                coords[++t] = ptOnPath[0];
                coords[++t] = ptOnPath[1];
                coords[++t] = ptOnPath[2];
                colors[++c] = traj.startColor[0];
                colors[++c] = traj.startColor[1];
                colors[++c] = traj.startColor[2];
            }
            coords[++t] = traj.startPts[0];
            coords[++t] = traj.startPts[1];
            coords[++t] = traj.startPts[2];
            colors[++c] = traj.startColor[0];
            colors[++c] = traj.startColor[1];
            colors[++c] = traj.startColor[2];
            coords[++t] = barbPtB[0];
            coords[++t] = barbPtB[1];
            coords[++t] = barbPtB[2];
            colors[++c] = traj.startColor[0];
            colors[++c] = traj.startColor[1];
            colors[++c] = traj.startColor[2];
            if (fill) {
                coords[++t] = ptOnPath[0];
                coords[++t] = ptOnPath[1];
                coords[++t] = ptOnPath[2];
                colors[++c] = traj.startColor[0];
                colors[++c] = traj.startColor[1];
                colors[++c] = traj.startColor[2];
            }
            coords[++t] = traj.startPts[0];
            coords[++t] = traj.startPts[1];
            coords[++t] = traj.startPts[2];
            colors[++c] = traj.startColor[0];
            colors[++c] = traj.startColor[1];
            colors[++c] = traj.startColor[2];
            coords[++t] = barbPtC[0];
            coords[++t] = barbPtC[1];
            coords[++t] = barbPtC[2];
            colors[++c] = traj.startColor[0];
            colors[++c] = traj.startColor[1];
            colors[++c] = traj.startColor[2];
            if (fill) {
                coords[++t] = ptOnPath[0];
                coords[++t] = ptOnPath[1];
                coords[++t] = ptOnPath[2];
                colors[++c] = traj.startColor[0];
                colors[++c] = traj.startColor[1];
                colors[++c] = traj.startColor[2];
            }
            coords[++t] = traj.startPts[0];
            coords[++t] = traj.startPts[1];
            coords[++t] = traj.startPts[2];
            colors[++c] = traj.startColor[0];
            colors[++c] = traj.startColor[1];
            colors[++c] = traj.startColor[2];
            coords[++t] = barbPtD[0];
            coords[++t] = barbPtD[1];
            coords[++t] = barbPtD[2];
            colors[++c] = traj.startColor[0];
            colors[++c] = traj.startColor[1];
            colors[++c] = traj.startColor[2];
            if (fill) {
                coords[++t] = ptOnPath[0];
                coords[++t] = ptOnPath[1];
                coords[++t] = ptOnPath[2];
                colors[++c] = traj.startColor[0];
                colors[++c] = traj.startColor[1];
                colors[++c] = traj.startColor[2];
            }
            array.vertexCount = numVerts;
            array.coordinates = coords;
            array.colors = colors;
            float[] anchrPts = new float[]{traj.startPts[0], traj.startPts[1], traj.startPts[2]};
            anchors.add(anchrPts);
            System.arraycopy(coords, 0, allCoords, k * 3 * 2 * 6, coords.length);
            System.arraycopy(colors, 0, allColors, k * 3 * 2 * 6, colors.length);
        }
        VisADTriangleArray allarray = new VisADTriangleArray();
        allarray.vertexCount = 12 * numTrajs;
        allarray.coordinates = allCoords;
        allarray.colors = allColors;
        return allarray;
    }

    public void initCleanUp(ScalarMap scalarMap, FlowControl flowCntrl, ProjectionControl pCntrl, DisplayImpl display) {
        if (!removeListeners.containsKey(scalarMap)) {
            removeListeners.put(scalarMap, new ListenForRemove(scalarMap, flowCntrl, pCntrl, display));
        }
    }

    public static TrajectoryParams getTrajParamsFromFile(TrajectoryParams trajParams, int which) {
        String filename = null;
        try {
            String propFile = null;
            if (which == 0) {
                propFile = PROP_TRAJECTORY_PARAM_FILE_1;
            } else if (which == 1) {
                propFile = PROP_TRAJECTORY_PARAM_FILE_2;
            }
            filename = System.getProperty(propFile, null);
        }
        catch (SecurityException exc) {
            exc.printStackTrace();
        }
        if (filename == null) {
            return trajParams;
        }
        Properties prop = new Properties();
        FileInputStream is = null;
        try {
            is = new FileInputStream(filename);
            if (is != null) {
                float fac;
                prop.load(is);
                String propStr = null;
                propStr = prop.getProperty("CylinderWidthFactor");
                if (propStr != null) {
                    fac = Float.valueOf(propStr.trim()).floatValue();
                    trajParams.setCylinderWidth(trajParams.getCylinderWidth() * fac);
                }
                if ((propStr = prop.getProperty("TracerSize")) != null) {
                    fac = Float.valueOf(propStr.trim()).floatValue();
                    trajParams.setMarkerSize(fac);
                }
                if ((propStr = prop.getProperty("RibbonWidthFactor")) != null) {
                    fac = Float.valueOf(propStr.trim()).floatValue();
                    trajParams.setRibbonWidthFactor(fac);
                }
                if ((propStr = prop.getProperty("ManualIntrpPts")) != null) {
                    trajParams.setManualIntrpPts(Boolean.valueOf(propStr.trim()));
                }
                if ((propStr = prop.getProperty("TerrainFollow")) != null) {
                    trajParams.setTerrainFollowing(Boolean.valueOf(propStr.trim()));
                }
                if ((propStr = prop.getProperty("TracerStreaming")) != null) {
                    trajParams.setTracerStreamingEnabled(Boolean.valueOf(propStr.trim()));
                }
                if ((propStr = prop.getProperty("SaveTracerLocations")) != null) {
                    trajParams.setSaveTracerLocations(Boolean.valueOf(propStr.trim()));
                }
                if ((propStr = prop.getProperty("ConserveColor")) != null) {
                    trajParams.setConserveColor(Boolean.valueOf(propStr.trim()));
                }
                if ((propStr = prop.getProperty("NumIntrpPts")) != null) {
                    trajParams.setNumIntrpPts(Integer.valueOf(propStr.trim()));
                }
                if ((propStr = prop.getProperty("TrajRefreshInterval")) != null) {
                    trajParams.setTrajRefreshInterval(Double.valueOf(propStr.trim()));
                }
                if ((propStr = prop.getProperty("TrajVisiblityTimeWindow")) != null) {
                    trajParams.setTrajVisibilityTimeWindow(Double.valueOf(propStr.trim()));
                }
                if ((propStr = prop.getProperty("TimeStepScaleFactor")) != null) {
                    trajParams.setTimeStepScaleFactor(Double.valueOf(propStr.trim()));
                }
                if ((propStr = prop.getProperty("StartSkip")) != null) {
                    trajParams.setStartSkip(Integer.valueOf(propStr.trim()));
                }
                if ((propStr = prop.getProperty("ZStartSkip")) != null) {
                    trajParams.setZStartSkip(Integer.valueOf(propStr.trim()));
                }
                if ((propStr = prop.getProperty("ZStartIndex")) != null) {
                    trajParams.setZStartIndex(Integer.valueOf(propStr.trim()));
                }
                if ((propStr = prop.getProperty("TrajForm")) != null) {
                    if ((propStr = propStr.trim()).equals("LINE")) {
                        trajParams.setTrajectoryForm(0);
                    } else if (propStr.equals("RIBBON")) {
                        trajParams.setTrajectoryForm(1);
                    } else if (propStr.equals("CYLINDER")) {
                        trajParams.setTrajectoryForm(2);
                    } else if (propStr.equals("DEFORM_RIBBON")) {
                        trajParams.setTrajectoryForm(3);
                    } else if (propStr.equals("POINT")) {
                        trajParams.setTrajectoryForm(4);
                    } else if (propStr.equals("TRACER")) {
                        trajParams.setTrajectoryForm(5);
                    } else if (propStr.equals("TRACER_POINT")) {
                        trajParams.setTrajectoryForm(6);
                    }
                }
                if ((propStr = prop.getProperty("Method")) != null) {
                    if ((propStr = propStr.trim()).equals("HYSPLIT")) {
                        trajParams.setMethod(TrajectoryParams.Method.HySplit);
                    } else if (propStr.equals("RK4")) {
                        trajParams.setMethod(TrajectoryParams.Method.RK4);
                    } else if (propStr.equals("EULER")) {
                        trajParams.setMethod(TrajectoryParams.Method.Euler);
                    }
                }
                if ((propStr = prop.getProperty("InterpMethod")) != null) {
                    if ((propStr = propStr.trim()).equals("CUBIC")) {
                        trajParams.setInterpolationMethod(TrajectoryParams.InterpolationMethod.Cubic);
                    } else if (propStr.equals("LINEAR")) {
                        trajParams.setInterpolationMethod(TrajectoryParams.InterpolationMethod.Linear);
                    } else if (propStr.equals("NONE")) {
                        trajParams.setInterpolationMethod(TrajectoryParams.InterpolationMethod.None);
                    }
                }
                if ((propStr = prop.getProperty("Direction")) != null) {
                    if ((propStr = propStr.trim()).equals("FORWARD")) {
                        trajParams.setDirectionFlag(true);
                    } else if (propStr.equals("REVERSE")) {
                        trajParams.setDirectionFlag(false);
                    }
                }
                ((InputStream)is).close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return trajParams;
    }

    public float[][] getStartPointsFromFile(DataRenderer renderer, ScalarMap altToZ, byte[][] colors, double[][] times, int which) throws VisADException, RemoteException {
        Object[] vals;
        String filename = null;
        Object filename1 = null;
        Object filename2 = null;
        try {
            filename = System.getProperty(PPOP_TRAJECTORY_START_POINTS_FILE, null);
            if (filename == null) {
                if (which == 0) {
                    filename = System.getProperty(PPOP_TRAJECTORY_START_POINTS_FILE_1, null);
                } else if (which == 1) {
                    filename = System.getProperty(PPOP_TRAJECTORY_START_POINTS_FILE_2, null);
                }
            }
        }
        catch (SecurityException exc) {
            exc.printStackTrace();
        }
        if (filename == null) {
            return null;
        }
        FieldImpl data = null;
        try {
            TextAdapter txtAdapter = new TextAdapter(filename);
            data = (FieldImpl)txtAdapter.getData();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        RealTupleType rngTupType = (RealTupleType)((FunctionType)data.getType()).getRange();
        int lonIdx = rngTupType.getIndex(RealType.Longitude);
        int latIdx = rngTupType.getIndex(RealType.Latitude);
        int altIdx = rngTupType.getIndex(RealType.Altitude);
        int timeIdx = rngTupType.getIndex(RealType.Time);
        int numPts = data.getLength();
        ArrayList<float[]> keepPts = new ArrayList<float[]>();
        ArrayList<Float> keepVal = new ArrayList<Float>();
        ArrayList<Double> keepTime = new ArrayList<Double>();
        for (int k = 0; k < numPts; ++k) {
            RealTuple tup = (RealTuple)data.getSample(k);
            vals = tup.getValues();
            float[] locVal = new float[]{(float)vals[lonIdx], (float)vals[latIdx], (float)vals[altIdx]};
            keepPts.add(locVal);
            if (vals.length > 3) {
                if (timeIdx >= 0) {
                    keepTime.add(vals[timeIdx]);
                    continue;
                }
                keepVal.add(Float.valueOf((float)vals[3]));
                continue;
            }
            if (vals.length <= 4) continue;
            keepTime.add(vals[timeIdx]);
            keepVal.add(Float.valueOf((float)vals[4]));
        }
        if (keepVal.size() != 0 && (keepPts.size() != keepVal.size() || keepPts.size() != keepTime.size())) {
            throw new VisADException("Trajectory start point file problem: all points must be specified as either lon,lat,alt or lon,lat,alt,val or lon,lat,alt,time or lon,lat,alt,time,value");
        }
        float[][] latlonalt = new float[3][keepPts.size()];
        for (int k = 0; k < keepPts.size(); ++k) {
            vals = (float[])keepPts.get(k);
            latlonalt[0][k] = (float)vals[1];
            latlonalt[1][k] = (float)vals[0];
            latlonalt[2][k] = (float)vals[2];
        }
        float[] trcrVals = null;
        if (keepVal.size() > 0) {
            trcrVals = new float[keepVal.size()];
        }
        if (trcrVals != null) {
            colors[0] = new byte[keepPts.size()];
            colors[1] = new byte[keepPts.size()];
            colors[2] = new byte[keepPts.size()];
            if (colors.length == 4) {
                colors[3] = new byte[keepPts.size()];
            }
            for (int k = 0; k < trcrVals.length; ++k) {
                float tval;
                trcrVals[k] = tval = ((Float)keepVal.get(k)).floatValue();
            }
            float[][] clrTbl = new float[colors.length][256];
            BaseColorControl.initTableVis5D(clrTbl);
            for (int i = 0; i < trcrVals.length; ++i) {
                float tval = trcrVals[i];
                if (tval > 1.0f) {
                    tval = 1.0f;
                }
                int ci = (int)(tval * 256.0f);
                colors[0][i] = (byte)(256.0f * clrTbl[0][ci]);
                colors[1][i] = (byte)(256.0f * clrTbl[1][ci]);
                colors[2][i] = (byte)(256.0f * clrTbl[2][ci]);
                if (colors.length != 4) continue;
                colors[3][i] = (byte)(256.0f * clrTbl[3][ci]);
            }
        }
        latlonalt[2] = altToZ.scaleValues(latlonalt[2]);
        CoordinateSystem dspCoordSys = renderer.getDisplayCoordinateSystem();
        float[][] fltVals = new float[3][latlonalt[0].length];
        for (int i = 0; i < latlonalt.length; ++i) {
            System.arraycopy(latlonalt[i], 0, fltVals[i], 0, fltVals[i].length);
        }
        float[][] xyz = dspCoordSys.toReference(fltVals);
        int tSize = keepTime.size();
        double[] timeVals = null;
        if (tSize > 0) {
            timeVals = new double[tSize];
        }
        for (int k = 0; k < tSize; ++k) {
            timeVals[k] = (Double)keepTime.get(k);
        }
        times[0] = timeVals;
        return xyz;
    }

    static {
        doStartOffset = false;
        o_j = new int[]{0, 0, 1, 1};
        o_i = new int[]{0, 1, 0, 1};
        scaleChangeListeners = new HashMap();
        removeListeners = new HashMap();
    }
}

