/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.GriddedLatLonSet;
import visad.MathType;
import visad.RealTupleType;
import visad.SetException;
import visad.VisADException;

public class XTrackScanLatLonSet
extends GriddedLatLonSet {
    GriddedLatLonSet[] scanSets;
    int numOfScans;
    int linesPerScan;
    int lastSetIdx;

    public XTrackScanLatLonSet(MathType type, float[][] samples, int XTrackLen, int TrackLen, int linesPerScan) throws VisADException {
        super(type, samples, XTrackLen, TrackLen, null, null, null, false);
        if (TrackLen % linesPerScan != 0) {
            throw new VisADException("There must be an intergral number of scans with detectorsPerScan: " + linesPerScan + " per TrackLen: " + TrackLen);
        }
        this.linesPerScan = linesPerScan;
        this.numOfScans = TrackLen / linesPerScan;
        this.scanSets = new GriddedLatLonSet[this.numOfScans];
        int scanLen = linesPerScan * XTrackLen;
        for (int k = 0; k < this.numOfScans; ++k) {
            float[] scanLonArray = new float[linesPerScan * XTrackLen];
            float[] scanLatArray = new float[linesPerScan * XTrackLen];
            System.arraycopy(this.lons, k * scanLen, scanLonArray, 0, scanLen);
            System.arraycopy(this.lats, k * scanLen, scanLatArray, 0, scanLen);
            this.scanSets[k] = new GriddedLatLonSet((MathType)RealTupleType.SpatialEarth2DTuple, new float[][]{scanLonArray, scanLatArray}, XTrackLen, linesPerScan);
        }
    }

    @Override
    public float[][] valueToGrid(float[][] value) throws VisADException {
        return this.valueToGrid(value, null);
    }

    @Override
    public float[][] valueToGrid(float[][] value, int[] guess) throws VisADException {
        int setIdx;
        if (value.length < this.DomainDimension) {
            throw new SetException("Gridded2DSet.valueToGrid: value dimension " + value.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        if (this.ManifoldDimension < 2) {
            throw new SetException("Gridded2DSet.valueToGrid: Manifold dimension must be 2, not " + this.ManifoldDimension);
        }
        if (this.Length > 1 && (this.Lengths[0] < 2 || this.Lengths[1] < 2)) {
            throw new SetException("Gridded2DSet.valueToGrid: requires all grid dimensions to be > 1");
        }
        if (guess != null && guess.length != 2) {
            throw new SetException("Gridded2DSet.valueToGrid: guess length " + guess.length + " must equal 2");
        }
        int length = Math.min(value[0].length, value[1].length);
        float[][] grid = new float[this.ManifoldDimension][length];
        int gx = (this.LengthX - 1) / 2;
        int gy = (this.TrackLen - 1) / 2;
        if (guess != null && guess[0] >= 0 && guess[1] >= 0) {
            gx = guess[0];
            gy = guess[1];
        } else if (this.lgxy[0] != -1 && this.lgxy[1] != -1) {
            gx = this.lgxy[0];
            gy = this.lgxy[1];
        }
        this.lastSetIdx = setIdx = gy / this.linesPerScan;
        int idx = gy * this.LengthX + gx;
        if (Float.isNaN(this.lons[idx]) || Float.isNaN(this.lats[idx]) || Math.abs(this.lats[idx]) > 90.0f) {
            throw new VisADException("initial grid box guess cannot be invalid or missing");
        }
        float[][] lonlat = new float[2][1];
        int[] guess_set = new int[]{gx, this.linesPerScan / 2};
        block0: for (int i = 0; i < length; ++i) {
            if (this.Length == 1) {
                if (Float.isNaN(value[0][i]) || Float.isNaN(value[1][i])) {
                    grid[1][i] = Float.NaN;
                    grid[0][i] = Float.NaN;
                    continue;
                }
                grid[0][i] = 0.0f;
                grid[1][i] = 0.0f;
                continue;
            }
            if (i != 0 && grid[0][i - 1] != grid[0][i - 1] && this.lgxy[0] != -1 && this.lgxy[1] != -1) {
                gx = this.lgxy[0];
                gy = this.lgxy[1];
            }
            grid[1][i] = Float.NaN;
            grid[0][i] = Float.NaN;
            float targetLon = value[this.lonI][i];
            float targetLat = value[this.latI][i];
            lonlat[this.lonI][0] = targetLon;
            lonlat[this.latI][0] = targetLat;
            int dir = 0;
            for (int cnt = 0; this.lastSetIdx >= 0 && this.lastSetIdx < this.numOfScans && cnt < this.numOfScans; ++cnt) {
                GriddedLatLonSet scanSet = this.scanSets[this.lastSetIdx];
                float[][] gxgy = scanSet.valueToGrid(lonlat, guess_set);
                if (Float.isNaN(gxgy[0][0]) || Float.isNaN(gxgy[1][0])) {
                    int gx_set = guess_set[0];
                    int gy_set = guess_set[1];
                    if (gy_set == 0) {
                        --this.lastSetIdx;
                        guess_set[0] = gx_set;
                        guess_set[1] = this.linesPerScan - 1;
                        if (dir == 1) continue block0;
                        dir = -1;
                        continue;
                    }
                    if (gy_set == this.linesPerScan - 1) {
                        ++this.lastSetIdx;
                        guess_set[0] = gx_set;
                        guess_set[1] = 0;
                        if (dir == -1) continue block0;
                        dir = 1;
                        continue;
                    }
                    if (gx_set == 0 || gx_set == this.LengthX - 1) continue block0;
                    continue;
                }
                grid[0][i] = gxgy[0][0];
                grid[1][i] = (float)(this.lastSetIdx * this.linesPerScan) + gxgy[1][0];
                this.lgxy[0] = scanSet.lgxy[0];
                this.lgxy[1] = scanSet.lgxy[1] + this.lastSetIdx * this.linesPerScan;
                continue block0;
            }
        }
        return grid;
    }
}

