/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.rmi.RemoteException;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Group;
import javax.swing.JFrame;
import visad.ConstantMap;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.DelaunayCustom;
import visad.Display;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Gridded2DSet;
import visad.Irregular2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.Text;
import visad.TextControl;
import visad.TextType;
import visad.VisADException;
import visad.java3d.DefaultRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;

public class ScreenLockedRendererJ3D
extends DefaultRendererJ3D {
    boolean initWithProj = false;

    public ScreenLockedRendererJ3D() {
    }

    public ScreenLockedRendererJ3D(boolean initWithProj) {
        this();
        this.initWithProj = initWithProj;
    }

    @Override
    public void addSwitch(DisplayRendererJ3D displayRenderer, BranchGroup branch) {
        if (this.initWithProj) {
            displayRenderer.addLockedSceneGraphComponent((Group)branch, this.initWithProj);
        } else {
            displayRenderer.addLockedSceneGraphComponent((Group)branch);
        }
    }

    public static final void main(String[] args) throws VisADException, RemoteException {
        DisplayImplJ3D display = new DisplayImplJ3D("display");
        DisplayRendererJ3D renderer = (DisplayRendererJ3D)display.getDisplayRenderer();
        renderer.setBoxOn(false);
        renderer.setBackgroundColor(0.0f, 0.2f, 1.0f);
        GraphicsModeControl gmc = display.getGraphicsModeControl();
        gmc.setScaleEnable(false);
        gmc.setProjectionPolicy(0);
        RealTupleType domainType = new RealTupleType(RealType.Latitude, RealType.Longitude);
        TextType textType = TextType.getTextType("text");
        FunctionType functionType = new FunctionType(domainType, textType);
        float[][] domainSamples = new float[2][4];
        domainSamples[0][0] = 0.0f;
        domainSamples[1][0] = 0.0f;
        domainSamples[0][1] = 10.0f;
        domainSamples[1][1] = 0.0f;
        domainSamples[0][2] = 10.0f;
        domainSamples[1][2] = 10.0f;
        domainSamples[0][3] = 0.0f;
        domainSamples[1][3] = 10.0f;
        Gridded2DSet domainSet2 = new Gridded2DSet((MathType)domainType, domainSamples, 4);
        Irregular2DSet filledSet = DelaunayCustom.fill(domainSet2);
        DataReferenceImpl unlockedDataRef = new DataReferenceImpl("unlocked_data_ref");
        unlockedDataRef.setData(filledSet);
        ScalarMap latMap = new ScalarMap(RealType.Latitude, Display.YAxis);
        ScalarMap lonMap = new ScalarMap(RealType.Longitude, Display.XAxis);
        ScalarMap textMap = new ScalarMap(textType, Display.Text);
        display.addMap(latMap);
        display.addMap(lonMap);
        display.addMap(textMap);
        latMap.setRange(0.0, 10.0);
        lonMap.setRange(0.0, 10.0);
        textMap.setRange(0.0, 10.0);
        TextControl textControl = (TextControl)textMap.getControl();
        textControl.setCenter(true);
        Text text = new Text(textType, "Screen Locked 1");
        DataReferenceImpl lockedDataRef1 = new DataReferenceImpl("locked_data_ref");
        lockedDataRef1.setData(text);
        display.addReferences((DataRenderer)new ScreenLockedRendererJ3D(), lockedDataRef1, new ConstantMap[]{new ConstantMap(-1.0, Display.XAxis), new ConstantMap(1.0, Display.YAxis), new ConstantMap(-0.2, Display.ZAxis)});
        text = new Text(textType, "Screen Locked 2");
        DataReferenceImpl lockedDataRef2 = new DataReferenceImpl("locked_data_ref");
        lockedDataRef2.setData(text);
        display.addReferences((DataRenderer)new ScreenLockedRendererJ3D(), lockedDataRef2, new ConstantMap[]{new ConstantMap(1.0, Display.XAxis), new ConstantMap(-1.0, Display.YAxis), new ConstantMap(-0.2, Display.ZAxis)});
        display.addReference(unlockedDataRef, new ConstantMap[]{new ConstantMap(0.0, Display.Green), new ConstantMap(0.0, Display.Blue), new ConstantMap(-1.0, Display.ZAxis)});
        JFrame frame = new JFrame("ScreenLockedRendererJ3D");
        frame.getContentPane().add(display.getComponent());
        frame.setSize(400, 400);
        frame.setVisible(true);
    }
}

