/*
 * Decompiled with CFR 0.152.
 */
package visad.data.dods;

import dods.dap.DAS;
import dods.dap.DArray;
import java.lang.ref.WeakReference;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.WeakHashMap;
import visad.DataImpl;
import visad.GriddedSet;
import visad.MathType;
import visad.VisADException;
import visad.data.dods.VariableAdapter;
import visad.data.dods.VariableAdapterFactory;
import visad.data.dods.VectorAdapter;

public class GridVariableMapAdapter
extends VariableAdapter {
    private final VectorAdapter vectorAdapter;
    private static final Map setMap = new WeakHashMap();

    private GridVariableMapAdapter(DArray array, DAS das, VariableAdapterFactory factory) throws VisADException, RemoteException {
        this.vectorAdapter = factory.vectorAdapter(array.getPrimitiveVector(), das);
    }

    public static GridVariableMapAdapter gridVariableMapAdapter(DArray array, DAS das, VariableAdapterFactory factory) throws VisADException, RemoteException {
        if (array.numDimensions() != 1) {
            throw new VisADException("visad.data.dods.GridVariableMapAdapter.gridVariableMapAdapter(...): Array not one-dimensional");
        }
        return new GridVariableMapAdapter(array, das, factory);
    }

    @Override
    public MathType getMathType() {
        return this.vectorAdapter.getMathType();
    }

    @Override
    public DataImpl data(DArray array, boolean copy) throws VisADException, RemoteException {
        GriddedSet newSet = this.vectorAdapter.griddedSet(array.getPrimitiveVector());
        WeakReference ref = (WeakReference)setMap.get(newSet);
        if (ref == null) {
            setMap.put(newSet, new WeakReference<GriddedSet>(newSet));
        } else {
            GriddedSet oldSet = (GriddedSet)ref.get();
            if (oldSet == null) {
                setMap.put(newSet, new WeakReference<GriddedSet>(newSet));
            } else {
                newSet = oldSet;
            }
        }
        return newSet;
    }
}

