/*
 * Decompiled with CFR 0.152.
 */
package visad.data.in;

import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import visad.data.in.ValueUnpacker;

public final class ScaleAndOffsetUnpacker
extends ValueUnpacker {
    private final float floatScale;
    private final double doubleScale;
    private final float floatOffset;
    private final double doubleOffset;
    private static final WeakHashMap map = new WeakHashMap();

    private ScaleAndOffsetUnpacker(double scale, double offset) {
        this.floatScale = (float)scale;
        this.doubleScale = scale;
        this.floatOffset = (float)offset;
        this.doubleOffset = offset;
    }

    public static synchronized ScaleAndOffsetUnpacker scaleAndOffsetUnpacker(double scale, double offset) {
        ScaleAndOffsetUnpacker unpacker = new ScaleAndOffsetUnpacker(scale, offset);
        WeakReference ref = (WeakReference)map.get(unpacker);
        if (ref == null) {
            map.put(unpacker, new WeakReference<ScaleAndOffsetUnpacker>(unpacker));
        } else {
            ScaleAndOffsetUnpacker oldUnpacker = (ScaleAndOffsetUnpacker)ref.get();
            if (oldUnpacker == null) {
                map.put(unpacker, new WeakReference<ScaleAndOffsetUnpacker>(unpacker));
            } else {
                unpacker = oldUnpacker;
            }
        }
        return unpacker;
    }

    @Override
    public double getIncrement() {
        return Math.abs(this.doubleScale);
    }

    @Override
    public float process(float value) {
        return this.floatScale * value + this.floatOffset;
    }

    @Override
    public double process(double value) {
        return this.doubleScale * value + this.doubleOffset;
    }

    @Override
    public float[] process(float[] values) {
        for (int i = 0; i < values.length; ++i) {
            values[i] = values[i] * this.floatScale + this.floatOffset;
        }
        return values;
    }

    @Override
    public double[] process(double[] values) {
        for (int i = 0; i < values.length; ++i) {
            values[i] = values[i] * this.doubleScale + this.doubleOffset;
        }
        return values;
    }

    public boolean equals(Object obj) {
        ScaleAndOffsetUnpacker that;
        boolean equals = !this.getClass().isInstance(obj) ? false : this == (that = (ScaleAndOffsetUnpacker)obj) || this.doubleOffset == that.doubleOffset && this.doubleScale == that.doubleScale;
        return equals;
    }

    public int hashCode() {
        return new Double(this.doubleOffset).hashCode() ^ new Double(this.doubleScale).hashCode();
    }
}

