/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf.in;

import java.io.IOException;
import java.rmi.RemoteException;
import visad.DataImpl;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.netcdf.in.NetcdfAdapter;
import visad.data.netcdf.in.Strategy;

public final class CompositeStrategy
extends Strategy {
    private final Strategy[] strategies;

    private CompositeStrategy(Strategy[] strategies) {
        if (strategies.length < 2) {
            throw new IllegalArgumentException();
        }
        this.strategies = (Strategy[])strategies.clone();
    }

    public static Strategy instance(Strategy[] strategies) {
        return strategies.length == 1 ? strategies[0] : new CompositeStrategy(strategies);
    }

    @Override
    public DataImpl getData(NetcdfAdapter adapter) throws IOException, VisADException, RemoteException, BadFormException, OutOfMemoryError {
        for (int i = 0; i < this.strategies.length - 1; ++i) {
            System.gc();
            try {
                return this.strategies[i].getData(adapter);
            }
            catch (OutOfMemoryError memErr) {
                System.err.println("Couldn't import netCDF dataset due to insufficient memory.  Using different strategy...");
                continue;
            }
        }
        return this.strategies[this.strategies.length - 1].getData(adapter);
    }
}

