/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf.in;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import ucar.netcdf.Netcdf;
import ucar.netcdf.NetcdfFile;
import visad.DataImpl;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.netcdf.QuantityDB;
import visad.data.netcdf.QuantityDBManager;
import visad.data.netcdf.in.DataFactory;
import visad.data.netcdf.in.Merger;
import visad.data.netcdf.in.Strategy;
import visad.data.netcdf.in.View;
import visad.data.netcdf.in.VirtualDataIterator;
import visad.data.netcdf.in.VirtualTuple;

public class NetcdfAdapter {
    public static final String IMPORT_STRATEGY_PROPERTY = "visad.data.netcdf.in.Strategy";
    private static Strategy strategy;
    private View view;
    private DataImpl data;

    public NetcdfAdapter(Netcdf netcdf, QuantityDB quantityDB) throws VisADException, RemoteException, IOException, BadFormException {
        this(netcdf, quantityDB, false);
    }

    public NetcdfAdapter(Netcdf netcdf, QuantityDB quantityDB, boolean charToText) throws VisADException, RemoteException, IOException, BadFormException {
        this(View.getInstance(netcdf, quantityDB, charToText));
    }

    public NetcdfAdapter(View view) {
        this.view = view;
    }

    public static synchronized Strategy setDefaultStrategy(Strategy strategy) {
        if (strategy == null) {
            throw new NullPointerException();
        }
        Strategy prev = NetcdfAdapter.strategy;
        NetcdfAdapter.strategy = strategy;
        return prev;
    }

    public static synchronized Strategy getDefaultStrategy() {
        return strategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized DataImpl getData() throws IOException, VisADException, RemoteException, BadFormException, OutOfMemoryError {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            return this.getData(strategy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized DataImpl getData(Strategy strategy) throws IOException, VisADException, RemoteException, BadFormException, OutOfMemoryError {
        if (this.data == null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                this.data = strategy.getData(this);
            }
        }
        return this.data;
    }

    public DataImpl getProxy() throws IOException, VisADException, RemoteException, BadFormException, OutOfMemoryError {
        return this.getData();
    }

    protected static DataImpl importData(View view, Merger merger, DataFactory dataFactory) throws IOException, VisADException, RemoteException, BadFormException, OutOfMemoryError {
        VirtualTuple topTuple = new VirtualTuple();
        VirtualDataIterator iter = view.getVirtualDataIterator();
        while (iter.hasNext()) {
            merger.merge(topTuple, iter.next());
        }
        topTuple.setDataFactory(dataFactory);
        return topTuple.getData();
    }

    protected View getView() {
        return this.view;
    }

    public static void main(String[] args) throws Exception {
        String[] pathnames = args.length == 0 ? new String[]{"test.nc"} : args;
        for (int i = 0; i < pathnames.length; ++i) {
            NetcdfFile file;
            try {
                URL url = new URL(pathnames[i]);
                file = new NetcdfFile(url);
            }
            catch (MalformedURLException e) {
                file = new NetcdfFile(pathnames[i], true);
            }
            NetcdfAdapter adapter = new NetcdfAdapter(file, QuantityDBManager.instance());
            DataImpl data = adapter.getData();
            System.out.println("data.getClass().getName() = " + data.getClass().getName());
            System.out.println("data.getType().prettyString():\n" + data.getType().prettyString());
        }
    }

    static {
        String strategyName = System.getProperty(IMPORT_STRATEGY_PROPERTY);
        try {
            strategy = strategyName == null ? Strategy.DEFAULT : (Strategy)Class.forName(strategyName).getMethod("instance", new Class[0]).invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new Error("Import strategy \"" + strategyName + "\" doesn't have an \"instance()\" method");
        }
        catch (ClassNotFoundException e) {
            throw new Error("Import strategy \"" + strategyName + "\" not found");
        }
        catch (IllegalAccessException e) {
            throw new Error("Permission to access import strategy \"" + strategyName + "\" denied");
        }
        catch (InvocationTargetException e) {
            throw new Error("Import strategy's \"" + strategyName + "\" \"instance()\" method threw exception: " + e.getMessage());
        }
    }
}

