/*
 * Decompiled with CFR 0.152.
 */
package visad.georef;

import java.rmi.RemoteException;
import visad.CommonUnit;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.Unit;
import visad.VisADException;
import visad.browser.Convert;
import visad.georef.EarthLocation;
import visad.georef.LatLonPoint;
import visad.georef.LatLonTuple;

public class EarthLocationTuple
extends RealTuple
implements EarthLocation {
    LatLonTuple latlon;
    Real alt;
    public static final Unit[] DEFAULT_UNITS = new Unit[]{CommonUnit.degree, CommonUnit.degree, CommonUnit.meter};

    public EarthLocationTuple() throws VisADException, RemoteException {
        this(Double.NaN, Double.NaN, Double.NaN);
    }

    public EarthLocationTuple(Real lat, Real lon, Real alt) throws VisADException, RemoteException {
        this(lat, lon, alt, (Unit[])null, true);
    }

    public EarthLocationTuple(Real lat, Real lon, Real alt, Unit[] units, boolean checkUnits) throws VisADException, RemoteException {
        this(lat, lon, alt, units, checkUnits, false);
    }

    EarthLocationTuple(Real lat, Real lon, Real alt, Unit[] units, boolean checkUnits, boolean useLLTUnits) throws VisADException, RemoteException {
        super(RealTupleType.LatitudeLongitudeAltitude, new Real[]{lat, lon, alt}, null, units, checkUnits);
        this.latlon = useLLTUnits ? new LatLonTuple(lat, lon, LatLonTuple.DEFAULT_UNITS, checkUnits) : new LatLonTuple(lat, lon);
        this.alt = alt;
    }

    public EarthLocationTuple(double lat, double lon, double alt) throws VisADException, RemoteException {
        this(new Real(RealType.Latitude, lat), new Real(RealType.Longitude, lon), new Real(RealType.Altitude, alt), DEFAULT_UNITS, false, true);
    }

    public EarthLocationTuple(LatLonPoint latlon, Real alt) throws VisADException, RemoteException {
        this(latlon.getLatitude(), latlon.getLongitude(), alt);
    }

    @Override
    public Real getLatitude() {
        return this.latlon.getLatitude();
    }

    @Override
    public Real getLongitude() {
        return this.latlon.getLongitude();
    }

    @Override
    public Real getAltitude() {
        return this.alt;
    }

    @Override
    public LatLonPoint getLatLonPoint() {
        return this.latlon;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.latlon.toString());
        buf.append(" Alt: ");
        try {
            buf.append(Convert.shortString(this.alt.getValue(CommonUnit.meter)));
        }
        catch (VisADException ve) {
            buf.append(Convert.shortString(this.alt.getValue()));
        }
        return buf.toString();
    }
}

