/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import javax.media.j3d.BranchGroup;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.UniverseBuilderJ3D;
import visad.java3d.VisADCanvasJ3D;

public class DisplayPanelJ3D
extends JPanel {
    private DisplayImplJ3D display;
    private DisplayRendererJ3D renderer;
    private UniverseBuilderJ3D universe;
    private VisADCanvasJ3D canvas;

    public DisplayPanelJ3D(DisplayImplJ3D d) {
        this(d, null, null);
    }

    public DisplayPanelJ3D(DisplayImplJ3D d, GraphicsConfiguration config, VisADCanvasJ3D c) {
        this.display = d;
        this.renderer = (DisplayRendererJ3D)this.display.getDisplayRenderer();
        this.setLayout(new BoxLayout(this, 0));
        this.canvas = c != null ? c : new VisADCanvasJ3D(this.renderer, config);
        this.canvas.setComponent(this);
        this.add((Component)((Object)this.canvas));
        this.universe = new UniverseBuilderJ3D(this.canvas);
        BranchGroup scene = this.renderer.createSceneGraph(this.universe.view, this.universe.vpTrans, this.canvas);
        this.universe.addBranchGraph(scene);
        this.setPreferredSize(new Dimension(256, 256));
        this.setMinimumSize(new Dimension(0, 0));
    }

    @Override
    public void setVisible(boolean v) {
        super.setVisible(v);
        this.canvas.setVisible(v);
    }

    public void destroy() {
        this.canvas = null;
        this.display = null;
        this.renderer = null;
        if (this.universe != null) {
            this.universe.destroy();
            this.universe = null;
        }
    }
}

