/*
 * Decompiled with CFR 0.152.
 */
package visad.java3d;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GraphicsContext3D;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.OrderedGroup;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Switch;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4d;
import visad.AxisScale;
import visad.ColorAlphaControl;
import visad.ColorControl;
import visad.ContourControl;
import visad.Control;
import visad.ControlEvent;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.DisplayRenderer;
import visad.Flow1Control;
import visad.Flow2Control;
import visad.GraphicsModeControl;
import visad.KeyboardBehavior;
import visad.MouseBehavior;
import visad.PlotText;
import visad.ProjectionControl;
import visad.RangeControl;
import visad.RealType;
import visad.RendererControl;
import visad.RendererSourceListener;
import visad.ScalarMap;
import visad.ShapeControl;
import visad.TextControl;
import visad.VisADException;
import visad.VisADLineArray;
import visad.VisADRay;
import visad.VisADTriangleArray;
import visad.java3d.AnimationControlJ3D;
import visad.java3d.DefaultRendererJ3D;
import visad.java3d.DirectManipulationRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.KeyboardBehaviorJ3D;
import visad.java3d.MouseBehaviorJ3D;
import visad.java3d.ProjectionControlJ3D;
import visad.java3d.RendererJ3D;
import visad.java3d.ShadowTypeJ3D;
import visad.java3d.ValueControlJ3D;
import visad.java3d.VisADCanvasJ3D;
import visad.util.OBJWriter;
import visad.util.Util;

public abstract class DisplayRendererJ3D
extends DisplayRenderer
implements RendererSourceListener {
    private Object not_destroyed = new Object();
    private OrderedGroup screen_locked = null;
    private TransformGroup locked_trans = null;
    private View view;
    private VisADCanvasJ3D canvas;
    private BranchGroup root = null;
    private TransformGroup trans = null;
    private OrderedGroup non_direct = null;
    private TransformGroup vpTrans = null;
    private MouseBehaviorJ3D mouse = null;
    private KeyboardBehaviorJ3D keyboard = null;
    private ColoringAttributes box_color = null;
    private ColoringAttributes cursor_color = null;
    private Background background = null;
    private TransformGroup cursor_trans = null;
    private Switch cursor_switch = null;
    private BranchGroup cursor_on = null;
    private BranchGroup cursor_off = null;
    private boolean cursorOn = false;
    private boolean directOn = false;
    private Switch box_switch = null;
    private BranchGroup box_on = null;
    private BranchGroup box_off = null;
    private boolean boxOn = false;
    private Switch scale_switch = null;
    private BranchGroup scale_on = null;
    private BranchGroup scale_off = null;
    private Vector axis_vector = new Vector();
    private Vector directs = new Vector();
    private float cursorX;
    private float cursorY;
    private float cursorZ;
    private float line_x;
    private float line_y;
    private float line_z;
    private float point_x;
    private float point_y;
    private float point_z;
    private Method modelClipSetEnable = null;
    private Method modelClipSetPlane = null;
    private Method modelClipAddScope = null;
    private Object modelClip = null;
    private boolean[] modelClipEnables = new boolean[]{false, false, false, false, false, false};
    private boolean hasNotifyBeenCalled = false;
    private boolean waitingOnImageCapture = false;

    public static void setSceneGraphObjectName(SceneGraphObject obj, String name) {
        Util.setName(obj, name);
    }

    public void destroy() {
        this.not_destroyed = null;
        if (this.canvas != null) {
            this.canvas.stop();
        }
        if (this.mouse != null) {
            this.mouse.destroy();
        }
        if (this.root != null) {
            this.root.detach();
            this.root = null;
        }
        this.axis_vector.removeAllElements();
        this.directs.removeAllElements();
        this.screen_locked = null;
        this.locked_trans = null;
        this.trans = null;
        this.vpTrans = null;
        this.non_direct = null;
        this.view = null;
        this.canvas = null;
        this.mouse = null;
        this.box_color = null;
        this.cursor_color = null;
        this.background = null;
        this.cursor_trans = null;
        this.cursor_switch = null;
        this.cursor_on = null;
        this.cursor_off = null;
        this.box_switch = null;
        this.box_on = null;
        this.box_off = null;
        this.scale_switch = null;
        this.scale_on = null;
        this.scale_off = null;
    }

    @Override
    public void setDisplay(DisplayImpl dpy) throws VisADException {
        if (this.not_destroyed == null) {
            return;
        }
        super.setDisplay(dpy);
        dpy.addRendererSourceListener(this);
        this.boxOn = this.getRendererControl().getBoxOn();
    }

    public View getView() {
        return this.view;
    }

    public TransformGroup getViewTrans() {
        return this.vpTrans;
    }

    public VisADCanvasJ3D getCanvas() {
        return this.canvas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage getImage() {
        if (this.not_destroyed == null) {
            return null;
        }
        BufferedImage image = null;
        this.canvas.captureImage = null;
        ProjectionControl proj = this.getDisplay().getProjectionControl();
        double[] matrix = proj.getMatrix();
        while (image == null) {
            try {
                DisplayRendererJ3D displayRendererJ3D = this;
                synchronized (displayRendererJ3D) {
                    this.canvas.setDoubleBufferEnable(false);
                    this.canvas.captureFlag = true;
                    this.hasNotifyBeenCalled = false;
                    if (this.canvas.getOffscreen()) {
                        try {
                            Method renderMethod = Canvas3D.class.getMethod("renderOffScreenBuffer", new Class[0]);
                            renderMethod.invoke((Object)this.canvas, new Object[0]);
                        }
                        catch (NoSuchMethodException renderMethod) {
                        }
                        catch (IllegalAccessException renderMethod) {
                        }
                        catch (InvocationTargetException renderMethod) {
                            // empty catch block
                        }
                    }
                    try {
                        proj.setMatrix(matrix);
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                    }
                    catch (VisADException e) {
                        e.printStackTrace();
                    }
                    image = this.canvas.captureImage;
                    if (image == null && !this.hasNotifyBeenCalled) {
                        this.waitingOnImageCapture = true;
                        this.wait();
                        this.waitingOnImageCapture = false;
                    }
                }
            }
            catch (InterruptedException e) {
                this.canvas.setDoubleBufferEnable(true);
                e.printStackTrace();
            }
            if (image == null) {
                image = this.canvas.captureImage;
            }
            this.canvas.captureImage = null;
            this.canvas.setDoubleBufferEnable(true);
            if (image != null) continue;
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyCapture() {
        this.hasNotifyBeenCalled = true;
        if (this.waitingOnImageCapture) {
            this.waitingOnImageCapture = false;
            DisplayRendererJ3D displayRendererJ3D = this;
            synchronized (displayRendererJ3D) {
                this.notify();
            }
        }
    }

    @Override
    public void saveSceneToFile(final File file) throws VisADException, RemoteException {
        Runnable writeFile = new Runnable(){

            @Override
            public void run() {
                try {
                    DisplayRendererJ3D.this.write(file);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.getDisplay().queue(writeFile);
    }

    private void write(File file) throws Exception {
        OBJWriter writer = new OBJWriter(file);
        writer.writeNode((Node)this.non_direct);
        writer.close();
    }

    public BranchGroup getRoot() {
        return this.root;
    }

    @Override
    public void initControl(RendererControl ctl) {
        if (this.not_destroyed == null) {
            return;
        }
        Color3f c3f = new Color3f();
        if (this.box_color != null) {
            this.box_color.getColor(c3f);
            try {
                ctl.setBoxColor(c3f.x, c3f.y, c3f.z);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.cursor_color != null) {
            this.cursor_color.getColor(c3f);
            try {
                ctl.setCursorColor(c3f.x, c3f.y, c3f.z);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.background != null) {
            this.background.getColor(c3f);
            try {
                ctl.setBackgroundColor(c3f.x, c3f.y, c3f.z);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            ctl.setBoxOn(this.boxOn);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void controlChanged(ControlEvent evt) {
        boolean on;
        float[] ct;
        if (this.not_destroyed == null) {
            return;
        }
        RendererControl ctl = (RendererControl)evt.getControl();
        Color3f c3f = new Color3f();
        if (this.box_color != null) {
            ct = ctl.getBoxColor();
            this.box_color.getColor(c3f);
            if (!(Util.isApproximatelyEqual(ct[0], c3f.x) && Util.isApproximatelyEqual(ct[1], c3f.y) && Util.isApproximatelyEqual(ct[2], c3f.z))) {
                this.box_color.setColor(ct[0], ct[1], ct[2]);
            }
        }
        if (this.cursor_color != null) {
            ct = ctl.getCursorColor();
            this.cursor_color.getColor(c3f);
            if (!(Util.isApproximatelyEqual(ct[0], c3f.x) && Util.isApproximatelyEqual(ct[1], c3f.y) && Util.isApproximatelyEqual(ct[2], c3f.z))) {
                this.cursor_color.setColor(ct[0], ct[1], ct[2]);
            }
        }
        ct = ctl.getBackgroundColor();
        this.background.getColor(c3f);
        if (!(Util.isApproximatelyEqual(ct[0], c3f.x) && Util.isApproximatelyEqual(ct[1], c3f.y) && Util.isApproximatelyEqual(ct[2], c3f.z))) {
            this.background.setColor(ct[0], ct[1], ct[2]);
        }
        if ((on = ctl.getBoxOn()) != this.boxOn) {
            this.boxOn = on;
            this.box_switch.setWhichChild(this.boxOn ? 1 : 0);
        }
    }

    public TransformGroup getTrans() {
        return this.trans;
    }

    public BranchGroup getCursorOnBranch() {
        return this.cursor_on;
    }

    public BranchGroup getBoxOnBranch() {
        return this.box_on;
    }

    @Override
    public void setCursorOn(boolean on) {
        if (this.not_destroyed == null) {
            return;
        }
        this.cursorOn = on;
        if (on) {
            this.cursor_switch.setWhichChild(1);
            this.setCursorStringVector();
        } else {
            this.cursor_switch.setWhichChild(0);
            this.setCursorStringVector(null);
        }
    }

    @Override
    public void setDirectOn(boolean on) {
        if (this.not_destroyed == null) {
            return;
        }
        this.directOn = on;
        if (!on) {
            this.setCursorStringVector(null);
        }
    }

    public abstract BranchGroup createSceneGraph(View var1, TransformGroup var2, VisADCanvasJ3D var3);

    public BranchGroup createBasicSceneGraph(View v, TransformGroup vpt, VisADCanvasJ3D c, MouseBehaviorJ3D m) {
        if (this.not_destroyed == null) {
            return null;
        }
        this.box_color = new ColoringAttributes();
        this.box_color.setCapability(0);
        this.box_color.setCapability(1);
        this.cursor_color = new ColoringAttributes();
        this.cursor_color.setCapability(0);
        this.cursor_color.setCapability(1);
        return this.createBasicSceneGraph(v, vpt, c, m, this.box_color, this.cursor_color);
    }

    public BranchGroup createBasicSceneGraph(View v, TransformGroup vpt, VisADCanvasJ3D c, MouseBehaviorJ3D m, ColoringAttributes bc, ColoringAttributes cc) {
        if (this.root != null) {
            return this.root;
        }
        if (this.not_destroyed == null) {
            return null;
        }
        this.mouse = m;
        this.view = v;
        this.vpTrans = vpt;
        this.box_color = bc;
        this.cursor_color = cc;
        v.setDepthBufferFreezeTransparent(false);
        this.canvas = c;
        this.root = new BranchGroup();
        DisplayRendererJ3D.setSceneGraphObjectName((SceneGraphObject)this.root, "Root");
        this.root.setCapability(17);
        this.root.setCapability(12);
        this.root.setCapability(13);
        this.root.setCapability(14);
        this.setTransform3D(null);
        this.root.addChild((Node)this.trans);
        this.background = new Background();
        DisplayRendererJ3D.setSceneGraphObjectName((SceneGraphObject)this.background, "Background");
        this.background.setCapability(17);
        this.background.setCapability(16);
        float[] ctlBg = this.getRendererControl().getBackgroundColor();
        this.background.setColor(ctlBg[0], ctlBg[1], ctlBg[2]);
        BoundingSphere bound2 = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 2000000.0);
        this.background.setApplicationBounds((Bounds)bound2);
        this.root.addChild((Node)this.background);
        this.non_direct = new OrderedGroup();
        DisplayRendererJ3D.setSceneGraphObjectName((SceneGraphObject)this.non_direct, "NonDirect");
        this.non_direct.setCapability(12);
        this.non_direct.setCapability(13);
        this.non_direct.setCapability(14);
        this.non_direct.setCapability(1);
        this.trans.addChild((Node)this.non_direct);
        this.cursor_trans = new TransformGroup();
        DisplayRendererJ3D.setSceneGraphObjectName((SceneGraphObject)this.cursor_trans, "CursorTrans");
        this.cursor_trans.setCapability(17);
        this.cursor_trans.setCapability(18);
        this.cursor_trans.setCapability(12);
        this.cursor_trans.setCapability(13);
        this.cursor_trans.setCapability(14);
        this.trans.addChild((Node)this.cursor_trans);
        this.cursor_switch = new Switch();
        DisplayRendererJ3D.setSceneGraphObjectName((SceneGraphObject)this.cursor_switch, "CursorSwitch");
        this.cursor_switch.setCapability(17);
        this.cursor_switch.setCapability(18);
        this.cursor_switch.setCapability(12);
        this.cursor_trans.addChild((Node)this.cursor_switch);
        this.cursor_on = new BranchGroup();
        DisplayRendererJ3D.setSceneGraphObjectName((SceneGraphObject)this.cursor_on, "CursorOn");
        this.cursor_on.setCapability(12);
        this.cursor_on.setCapability(13);
        this.cursor_off = new BranchGroup();
        DisplayRendererJ3D.setSceneGraphObjectName((SceneGraphObject)this.cursor_off, "CursorOff");
        this.cursor_off.setCapability(12);
        this.cursor_switch.addChild((Node)this.cursor_off);
        this.cursor_switch.addChild((Node)this.cursor_on);
        this.cursor_switch.setWhichChild(0);
        this.cursorOn = false;
        this.box_switch = new Switch();
        DisplayRendererJ3D.setSceneGraphObjectName((SceneGraphObject)this.box_switch, "BoxSwitch");
        this.box_switch.setCapability(17);
        this.box_switch.setCapability(18);
        this.box_switch.setCapability(12);
        this.trans.addChild((Node)this.box_switch);
        this.box_on = new BranchGroup();
        DisplayRendererJ3D.setSceneGraphObjectName((SceneGraphObject)this.box_on, "BoxOn");
        this.box_on.setCapability(12);
        this.box_on.setCapability(13);
        this.box_off = new BranchGroup();
        DisplayRendererJ3D.setSceneGraphObjectName((SceneGraphObject)this.box_off, "BoxOff");
        this.box_off.setCapability(12);
        this.box_switch.addChild((Node)this.box_off);
        this.box_switch.addChild((Node)this.box_on);
        this.box_switch.setWhichChild(1);
        try {
            this.setBoxOn(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.scale_switch = new Switch();
        DisplayRendererJ3D.setSceneGraphObjectName((SceneGraphObject)this.scale_switch, "ScaleSwitch");
        this.scale_switch.setCapability(17);
        this.scale_switch.setCapability(18);
        this.scale_switch.setCapability(12);
        this.trans.addChild((Node)this.scale_switch);
        this.scale_on = new BranchGroup();
        DisplayRendererJ3D.setSceneGraphObjectName((SceneGraphObject)this.scale_on, "ScaleOn");
        this.scale_on.setCapability(12);
        this.scale_on.setCapability(13);
        this.scale_on.setCapability(14);
        this.scale_off = new BranchGroup();
        DisplayRendererJ3D.setSceneGraphObjectName((SceneGraphObject)this.scale_off, "ScaleOff");
        this.scale_off.setCapability(12);
        this.scale_switch.addChild((Node)this.scale_off);
        this.scale_switch.addChild((Node)this.scale_on);
        this.scale_switch.setWhichChild(0);
        try {
            Class<?> modelClipClass = Class.forName("javax.media.j3d.ModelClip");
            Class[] param = new Class[]{};
            Constructor<?> modelClipConstructor = modelClipClass.getConstructor(param);
            param = new Class[]{Integer.TYPE, Boolean.TYPE};
            this.modelClipSetEnable = modelClipClass.getMethod("setEnable", param);
            param = new Class[]{Integer.TYPE, Vector4d.class};
            this.modelClipSetPlane = modelClipClass.getMethod("setPlane", param);
            param = new Class[]{Group.class};
            this.modelClipAddScope = modelClipClass.getMethod("addScope", param);
            param = new Class[]{Integer.TYPE};
            Method modelClipSetCapability = modelClipClass.getMethod("setCapability", param);
            param = new Class[]{Bounds.class};
            Method modelClipSetInfluencingBounds = modelClipClass.getMethod("setInfluencingBounds", param);
            this.modelClip = modelClipConstructor.newInstance(new Object[0]);
            int ALLOW_PLANE_WRITE = modelClipClass.getField("ALLOW_PLANE_WRITE").getInt(this.modelClip);
            modelClipSetCapability.invoke(this.modelClip, new Integer(ALLOW_PLANE_WRITE));
            int ALLOW_ENABLE_WRITE = modelClipClass.getField("ALLOW_ENABLE_WRITE").getInt(this.modelClip);
            modelClipSetCapability.invoke(this.modelClip, new Integer(ALLOW_ENABLE_WRITE));
            Boolean f = new Boolean(false);
            for (int i = 0; i < 6; ++i) {
                this.modelClipSetEnable.invoke(this.modelClip, new Integer(i), f);
            }
            BoundingSphere bound3 = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 2000000.0);
            modelClipSetInfluencingBounds.invoke(this.modelClip, bound3);
            this.background.setApplicationBounds((Bounds)bound2);
            this.modelClipAddScope.invoke(this.modelClip, this.non_direct);
            DisplayRendererJ3D.setSceneGraphObjectName((SceneGraphObject)((Node)this.modelClip), "ModelClip");
            this.trans.addChild((Node)this.modelClip);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return this.root;
    }

    public void setClip(int plane, boolean enable, float a, float b, float c, float d) throws VisADException {
        if (this.not_destroyed == null) {
            return;
        }
        if (plane < 0 || 5 < plane) {
            throw new DisplayException("plane must be in 0,...,5 range " + plane);
        }
        if (this.modelClip == null || this.modelClipSetEnable == null || this.modelClipSetPlane == null) {
            throw new DisplayException("model clipping not supported in this version of Java3D");
        }
        Vector4d vect = new Vector4d((double)a, (double)b, (double)c, (double)d);
        try {
            Object[] params = new Object[]{new Integer(plane), new Boolean(enable)};
            this.modelClipSetEnable.invoke(this.modelClip, params);
            params = new Object[]{new Integer(plane), vect};
            this.modelClipSetPlane.invoke(this.modelClip, params);
            this.modelClipEnables[plane] = enable;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private void clipOff() {
        if (this.not_destroyed == null) {
            return;
        }
        try {
            for (int i = 0; i < 6; ++i) {
                if (!this.modelClipEnables[i]) continue;
                Object[] params = new Object[]{new Integer(i), new Boolean(false)};
                this.modelClipSetEnable.invoke(this.modelClip, params);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private void clipOn() {
        if (this.not_destroyed == null) {
            return;
        }
        try {
            for (int i = 0; i < 6; ++i) {
                if (!this.modelClipEnables[i]) continue;
                Object[] params = new Object[]{new Integer(i), new Boolean(true)};
                this.modelClipSetEnable.invoke(this.modelClip, params);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    public MouseBehavior getMouseBehavior() {
        return this.mouse;
    }

    public KeyboardBehavior getKeyboardBehavior() {
        return this.keyboard;
    }

    public void addSceneGraphComponent(Group group) {
        if (this.not_destroyed == null) {
            return;
        }
        this.non_direct.addChild((Node)group);
    }

    public void addLockedSceneGraphComponent(Group group) {
        if (this.not_destroyed == null || this.screen_locked == null) {
            return;
        }
        this.screen_locked.addChild((Node)group);
    }

    public void addLockedSceneGraphComponent(Group group, boolean initWithProj) {
        if (this.not_destroyed == null || this.screen_locked == null) {
            return;
        }
        if (initWithProj) {
            ProjectionControl proj = this.getDisplay().getProjectionControl();
            this.locked_trans.setTransform(new Transform3D(proj.getMatrix()));
        }
        this.screen_locked.addChild((Node)group);
    }

    public void updateLockedTrans(double[] matrix) {
        if (this.locked_trans != null) {
            this.locked_trans.setTransform(new Transform3D(matrix));
        }
    }

    public void addDirectManipulationSceneGraphComponent(Group group, DirectManipulationRendererJ3D renderer) {
        if (this.not_destroyed == null) {
            return;
        }
        this.non_direct.addChild((Node)group);
        this.directs.addElement(renderer);
    }

    public void clearScene(DataRenderer renderer) {
        if (this.not_destroyed == null) {
            return;
        }
        this.directs.removeElement(renderer);
    }

    @Override
    public double[] getCursor() {
        double[] cursor = new double[]{this.cursorX, this.cursorY, this.cursorZ};
        return cursor;
    }

    @Override
    public void depth_cursor(VisADRay ray) {
        this.line_x = (float)ray.vector[0];
        this.line_y = (float)ray.vector[1];
        this.line_z = (float)ray.vector[2];
        this.point_x = this.cursorX;
        this.point_y = this.cursorY;
        this.point_z = this.cursorZ;
    }

    @Override
    public void drag_depth(float diff) {
        if (this.not_destroyed == null) {
            return;
        }
        this.cursorX = this.point_x + diff * this.line_x;
        this.cursorY = this.point_y + diff * this.line_y;
        this.cursorZ = this.point_z + diff * this.line_z;
        this.setCursorLoc();
    }

    @Override
    public void drag_cursor(VisADRay ray, boolean first) {
        if (this.not_destroyed == null) {
            return;
        }
        float o_x = (float)ray.position[0];
        float o_y = (float)ray.position[1];
        float o_z = (float)ray.position[2];
        float d_x = (float)ray.vector[0];
        float d_y = (float)ray.vector[1];
        float d_z = (float)ray.vector[2];
        if (first) {
            this.line_x = d_x;
            this.line_y = d_y;
            this.line_z = d_z;
        }
        float dot = (this.cursorX - o_x) * this.line_x + (this.cursorY - o_y) * this.line_y + (this.cursorZ - o_z) * this.line_z;
        float dot2 = d_x * this.line_x + d_y * this.line_y + d_z * this.line_z;
        if ((double)dot2 == 0.0) {
            return;
        }
        this.cursorX = o_x + (dot /= dot2) * d_x;
        this.cursorY = o_y + dot * d_y;
        this.cursorZ = o_z + dot * d_z;
        this.setCursorLoc();
    }

    private void setCursorLoc() {
        if (this.not_destroyed == null) {
            return;
        }
        Transform3D t = new Transform3D();
        t.setTranslation(new Vector3f(this.cursorX, this.cursorY, this.cursorZ));
        this.cursor_trans.setTransform(t);
        if (this.cursorOn) {
            this.setCursorStringVector();
        }
    }

    public void setCursorLoc(float x, float y, float z) {
        if (this.not_destroyed == null) {
            return;
        }
        Transform3D t = new Transform3D();
        t.setTranslation(new Vector3f(x, y, z));
        this.cursor_trans.setTransform(t);
        if (this.cursorOn) {
            this.setCursorStringVector();
        }
    }

    public void drawCursorStringVector(VisADCanvasJ3D canvas) {
        String[] animation_string;
        if (this.not_destroyed == null) {
            return;
        }
        GraphicsContext3D graphics = canvas.getGraphicsContext3D();
        try {
            float[] c3 = this.getCursorColor();
            Appearance appearance = new Appearance();
            ColoringAttributes color = new ColoringAttributes();
            color.setColor(new Color3f(c3));
            appearance.setColoringAttributes(color);
            graphics.setAppearance(appearance);
        }
        catch (Exception c3) {
            // empty catch block
        }
        Point3d position1 = new Point3d();
        Point3d position2 = new Point3d();
        Point3d position3 = new Point3d();
        canvas.getPixelLocationInImagePlate(1, 10, position1);
        canvas.getPixelLocationInImagePlate(10, 10, position2);
        canvas.getPixelLocationInImagePlate(1, 1, position3);
        DisplayImpl display = this.getDisplay();
        if (display != null && display.getGraphicsModeControl() != null && this.getDisplay().getGraphicsModeControl().getProjectionPolicy() == 1) {
            Point3d left_eye = new Point3d();
            Point3d right_eye = new Point3d();
            canvas.getLeftEyeInImagePlate(left_eye);
            canvas.getRightEyeInImagePlate(right_eye);
            Point3d eye = new Point3d((left_eye.x + right_eye.x) / 2.0, (left_eye.y + right_eye.y) / 2.0, (left_eye.z + right_eye.z) / 2.0);
            double alpha = 0.3;
            position1.x = alpha * position1.x + (1.0 - alpha) * eye.x;
            position1.y = alpha * position1.y + (1.0 - alpha) * eye.y;
            position1.z = alpha * position1.z + (1.0 - alpha) * eye.z;
            position2.x = alpha * position2.x + (1.0 - alpha) * eye.x;
            position2.y = alpha * position2.y + (1.0 - alpha) * eye.y;
            position2.z = alpha * position2.z + (1.0 - alpha) * eye.z;
            position3.x = alpha * position3.x + (1.0 - alpha) * eye.x;
            position3.y = alpha * position3.y + (1.0 - alpha) * eye.y;
            position3.z = alpha * position3.z + (1.0 - alpha) * eye.z;
        }
        Transform3D t = new Transform3D();
        canvas.getImagePlateToVworld(t);
        t.transform(position1);
        t.transform(position2);
        t.transform(position3);
        double[] start = new double[]{position1.x, position1.y, position1.z};
        double[] base = new double[]{position2.x - position1.x, position2.y - position1.y, position2.z - position1.z};
        double[] up = new double[]{position3.x - position1.x, position3.y - position1.y, position3.z - position1.z};
        if (this.cursorOn || this.directOn) {
            Enumeration strings = this.getCursorStringVector().elements();
            while (strings.hasMoreElements()) {
                String string = (String)strings.nextElement();
                if (string == null || string.trim().isEmpty()) continue;
                try {
                    VisADLineArray array = PlotText.render_label(string, start, base, up, false);
                    graphics.draw((Geometry)((DisplayImplJ3D)this.getDisplay()).makeGeometry(array));
                    start[1] = start[1] - 1.2 * up[1];
                }
                catch (VisADException array) {}
            }
        }
        double[] startl = new double[]{position3.x, -position3.y, position3.z};
        Vector rendererVector = this.getDisplay().getRendererVector();
        Enumeration renderers = rendererVector.elements();
        while (renderers.hasMoreElements()) {
            DataRenderer renderer = (DataRenderer)renderers.nextElement();
            Vector exceptionVector = renderer.getExceptionVector();
            Enumeration exceptions = exceptionVector.elements();
            while (exceptions.hasMoreElements()) {
                Exception error = (Exception)exceptions.nextElement();
                String string = error.getMessage();
                try {
                    VisADLineArray array = PlotText.render_label(string, startl, base, up, false);
                    graphics.draw((Geometry)((DisplayImplJ3D)this.getDisplay()).makeGeometry(array));
                    startl[1] = startl[1] + 1.2 * up[1];
                }
                catch (VisADException visADException) {}
            }
        }
        if (this.getWaitFlag() && this.getWaitMessageVisible()) {
            try {
                VisADLineArray array = PlotText.render_label("please wait . . .", startl, base, up, false);
                graphics.draw((Geometry)((DisplayImplJ3D)this.getDisplay()).makeGeometry(array));
                startl[1] = startl[1] + 1.2 * up[1];
            }
            catch (VisADException array) {
                // empty catch block
            }
        }
        if ((animation_string = this.getAnimationString())[0] != null) {
            int nchars = animation_string[0].length();
            if (nchars < 12) {
                nchars = 12;
            }
            double[] starta = new double[]{-position2.x - (double)nchars * (position2.x - position1.x), -position3.y + 1.2 * up[1], position2.z};
            try {
                VisADLineArray array = PlotText.render_label(animation_string[0], starta, base, up, false);
                graphics.draw((Geometry)((DisplayImplJ3D)this.getDisplay()).makeGeometry(array));
                starta[1] = starta[1] - 1.2 * up[1];
                if (animation_string[1] != null) {
                    array = PlotText.render_label(animation_string[1], starta, base, up, false);
                    graphics.draw((Geometry)((DisplayImplJ3D)this.getDisplay()).makeGeometry(array));
                    starta[1] = starta[1] - 1.2 * up[1];
                }
            }
            catch (VisADException array) {
                // empty catch block
            }
        }
        if (this.scale_switch != null && this.scale_switch.getWhichChild() == 1) {
            Dimension d = canvas.getSize();
            int w = d.width;
            int h = d.height;
            double MUL = 3.0 * (double)w / 256.0;
            double XMAX = Math.abs(MUL * position2.x - (MUL - 1.0) * position3.x);
            double YMAX = Math.abs(MUL * position2.y - (MUL - 1.0) * position3.y);
            double XMIN = -XMAX;
            double YMIN = -YMAX;
            TransformGroup trans = this.getTrans();
            Transform3D tt = new Transform3D();
            trans.getTransform(tt);
            tt.invert();
            Point3d positionx = new Point3d(XMAX, YMAX, 0.0);
            Point3d positionn = new Point3d(XMIN, YMIN, 0.0);
            tt.transform(positionx);
            tt.transform(positionn);
            double XTMAX = positionx.x;
            double YTMAX = positionx.y;
            double XTMIN = positionn.x;
            double YTMIN = positionn.y;
            Enumeration axes = this.axis_vector.elements();
            while (axes.hasMoreElements()) {
                AxisScale axisScale = (AxisScale)axes.nextElement();
                try {
                    boolean success = axisScale.makeScreenBasedScale(XMIN, YMIN, XMAX, YMAX, XTMIN, YTMIN, XTMAX, YTMAX);
                    if (!success) continue;
                    int axis = axisScale.getAxis();
                    int axis_ordinal = axisScale.getAxisOrdinal();
                    VisADLineArray array = axisScale.getScaleArray();
                    VisADTriangleArray labels = axisScale.getLabelArray();
                    float[] scale_color = axisScale.getColor().getColorComponents(null);
                    Appearance appearance = new Appearance();
                    ColoringAttributes color = new ColoringAttributes();
                    color.setColor(new Color3f(scale_color));
                    appearance.setColoringAttributes(color);
                    graphics.setAppearance(appearance);
                    graphics.draw((Geometry)((DisplayImplJ3D)this.getDisplay()).makeGeometry(array));
                    if (labels == null) continue;
                    GeometryArray labelGeometry = ((DisplayImplJ3D)this.getDisplay()).makeGeometry(labels);
                    Appearance labelAppearance = ShadowTypeJ3D.staticMakeAppearance(this.getDisplay().getGraphicsModeControl(), null, null, labelGeometry, true);
                    graphics.setAppearance(labelAppearance);
                    graphics.draw((Geometry)labelGeometry);
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public DataRenderer findDirect(VisADRay ray, int mouseModifiers) {
        if (this.not_destroyed == null) {
            return null;
        }
        DirectManipulationRendererJ3D renderer = null;
        float distance = Float.MAX_VALUE;
        Enumeration renderers = ((Vector)this.directs.clone()).elements();
        while (renderers.hasMoreElements()) {
            DirectManipulationRendererJ3D r = (DirectManipulationRendererJ3D)renderers.nextElement();
            if (!r.getEnabled()) continue;
            r.setLastMouseModifiers(mouseModifiers);
            float d = r.checkClose(ray.position, ray.vector);
            if (!(d < distance)) continue;
            distance = d;
            renderer = r;
        }
        if (distance < this.getPickThreshhold()) {
            return renderer;
        }
        return null;
    }

    @Override
    public boolean anyDirects() {
        if (this.not_destroyed == null) {
            return false;
        }
        return !this.directs.isEmpty();
    }

    @Override
    public void setScaleOn(boolean on) {
        if (this.not_destroyed == null) {
            return;
        }
        if (on) {
            this.scale_switch.setWhichChild(1);
        } else {
            this.scale_switch.setWhichChild(0);
        }
    }

    @Override
    public void setScale(AxisScale axisScale) throws VisADException {
        if (this.not_destroyed == null) {
            return;
        }
        if (axisScale.getScreenBased() && this.getMode2D()) {
            if (!this.axis_vector.contains(axisScale)) {
                this.axis_vector.addElement(axisScale);
                this.clearScale(axisScale);
            }
        } else {
            this.setScale(axisScale.getAxis(), axisScale.getAxisOrdinal(), axisScale.getScaleArray(), axisScale.getLabelArray(), axisScale.getColor().getColorComponents(null));
        }
    }

    @Override
    public void setScale(int axis, int axis_ordinal, VisADLineArray array, float[] scale_color) throws VisADException {
        if (this.not_destroyed == null) {
            return;
        }
        this.setScale(axis, axis_ordinal, array, null, scale_color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setScale(int axis, int axis_ordinal, VisADLineArray array, VisADTriangleArray labels, float[] scale_color) throws VisADException {
        if (this.not_destroyed == null) {
            return;
        }
        DisplayImplJ3D display = (DisplayImplJ3D)this.getDisplay();
        GeometryArray geometry = display.makeGeometry(array);
        GraphicsModeControl mode = display.getGraphicsModeControl();
        ColoringAttributes color = new ColoringAttributes();
        color.setColor(scale_color[0], scale_color[1], scale_color[2]);
        Appearance appearance = ShadowTypeJ3D.staticMakeAppearance(mode, null, color, geometry, false);
        Shape3D shape = new Shape3D((Geometry)geometry, appearance);
        shape.setCapability(12);
        shape.setCapability(14);
        BranchGroup group = new BranchGroup();
        group.setCapability(17);
        group.setCapability(12);
        group.addChild((Node)shape);
        if (labels != null) {
            GeometryArray labelGeometry = display.makeGeometry(labels);
            Appearance labelAppearance = ShadowTypeJ3D.staticMakeAppearance(mode, null, null, labelGeometry, true);
            Shape3D labelShape = new Shape3D((Geometry)labelGeometry, labelAppearance);
            labelShape.setCapability(12);
            labelShape.setCapability(14);
            group.addChild((Node)labelShape);
            if (labels instanceof VisADTriangleArray) {
                GeometryArray labelGeometry2 = display.makeGeometry(labels);
                Appearance labelAppearance2 = ShadowTypeJ3D.staticMakeAppearance(mode, null, null, labelGeometry2, true);
                PolygonAttributes pa = labelAppearance2.getPolygonAttributes();
                pa.setPolygonMode(1);
                Shape3D labelShape2 = new Shape3D((Geometry)labelGeometry2, labelAppearance2);
                labelShape2.setCapability(12);
                labelShape2.setCapability(14);
                group.addChild((Node)labelShape2);
            }
        }
        int dim = this.getMode2D() ? 2 : 3;
        BranchGroup branchGroup = this.scale_on;
        synchronized (branchGroup) {
            int n = this.scale_on.numChildren();
            int m = dim * axis_ordinal + axis;
            if (m >= n) {
                for (int i = n; i <= m; ++i) {
                    BranchGroup empty = new BranchGroup();
                    empty.setCapability(17);
                    empty.setCapability(12);
                    this.scale_on.addChild((Node)empty);
                }
            }
            this.scale_on.setChild((Node)group, m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearScales() {
        if (this.not_destroyed == null) {
            return;
        }
        if (this.scale_on != null) {
            BranchGroup branchGroup = this.scale_on;
            synchronized (branchGroup) {
                int n = this.scale_on.numChildren();
                for (int i = n - 1; i >= 0; --i) {
                    this.scale_on.removeChild(i);
                }
            }
        }
        this.axis_vector.removeAllElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearScale(AxisScale axisScale) {
        if (this.not_destroyed == null) {
            return;
        }
        int axis = axisScale.getAxis();
        int axis_ordinal = axisScale.getAxisOrdinal();
        int dim = this.getMode2D() ? 2 : 3;
        BranchGroup branchGroup = this.scale_on;
        synchronized (branchGroup) {
            int n = this.scale_on.numChildren();
            int m = dim * axis_ordinal + axis;
            if (m >= n) {
                for (int i = n; i <= m; ++i) {
                    BranchGroup empty = new BranchGroup();
                    empty.setCapability(17);
                    empty.setCapability(12);
                    this.scale_on.addChild((Node)empty);
                }
            }
            BranchGroup empty = new BranchGroup();
            empty.setCapability(17);
            empty.setCapability(12);
            this.scale_on.setChild((Node)empty, m);
        }
    }

    public void setTransform3D(Transform3D t) {
        if (this.not_destroyed == null) {
            return;
        }
        if (this.trans == null) {
            this.trans = new TransformGroup();
            DisplayRendererJ3D.setSceneGraphObjectName((SceneGraphObject)this.trans, "Trans");
            this.trans.setCapability(17);
            this.trans.setCapability(18);
            this.trans.setCapability(12);
            this.trans.setCapability(13);
            this.trans.setCapability(14);
        }
        if (t != null) {
            this.trans.setTransform(t);
            if (this.locked_trans == null && this.root != null) {
                this.locked_trans = new TransformGroup();
                DisplayRendererJ3D.setSceneGraphObjectName((SceneGraphObject)this.locked_trans, "LockedTrans");
                this.locked_trans.setCapability(17);
                this.locked_trans.setCapability(18);
                this.locked_trans.setCapability(12);
                this.locked_trans.setCapability(13);
                this.locked_trans.setCapability(14);
                this.locked_trans.setTransform(t);
                this.screen_locked = new OrderedGroup();
                DisplayRendererJ3D.setSceneGraphObjectName((SceneGraphObject)this.screen_locked, "ScreenLocked");
                this.screen_locked.setCapability(12);
                this.screen_locked.setCapability(13);
                this.screen_locked.setCapability(14);
                this.screen_locked.setCapability(1);
                this.locked_trans.addChild((Node)this.screen_locked);
                BranchGroup bgroup = new BranchGroup();
                DisplayRendererJ3D.setSceneGraphObjectName((SceneGraphObject)bgroup, "LockedGroup");
                bgroup.setCapability(12);
                bgroup.setCapability(13);
                bgroup.setCapability(14);
                bgroup.addChild((Node)this.locked_trans);
                this.root.addChild((Node)bgroup);
            }
        }
    }

    @Override
    public Control makeControl(ScalarMap map) {
        if (this.not_destroyed == null) {
            return null;
        }
        DisplayRealType type = map.getDisplayScalar();
        DisplayImplJ3D display = (DisplayImplJ3D)this.getDisplay();
        if (type == null) {
            return null;
        }
        if (type.equals(Display.XAxis) || type.equals(Display.YAxis) || type.equals(Display.ZAxis) || type.equals(Display.Latitude) || type.equals(Display.Longitude) || type.equals(Display.Radius)) {
            return (ProjectionControlJ3D)display.getProjectionControl();
        }
        if (type.equals(Display.RGB) || type.equals(Display.HSV) || type.equals(Display.CMY)) {
            return new ColorControl(display);
        }
        if (type.equals(Display.RGBA)) {
            return new ColorAlphaControl(display);
        }
        if (type.equals(Display.Animation)) {
            Control control = display.getControl(AnimationControlJ3D.class);
            if (control != null) {
                return control;
            }
            return new AnimationControlJ3D(display, (RealType)map.getScalar());
        }
        if (type.equals(Display.SelectValue)) {
            return new ValueControlJ3D(display);
        }
        if (type.equals(Display.SelectRange)) {
            return new RangeControl(display);
        }
        if (type.equals(Display.IsoContour)) {
            return new ContourControl(display);
        }
        if (type.equals(Display.Flow1X) || type.equals(Display.Flow1Y) || type.equals(Display.Flow1Z) || type.equals(Display.Flow1Elevation) || type.equals(Display.Flow1Azimuth) || type.equals(Display.Flow1Radial)) {
            Control control = display.getControl(Flow1Control.class);
            if (control != null) {
                return control;
            }
            return new Flow1Control(display);
        }
        if (type.equals(Display.Flow2X) || type.equals(Display.Flow2Y) || type.equals(Display.Flow2Z) || type.equals(Display.Flow2Elevation) || type.equals(Display.Flow2Azimuth) || type.equals(Display.Flow2Radial)) {
            Control control = display.getControl(Flow2Control.class);
            if (control != null) {
                return control;
            }
            return new Flow2Control(display);
        }
        if (type.equals(Display.Shape)) {
            return new ShapeControl(display);
        }
        if (type.equals(Display.Text)) {
            return new TextControl(display);
        }
        return null;
    }

    @Override
    public DataRenderer makeDefaultRenderer() {
        return new DefaultRendererJ3D();
    }

    @Override
    public boolean legalDataRenderer(DataRenderer renderer) {
        return renderer instanceof RendererJ3D;
    }

    @Override
    public void rendererDeleted(DataRenderer renderer) {
        if (this.not_destroyed == null) {
            return;
        }
        this.clearScene(renderer);
    }

    public void setLineWidth(float width) {
    }

    public void addKeyboardBehavior(KeyboardBehaviorJ3D behavior) {
        if (this.not_destroyed == null) {
            return;
        }
        BranchGroup bg = new BranchGroup();
        bg.setCapability(12);
        bg.addChild((Node)behavior);
        this.trans.addChild((Node)bg);
    }

    @Override
    public void render_trigger() {
        ProjectionControl proj = this.getDisplay().getProjectionControl();
        try {
            if (proj != null) {
                proj.setMatrix(proj.getMatrix());
            }
        }
        catch (VisADException visADException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void setWaitFlag(boolean b) {
        if (this.not_destroyed == null) {
            return;
        }
        boolean old = this.getWaitFlag();
        super.setWaitFlag(b);
        if (b != old) {
            this.render_trigger();
        }
    }

    @Override
    public int getTextureWidthMax() {
        return VisADCanvasJ3D.getTextureWidthMax();
    }

    @Override
    public int getTextureHeightMax() {
        return VisADCanvasJ3D.getTextureWidthMax();
    }
}

