/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.util.Arrays;
import visad.util.Interpolator;

public class LinearInterpolator
implements Interpolator {
    private double[][] solution = null;
    private double x0 = 0.0;
    private double x1 = 0.0;
    private double x2 = 0.0;
    private double x0_last = 0.0;
    private double x0_save;
    private float[] values0 = null;
    private float[] values1 = null;
    private float[] values2 = null;
    private float[] values0_last = null;
    private float[] values0_save = null;
    private int numSpatialPts = 1;
    private boolean[] needed = null;
    private boolean[] computed = null;

    public LinearInterpolator(int numSpatialPts) {
        this.numSpatialPts = numSpatialPts;
        this.solution = new double[4][numSpatialPts];
        this.needed = new boolean[numSpatialPts];
        this.computed = new boolean[numSpatialPts];
        Arrays.fill(this.needed, false);
        Arrays.fill(this.computed, false);
    }

    @Override
    public void interpolate(double xt, float[] interpValues) {
        Arrays.fill(interpValues, Float.NaN);
        for (int k = 0; k < this.numSpatialPts; ++k) {
            if (!this.computed[k]) continue;
            interpValues[k] = (float)(this.solution[0][k] * xt + this.solution[1][k]);
        }
    }

    @Override
    public void next(double x0, double x1, double x2, float[] values0, float[] values1, float[] values2) {
        this.x0 = x0;
        this.x1 = x1;
        this.x2 = x2;
        this.values0 = values0;
        this.values1 = values1;
        this.values2 = values2;
        this.x0_last = this.x0_save;
        this.x0_save = x0;
        this.values0_last = this.values0_save;
        this.values0_save = values0;
        Arrays.fill(this.computed, false);
    }

    @Override
    public void update(boolean[] needed) {
        Arrays.fill(this.needed, false);
        for (int k = 0; k < this.numSpatialPts; ++k) {
            if (!needed[k] || this.computed[k]) continue;
            this.needed[k] = true;
        }
        this.getSolution();
    }

    private void getSolution() {
        for (int k = 0; k < this.numSpatialPts; ++k) {
            if (!this.needed[k]) continue;
            double D1_1 = Double.NaN;
            double D1_0 = Double.NaN;
            double y0 = this.values0[k];
            double y1 = this.values1[k];
            this.solution[0][k] = (y1 - y0) / (this.x1 - this.x0);
            this.solution[1][k] = y0 - this.solution[0][k] * this.x0;
            this.computed[k] = true;
        }
    }
}

