/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GeometryStripArray;
import javax.media.j3d.Group;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.IndexedGeometryArray;
import javax.media.j3d.IndexedGeometryStripArray;
import javax.media.j3d.IndexedLineArray;
import javax.media.j3d.IndexedLineStripArray;
import javax.media.j3d.IndexedQuadArray;
import javax.media.j3d.IndexedTriangleArray;
import javax.media.j3d.IndexedTriangleFanArray;
import javax.media.j3d.IndexedTriangleStripArray;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Link;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.QuadArray;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TexCoordGeneration;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.TriangleArray;
import javax.media.j3d.TriangleFanArray;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import visad.util.OBJMaterial;

public class OBJWriter
extends FilterWriter {
    private final NumberFormat defaultNumberFormat = new DecimalFormat("0.#######", new DecimalFormatSymbols(Locale.US));
    private final NumberFormat numberFormat;
    private final String header;
    private boolean firstNode = true;
    private String mtlFileName;
    private int shapeIndex = 1;
    private Map<Point3f, Integer> vertexIndices = new HashMap<Point3f, Integer>();
    private Map<Vector3f, Integer> normalIndices = new HashMap<Vector3f, Integer>();
    private Map<TexCoord2f, Integer> textureCoordinatesIndices = new HashMap<TexCoord2f, Integer>();
    private Map<ComparableAppearance, String> appearances = new LinkedHashMap<ComparableAppearance, String>();
    private Map<Texture, File> textures = new HashMap<Texture, File>();
    private List<URL> copiedTextures = new ArrayList<URL>();

    public OBJWriter(File objFile) throws FileNotFoundException, IOException {
        this(objFile, null, -1);
    }

    public OBJWriter(File objFile, String header, int maximumFractionDigits) throws FileNotFoundException, IOException {
        this(objFile.toString(), header, maximumFractionDigits);
    }

    public OBJWriter(String objFileName) throws FileNotFoundException, IOException {
        this(objFileName, null, -1);
    }

    public OBJWriter(String objFileName, String header, int maximumFractionDigits) throws FileNotFoundException, IOException {
        this(new FileOutputStream(objFileName), header, maximumFractionDigits);
        this.mtlFileName = objFileName.toLowerCase().endsWith(".obj") ? objFileName.substring(0, objFileName.length() - 4) + ".mtl" : objFileName + ".mtl";
        this.mtlFileName = new File(new File(this.mtlFileName).getParent(), new File(this.mtlFileName).getName().replace(' ', '_')).toString();
        String name = new File(this.mtlFileName).getName();
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) < '\u0080') continue;
            this.mtlFileName = new File(new File(this.mtlFileName).getParent(), "materials.mtl").toString();
            break;
        }
    }

    public OBJWriter(OutputStream out) throws IOException {
        this(out, null, -1);
    }

    public OBJWriter(OutputStream out, String header, int maximumFractionDigits) throws IOException {
        this(new OutputStreamWriter((OutputStream)new BufferedOutputStream(out), "US-ASCII"), header, maximumFractionDigits);
    }

    public OBJWriter(Writer out) throws IOException {
        this(out, null, -1);
    }

    public OBJWriter(Writer out, String header, int maximumFractionDigits) throws IOException {
        super(out);
        if (maximumFractionDigits >= 0) {
            this.numberFormat = NumberFormat.getNumberInstance(Locale.US);
            this.numberFormat.setMinimumFractionDigits(0);
            this.numberFormat.setMaximumFractionDigits(maximumFractionDigits);
        } else {
            this.numberFormat = null;
        }
        this.header = header;
        this.writeHeader(this.out);
    }

    private void writeHeader(Writer writer) throws IOException {
        if (this.header != null) {
            if (!this.header.startsWith("#")) {
                writer.write("# ");
            }
            writer.write(this.header.replace("\n", "\n# "));
            writer.write("\n");
        }
    }

    @Override
    public void write(int c) throws IOException {
        this.out.write("# ");
        this.out.write(c);
        this.out.write("\n");
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.out.write("# ");
        this.out.write(cbuf, off, len);
        this.out.write("\n");
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.out.write("# ");
        this.out.write(str, off, len);
        this.out.write("\n");
    }

    @Override
    public void write(String str) throws IOException {
        this.out.write("# ");
        this.out.write(str, 0, str.length());
        this.out.write("\n");
    }

    private void checkCurrentThreadIsntInterrupted() throws InterruptedIOException {
        if (Thread.interrupted()) {
            this.mtlFileName = null;
            throw new InterruptedIOException("Current thread interrupted");
        }
    }

    public void writeNode(Node node) throws IOException, InterruptedIOException {
        this.writeNode(node, null);
    }

    public void writeNode(Node node, String nodeName) throws IOException, InterruptedIOException {
        if (this.firstNode) {
            if (this.mtlFileName != null) {
                this.out.write("mtllib " + new File(this.mtlFileName).getName() + "\n");
            }
            this.firstNode = false;
        }
        this.writeNode(node, nodeName, new Transform3D());
    }

    private void writeNode(Node node, String nodeName, Transform3D parentTransformations) throws IOException {
        block23: {
            RenderingAttributes renderingAttributes;
            block24: {
                block22: {
                    if (!(node instanceof Group)) break block22;
                    if (node instanceof TransformGroup) {
                        parentTransformations = new Transform3D(parentTransformations);
                        Transform3D transform = new Transform3D();
                        ((TransformGroup)node).getTransform(transform);
                        parentTransformations.mul(transform);
                    }
                    Enumeration enumeration = ((Group)node).getAllChildren();
                    while (enumeration.hasMoreElements()) {
                        this.writeNode((Node)enumeration.nextElement(), nodeName, parentTransformations);
                    }
                    break block23;
                }
                if (!(node instanceof Link)) break block24;
                this.writeNode((Node)((Link)node).getSharedGroup(), nodeName, parentTransformations);
                break block23;
            }
            if (!(node instanceof Shape3D)) break block23;
            Shape3D shape = (Shape3D)node;
            Appearance appearance = shape.getAppearance();
            RenderingAttributes renderingAttributes2 = renderingAttributes = appearance != null ? appearance.getRenderingAttributes() : null;
            if (shape.numGeometries() >= 1 && (renderingAttributes == null || renderingAttributes.getVisible())) {
                PolygonAttributes polygonAttributes;
                String objectName = "";
                if (this.accept(nodeName)) {
                    objectName = nodeName + "_";
                }
                String shapeName = null;
                if (shape.getUserData() instanceof String) {
                    shapeName = (String)shape.getUserData();
                }
                if (this.accept(shapeName)) {
                    objectName = objectName + shapeName + "_";
                }
                objectName = objectName + String.valueOf(this.shapeIndex++);
                this.out.write("g " + objectName + "\n");
                TexCoordGeneration texCoordGeneration = null;
                Transform3D textureTransform = new Transform3D();
                if (this.mtlFileName != null && appearance != null) {
                    ComparableAppearance comparableAppearance;
                    String appearanceName;
                    texCoordGeneration = appearance.getTexCoordGeneration();
                    TextureAttributes textureAttributes = appearance.getTextureAttributes();
                    if (textureAttributes != null) {
                        textureAttributes.getTextureTransform(textureTransform);
                    }
                    if ((appearanceName = this.appearances.get(comparableAppearance = new ComparableAppearance(appearance))) == null) {
                        File textureFile;
                        try {
                            appearanceName = appearance.getName();
                        }
                        catch (NoSuchMethodError noSuchMethodError) {
                            // empty catch block
                        }
                        if (appearanceName == null || !this.accept(appearanceName)) {
                            appearanceName = objectName;
                        } else {
                            Collection<String> appearanceNames = this.appearances.values();
                            String baseName = appearanceName + "_" + objectName;
                            int i = 0;
                            while (appearanceNames.contains(appearanceName)) {
                                appearanceName = i == 0 ? baseName : baseName + "_" + i;
                                ++i;
                            }
                        }
                        this.appearances.put(comparableAppearance, appearanceName);
                        Texture texture = appearance.getTexture();
                        if (texture != null && (textureFile = this.textures.get(texture)) == null) {
                            String fileExtension;
                            block21: {
                                fileExtension = "png";
                                URL textureUrl = (URL)texture.getUserData();
                                if (textureUrl instanceof URL) {
                                    InputStream in = null;
                                    try {
                                        in = this.openStream(textureUrl);
                                        ImageInputStream imageIn = ImageIO.createImageInputStream(in);
                                        Iterator<ImageReader> imageReaders = ImageIO.getImageReaders(imageIn);
                                        if (imageReaders.hasNext()) {
                                            ImageReader reader = imageReaders.next();
                                            fileExtension = reader.getFormatName().toLowerCase();
                                            this.copiedTextures.add(textureUrl);
                                        }
                                    }
                                    catch (IOException ex) {
                                        if (in == null) break block21;
                                        in.close();
                                    }
                                }
                            }
                            textureFile = new File(this.mtlFileName.substring(0, this.mtlFileName.length() - 4) + "_" + appearanceName + "." + fileExtension);
                            this.textures.put(texture, textureFile);
                        }
                    }
                    this.out.write("usemtl " + appearanceName + "\n");
                }
                int cullFace = 1;
                boolean backFaceNormalFlip = false;
                if (appearance != null && (polygonAttributes = appearance.getPolygonAttributes()) != null) {
                    cullFace = polygonAttributes.getCullFace();
                    backFaceNormalFlip = polygonAttributes.getBackFaceNormalFlip();
                }
                int n = shape.numGeometries();
                for (int i = 0; i < n; ++i) {
                    this.writeNodeGeometry(shape.getGeometry(i), parentTransformations, texCoordGeneration, textureTransform, cullFace, backFaceNormalFlip);
                }
            }
        }
    }

    private InputStream openStream(URL url) throws IOException {
        JarURLConnection urlConnection;
        URL jarFileUrl;
        URLConnection connection = url.openConnection();
        if (System.getProperty("os.name").startsWith("Windows") && connection instanceof JarURLConnection && (jarFileUrl = (urlConnection = (JarURLConnection)connection).getJarFileURL()).getProtocol().equalsIgnoreCase("file")) {
            try {
                File file;
                try {
                    file = new File(jarFileUrl.toURI());
                }
                catch (IllegalArgumentException ex) {
                    file = new File(jarFileUrl.getPath());
                }
                if (file.canWrite()) {
                    connection.setUseCaches(false);
                }
            }
            catch (URISyntaxException ex) {
                IOException ex2 = new IOException();
                ex2.initCause(ex);
                throw ex2;
            }
        }
        return connection.getInputStream();
    }

    private boolean accept(String name) {
        if (name == null) {
            return false;
        }
        for (int i = 0; i < name.length(); ++i) {
            char car = name.charAt(i);
            if (car >= 'a' && car <= 'z' || car >= 'A' && car <= 'Z' || car >= '0' && car <= '9' || car == '_') continue;
            return false;
        }
        return true;
    }

    private void writeNodeGeometry(Geometry geometry, Transform3D parentTransformations, TexCoordGeneration texCoordGeneration, Transform3D textureTransform, int cullFace, boolean backFaceNormalFlip) throws IOException {
        block73: {
            int i;
            int strip;
            int initialIndex;
            int i2;
            int n;
            boolean textureCoordinatesGenerated;
            int[] textureCoordinatesIndexSubstitutes;
            int[] oppositeSideNormalIndexSubstitutes;
            int[] normalIndexSubstitutes;
            boolean normalsDefined;
            int[] vertexIndexSubstitutes;
            GeometryArray geometryArray;
            block74: {
                int[] stripIndexCounts;
                IndexedGeometryStripArray geometryStripArray;
                block79: {
                    block78: {
                        block77: {
                            block76: {
                                block75: {
                                    ArrayList<Vector3f> addedNormals;
                                    StringBuilder normalsBuffer;
                                    if (!(geometry instanceof GeometryArray)) break block73;
                                    geometryArray = (GeometryArray)geometry;
                                    vertexIndexSubstitutes = new int[geometryArray.getVertexCount()];
                                    boolean bl = normalsDefined = (geometryArray.getVertexFormat() & 2) != 0;
                                    if (normalsDefined) {
                                        normalsBuffer = new StringBuilder(geometryArray.getVertexCount() * 3 * 10);
                                        addedNormals = new ArrayList<Vector3f>();
                                    } else {
                                        normalsBuffer = null;
                                        addedNormals = null;
                                    }
                                    normalIndexSubstitutes = new int[geometryArray.getVertexCount()];
                                    oppositeSideNormalIndexSubstitutes = cullFace == 0 ? new int[geometryArray.getVertexCount()] : null;
                                    boolean textureCoordinatesDefined = (geometryArray.getVertexFormat() & 0x20) != 0;
                                    textureCoordinatesIndexSubstitutes = new int[geometryArray.getVertexCount()];
                                    textureCoordinatesGenerated = false;
                                    Vector4f planeS = null;
                                    Vector4f planeT = null;
                                    if (texCoordGeneration != null) {
                                        boolean bl2 = textureCoordinatesGenerated = texCoordGeneration.getGenMode() == 0 && texCoordGeneration.getEnable() && !(geometryArray instanceof IndexedLineArray) && !(geometryArray instanceof IndexedLineStripArray) && !(geometryArray instanceof LineArray) && !(geometryArray instanceof LineStripArray);
                                        if (textureCoordinatesGenerated) {
                                            planeS = new Vector4f();
                                            planeT = new Vector4f();
                                            texCoordGeneration.getPlaneS(planeS);
                                            texCoordGeneration.getPlaneT(planeT);
                                        }
                                    }
                                    this.checkCurrentThreadIsntInterrupted();
                                    if ((geometryArray.getVertexFormat() & 0x80) != 0) {
                                        Vector3f normal;
                                        TexCoord2f textureCoordinates;
                                        if ((geometryArray.getVertexFormat() & 0x100) != 0) {
                                            float[] vertexData = geometryArray.getInterleavedVertices();
                                            int vertexSize = vertexData.length / geometryArray.getVertexCount();
                                            int index = 0;
                                            int i3 = vertexSize - 3;
                                            int n2 = geometryArray.getVertexCount();
                                            while (index < n2) {
                                                Point3f vertex = new Point3f(vertexData[i3], vertexData[i3 + 1], vertexData[i3 + 2]);
                                                this.writeVertex(parentTransformations, vertex, index, vertexIndexSubstitutes);
                                                ++index;
                                                i3 += vertexSize;
                                            }
                                            if (texCoordGeneration != null) {
                                                if (textureCoordinatesGenerated) {
                                                    index = 0;
                                                    i3 = vertexSize - 3;
                                                    n2 = geometryArray.getVertexCount();
                                                    while (index < n2) {
                                                        textureCoordinates = this.generateTextureCoordinates(vertexData[i3], vertexData[i3 + 1], vertexData[i3 + 2], planeS, planeT);
                                                        this.writeTextureCoordinates(textureCoordinates, textureTransform, index, textureCoordinatesIndexSubstitutes);
                                                        ++index;
                                                        i3 += vertexSize;
                                                    }
                                                }
                                            } else if (textureCoordinatesDefined) {
                                                index = 0;
                                                i3 = 0;
                                                n2 = geometryArray.getVertexCount();
                                                while (index < n2) {
                                                    textureCoordinates = new TexCoord2f(vertexData[i3], vertexData[i3 + 1]);
                                                    this.writeTextureCoordinates(textureCoordinates, textureTransform, index, textureCoordinatesIndexSubstitutes);
                                                    ++index;
                                                    i3 += vertexSize;
                                                }
                                            }
                                            if (normalsDefined) {
                                                index = 0;
                                                i3 = vertexSize - 6;
                                                n2 = geometryArray.getVertexCount();
                                                while (normalsDefined && index < n2) {
                                                    normal = new Vector3f(vertexData[i3], vertexData[i3 + 1], vertexData[i3 + 2]);
                                                    normalsDefined = this.writeNormal(normalsBuffer, parentTransformations, normal, index, normalIndexSubstitutes, oppositeSideNormalIndexSubstitutes, addedNormals, cullFace, backFaceNormalFlip);
                                                    ++index;
                                                    i3 += vertexSize;
                                                }
                                            }
                                        } else {
                                            int i4;
                                            int index;
                                            float[] vertexCoordinates = geometryArray.getCoordRefFloat();
                                            int index2 = 0;
                                            int i5 = 0;
                                            int n3 = geometryArray.getVertexCount();
                                            while (index2 < n3) {
                                                Point3f vertex = new Point3f(vertexCoordinates[i5], vertexCoordinates[i5 + 1], vertexCoordinates[i5 + 2]);
                                                this.writeVertex(parentTransformations, vertex, index2, vertexIndexSubstitutes);
                                                ++index2;
                                                i5 += 3;
                                            }
                                            if (texCoordGeneration != null) {
                                                if (textureCoordinatesGenerated) {
                                                    index2 = 0;
                                                    i5 = 0;
                                                    n3 = geometryArray.getVertexCount();
                                                    while (index2 < n3) {
                                                        TexCoord2f textureCoordinates2 = this.generateTextureCoordinates(vertexCoordinates[i5], vertexCoordinates[i5 + 1], vertexCoordinates[i5 + 2], planeS, planeT);
                                                        this.writeTextureCoordinates(textureCoordinates2, textureTransform, index2, textureCoordinatesIndexSubstitutes);
                                                        ++index2;
                                                        i5 += 3;
                                                    }
                                                }
                                            } else if (textureCoordinatesDefined) {
                                                float[] textureCoordinatesArray = geometryArray.getTexCoordRefFloat(0);
                                                index = 0;
                                                i4 = 0;
                                                int n4 = geometryArray.getVertexCount();
                                                while (index < n4) {
                                                    textureCoordinates = new TexCoord2f(textureCoordinatesArray[i4], textureCoordinatesArray[i4 + 1]);
                                                    this.writeTextureCoordinates(textureCoordinates, textureTransform, index, textureCoordinatesIndexSubstitutes);
                                                    ++index;
                                                    i4 += 2;
                                                }
                                            }
                                            if (normalsDefined) {
                                                float[] normalCoordinates = geometryArray.getNormalRefFloat();
                                                index = 0;
                                                i4 = 0;
                                                int n5 = geometryArray.getVertexCount();
                                                while (normalsDefined && index < n5) {
                                                    normal = new Vector3f(normalCoordinates[i4], normalCoordinates[i4 + 1], normalCoordinates[i4 + 2]);
                                                    normalsDefined = this.writeNormal(normalsBuffer, parentTransformations, normal, index, normalIndexSubstitutes, oppositeSideNormalIndexSubstitutes, addedNormals, cullFace, backFaceNormalFlip);
                                                    ++index;
                                                    i4 += 3;
                                                }
                                            }
                                        }
                                    } else {
                                        Point3f vertex;
                                        int index;
                                        int n6 = geometryArray.getVertexCount();
                                        for (index = 0; index < n6; ++index) {
                                            vertex = new Point3f();
                                            geometryArray.getCoordinate(index, vertex);
                                            this.writeVertex(parentTransformations, vertex, index, vertexIndexSubstitutes);
                                        }
                                        if (texCoordGeneration != null) {
                                            if (textureCoordinatesGenerated) {
                                                n6 = geometryArray.getVertexCount();
                                                for (index = 0; index < n6; ++index) {
                                                    vertex = new Point3f();
                                                    geometryArray.getCoordinate(index, vertex);
                                                    TexCoord2f textureCoordinates = this.generateTextureCoordinates(vertex.x, vertex.y, vertex.z, planeS, planeT);
                                                    this.writeTextureCoordinates(textureCoordinates, textureTransform, index, textureCoordinatesIndexSubstitutes);
                                                }
                                            }
                                        } else if (textureCoordinatesDefined) {
                                            n6 = geometryArray.getVertexCount();
                                            for (index = 0; index < n6; ++index) {
                                                TexCoord2f textureCoordinates = new TexCoord2f();
                                                geometryArray.getTextureCoordinate(0, index, textureCoordinates);
                                                this.writeTextureCoordinates(textureCoordinates, textureTransform, index, textureCoordinatesIndexSubstitutes);
                                            }
                                        }
                                        if (normalsDefined) {
                                            n6 = geometryArray.getVertexCount();
                                            for (index = 0; normalsDefined && index < n6; ++index) {
                                                Vector3f normal = new Vector3f();
                                                geometryArray.getNormal(index, normal);
                                                normalsDefined = this.writeNormal(normalsBuffer, parentTransformations, normal, index, normalIndexSubstitutes, oppositeSideNormalIndexSubstitutes, addedNormals, cullFace, backFaceNormalFlip);
                                            }
                                        }
                                    }
                                    if (normalsDefined) {
                                        this.out.write(normalsBuffer.toString());
                                    } else if (addedNormals != null) {
                                        for (Vector3f normal : addedNormals) {
                                            this.normalIndices.remove(normal);
                                        }
                                    }
                                    this.checkCurrentThreadIsntInterrupted();
                                    if (!(geometryArray instanceof IndexedGeometryArray)) break block74;
                                    if (!(geometryArray instanceof IndexedLineArray)) break block75;
                                    IndexedLineArray lineArray = (IndexedLineArray)geometryArray;
                                    n = lineArray.getIndexCount();
                                    for (i2 = 0; i2 < n; i2 += 2) {
                                        this.writeIndexedLine((IndexedGeometryArray)lineArray, i2, i2 + 1, vertexIndexSubstitutes, textureCoordinatesIndexSubstitutes);
                                    }
                                    break block73;
                                }
                                if (!(geometryArray instanceof IndexedTriangleArray)) break block76;
                                IndexedTriangleArray triangleArray = (IndexedTriangleArray)geometryArray;
                                n = triangleArray.getIndexCount();
                                for (i2 = 0; i2 < n; i2 += 3) {
                                    this.writeIndexedTriangle((IndexedGeometryArray)triangleArray, i2, i2 + 1, i2 + 2, vertexIndexSubstitutes, normalIndexSubstitutes, oppositeSideNormalIndexSubstitutes, normalsDefined, textureCoordinatesIndexSubstitutes, textureCoordinatesGenerated, cullFace);
                                }
                                break block73;
                            }
                            if (!(geometryArray instanceof IndexedQuadArray)) break block77;
                            IndexedQuadArray quadArray = (IndexedQuadArray)geometryArray;
                            n = quadArray.getIndexCount();
                            for (i2 = 0; i2 < n; i2 += 4) {
                                this.writeIndexedQuadrilateral((IndexedGeometryArray)quadArray, i2, i2 + 1, i2 + 2, i2 + 3, vertexIndexSubstitutes, normalIndexSubstitutes, oppositeSideNormalIndexSubstitutes, normalsDefined, textureCoordinatesIndexSubstitutes, textureCoordinatesGenerated, cullFace);
                            }
                            break block73;
                        }
                        if (!(geometryArray instanceof IndexedGeometryStripArray)) break block73;
                        geometryStripArray = (IndexedGeometryStripArray)geometryArray;
                        stripIndexCounts = new int[geometryStripArray.getNumStrips()];
                        geometryStripArray.getStripIndexCounts(stripIndexCounts);
                        initialIndex = 0;
                        if (!(geometryStripArray instanceof IndexedLineStripArray)) break block78;
                        for (strip = 0; strip < stripIndexCounts.length; ++strip) {
                            int n7 = initialIndex + stripIndexCounts[strip] - 1;
                            for (i = initialIndex; i < n7; ++i) {
                                this.writeIndexedLine((IndexedGeometryArray)geometryStripArray, i, i + 1, vertexIndexSubstitutes, textureCoordinatesIndexSubstitutes);
                            }
                            initialIndex += stripIndexCounts[strip];
                        }
                        break block73;
                    }
                    if (!(geometryStripArray instanceof IndexedTriangleStripArray)) break block79;
                    for (strip = 0; strip < stripIndexCounts.length; ++strip) {
                        i = initialIndex;
                        int n8 = initialIndex + stripIndexCounts[strip] - 2;
                        int j = 0;
                        while (i < n8) {
                            if (j % 2 == 0) {
                                this.writeIndexedTriangle((IndexedGeometryArray)geometryStripArray, i, i + 1, i + 2, vertexIndexSubstitutes, normalIndexSubstitutes, oppositeSideNormalIndexSubstitutes, normalsDefined, textureCoordinatesIndexSubstitutes, textureCoordinatesGenerated, cullFace);
                            } else {
                                this.writeIndexedTriangle((IndexedGeometryArray)geometryStripArray, i, i + 2, i + 1, vertexIndexSubstitutes, normalIndexSubstitutes, oppositeSideNormalIndexSubstitutes, normalsDefined, textureCoordinatesIndexSubstitutes, textureCoordinatesGenerated, cullFace);
                            }
                            ++i;
                            ++j;
                        }
                        initialIndex += stripIndexCounts[strip];
                    }
                    break block73;
                }
                if (!(geometryStripArray instanceof IndexedTriangleFanArray)) break block73;
                for (strip = 0; strip < stripIndexCounts.length; ++strip) {
                    int n9 = initialIndex + stripIndexCounts[strip] - 2;
                    for (i = initialIndex; i < n9; ++i) {
                        this.writeIndexedTriangle((IndexedGeometryArray)geometryStripArray, initialIndex, i + 1, i + 2, vertexIndexSubstitutes, normalIndexSubstitutes, oppositeSideNormalIndexSubstitutes, normalsDefined, textureCoordinatesIndexSubstitutes, textureCoordinatesGenerated, cullFace);
                    }
                    initialIndex += stripIndexCounts[strip];
                }
                break block73;
            }
            if (geometryArray instanceof LineArray) {
                LineArray lineArray = (LineArray)geometryArray;
                n = lineArray.getVertexCount();
                for (i2 = 0; i2 < n; i2 += 2) {
                    this.writeLine((GeometryArray)lineArray, i2, i2 + 1, vertexIndexSubstitutes, textureCoordinatesIndexSubstitutes);
                }
            } else if (geometryArray instanceof TriangleArray) {
                TriangleArray triangleArray = (TriangleArray)geometryArray;
                n = triangleArray.getVertexCount();
                for (i2 = 0; i2 < n; i2 += 3) {
                    this.writeTriangle((GeometryArray)triangleArray, i2, i2 + 1, i2 + 2, vertexIndexSubstitutes, normalIndexSubstitutes, oppositeSideNormalIndexSubstitutes, normalsDefined, textureCoordinatesIndexSubstitutes, textureCoordinatesGenerated, cullFace);
                }
            } else if (geometryArray instanceof QuadArray) {
                QuadArray quadArray = (QuadArray)geometryArray;
                n = quadArray.getVertexCount();
                for (i2 = 0; i2 < n; i2 += 4) {
                    this.writeQuadrilateral((GeometryArray)quadArray, i2, i2 + 1, i2 + 2, i2 + 3, vertexIndexSubstitutes, normalIndexSubstitutes, oppositeSideNormalIndexSubstitutes, normalsDefined, textureCoordinatesIndexSubstitutes, textureCoordinatesGenerated, cullFace);
                }
            } else if (geometryArray instanceof GeometryStripArray) {
                GeometryStripArray geometryStripArray = (GeometryStripArray)geometryArray;
                int[] stripVertexCounts = new int[geometryStripArray.getNumStrips()];
                geometryStripArray.getStripVertexCounts(stripVertexCounts);
                initialIndex = 0;
                if (geometryStripArray instanceof LineStripArray) {
                    for (strip = 0; strip < stripVertexCounts.length; ++strip) {
                        int n10 = initialIndex + stripVertexCounts[strip] - 1;
                        for (i = initialIndex; i < n10; ++i) {
                            this.writeLine((GeometryArray)geometryStripArray, i, i + 1, vertexIndexSubstitutes, textureCoordinatesIndexSubstitutes);
                        }
                        initialIndex += stripVertexCounts[strip];
                    }
                } else if (geometryStripArray instanceof TriangleStripArray) {
                    for (strip = 0; strip < stripVertexCounts.length; ++strip) {
                        i = initialIndex;
                        int n11 = initialIndex + stripVertexCounts[strip] - 2;
                        int j = 0;
                        while (i < n11) {
                            if (j % 2 == 0) {
                                this.writeTriangle((GeometryArray)geometryStripArray, i, i + 1, i + 2, vertexIndexSubstitutes, normalIndexSubstitutes, oppositeSideNormalIndexSubstitutes, normalsDefined, textureCoordinatesIndexSubstitutes, textureCoordinatesGenerated, cullFace);
                            } else {
                                this.writeTriangle((GeometryArray)geometryStripArray, i, i + 2, i + 1, vertexIndexSubstitutes, normalIndexSubstitutes, oppositeSideNormalIndexSubstitutes, normalsDefined, textureCoordinatesIndexSubstitutes, textureCoordinatesGenerated, cullFace);
                            }
                            ++i;
                            ++j;
                        }
                        initialIndex += stripVertexCounts[strip];
                    }
                } else if (geometryStripArray instanceof TriangleFanArray) {
                    for (strip = 0; strip < stripVertexCounts.length; ++strip) {
                        int n12 = initialIndex + stripVertexCounts[strip] - 2;
                        for (i = initialIndex; i < n12; ++i) {
                            this.writeTriangle((GeometryArray)geometryStripArray, initialIndex, i + 1, i + 2, vertexIndexSubstitutes, normalIndexSubstitutes, oppositeSideNormalIndexSubstitutes, normalsDefined, textureCoordinatesIndexSubstitutes, textureCoordinatesGenerated, cullFace);
                        }
                        initialIndex += stripVertexCounts[strip];
                    }
                }
            }
        }
    }

    private TexCoord2f generateTextureCoordinates(float x, float y, float z, Vector4f planeS, Vector4f planeT) {
        return new TexCoord2f(x * planeS.x + y * planeS.y + z * planeS.z + planeS.w, x * planeT.x + y * planeT.y + z * planeT.z + planeT.w);
    }

    private void writeVertex(Transform3D transformationToParent, Point3f vertex, int index, int[] vertexIndexSubstitutes) throws IOException {
        transformationToParent.transform(vertex);
        Integer vertexIndex = this.vertexIndices.get(vertex);
        if (vertexIndex == null) {
            vertexIndexSubstitutes[index] = this.vertexIndices.size() + 1;
            this.vertexIndices.put(vertex, vertexIndexSubstitutes[index]);
            this.out.write("v " + this.format(vertex.x) + " " + this.format(vertex.y) + " " + this.format(vertex.z) + "\n");
        } else {
            vertexIndexSubstitutes[index] = vertexIndex;
        }
    }

    private String format(float number) {
        if (this.numberFormat != null) {
            return this.numberFormat.format(number);
        }
        String numberString = String.valueOf(number);
        if (numberString.indexOf(69) != -1) {
            return this.defaultNumberFormat.format(number);
        }
        return numberString;
    }

    private boolean writeNormal(StringBuilder normalsBuffer, Transform3D transformationToParent, Vector3f normal, int index, int[] normalIndexSubstitutes, int[] oppositeSideNormalIndexSubstitutes, List<Vector3f> addedNormals, int cullFace, boolean backFaceNormalFlip) throws IOException {
        Integer normalIndex;
        if (Float.isNaN(normal.x) || Float.isNaN(normal.y) || Float.isNaN(normal.z)) {
            return false;
        }
        if (backFaceNormalFlip) {
            normal.negate();
        }
        if (normal.x != 0.0f || normal.y != 0.0f || normal.z != 0.0f) {
            transformationToParent.transform(normal);
            normal.normalize();
        }
        if ((normalIndex = this.normalIndices.get(normal)) == null) {
            normalIndexSubstitutes[index] = this.normalIndices.size() + 1;
            this.normalIndices.put(normal, normalIndexSubstitutes[index]);
            addedNormals.add(normal);
            normalsBuffer.append("vn " + this.format(normal.x) + " " + this.format(normal.y) + " " + this.format(normal.z) + "\n");
        } else {
            normalIndexSubstitutes[index] = normalIndex;
        }
        if (cullFace == 0) {
            Vector3f oppositeNormal = new Vector3f();
            oppositeNormal.negate((Tuple3f)normal);
            return this.writeNormal(normalsBuffer, transformationToParent, oppositeNormal, index, oppositeSideNormalIndexSubstitutes, null, addedNormals, 2, false);
        }
        return true;
    }

    private void writeTextureCoordinates(TexCoord2f textureCoordinates, Transform3D textureTransform, int index, int[] textureCoordinatesIndexSubstitutes) throws IOException {
        Integer textureCoordinatesIndex;
        if (textureTransform.getBestType() != 2) {
            Point3f transformedCoordinates = new Point3f(textureCoordinates.x, textureCoordinates.y, 0.0f);
            textureTransform.transform(transformedCoordinates);
            textureCoordinates = new TexCoord2f(transformedCoordinates.x, transformedCoordinates.y);
        }
        if ((textureCoordinatesIndex = this.textureCoordinatesIndices.get(textureCoordinates)) == null) {
            textureCoordinatesIndexSubstitutes[index] = this.textureCoordinatesIndices.size() + 1;
            this.textureCoordinatesIndices.put(textureCoordinates, textureCoordinatesIndexSubstitutes[index]);
            this.out.write("vt " + this.format(textureCoordinates.x) + " " + this.format(textureCoordinates.y) + " 0\n");
        } else {
            textureCoordinatesIndexSubstitutes[index] = textureCoordinatesIndex;
        }
    }

    private void writeIndexedLine(IndexedGeometryArray geometryArray, int vertexIndex1, int vertexIndex2, int[] vertexIndexSubstitutes, int[] textureCoordinatesIndexSubstitutes) throws IOException {
        if ((geometryArray.getVertexFormat() & 0x20) != 0) {
            this.out.write("l " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex1)] + "/" + textureCoordinatesIndexSubstitutes[geometryArray.getTextureCoordinateIndex(0, vertexIndex1)] + " " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex2)] + "/" + textureCoordinatesIndexSubstitutes[geometryArray.getTextureCoordinateIndex(0, vertexIndex2)] + "\n");
        } else {
            this.out.write("l " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex1)] + " " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex2)] + "\n");
        }
    }

    private void writeIndexedTriangle(IndexedGeometryArray geometryArray, int vertexIndex1, int vertexIndex2, int vertexIndex3, int[] vertexIndexSubstitutes, int[] normalIndexSubstitutes, int[] oppositeSideNormalIndexSubstitutes, boolean normalsDefined, int[] textureCoordinatesIndexSubstitutes, boolean textureCoordinatesGenerated, int cullFace) throws IOException {
        if (cullFace == 2) {
            int tmp = vertexIndex1;
            vertexIndex1 = vertexIndex3;
            vertexIndex3 = tmp;
        }
        if (textureCoordinatesGenerated) {
            if (normalsDefined) {
                this.out.write("f " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex1)] + "/" + textureCoordinatesIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex1)] + "/" + normalIndexSubstitutes[geometryArray.getNormalIndex(vertexIndex1)] + " " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex2)] + "/" + textureCoordinatesIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex2)] + "/" + normalIndexSubstitutes[geometryArray.getNormalIndex(vertexIndex2)] + " " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex3)] + "/" + textureCoordinatesIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex3)] + "/" + normalIndexSubstitutes[geometryArray.getNormalIndex(vertexIndex3)] + "\n");
            } else {
                this.out.write("f " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex1)] + "/" + textureCoordinatesIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex1)] + " " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex2)] + "/" + textureCoordinatesIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex2)] + " " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex3)] + "/" + textureCoordinatesIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex3)] + "\n");
            }
        } else if ((geometryArray.getVertexFormat() & 0x20) != 0) {
            if (normalsDefined) {
                this.out.write("f " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex1)] + "/" + textureCoordinatesIndexSubstitutes[geometryArray.getTextureCoordinateIndex(0, vertexIndex1)] + "/" + normalIndexSubstitutes[geometryArray.getNormalIndex(vertexIndex1)] + " " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex2)] + "/" + textureCoordinatesIndexSubstitutes[geometryArray.getTextureCoordinateIndex(0, vertexIndex2)] + "/" + normalIndexSubstitutes[geometryArray.getNormalIndex(vertexIndex2)] + " " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex3)] + "/" + textureCoordinatesIndexSubstitutes[geometryArray.getTextureCoordinateIndex(0, vertexIndex3)] + "/" + normalIndexSubstitutes[geometryArray.getNormalIndex(vertexIndex3)] + "\n");
            } else {
                this.out.write("f " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex1)] + "/" + textureCoordinatesIndexSubstitutes[geometryArray.getTextureCoordinateIndex(0, vertexIndex1)] + " " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex2)] + "/" + textureCoordinatesIndexSubstitutes[geometryArray.getTextureCoordinateIndex(0, vertexIndex2)] + " " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex3)] + "/" + textureCoordinatesIndexSubstitutes[geometryArray.getTextureCoordinateIndex(0, vertexIndex3)] + "\n");
            }
        } else if (normalsDefined) {
            this.out.write("f " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex1)] + "//" + normalIndexSubstitutes[geometryArray.getNormalIndex(vertexIndex1)] + " " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex2)] + "//" + normalIndexSubstitutes[geometryArray.getNormalIndex(vertexIndex2)] + " " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex3)] + "//" + normalIndexSubstitutes[geometryArray.getNormalIndex(vertexIndex3)] + "\n");
        } else {
            this.out.write("f " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex1)] + " " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex2)] + " " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex3)] + "\n");
        }
        if (cullFace == 0) {
            this.writeIndexedTriangle(geometryArray, vertexIndex1, vertexIndex2, vertexIndex3, vertexIndexSubstitutes, oppositeSideNormalIndexSubstitutes, null, normalsDefined, textureCoordinatesIndexSubstitutes, textureCoordinatesGenerated, 2);
        }
    }

    private void writeIndexedQuadrilateral(IndexedGeometryArray geometryArray, int vertexIndex1, int vertexIndex2, int vertexIndex3, int vertexIndex4, int[] vertexIndexSubstitutes, int[] normalIndexSubstitutes, int[] oppositeSideNormalIndexSubstitutes, boolean normalsDefined, int[] textureCoordinatesIndexSubstitutes, boolean textureCoordinatesGenerated, int cullFace) throws IOException {
        if (cullFace == 2) {
            int tmp = vertexIndex2;
            vertexIndex2 = vertexIndex3;
            vertexIndex3 = tmp;
            tmp = vertexIndex1;
            vertexIndex1 = vertexIndex4;
            vertexIndex4 = tmp;
        }
        if (textureCoordinatesGenerated) {
            if (normalsDefined) {
                this.out.write("f " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex1)] + "/" + textureCoordinatesIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex1)] + "/" + normalIndexSubstitutes[geometryArray.getNormalIndex(vertexIndex1)] + " " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex2)] + "/" + textureCoordinatesIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex2)] + "/" + normalIndexSubstitutes[geometryArray.getNormalIndex(vertexIndex2)] + " " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex3)] + "/" + textureCoordinatesIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex3)] + "/" + normalIndexSubstitutes[geometryArray.getNormalIndex(vertexIndex3)] + " " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex4)] + "/" + textureCoordinatesIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex4)] + "/" + normalIndexSubstitutes[geometryArray.getNormalIndex(vertexIndex4)] + "\n");
            } else {
                this.out.write("f " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex1)] + "/" + textureCoordinatesIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex1)] + " " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex2)] + "/" + textureCoordinatesIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex2)] + " " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex3)] + "/" + textureCoordinatesIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex3)] + " " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex4)] + "/" + textureCoordinatesIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex4)] + "\n");
            }
        } else if ((geometryArray.getVertexFormat() & 0x20) != 0) {
            if (normalsDefined) {
                this.out.write("f " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex1)] + "/" + textureCoordinatesIndexSubstitutes[geometryArray.getTextureCoordinateIndex(0, vertexIndex1)] + "/" + normalIndexSubstitutes[geometryArray.getNormalIndex(vertexIndex1)] + " " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex2)] + "/" + textureCoordinatesIndexSubstitutes[geometryArray.getTextureCoordinateIndex(0, vertexIndex2)] + "/" + normalIndexSubstitutes[geometryArray.getNormalIndex(vertexIndex2)] + " " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex3)] + "/" + textureCoordinatesIndexSubstitutes[geometryArray.getTextureCoordinateIndex(0, vertexIndex3)] + "/" + normalIndexSubstitutes[geometryArray.getNormalIndex(vertexIndex3)] + " " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex4)] + "/" + textureCoordinatesIndexSubstitutes[geometryArray.getTextureCoordinateIndex(0, vertexIndex4)] + "/" + normalIndexSubstitutes[geometryArray.getNormalIndex(vertexIndex4)] + "\n");
            } else {
                this.out.write("f " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex1)] + "/" + textureCoordinatesIndexSubstitutes[geometryArray.getTextureCoordinateIndex(0, vertexIndex1)] + " " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex2)] + "/" + textureCoordinatesIndexSubstitutes[geometryArray.getTextureCoordinateIndex(0, vertexIndex2)] + " " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex3)] + "/" + textureCoordinatesIndexSubstitutes[geometryArray.getTextureCoordinateIndex(0, vertexIndex3)] + " " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex4)] + "/" + textureCoordinatesIndexSubstitutes[geometryArray.getTextureCoordinateIndex(0, vertexIndex4)] + "\n");
            }
        } else if (normalsDefined) {
            this.out.write("f " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex1)] + "//" + normalIndexSubstitutes[geometryArray.getNormalIndex(vertexIndex1)] + " " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex2)] + "//" + normalIndexSubstitutes[geometryArray.getNormalIndex(vertexIndex2)] + " " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex3)] + "//" + normalIndexSubstitutes[geometryArray.getNormalIndex(vertexIndex3)] + " " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex4)] + "//" + normalIndexSubstitutes[geometryArray.getNormalIndex(vertexIndex4)] + "\n");
        } else {
            this.out.write("f " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex1)] + " " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex2)] + " " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex3)] + " " + vertexIndexSubstitutes[geometryArray.getCoordinateIndex(vertexIndex4)] + "\n");
        }
        if (cullFace == 0) {
            this.writeIndexedQuadrilateral(geometryArray, vertexIndex1, vertexIndex2, vertexIndex3, vertexIndex4, vertexIndexSubstitutes, oppositeSideNormalIndexSubstitutes, null, normalsDefined, textureCoordinatesIndexSubstitutes, textureCoordinatesGenerated, 2);
        }
    }

    private void writeLine(GeometryArray geometryArray, int vertexIndex1, int vertexIndex2, int[] vertexIndexSubstitutes, int[] textureCoordinatesIndexSubstitutes) throws IOException {
        if ((geometryArray.getVertexFormat() & 0x20) != 0) {
            this.out.write("l " + vertexIndexSubstitutes[vertexIndex1] + "/" + textureCoordinatesIndexSubstitutes[vertexIndex1] + " " + vertexIndexSubstitutes[vertexIndex2] + "/" + textureCoordinatesIndexSubstitutes[vertexIndex2] + "\n");
        } else {
            this.out.write("l " + vertexIndexSubstitutes[vertexIndex1] + " " + vertexIndexSubstitutes[vertexIndex2] + "\n");
        }
    }

    private void writeTriangle(GeometryArray geometryArray, int vertexIndex1, int vertexIndex2, int vertexIndex3, int[] vertexIndexSubstitutes, int[] normalIndexSubstitutes, int[] oppositeSideNormalIndexSubstitutes, boolean normalsDefined, int[] textureCoordinatesIndexSubstitutes, boolean textureCoordinatesGenerated, int cullFace) throws IOException {
        if (cullFace == 2) {
            int tmp = vertexIndex1;
            vertexIndex1 = vertexIndex3;
            vertexIndex3 = tmp;
        }
        if (textureCoordinatesGenerated || (geometryArray.getVertexFormat() & 0x20) != 0) {
            if (normalsDefined) {
                this.out.write("f " + vertexIndexSubstitutes[vertexIndex1] + "/" + textureCoordinatesIndexSubstitutes[vertexIndex1] + "/" + normalIndexSubstitutes[vertexIndex1] + " " + vertexIndexSubstitutes[vertexIndex2] + "/" + textureCoordinatesIndexSubstitutes[vertexIndex2] + "/" + normalIndexSubstitutes[vertexIndex2] + " " + vertexIndexSubstitutes[vertexIndex3] + "/" + textureCoordinatesIndexSubstitutes[vertexIndex3] + "/" + normalIndexSubstitutes[vertexIndex3] + "\n");
            } else {
                this.out.write("f " + vertexIndexSubstitutes[vertexIndex1] + "/" + textureCoordinatesIndexSubstitutes[vertexIndex1] + " " + vertexIndexSubstitutes[vertexIndex2] + "/" + textureCoordinatesIndexSubstitutes[vertexIndex2] + " " + vertexIndexSubstitutes[vertexIndex3] + "/" + textureCoordinatesIndexSubstitutes[vertexIndex3] + "\n");
            }
        } else if (normalsDefined) {
            this.out.write("f " + vertexIndexSubstitutes[vertexIndex1] + "//" + normalIndexSubstitutes[vertexIndex1] + " " + vertexIndexSubstitutes[vertexIndex2] + "//" + normalIndexSubstitutes[vertexIndex2] + " " + vertexIndexSubstitutes[vertexIndex3] + "//" + normalIndexSubstitutes[vertexIndex3] + "\n");
        } else {
            this.out.write("f " + vertexIndexSubstitutes[vertexIndex1] + " " + vertexIndexSubstitutes[vertexIndex2] + " " + vertexIndexSubstitutes[vertexIndex3] + "\n");
        }
        if (cullFace == 0) {
            this.writeTriangle(geometryArray, vertexIndex1, vertexIndex2, vertexIndex3, vertexIndexSubstitutes, oppositeSideNormalIndexSubstitutes, null, normalsDefined, textureCoordinatesIndexSubstitutes, textureCoordinatesGenerated, 2);
        }
    }

    private void writeQuadrilateral(GeometryArray geometryArray, int vertexIndex1, int vertexIndex2, int vertexIndex3, int vertexIndex4, int[] vertexIndexSubstitutes, int[] normalIndexSubstitutes, int[] oppositeSideNormalIndexSubstitutes, boolean normalsDefined, int[] textureCoordinatesIndexSubstitutes, boolean textureCoordinatesGenerated, int cullFace) throws IOException {
        if (cullFace == 2) {
            int tmp = vertexIndex2;
            vertexIndex2 = vertexIndex3;
            vertexIndex3 = tmp;
            tmp = vertexIndex1;
            vertexIndex1 = vertexIndex4;
            vertexIndex4 = tmp;
        }
        if (textureCoordinatesGenerated || (geometryArray.getVertexFormat() & 0x20) != 0) {
            if (normalsDefined) {
                this.out.write("f " + vertexIndexSubstitutes[vertexIndex1] + "/" + textureCoordinatesIndexSubstitutes[vertexIndex1] + "/" + normalIndexSubstitutes[vertexIndex1] + " " + vertexIndexSubstitutes[vertexIndex2] + "/" + textureCoordinatesIndexSubstitutes[vertexIndex2] + "/" + normalIndexSubstitutes[vertexIndex2] + " " + vertexIndexSubstitutes[vertexIndex3] + "/" + textureCoordinatesIndexSubstitutes[vertexIndex3] + "/" + normalIndexSubstitutes[vertexIndex3] + " " + vertexIndexSubstitutes[vertexIndex4] + "/" + textureCoordinatesIndexSubstitutes[vertexIndex4] + "/" + normalIndexSubstitutes[vertexIndex4] + "\n");
            } else {
                this.out.write("f " + vertexIndexSubstitutes[vertexIndex1] + "/" + textureCoordinatesIndexSubstitutes[vertexIndex1] + " " + vertexIndexSubstitutes[vertexIndex2] + "/" + textureCoordinatesIndexSubstitutes[vertexIndex2] + " " + vertexIndexSubstitutes[vertexIndex3] + "/" + textureCoordinatesIndexSubstitutes[vertexIndex3] + " " + vertexIndexSubstitutes[vertexIndex4] + "/" + textureCoordinatesIndexSubstitutes[vertexIndex4] + "\n");
            }
        } else if (normalsDefined) {
            this.out.write("f " + vertexIndexSubstitutes[vertexIndex1] + "//" + normalIndexSubstitutes[vertexIndex1] + " " + vertexIndexSubstitutes[vertexIndex2] + "//" + normalIndexSubstitutes[vertexIndex2] + " " + vertexIndexSubstitutes[vertexIndex3] + "//" + normalIndexSubstitutes[vertexIndex3] + " " + vertexIndexSubstitutes[vertexIndex4] + "//" + normalIndexSubstitutes[vertexIndex4] + "\n");
        } else {
            this.out.write("f " + vertexIndexSubstitutes[vertexIndex1] + " " + vertexIndexSubstitutes[vertexIndex2] + " " + vertexIndexSubstitutes[vertexIndex3] + " " + vertexIndexSubstitutes[vertexIndex4] + "\n");
        }
        if (cullFace == 0) {
            this.writeQuadrilateral(geometryArray, vertexIndex1, vertexIndex2, vertexIndex3, vertexIndex4, vertexIndexSubstitutes, oppositeSideNormalIndexSubstitutes, null, normalsDefined, textureCoordinatesIndexSubstitutes, textureCoordinatesGenerated, 2);
        }
    }

    @Override
    public void close() throws IOException, InterruptedIOException {
        super.close();
        if (this.mtlFileName != null) {
            this.writeAppearancesToMTLFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAppearancesToMTLFile() throws IOException {
        Writer writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(this.mtlFileName)), "ISO-8859-1");
            this.writeHeader(writer);
            for (Map.Entry<ComparableAppearance, String> entry : this.appearances.entrySet()) {
                Texture texture;
                this.checkCurrentThreadIsntInterrupted();
                Appearance appearance = entry.getKey().getAppearance();
                String appearanceName = entry.getValue();
                writer.write("\nnewmtl " + appearanceName + "\n");
                Material material = appearance.getMaterial();
                if (material != null) {
                    if (material instanceof OBJMaterial && ((OBJMaterial)material).isIlluminationModelSet()) {
                        writer.write("illum " + ((OBJMaterial)material).getIlluminationModel() + "\n");
                    } else if (material.getShininess() > 1.0f) {
                        writer.write("illum 2\n");
                    } else if (material.getLightingEnable()) {
                        writer.write("illum 1\n");
                    } else {
                        writer.write("illum 0\n");
                    }
                    Color3f color = new Color3f();
                    material.getAmbientColor(color);
                    writer.write("Ka " + this.format(color.x) + " " + this.format(color.y) + " " + this.format(color.z) + "\n");
                    material.getDiffuseColor(color);
                    writer.write("Kd " + this.format(color.x) + " " + this.format(color.y) + " " + this.format(color.z) + "\n");
                    material.getSpecularColor(color);
                    writer.write("Ks " + this.format(color.x) + " " + this.format(color.y) + " " + this.format(color.z) + "\n");
                    writer.write("Ns " + this.format(material.getShininess()) + "\n");
                    if (material instanceof OBJMaterial) {
                        OBJMaterial objMaterial = (OBJMaterial)material;
                        if (objMaterial.isOpticalDensitySet()) {
                            writer.write("Ni " + this.format(objMaterial.getOpticalDensity()) + "\n");
                        }
                        if (objMaterial.isSharpnessSet()) {
                            writer.write("sharpness " + this.format(objMaterial.getSharpness()) + "\n");
                        }
                    }
                } else {
                    ColoringAttributes coloringAttributes = appearance.getColoringAttributes();
                    if (coloringAttributes != null) {
                        writer.write("illum 0\n");
                        Color3f color = new Color3f();
                        coloringAttributes.getColor(color);
                        writer.write("Ka " + this.format(color.x) + " " + this.format(color.y) + " " + this.format(color.z) + "\n");
                        writer.write("Kd " + this.format(color.x) + " " + this.format(color.y) + " " + this.format(color.z) + "\n");
                        writer.write("Ks " + this.format(color.x) + " " + this.format(color.y) + " " + this.format(color.z) + "\n");
                    }
                }
                TransparencyAttributes transparency = appearance.getTransparencyAttributes();
                if (transparency != null) {
                    if (!(material instanceof OBJMaterial)) {
                        writer.write("Ni 1\n");
                    }
                    writer.write("d " + this.format(1.0f - transparency.getTransparency()) + "\n");
                }
                if ((texture = appearance.getTexture()) == null) continue;
                writer.write("map_Kd " + this.textures.get(texture).getName() + "\n");
            }
            for (Map.Entry<ComparableAppearance, Object> entry : this.textures.entrySet()) {
                Texture texture = (Texture)entry.getKey();
                Object textureUrl = texture.getUserData();
                if (this.copiedTextures.contains(textureUrl)) {
                    InputStream in = null;
                    OutputStream out = null;
                    try {
                        int size;
                        in = this.openStream((URL)textureUrl);
                        out = new FileOutputStream((File)entry.getValue());
                        byte[] buffer = new byte[8192];
                        while ((size = in.read(buffer)) != -1) {
                            out.write(buffer, 0, size);
                        }
                        continue;
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                        if (out != null) {
                            out.close();
                        }
                        continue;
                    }
                }
                ImageComponent2D imageComponent = (ImageComponent2D)texture.getImage(0);
                RenderedImage image = imageComponent.getRenderedImage();
                ImageIO.write(image, "png", (File)entry.getValue());
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public static void writeNodeInZIPFile(Node node, File zipFile, int compressionLevel, String entryName, String header) throws IOException {
        OBJWriter.writeNodeInZIPFile(node, null, zipFile, compressionLevel, entryName, header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void writeNodeInZIPFile(Node node, Map<String, Appearance> materialAppearances, File zipFile, int compressionLevel, String entryName, String header) throws IOException {
        void var10_15;
        File tempFolder;
        block16: {
            tempFolder = null;
            for (int i = 0; i < 10 && tempFolder == null; ++i) {
                tempFolder = File.createTempFile("obj", "tmp");
                tempFolder.delete();
                if (tempFolder.mkdirs()) continue;
                tempFolder = null;
            }
            if (tempFolder == null) {
                throw new IOException("Couldn't create a temporary folder");
            }
            ZipOutputStream zipOut = null;
            try {
                OBJWriter writer = new OBJWriter(new File(tempFolder, entryName), header, -1);
                writer.writeNode(node);
                writer.close();
                zipOut = new ZipOutputStream(new FileOutputStream(zipFile));
                zipOut.setLevel(compressionLevel);
                for (File tempFile : tempFolder.listFiles()) {
                    if (!tempFile.isFile()) continue;
                    InputStream tempIn = null;
                    try {
                        int size;
                        zipOut.putNextEntry(new ZipEntry(tempFile.getName()));
                        tempIn = new FileInputStream(tempFile);
                        byte[] buffer = new byte[8096];
                        while ((size = tempIn.read(buffer)) != -1) {
                            zipOut.write(buffer, 0, size);
                        }
                        zipOut.closeEntry();
                    }
                    finally {
                        if (tempIn != null) {
                            tempIn.close();
                        }
                    }
                }
                if (materialAppearances != null) {
                    for (Map.Entry entry : writer.appearances.entrySet()) {
                        materialAppearances.put((String)entry.getValue(), ((ComparableAppearance)entry.getKey()).getAppearance());
                    }
                }
                if (zipOut == null) break block16;
            }
            catch (Throwable throwable) {
                if (zipOut != null) {
                    zipOut.close();
                }
                for (File tempFile : tempFolder.listFiles()) {
                    if (!tempFile.isFile()) continue;
                    tempFile.delete();
                }
                tempFolder.delete();
                throw throwable;
            }
            zipOut.close();
        }
        File[] fileArray = tempFolder.listFiles();
        int n = fileArray.length;
        boolean bl = false;
        while (var10_15 < n) {
            File tempFile = fileArray[var10_15];
            if (tempFile.isFile()) {
                tempFile.delete();
            }
            ++var10_15;
        }
        tempFolder.delete();
    }

    private static class ComparableAppearance {
        private Appearance appearance;

        public ComparableAppearance(Appearance appearance) {
            this.appearance = appearance;
        }

        public Appearance getAppearance() {
            return this.appearance;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ComparableAppearance) {
                Texture texture2;
                TransparencyAttributes transparency2;
                TransparencyAttributes transparency1;
                Material material2;
                Material material1;
                ColoringAttributes coloringAttributes2;
                Appearance appearance2 = ((ComparableAppearance)obj).appearance;
                ColoringAttributes coloringAttributes1 = this.appearance.getColoringAttributes();
                if (coloringAttributes1 == null ^ (coloringAttributes2 = appearance2.getColoringAttributes()) == null) {
                    return false;
                }
                if (coloringAttributes1 != coloringAttributes2) {
                    Color3f color1 = new Color3f();
                    Color3f color2 = new Color3f();
                    coloringAttributes1.getColor(color1);
                    coloringAttributes2.getColor(color2);
                    if (!color1.equals((Tuple3f)color2)) {
                        return false;
                    }
                }
                if ((material1 = this.appearance.getMaterial()) == null ^ (material2 = appearance2.getMaterial()) == null) {
                    return false;
                }
                if (material1 != material2) {
                    Color3f color1 = new Color3f();
                    Color3f color2 = new Color3f();
                    material1.getAmbientColor(color1);
                    material2.getAmbientColor(color2);
                    if (!color1.equals((Tuple3f)color2)) {
                        return false;
                    }
                    material1.getDiffuseColor(color1);
                    material2.getDiffuseColor(color2);
                    if (!color1.equals((Tuple3f)color2)) {
                        return false;
                    }
                    material1.getEmissiveColor(color1);
                    material2.getEmissiveColor(color2);
                    if (!color1.equals((Tuple3f)color2)) {
                        return false;
                    }
                    material1.getSpecularColor(color1);
                    material2.getSpecularColor(color2);
                    if (!color1.equals((Tuple3f)color2)) {
                        return false;
                    }
                    if (material1.getShininess() != material2.getShininess()) {
                        return false;
                    }
                    if (material1.getClass() != material2.getClass()) {
                        return false;
                    }
                    if (material1.getClass() == OBJMaterial.class) {
                        OBJMaterial objMaterial1 = (OBJMaterial)material1;
                        OBJMaterial objMaterial2 = (OBJMaterial)material2;
                        if (objMaterial1.isOpticalDensitySet() ^ objMaterial2.isOpticalDensitySet()) {
                            return false;
                        }
                        if (objMaterial1.isOpticalDensitySet() && objMaterial2.isOpticalDensitySet() && objMaterial1.getOpticalDensity() != objMaterial2.getOpticalDensity()) {
                            return false;
                        }
                        if (objMaterial1.isIlluminationModelSet() ^ objMaterial2.isIlluminationModelSet()) {
                            return false;
                        }
                        if (objMaterial1.isIlluminationModelSet() && objMaterial2.isIlluminationModelSet() && objMaterial1.getIlluminationModel() != objMaterial2.getIlluminationModel()) {
                            return false;
                        }
                        if (objMaterial1.isSharpnessSet() ^ objMaterial2.isSharpnessSet()) {
                            return false;
                        }
                        if (objMaterial1.isSharpnessSet() && objMaterial2.isSharpnessSet() && objMaterial1.getSharpness() != objMaterial2.getSharpness()) {
                            return false;
                        }
                    }
                }
                if ((transparency1 = this.appearance.getTransparencyAttributes()) == null ^ (transparency2 = appearance2.getTransparencyAttributes()) == null) {
                    return false;
                }
                if (transparency1 != transparency2 && transparency1.getTransparency() != transparency2.getTransparency()) {
                    return false;
                }
                Texture texture1 = this.appearance.getTexture();
                if (texture1 == null ^ (texture2 = appearance2.getTexture()) == null) {
                    return false;
                }
                if (texture1 != texture2 && texture1.getImage(0) != texture2.getImage(0)) {
                    return false;
                }
                try {
                    String name1 = this.appearance.getName();
                    String name2 = appearance2.getName();
                    if (name1 == null ^ name2 == null) {
                        return false;
                    }
                    if (name1 != name2 && !name1.equals(name2)) {
                        return false;
                    }
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            Texture texture;
            TransparencyAttributes transparency;
            Material material;
            int code = 0;
            ColoringAttributes coloringAttributes = this.appearance.getColoringAttributes();
            if (coloringAttributes != null) {
                Color3f color = new Color3f();
                coloringAttributes.getColor(color);
                code += color.hashCode();
            }
            if ((material = this.appearance.getMaterial()) != null) {
                Color3f color = new Color3f();
                material.getAmbientColor(color);
                code += color.hashCode();
                material.getDiffuseColor(color);
                code += color.hashCode();
                material.getEmissiveColor(color);
                code += color.hashCode();
                material.getSpecularColor(color);
                code += color.hashCode();
                code += Float.floatToIntBits(material.getShininess());
            }
            if ((transparency = this.appearance.getTransparencyAttributes()) != null) {
                code += Float.floatToIntBits(transparency.getTransparency());
            }
            if ((texture = this.appearance.getTexture()) != null) {
                code += texture.getImage(0).hashCode();
            }
            try {
                String name = this.appearance.getName();
                if (name != null) {
                    code += name.hashCode();
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            return code;
        }
    }
}

