/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.MultipleNodeKindTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ManualIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.UType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionalPattern
extends Pattern {
    private Expression[] conditions;
    private Pattern[] patterns;

    public ConditionalPattern(Expression[] conditions, Pattern[] patterns) {
        this.conditions = conditions;
        this.patterns = patterns;
    }

    private Expression getCondition(int n) {
        return this.conditions[n];
    }

    private void setCondition(int n, Expression exp) {
        this.conditions[n] = exp;
    }

    @Override
    public Pattern simplify() throws XPathException {
        for (int i = 0; i < this.conditions.length; ++i) {
            this.setCondition(i, this.getCondition(i).simplify());
            this.patterns[i] = this.patterns[i].simplify();
        }
        return this;
    }

    @Override
    public Pattern typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        for (int i = 0; i < this.conditions.length; ++i) {
            this.setCondition(i, this.getCondition(i).typeCheck(visitor, contextItemType));
            this.patterns[i] = this.patterns[i].typeCheck(visitor, contextItemType);
        }
        return this;
    }

    @Override
    public void promote(PromotionOffer offer, Expression parent) throws XPathException {
        for (int i = 0; i < this.conditions.length; ++i) {
            this.setCondition(i, this.getCondition(i).promote(offer));
            this.patterns[i].promote(offer, parent);
        }
    }

    @Override
    public void setOriginalText(String pattern) {
        super.setOriginalText(pattern);
        for (int i = 0; i < this.conditions.length; ++i) {
            this.patterns[i].setOriginalText(pattern);
        }
    }

    @Override
    public int allocateSlots(SlotManager slotManager, int nextFree) {
        for (int i = 0; i < this.conditions.length; ++i) {
            nextFree = ExpressionTool.allocateSlots(this.getCondition(i), nextFree, slotManager);
            nextFree = this.patterns[i].allocateSlots(slotManager, nextFree);
        }
        return nextFree;
    }

    @Override
    public void export(ExpressionPresenter presenter) throws XPathException {
        presenter.startElement("p.choose");
        for (int i = 0; i < this.conditions.length; ++i) {
            this.conditions[i].export(presenter);
            this.patterns[i].export(presenter);
        }
        presenter.endElement();
    }

    @Override
    public boolean matches(Item item, XPathContext context) throws XPathException {
        for (int i = 0; i < this.conditions.length; ++i) {
            boolean b = this.getCondition(i).effectiveBooleanValue(context);
            if (!b) continue;
            return this.patterns[i].matches(item, context);
        }
        return false;
    }

    @Override
    public boolean matchesBeneathAnchor(NodeInfo node, NodeInfo anchor, XPathContext context) throws XPathException {
        XPathContextMajor c2 = context.newContext();
        ManualIterator iter = new ManualIterator(anchor);
        c2.setCurrentIterator(iter);
        for (int i = 0; i < this.conditions.length; ++i) {
            boolean b = this.getCondition(i).effectiveBooleanValue(c2);
            if (!b) continue;
            return this.patterns[i].matchesBeneathAnchor(node, anchor, context);
        }
        return false;
    }

    @Override
    public UType getUType() {
        UType mask = this.patterns[0].getUType();
        for (int i = 1; i < this.patterns.length; ++i) {
            mask = mask.union(this.patterns[i].getUType());
        }
        return mask;
    }

    @Override
    public ItemType getItemType() {
        UType uType = this.getUType();
        if (uType.equals(UType.ANY)) {
            return AnyItemType.getInstance();
        }
        if (uType.equals(UType.ANY_NODE)) {
            return AnyNodeTest.getInstance();
        }
        return new MultipleNodeKindTest(uType);
    }

    @Override
    public int getDependencies() {
        int d = 0;
        for (int i = 0; i < this.conditions.length; ++i) {
            d |= this.getCondition(i).getDependencies();
            d |= this.patterns[i].getDependencies();
        }
        return d;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        ArrayList<Expression> list = new ArrayList<Expression>(this.conditions.length * 2);
        for (int i = 0; i < this.conditions.length; i += 2) {
            for (Operand o : this.getCondition(i).operands()) {
                list.add(o.getChildExpression());
            }
            Iterator<Expression> iter = this.patterns[i].iterateSubExpressions();
            while (iter.hasNext()) {
                list.add(iter.next());
            }
        }
        return list.iterator();
    }

    public boolean equals(Object other) {
        if (other instanceof ConditionalPattern) {
            return Arrays.equals(this.conditions, ((ConditionalPattern)other).conditions) && Arrays.equals(this.patterns, ((ConditionalPattern)other).patterns);
        }
        return false;
    }

    public int hashCode() {
        int h2 = -2090102112;
        for (int i = 0; i < this.conditions.length; i += 2) {
            h2 ^= this.patterns[i].hashCode() ^ this.getCondition(i).hashCode();
        }
        return h2;
    }

    @Override
    public Pattern copy(RebindingMap rebindings) {
        ConditionalPattern n = new ConditionalPattern(this.conditions, this.patterns);
        ExpressionTool.copyLocationInfo(this, n);
        return n;
    }
}

