/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.util.Collection;
import java.util.HashMap;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.TemplateRule;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternOptimization;
import net.sf.saxon.pattern.UnionPattern;
import net.sf.saxon.style.StylesheetModule;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.Rule;
import net.sf.saxon.trans.SimpleMode;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RuleManager {
    private StylesheetPackage stylesheetPackage;
    private Configuration config;
    private SimpleMode unnamedMode;
    private HashMap<StructuredQName, Mode> modes;
    private SimpleMode omniMode = null;
    private int recoveryPolicy;
    private boolean unnamedModeExplicit;
    private CompilerInfo compilerInfo;

    public RuleManager(StylesheetPackage pack) {
        this.stylesheetPackage = pack;
        this.config = pack.getConfiguration();
        this.compilerInfo = this.config.getDefaultXsltCompilerInfo();
        this.resetHandlers();
    }

    public RuleManager(StylesheetPackage pack, CompilerInfo compilerInfo) {
        this.stylesheetPackage = pack;
        this.config = pack.getConfiguration();
        this.compilerInfo = compilerInfo;
        this.resetHandlers();
    }

    public void setUnnamedModeExplicit(boolean declared) {
        this.unnamedModeExplicit = declared;
    }

    public boolean isUnnamedModeExplicit() {
        return this.unnamedModeExplicit;
    }

    public void setCompilerInfo(CompilerInfo compilerInfo) {
        this.compilerInfo = compilerInfo;
    }

    public void setRecoveryPolicy(int policy) {
        this.recoveryPolicy = policy;
        this.unnamedMode.setRecoveryPolicy(policy);
    }

    public int getRecoveryPolicy() {
        return this.recoveryPolicy;
    }

    public Collection<Mode> getAllNamedModes() {
        return this.modes.values();
    }

    public void resetHandlers() {
        this.unnamedMode = this.config.makeMode(Mode.UNNAMED_MODE_NAME, this.compilerInfo);
        Component c = this.unnamedMode.makeDeclaringComponent(Visibility.PRIVATE, this.stylesheetPackage);
        this.stylesheetPackage.addComponent(c);
        this.unnamedMode.setRecoveryPolicy(this.recoveryPolicy);
        this.modes = new HashMap(5);
    }

    public SimpleMode getUnnamedMode() {
        return this.unnamedMode;
    }

    public Mode obtainMode(StructuredQName modeName, boolean createIfAbsent) {
        if (modeName == null || modeName.equals(Mode.UNNAMED_MODE_NAME)) {
            return this.unnamedMode;
        }
        if (modeName.equals(Mode.OMNI_MODE)) {
            if (this.omniMode == null) {
                this.omniMode = this.config.makeMode(modeName, this.compilerInfo);
                this.omniMode.setRecoveryPolicy(this.recoveryPolicy);
            }
            return this.omniMode;
        }
        Mode m3 = this.modes.get(modeName);
        if (m3 == null && createIfAbsent) {
            m3 = this.config.makeMode(modeName, this.compilerInfo);
            m3.setRecoveryPolicy(this.recoveryPolicy);
            this.modes.put(modeName, m3);
            Component c = m3.makeDeclaringComponent(Visibility.PRIVATE, this.stylesheetPackage);
            this.stylesheetPackage.addComponent(c);
        }
        return m3;
    }

    public void registerMode(Mode mode) {
        this.modes.put(mode.getModeName(), mode);
    }

    public boolean existsOmniMode() {
        return this.omniMode != null;
    }

    public void setTemplateRule(Pattern pattern, TemplateRule eh, Mode mode, StylesheetModule module, double priority) {
        if (pattern instanceof UnionPattern) {
            UnionPattern up = (UnionPattern)pattern;
            Pattern p1 = up.getLHS();
            Pattern p2 = up.getRHS();
            this.setTemplateRule(p1, eh, mode, module, priority);
            this.setTemplateRule(p2, eh, mode, module, priority);
            return;
        }
        if (pattern instanceof NodeTestPattern && pattern.getItemType() instanceof CombinedNodeTest && ((CombinedNodeTest)pattern.getItemType()).getOperator() == 1) {
            CombinedNodeTest cnt = (CombinedNodeTest)pattern.getItemType();
            NodeTest[] nt = cnt.getComponentNodeTests();
            NodeTestPattern nt0 = new NodeTestPattern(nt[0]);
            ExpressionTool.copyLocationInfo(pattern, nt0);
            this.setTemplateRule(nt0, eh, mode, module, priority);
            NodeTestPattern nt1 = new NodeTestPattern(nt[1]);
            ExpressionTool.copyLocationInfo(pattern, nt1);
            this.setTemplateRule(nt1, eh, mode, module, priority);
            return;
        }
        if (Double.isNaN(priority)) {
            priority = pattern.getDefaultPriority();
        }
        if (mode instanceof SimpleMode) {
            ((SimpleMode)mode).addRule(pattern, eh, module, module.getPrecedence(), priority, true);
        } else {
            mode.getActivePart().addRule(pattern, eh, module, mode.getMaxPrecedence(), priority, true);
        }
    }

    public Rule getTemplateRule(Item item, Mode mode, int min2, int max, XPathContext c) throws XPathException {
        if (mode == null) {
            mode = this.unnamedMode;
        }
        return mode.getRule(item, min2, max, c);
    }

    public void computeRankings() throws XPathException {
        this.unnamedMode.computeRankings(0);
        for (Mode mode : this.modes.values()) {
            mode.computeRankings(0);
        }
    }

    public void invertStreamableTemplates() throws XPathException {
        this.unnamedMode.invertStreamableTemplates();
        for (Mode mode : this.modes.values()) {
            mode.getActivePart().invertStreamableTemplates();
        }
    }

    public void checkConsistency() throws XPathException {
        this.unnamedMode.checkForConflictingProperties();
        for (Mode mode : this.modes.values()) {
            mode.getActivePart().checkForConflictingProperties();
        }
    }

    public void exportTemplateRules(ExpressionPresenter presenter) throws XPathException {
        this.unnamedMode.export(presenter);
        for (Mode mode : this.modes.values()) {
            mode.export(presenter);
        }
    }

    public void explainTemplateRules(ExpressionPresenter presenter) throws XPathException {
        this.unnamedMode.explain(presenter);
        for (Mode mode : this.modes.values()) {
            mode.explain(presenter);
        }
    }

    public void optimizeRules() {
        PatternOptimization patternOptimization = this.compilerInfo.getPatternOptimization();
        if (patternOptimization != null && patternOptimization.isOptimize()) {
            this.unnamedMode.optimizeRules();
            for (Mode mode : this.modes.values()) {
                mode.getActivePart().optimizeRules();
            }
        }
    }
}

