/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.Message;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public final class XSLMessage
extends StyleElement {
    private Expression terminate = null;
    private Expression select = null;
    private Expression errorCode = null;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        String terminateAtt = null;
        String selectAtt = null;
        String errorCodeAtt = null;
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("terminate")) {
                terminateAtt = Whitespace.trim(atts.getValue(a));
                this.terminate = this.makeAttributeValueTemplate(terminateAtt, a);
                continue;
            }
            if (f.equals("select")) {
                selectAtt = atts.getValue(a);
                this.select = this.makeExpression(selectAtt, a);
                continue;
            }
            if (f.equals("error-code")) {
                errorCodeAtt = atts.getValue(a);
                this.errorCode = this.makeAttributeValueTemplate(errorCodeAtt, a);
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (terminateAtt == null) {
            terminateAtt = "no";
            this.terminate = this.makeAttributeValueTemplate(terminateAtt, -1);
        }
        this.checkAttributeValue("terminate", terminateAtt, true, StyleElement.YES_NO);
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        this.select = this.typeCheck("select", this.select);
        this.terminate = this.typeCheck("terminate", this.terminate);
        if (this.errorCode != null && !this.isXslt30Processor()) {
            if (this.forwardsCompatibleModeIsEnabled()) {
                this.compileWarning("xsl:message/@error-code is ignored in forwards-compatibility mode", "");
            } else {
                this.compileError("The xsl:message/@error-code attribute is not recognized by an XSLT 2.0 processor");
            }
        }
        this.errorCode = this.errorCode == null ? new StringLiteral("Q{http://www.w3.org/2005/xqt-errors}XTMM9000") : this.typeCheck("error-code", this.errorCode);
    }

    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        String code;
        Expression b = this.compileSequenceConstructor(exec, decl, true);
        if (b != null) {
            if (this.select == null) {
                this.select = b;
            } else {
                this.select = Block.makeBlock(this.select, b);
                this.select.setLocation(this.allocateLocation());
            }
        }
        if (this.select == null) {
            this.select = new StringLiteral("xsl:message (no content)");
        }
        if (this.errorCode instanceof StringLiteral && (code = ((StringLiteral)this.errorCode).getStringValue()).contains(":") && !code.startsWith("Q{")) {
            try {
                StructuredQName name = this.makeQName(code);
                this.errorCode = new StringLiteral("Q" + name.getClarkName());
            }
            catch (NamespaceException err) {
                this.errorCode = new StringLiteral("Q{http://www.w3.org/2005/xqt-errors}XTMM9000");
            }
        }
        Message m3 = new Message(this.select, this.terminate, this.errorCode);
        m3.setRetainedStaticContext(this.makeRetainedStaticContext());
        return m3;
    }
}

