/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.BuilderMonitor;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.CompressedWhitespace;
import net.sf.saxon.tree.tiny.Statistics;
import net.sf.saxon.tree.tiny.TinyBuilderMonitor;
import net.sf.saxon.tree.tiny.TinyDocumentImpl;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public class TinyBuilder
extends Builder {
    public static final int PARENT_POINTER_INTERVAL = 10;
    private TinyTree tree;
    private int currentDepth = 0;
    private int nodeNr = 0;
    private boolean ended = false;
    private Statistics statistics = Statistics.TEMPORARY_TREE_STATISTICS;
    private boolean markDefaultedAttributes = false;
    private int[] prevAtDepth = new int[100];
    private int[] siblingsAtDepth = new int[100];
    private boolean isIDElement = false;

    public TinyBuilder(PipelineConfiguration pipe) {
        super(pipe);
        Configuration config = pipe.getConfiguration();
        this.markDefaultedAttributes = config.isExpandAttributeDefaults() && config.getBooleanProperty("http://saxon.sf.net/feature/markDefaultedAttributes");
    }

    public void setStatistics(Statistics stats) {
        this.statistics = stats;
    }

    public TinyTree getTree() {
        return this.tree;
    }

    public int getCurrentDepth() {
        return this.currentDepth;
    }

    public void open() {
        if (this.started) {
            return;
        }
        if (this.tree == null) {
            this.tree = new TinyTree(this.config, this.statistics);
            this.currentDepth = 0;
            if (this.lineNumbering) {
                this.tree.setLineNumbering();
            }
        }
        super.open();
    }

    public void startDocument(int properties) throws XPathException {
        int nodeNr;
        if (this.started && !this.ended || this.currentDepth > 0) {
            return;
        }
        this.started = true;
        this.ended = false;
        TinyTree tt = this.tree;
        assert (tt != null);
        this.currentRoot = new TinyDocumentImpl(tt);
        TinyDocumentImpl doc = (TinyDocumentImpl)this.currentRoot;
        doc.setSystemId(this.getSystemId());
        doc.setBaseURI(this.getBaseURI());
        this.currentDepth = 0;
        this.prevAtDepth[0] = nodeNr = tt.addDocumentNode((TinyDocumentImpl)this.currentRoot);
        this.prevAtDepth[1] = -1;
        this.siblingsAtDepth[0] = 0;
        this.siblingsAtDepth[1] = 0;
        tt.next[nodeNr] = -1;
        ++this.currentDepth;
    }

    public void endDocument() throws XPathException {
        this.tree.addNode((short)11, 0, 0, 0, -1);
        --this.tree.numberOfNodes;
        if (this.currentDepth > 1) {
            return;
        }
        if (this.ended) {
            return;
        }
        this.ended = true;
        this.prevAtDepth[this.currentDepth] = -1;
        --this.currentDepth;
    }

    public void reset() {
        super.reset();
        this.tree = null;
        this.currentDepth = 0;
        this.nodeNr = 0;
        this.ended = false;
        this.statistics = Statistics.TEMPORARY_TREE_STATISTICS;
    }

    public void close() throws XPathException {
        TinyTree tt = this.tree;
        if (tt != null) {
            tt.addNode((short)11, 0, 0, 0, -1);
            tt.condense(this.statistics);
        }
        super.close();
    }

    public void startElement(NodeName elemName, SchemaType type, Location location, int properties) throws XPathException {
        TinyTree tt = this.tree;
        assert (tt != null);
        if (this.siblingsAtDepth[this.currentDepth] > 10) {
            this.nodeNr = tt.addNode((short)12, this.currentDepth, this.prevAtDepth[this.currentDepth - 1], 0, 0);
            int prev = this.prevAtDepth[this.currentDepth];
            if (prev > 0) {
                tt.next[prev] = this.nodeNr;
            }
            tt.next[this.nodeNr] = this.prevAtDepth[this.currentDepth - 1];
            this.prevAtDepth[this.currentDepth] = this.nodeNr;
            this.siblingsAtDepth[this.currentDepth] = 0;
        }
        int nameCode = elemName.allocateNameCode(this.namePool);
        this.nodeNr = tt.addNode((short)1, this.currentDepth, -1, -1, nameCode);
        this.isIDElement = (properties & 0x800) != 0;
        int typeCode = type.getFingerprint();
        if (typeCode != 630) {
            tt.setElementAnnotation(this.nodeNr, type);
            if ((properties & 0x10) != 0) {
                tt.setNilled(this.nodeNr);
            }
            if (!this.isIDElement && type.isIdType()) {
                this.isIDElement = true;
            }
        }
        if (this.currentDepth == 0) {
            this.prevAtDepth[0] = this.nodeNr;
            this.prevAtDepth[1] = -1;
            this.currentRoot = tt.getNode(this.nodeNr);
        } else {
            int prev = this.prevAtDepth[this.currentDepth];
            if (prev > 0) {
                tt.next[prev] = this.nodeNr;
            }
            tt.next[this.nodeNr] = this.prevAtDepth[this.currentDepth - 1];
            this.prevAtDepth[this.currentDepth] = this.nodeNr;
            int n = this.currentDepth;
            this.siblingsAtDepth[n] = this.siblingsAtDepth[n] + 1;
        }
        ++this.currentDepth;
        if (this.currentDepth == this.prevAtDepth.length) {
            int[] p2 = new int[this.currentDepth * 2];
            System.arraycopy(this.prevAtDepth, 0, p2, 0, this.currentDepth);
            this.prevAtDepth = p2;
            p2 = new int[this.currentDepth * 2];
            System.arraycopy(this.siblingsAtDepth, 0, p2, 0, this.currentDepth);
            this.siblingsAtDepth = p2;
        }
        this.prevAtDepth[this.currentDepth] = -1;
        this.siblingsAtDepth[this.currentDepth] = 0;
        if (!this.pipe.isLocationIsCodeLocation() && location.getSystemId() != null) {
            tt.setSystemId(this.nodeNr, location.getSystemId());
        } else if (this.currentDepth == 1) {
            tt.setSystemId(this.nodeNr, this.systemId);
        }
        if (this.lineNumbering) {
            tt.setLineNumber(this.nodeNr, location.getLineNumber(), location.getColumnNumber());
        }
    }

    public void namespace(NamespaceBinding namespaceBinding, int properties) throws XPathException {
        assert (this.tree != null);
        this.tree.addNamespace(this.nodeNr, namespaceBinding);
    }

    public void attribute(NodeName attName, SimpleType type, CharSequence value, Location locationId, int properties) throws XPathException {
        int nameCode;
        int n = nameCode = attName.hasFingerprint() ? attName.getNameCode() : attName.allocateNameCode(this.namePool);
        assert (this.tree != null);
        assert (this.currentRoot != null);
        this.tree.addAttribute(this.currentRoot, this.nodeNr, nameCode, type, value, properties);
        if (this.markDefaultedAttributes && (properties & 8) != 0) {
            this.tree.markDefaultedAttribute(this.tree.numberOfAttributes - 1);
        }
    }

    public void startContent() {
        ++this.nodeNr;
    }

    public void endElement() throws XPathException {
        TinyTree tt = this.tree;
        assert (tt != null);
        this.prevAtDepth[this.currentDepth] = -1;
        this.siblingsAtDepth[this.currentDepth] = 0;
        --this.currentDepth;
        if (this.isIDElement) {
            tt.indexIDElement(this.currentRoot, this.prevAtDepth[this.currentDepth]);
            this.isIDElement = false;
        }
    }

    public TinyNodeImpl getLastCompletedElement() {
        if (this.tree == null) {
            return null;
        }
        return this.tree.getNode(this.currentDepth >= 0 ? this.prevAtDepth[this.currentDepth] : 0);
    }

    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        if (chars instanceof CompressedWhitespace && (properties & 0x400) != 0) {
            TinyTree tt = this.tree;
            assert (tt != null);
            long lvalue = ((CompressedWhitespace)chars).getCompressedValue();
            this.nodeNr = tt.addNode((short)4, this.currentDepth, (int)(lvalue >> 32), (int)lvalue, -1);
            int prev = this.prevAtDepth[this.currentDepth];
            if (prev > 0) {
                tt.next[prev] = this.nodeNr;
            }
            tt.next[this.nodeNr] = this.prevAtDepth[this.currentDepth - 1];
            this.prevAtDepth[this.currentDepth] = this.nodeNr;
            int n = this.currentDepth;
            this.siblingsAtDepth[n] = this.siblingsAtDepth[n] + 1;
            return;
        }
        int len = chars.length();
        if (len > 0) {
            this.nodeNr = this.makeTextNode(chars, len);
        }
    }

    protected int makeTextNode(CharSequence chars, int len) {
        TinyTree tt = this.tree;
        assert (tt != null);
        int bufferStart = tt.getCharacterBuffer().length();
        tt.appendChars(chars);
        int n = tt.numberOfNodes - 1;
        if (tt.nodeKind[n] == 3 && tt.depth[n] == this.currentDepth) {
            int n2 = n;
            tt.beta[n2] = tt.beta[n2] + len;
        } else {
            this.nodeNr = tt.addNode((short)3, this.currentDepth, bufferStart, len, -1);
            int prev = this.prevAtDepth[this.currentDepth];
            if (prev > 0) {
                tt.next[prev] = this.nodeNr;
            }
            tt.next[this.nodeNr] = this.prevAtDepth[this.currentDepth - 1];
            this.prevAtDepth[this.currentDepth] = this.nodeNr;
            int n3 = this.currentDepth;
            this.siblingsAtDepth[n3] = this.siblingsAtDepth[n3] + 1;
        }
        return this.nodeNr;
    }

    public void processingInstruction(String piname, CharSequence remainder, Location locationId, int properties) throws XPathException {
        TinyTree tt = this.tree;
        assert (tt != null);
        if (tt.commentBuffer == null) {
            tt.commentBuffer = new FastStringBuffer(256);
        }
        int s2 = tt.commentBuffer.length();
        tt.commentBuffer.append(remainder.toString());
        int nameCode = this.namePool.allocate("", "", piname);
        this.nodeNr = tt.addNode((short)7, this.currentDepth, s2, remainder.length(), nameCode);
        int prev = this.prevAtDepth[this.currentDepth];
        if (prev > 0) {
            tt.next[prev] = this.nodeNr;
        }
        tt.next[this.nodeNr] = this.prevAtDepth[this.currentDepth - 1];
        this.prevAtDepth[this.currentDepth] = this.nodeNr;
        int n = this.currentDepth;
        this.siblingsAtDepth[n] = this.siblingsAtDepth[n] + 1;
        tt.setSystemId(this.nodeNr, locationId.getSystemId());
        if (this.lineNumbering) {
            tt.setLineNumber(this.nodeNr, locationId.getLineNumber(), locationId.getColumnNumber());
        }
    }

    public void comment(CharSequence chars, Location locationId, int properties) throws XPathException {
        TinyTree tt = this.tree;
        assert (tt != null);
        if (tt.commentBuffer == null) {
            tt.commentBuffer = new FastStringBuffer(256);
        }
        int s2 = tt.commentBuffer.length();
        tt.commentBuffer.append(chars.toString());
        this.nodeNr = tt.addNode((short)8, this.currentDepth, s2, chars.length(), -1);
        int prev = this.prevAtDepth[this.currentDepth];
        if (prev > 0) {
            tt.next[prev] = this.nodeNr;
        }
        tt.next[this.nodeNr] = this.prevAtDepth[this.currentDepth - 1];
        this.prevAtDepth[this.currentDepth] = this.nodeNr;
        int n = this.currentDepth;
        this.siblingsAtDepth[n] = this.siblingsAtDepth[n] + 1;
    }

    public void setUnparsedEntity(String name, String uri, String publicId) {
        if (this.tree.getUnparsedEntity(name) == null) {
            this.tree.setUnparsedEntity(name, uri, publicId);
        }
    }

    public BuilderMonitor getBuilderMonitor() {
        return new TinyBuilderMonitor(this);
    }
}

