/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.eds.threddsutilities.bean;

import gov.noaa.eds.threddsutilities.bean.MetadataContainer;
import java.util.Enumeration;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreddsDatasetTree {
    private static Logger _logger = LoggerFactory.getLogger(ThreddsDatasetTree.class);
    public Integer _id;
    public String _displayName;
    public String _url;
    public Integer _level;
    public MetadataContainer _mdc;
    public Vector<ThreddsDatasetTree> _components;
    public boolean _isLeaf;
    public boolean _isLastElement;
    public ThreddsDatasetTree _parent = null;

    public ThreddsDatasetTree(Integer id, ThreddsDatasetTree parent, String name, String url, MetadataContainer mdc, Integer level) {
        this._id = id;
        this._displayName = name;
        _logger.info("displayName=" + this._displayName);
        this._parent = parent;
        this._url = url;
        this._mdc = mdc;
        this._level = level;
        this._components = new Vector();
        this._isLeaf = false;
    }

    public void setLeaf(boolean b) {
        this._isLeaf = b;
    }

    public void setLastElement(boolean b) {
        this._isLastElement = b;
    }

    public String getName() {
        return this._displayName;
    }

    public String getUrl() {
        return this._url;
    }

    public boolean add(ThreddsDatasetTree e) {
        if (!this._isLeaf) {
            this._components.addElement(e);
        }
        return this._isLeaf;
    }

    public void remove(ThreddsDatasetTree e) {
        if (!this._isLeaf) {
            this._components.removeElement(e);
        }
    }

    public Enumeration<ThreddsDatasetTree> elements() {
        return this._components.elements();
    }

    public ThreddsDatasetTree getChild(String s) {
        ThreddsDatasetTree newDataset = null;
        if (this.getUrl().equals(s)) {
            _logger.info("returning: " + this._displayName + "; url: " + this._url);
            return this;
        }
        boolean found = false;
        Enumeration<ThreddsDatasetTree> e = this.elements();
        while (e.hasMoreElements() && !found) {
            newDataset = e.nextElement();
            found = newDataset.getName().equals(s);
            if (found) continue;
            found = (newDataset = newDataset.getChild(s)) != null;
        }
        if (found) {
            _logger.info("found: " + newDataset._url);
            return newDataset;
        }
        return null;
    }
}

