/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import net.sf.saxon.dom.DocumentOverNodeInfo;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.dom.TypeInfoImpl;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public class ElementOverNodeInfo
extends NodeOverNodeInfo
implements Element {
    public String getTagName() {
        return this.node.getDisplayName();
    }

    public NodeList getElementsByTagName(String name) {
        return DocumentOverNodeInfo.getElementsByTagName(this.node, name);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) throws DOMException {
        return DocumentOverNodeInfo.getElementsByTagNameNS(this.node, namespaceURI, localName);
    }

    public String getAttribute(String name) {
        NodeInfo att;
        AxisIterator atts = this.node.iterateAxis((byte)2);
        do {
            if ((att = atts.next()) != null) continue;
            return "";
        } while (!att.getDisplayName().equals(name));
        String val = att.getStringValue();
        if (val == null) {
            return "";
        }
        return val;
    }

    public Attr getAttributeNode(String name) {
        NodeInfo att;
        AxisIterator atts = this.node.iterateAxis((byte)2);
        do {
            if ((att = atts.next()) != null) continue;
            return null;
        } while (!att.getDisplayName().equals(name));
        return (Attr)((Object)att);
    }

    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        ElementOverNodeInfo.disallowUpdate();
        return null;
    }

    public void removeAttribute(String oldAttr) throws DOMException {
        ElementOverNodeInfo.disallowUpdate();
    }

    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        ElementOverNodeInfo.disallowUpdate();
        return null;
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        String val = Navigator.getAttributeValue(this.node, namespaceURI == null ? "" : namespaceURI, localName);
        if (val == null) {
            return "";
        }
        return val;
    }

    public void setAttribute(String name, String value) throws DOMException {
        ElementOverNodeInfo.disallowUpdate();
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        ElementOverNodeInfo.disallowUpdate();
    }

    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        ElementOverNodeInfo.disallowUpdate();
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        NamePool pool = this.node.getConfiguration().getNamePool();
        NameTest test = new NameTest(2, namespaceURI, localName, pool);
        AxisIterator atts = this.node.iterateAxis((byte)2, test);
        return (Attr)((Object)ElementOverNodeInfo.wrap(atts.next()));
    }

    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        ElementOverNodeInfo.disallowUpdate();
        return null;
    }

    public boolean hasAttribute(String name) {
        NodeInfo att;
        AxisIterator atts = this.node.iterateAxis((byte)2);
        do {
            if ((att = atts.next()) != null) continue;
            return false;
        } while (!att.getDisplayName().equals(name));
        return true;
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return Navigator.getAttributeValue(this.node, namespaceURI == null ? "" : namespaceURI, localName) != null;
    }

    public void setIdAttribute(String name, boolean isId) throws DOMException {
        ElementOverNodeInfo.disallowUpdate();
    }

    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        ElementOverNodeInfo.disallowUpdate();
    }

    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        ElementOverNodeInfo.disallowUpdate();
    }

    public TypeInfo getSchemaTypeInfo() {
        SchemaType type = this.node.getSchemaType();
        if (type == null || Untyped.getInstance().equals(type) || BuiltInAtomicType.UNTYPED_ATOMIC.equals(type)) {
            return null;
        }
        return new TypeInfoImpl(this.node.getConfiguration(), type);
    }
}

