/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pull;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.EntityDeclaration;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.pull.PullPushCopier;
import net.sf.saxon.pull.UnparsedEntity;
import net.sf.saxon.serialize.XMLEmitter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.CharSlice;
import net.sf.saxon.tree.tiny.CompressedWhitespace;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Whitespace;

public class StaxBridge
implements PullProvider {
    private XMLStreamReader reader;
    private StaxAttributes attributes = new StaxAttributes();
    private PipelineConfiguration pipe;
    private List unparsedEntities = null;
    int currentEvent = 0;
    int depth = 0;
    boolean ignoreIgnorable = false;

    public void setInputStream(String systemId, InputStream inputStream) throws XPathException {
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setXMLReporter(new StaxErrorReporter());
            this.reader = factory.createXMLStreamReader(systemId, inputStream);
        }
        catch (XMLStreamException e) {
            throw new XPathException(e);
        }
    }

    public void setXMLStreamReader(XMLStreamReader reader) {
        this.reader = reader;
    }

    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        this.pipe = new PipelineConfiguration(pipe);
        this.ignoreIgnorable = pipe.getConfiguration().getStripsWhiteSpace() != 0;
    }

    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipe;
    }

    public XMLStreamReader getXMLStreamReader() {
        return this.reader;
    }

    public NamePool getNamePool() {
        return this.pipe.getConfiguration().getNamePool();
    }

    public int next() throws XPathException {
        if (this.currentEvent == 0) {
            this.currentEvent = 2;
            return this.currentEvent;
        }
        if (this.currentEvent == -1 || this.currentEvent == 3) {
            try {
                this.reader.close();
            }
            catch (XMLStreamException e) {
                throw new XPathException(e);
            }
            return -1;
        }
        try {
            if (this.reader.hasNext()) {
                int event = this.reader.next();
                this.currentEvent = this.translate(event);
            } else {
                this.currentEvent = -1;
            }
        }
        catch (XMLStreamException e) {
            int c;
            String message = e.getMessage();
            if (message.startsWith("ParseError at") && (c = message.indexOf("\nMessage: ")) > 0) {
                message = message.substring(c + 10);
            }
            XPathException err = new XPathException("Error reported by XML parser: " + message, e);
            err.setErrorCode("SXXP0003");
            err.setLocator(this.translateLocation(e.getLocation()));
            throw err;
        }
        return this.currentEvent;
    }

    private int translate(int event) throws XPathException {
        switch (event) {
            case 10: {
                return 6;
            }
            case 12: {
                return 8;
            }
            case 4: {
                if (this.depth == 0 && this.reader.isWhiteSpace()) {
                    return this.next();
                }
                return 8;
            }
            case 5: {
                return 9;
            }
            case 11: {
                this.unparsedEntities = (List)this.reader.getProperty("javax.xml.stream.entities");
                return this.next();
            }
            case 8: {
                return 3;
            }
            case 2: {
                --this.depth;
                return 5;
            }
            case 15: {
                return this.next();
            }
            case 9: {
                return this.next();
            }
            case 13: {
                return 7;
            }
            case 14: {
                return this.next();
            }
            case 3: {
                return 10;
            }
            case 6: {
                if (this.depth == 0) {
                    return this.next();
                }
                if (this.ignoreIgnorable) {
                    return this.next();
                }
                return 8;
            }
            case 7: {
                return this.next();
            }
            case 1: {
                ++this.depth;
                return 4;
            }
        }
        throw new IllegalStateException("Unknown StAX event " + event);
    }

    public int current() {
        return this.currentEvent;
    }

    public AttributeCollection getAttributes() throws XPathException {
        return this.attributes;
    }

    public NamespaceBinding[] getNamespaceDeclarations() throws XPathException {
        int n = this.reader.getNamespaceCount();
        if (n == 0) {
            return NamespaceBinding.EMPTY_ARRAY;
        }
        NamespaceBinding[] bindings = new NamespaceBinding[n];
        for (int i = 0; i < n; ++i) {
            String uri;
            String prefix = this.reader.getNamespacePrefix(i);
            if (prefix == null) {
                prefix = "";
            }
            if ((uri = this.reader.getNamespaceURI(i)) == null) {
                uri = "";
            }
            bindings[i] = new NamespaceBinding(prefix, uri);
        }
        return bindings;
    }

    public int skipToMatchingEnd() throws XPathException {
        switch (this.currentEvent) {
            case 2: {
                this.currentEvent = 3;
                return this.currentEvent;
            }
            case 4: {
                try {
                    int skipDepth = 0;
                    while (this.reader.hasNext()) {
                        int event = this.reader.next();
                        if (event == 1) {
                            ++skipDepth;
                            continue;
                        }
                        if (event != 2 || skipDepth-- != 0) continue;
                        this.currentEvent = 5;
                        return this.currentEvent;
                    }
                }
                catch (XMLStreamException e) {
                    throw new XPathException(e);
                }
                throw new IllegalStateException("Element start has no matching element end");
            }
        }
        throw new IllegalStateException("Cannot call skipToMatchingEnd() except when at start of element or document");
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    public NodeName getNodeName() {
        if (this.currentEvent == 4 || this.currentEvent == 5) {
            String local = this.reader.getLocalName();
            String uri = this.reader.getNamespaceURI();
            if (uri == null) {
                return new NoNamespaceName(local);
            }
            return new FingerprintedQName(this.reader.getPrefix(), uri, local);
        }
        if (this.currentEvent == 10) {
            String local = this.reader.getPITarget();
            return new NoNamespaceName(local);
        }
        throw new IllegalStateException();
    }

    public CharSequence getStringValue() throws XPathException {
        switch (this.currentEvent) {
            case 8: {
                CharSlice cs = new CharSlice(this.reader.getTextCharacters(), this.reader.getTextStart(), this.reader.getTextLength());
                return CompressedWhitespace.compress(cs);
            }
            case 9: {
                return new CharSlice(this.reader.getTextCharacters(), this.reader.getTextStart(), this.reader.getTextLength());
            }
            case 10: {
                String s2 = this.reader.getPIData();
                return Whitespace.removeLeadingWhitespace(s2);
            }
            case 4: {
                FastStringBuffer combinedText = null;
                try {
                    int depth = 0;
                    while (this.reader.hasNext()) {
                        int event = this.reader.next();
                        if (event == 4) {
                            if (combinedText == null) {
                                combinedText = new FastStringBuffer(64);
                            }
                            combinedText.append(this.reader.getTextCharacters(), this.reader.getTextStart(), this.reader.getTextLength());
                            continue;
                        }
                        if (event == 1) {
                            ++depth;
                            continue;
                        }
                        if (event != 2 || depth-- != 0) continue;
                        this.currentEvent = 5;
                        if (combinedText != null) {
                            return combinedText.condense();
                        }
                        return "";
                    }
                    break;
                }
                catch (XMLStreamException e) {
                    throw new XPathException(e);
                }
            }
        }
        throw new IllegalStateException("getStringValue() called when current event is " + this.currentEvent);
    }

    public AtomicValue getAtomicValue() {
        throw new IllegalStateException();
    }

    public SchemaType getSchemaType() {
        if (this.currentEvent == 4) {
            return Untyped.getInstance();
        }
        if (this.currentEvent == 6) {
            return BuiltInAtomicType.UNTYPED_ATOMIC;
        }
        return null;
    }

    public net.sf.saxon.expr.parser.Location getSourceLocator() {
        return this.translateLocation(this.reader.getLocation());
    }

    private ExplicitLocation translateLocation(Location location) {
        if (location == null) {
            return ExplicitLocation.UNKNOWN_LOCATION;
        }
        return new ExplicitLocation(location.getSystemId(), location.getLineNumber(), location.getColumnNumber());
    }

    public String getPublicId() {
        return this.reader.getLocation().getPublicId();
    }

    public String getSystemId() {
        Location location = this.reader.getLocation();
        return location == null ? null : location.getSystemId();
    }

    public int getLineNumber() {
        Location location = this.reader.getLocation();
        return location == null ? -1 : location.getLineNumber();
    }

    public int getColumnNumber() {
        return this.reader.getLocation().getColumnNumber();
    }

    public String getSystemId(int locationId) {
        return this.getSystemId();
    }

    public int getLineNumber(int locationId) {
        return this.getLineNumber();
    }

    public int getColumnNumber(int locationId) {
        return this.getColumnNumber();
    }

    public List getUnparsedEntities() {
        if (this.unparsedEntities == null) {
            return null;
        }
        ArrayList<UnparsedEntity> list = new ArrayList<UnparsedEntity>(this.unparsedEntities.size());
        for (int i = 0; i < this.unparsedEntities.size(); ++i) {
            Object ent = this.unparsedEntities.get(i);
            String name = null;
            String systemId = null;
            String publicId = null;
            String baseURI = null;
            if (ent instanceof EntityDeclaration) {
                EntityDeclaration ed = (EntityDeclaration)ent;
                name = ed.getName();
                systemId = ed.getSystemId();
                publicId = ed.getPublicId();
                baseURI = ed.getBaseURI();
            } else if (ent.getClass().getName().equals("com.ctc.wstx.ent.UnparsedExtEntity")) {
                try {
                    Class<?> woodstoxClass = ent.getClass();
                    Class[] noArgs = new Class[]{};
                    Method method = woodstoxClass.getMethod("getName", noArgs);
                    name = (String)method.invoke(ent, (Object[])noArgs);
                    method = woodstoxClass.getMethod("getSystemId", noArgs);
                    systemId = (String)method.invoke(ent, (Object[])noArgs);
                    method = woodstoxClass.getMethod("getPublicId", noArgs);
                    publicId = (String)method.invoke(ent, (Object[])noArgs);
                    method = woodstoxClass.getMethod("getBaseURI", noArgs);
                    baseURI = (String)method.invoke(ent, (Object[])noArgs);
                }
                catch (NoSuchMethodException woodstoxClass) {
                }
                catch (IllegalAccessException woodstoxClass) {
                }
                catch (InvocationTargetException woodstoxClass) {
                    // empty catch block
                }
            }
            if (name == null) continue;
            if (baseURI != null && systemId != null) {
                try {
                    systemId = new URI(baseURI).resolve(systemId).toString();
                }
                catch (URISyntaxException woodstoxClass) {
                    // empty catch block
                }
            }
            UnparsedEntity ue = new UnparsedEntity();
            ue.setName(name);
            ue.setSystemId(systemId);
            ue.setPublicId(publicId);
            ue.setBaseURI(baseURI);
            list.add(ue);
        }
        return list;
    }

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < 1; ++i) {
            long startTime = System.currentTimeMillis();
            PipelineConfiguration pipe = new Configuration().makePipelineConfiguration();
            StaxBridge puller = new StaxBridge();
            puller.setPipelineConfiguration(pipe);
            File f = new File(args[0]);
            puller.setInputStream(f.toURI().toString(), new FileInputStream(f));
            XMLEmitter emitter = new XMLEmitter();
            emitter.setPipelineConfiguration(pipe);
            emitter.setOutputProperties(new Properties());
            if (args.length > 1) {
                emitter.setOutputStream(new FileOutputStream(args[1]));
            } else {
                emitter.setOutputStream(System.out);
            }
            NamespaceReducer r = new NamespaceReducer(emitter);
            new PullPushCopier(puller, r).copy();
            System.err.println("Elapsed time: " + (System.currentTimeMillis() - startTime) + "ms");
        }
    }

    private class StaxErrorReporter
    implements XMLReporter {
        private StaxErrorReporter() {
        }

        public void report(String message, String errorType, Object relatedInformation, Location location) throws XMLStreamException {
            ExplicitLocation loc = StaxBridge.this.translateLocation(location);
            XPathException err = new XPathException("Error reported by XML parser: " + message + " (" + errorType + ')');
            err.setLocator(loc);
            StaxBridge.this.pipe.getErrorListener().error(err);
        }
    }

    private class StaxAttributes
    implements AttributeCollection {
        private StaxAttributes() {
        }

        public int getLength() {
            return StaxBridge.this.reader.getAttributeCount();
        }

        public int getNameCode(int index) {
            String local = StaxBridge.this.reader.getAttributeLocalName(index);
            String uri = StaxBridge.this.reader.getAttributeNamespace(index);
            String prefix = StaxBridge.this.reader.getAttributePrefix(index);
            if (prefix == null) {
                prefix = "";
            }
            if (uri == null) {
                uri = "";
            }
            return StaxBridge.this.getNamePool().allocate(prefix, uri, local);
        }

        public NodeName getNodeName(int index) {
            String local = StaxBridge.this.reader.getAttributeLocalName(index);
            String uri = StaxBridge.this.reader.getAttributeNamespace(index);
            String prefix = StaxBridge.this.reader.getAttributePrefix(index);
            if (prefix == null) {
                prefix = "";
            }
            if (uri == null) {
                uri = "";
            }
            return new FingerprintedQName(prefix, uri, local);
        }

        public SimpleType getTypeAnnotation(int index) {
            String type = StaxBridge.this.reader.getAttributeType(index);
            if ("ID".equals(type)) {
                return BuiltInAtomicType.ID;
            }
            return BuiltInAtomicType.UNTYPED_ATOMIC;
        }

        public net.sf.saxon.expr.parser.Location getLocation(int index) {
            return ExplicitLocation.UNKNOWN_LOCATION;
        }

        public String getSystemId(int index) {
            return StaxBridge.this.reader.getLocation().getSystemId();
        }

        public int getLineNumber(int index) {
            return StaxBridge.this.reader.getLocation().getLineNumber();
        }

        public int getProperties(int index) {
            int properties = 0;
            if (!StaxBridge.this.reader.isAttributeSpecified(index)) {
                properties |= 8;
            }
            if (this.isIdref(index)) {
                properties |= 0x3000;
            }
            return properties;
        }

        public String getPrefix(int index) {
            return this.getNodeName(index).getPrefix();
        }

        public String getQName(int index) {
            return this.getNodeName(index).getDisplayName();
        }

        public String getLocalName(int index) {
            return StaxBridge.this.reader.getAttributeLocalName(index);
        }

        public String getURI(int index) {
            return StaxBridge.this.reader.getAttributeNamespace(index);
        }

        public int getIndex(String uri, String localname) {
            for (int i = 0; i < this.getLength(); ++i) {
                if (!this.getLocalName(i).equals(localname) || !this.getURI(i).equals(uri)) continue;
                return i;
            }
            return -1;
        }

        public int getIndexByFingerprint(int fingerprint) {
            return this.getIndex(StaxBridge.this.getNamePool().getURI(fingerprint), StaxBridge.this.getNamePool().getLocalName(fingerprint));
        }

        public String getValueByFingerprint(int fingerprint) {
            return this.getValue(this.getIndexByFingerprint(fingerprint));
        }

        public String getValue(String uri, String localname) {
            return StaxBridge.this.reader.getAttributeValue(uri, localname);
        }

        public String getValue(int index) {
            return StaxBridge.this.reader.getAttributeValue(index);
        }

        public boolean isId(int index) {
            return "ID".equals(StaxBridge.this.reader.getAttributeType(index));
        }

        public boolean isIdref(int index) {
            String attributeType = StaxBridge.this.reader.getAttributeType(index);
            return "IDREF".equals(attributeType) || "IDREFS".equals(attributeType);
        }
    }
}

