/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.UnionType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class CastToUnion
extends UnaryExpression {
    private UnionType targetType;
    private boolean allowEmpty;

    public CastToUnion(Expression source, UnionType targetType, boolean allowEmpty) {
        super(source);
        this.targetType = targetType;
        this.allowEmpty = allowEmpty;
    }

    protected OperandRole getOperandRole() {
        return OperandRole.SINGLE_ATOMIC;
    }

    public boolean isAllowEmpty() {
        return this.allowEmpty;
    }

    public UnionType getTargetType() {
        return this.targetType;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.getRetainedStaticContext();
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.typeCheckChildren(visitor, contextInfo);
        SequenceType atomicType = SequenceType.makeSequenceType(BuiltInAtomicType.ANY_ATOMIC, this.getCardinality());
        RoleDiagnostic role = new RoleDiagnostic(2, "cast as", 0);
        Expression operand = TypeChecker.staticTypeCheck(this.getBaseExpression(), atomicType, false, role, visitor);
        this.setBaseExpression(operand);
        if (operand instanceof Literal) {
            GroundedValue literalOperand = ((Literal)operand).getValue();
            if (literalOperand instanceof AtomicValue) {
                GroundedValue av = SequenceTool.toGroundedValue(this.iterate(visitor.getStaticContext().makeEarlyEvaluationContext()));
                return Literal.makeLiteral(av);
            }
            if (literalOperand.getLength() == 0) {
                if (this.allowEmpty) {
                    return operand;
                }
                XPathException err = new XPathException("Cast can never succeed: the operand must not be an empty sequence");
                err.setErrorCode("XPTY0004");
                err.setLocation(this.getLocation());
                err.setIsTypeError(true);
                throw err;
            }
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        Expression e2 = super.optimize(visitor, contextInfo);
        if (e2 != this) {
            return e2;
        }
        if (!Cardinality.allowsZero(this.getBaseExpression().getCardinality())) {
            this.allowEmpty = false;
            this.resetLocalStaticProperties();
        }
        return this;
    }

    public int computeCardinality() {
        int c = 16384;
        if (this.allowEmpty && Cardinality.allowsZero(this.getBaseExpression().getCardinality())) {
            c |= 0x2000;
        }
        try {
            if (this.targetType.containsListType()) {
                c |= 0x2000;
                c |= 0x8000;
            }
        }
        catch (MissingComponentException e) {
            c |= 0x2000;
            c |= 0x8000;
        }
        return c;
    }

    public ItemType getItemType() {
        if (this.targetType instanceof PlainType) {
            return this.targetType;
        }
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return p | 0x400000;
    }

    public Expression copy(RebindingMap rebindings) {
        CastToUnion c = new CastToUnion(this.getBaseExpression().copy(rebindings), this.targetType, this.allowEmpty);
        ExpressionTool.copyLocationInfo(this, c);
        c.setRetainedStaticContext(this.getRetainedStaticContext());
        return c;
    }

    public int getImplementationMethod() {
        return 2;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        ConversionRules rules = context.getConfiguration().getConversionRules();
        AtomicValue value = (AtomicValue)this.getBaseExpression().evaluateItem(context);
        if (value == null) {
            if (this.allowEmpty) {
                return null;
            }
            XPathException e = new XPathException("Cast does not allow an empty sequence");
            e.setXPathContext(context);
            e.setLocation(this.getLocation());
            e.setErrorCode("XPTY0004");
            throw e;
        }
        try {
            AtomicSequence result = CastToUnion.cast(value, this.targetType, this.getRetainedStaticContext(), rules);
            return result.iterate();
        }
        catch (XPathException err) {
            err.maybeSetContext(context);
            err.maybeSetLocation(this.getLocation());
            err.setErrorCode("FORG0001");
            throw err;
        }
    }

    public static boolean castable(AtomicValue value, UnionType targetType, NamespaceResolver nsResolver, XPathContext context) {
        try {
            CastToUnion.cast(value, targetType, nsResolver, context.getConfiguration().getConversionRules());
            return true;
        }
        catch (XPathException err) {
            return false;
        }
    }

    public static AtomicSequence cast(AtomicValue value, UnionType targetType, NamespaceResolver nsResolver, ConversionRules rules) throws XPathException {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value instanceof StringValue && !(value instanceof AnyURIValue)) {
            try {
                return targetType.getTypedValue(value.getStringValueCS(), nsResolver, rules);
            }
            catch (ValidationException e) {
                e.setErrorCode("FORG0001");
                throw e;
            }
        }
        AtomicType label = value.getItemType();
        Iterable<PlainType> memberTypes = targetType.getPlainMemberTypes();
        for (PlainType member : memberTypes) {
            if (!label.equals(member)) continue;
            return value;
        }
        for (PlainType member : memberTypes) {
            AtomicType t2 = label;
            while (t2 != null) {
                if (t2.equals(member)) {
                    return value;
                }
                t2 = t2.getBaseType() instanceof AtomicType ? (AtomicType)t2.getBaseType() : null;
            }
        }
        for (PlainType type : memberTypes) {
            ConversionResult result;
            Converter c;
            if (!(type instanceof AtomicType) || (c = rules.getConverter(value.getItemType(), (AtomicType)type)) == null || !((result = c.convert(value)) instanceof AtomicValue)) continue;
            return (AtomicValue)result;
        }
        throw new XPathException("Cannot convert the supplied value to " + targetType.getDescription(), "FORG0001");
    }

    public boolean equals(Object other) {
        return super.equals(other) && other instanceof CastToUnion && this.targetType == ((CastToUnion)other).targetType && this.allowEmpty == ((CastToUnion)other).allowEmpty && ExpressionTool.equalOrNull(this.getRetainedStaticContext(), ((CastToUnion)other).getRetainedStaticContext());
    }

    public int hashCode() {
        return super.hashCode() ^ this.targetType.hashCode();
    }

    public String toString() {
        return this.targetType.getEQName() + "(" + this.getBaseExpression().toString() + ")";
    }

    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("castToUnion", this);
        out.emitAttribute("as", this.targetType.toString());
        this.getBaseExpression().export(out);
        out.endElement();
    }
}

