/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.File;
import java.io.FilenameFilter;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.trans.Instantiator;
import net.sf.saxon.trans.Maker;
import net.sf.saxon.tree.util.FastStringBuffer;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URIQueryParameters {
    FilenameFilter filter = null;
    Boolean recurse = null;
    Integer validation = null;
    int strip = 3;
    Integer onError = null;
    Maker<XMLReader> parserMaker = null;
    Boolean xinclude = null;
    boolean unparsed;
    Boolean stable = null;
    Boolean metadata = null;
    public static final int ON_ERROR_FAIL = 1;
    public static final int ON_ERROR_WARNING = 2;
    public static final int ON_ERROR_IGNORE = 3;

    public URIQueryParameters(String query, Configuration config) {
        if (query != null) {
            StringTokenizer t2 = new StringTokenizer(query, ";&");
            while (t2.hasMoreTokens()) {
                String tok = t2.nextToken();
                int eq = tok.indexOf(61);
                if (eq <= 0 || eq >= tok.length() - 1) continue;
                String keyword = tok.substring(0, eq);
                String value = tok.substring(eq + 1);
                this.processParameter(config, keyword, value);
            }
        }
    }

    private void processParameter(Configuration config, String keyword, String value) {
        if (keyword.equals("select")) {
            this.filter = URIQueryParameters.makeGlobFilter(value);
        } else if (keyword.equals("recurse")) {
            this.recurse = "yes".equals(value);
        } else if (keyword.equals("validation")) {
            int v = Validation.getCode(value);
            if (v != -1) {
                this.validation = v;
            }
        } else if (keyword.equals("strip-space")) {
            if (value.equals("yes")) {
                this.strip = 2;
            } else if (value.equals("ignorable")) {
                this.strip = 1;
            } else if (value.equals("no")) {
                this.strip = 0;
            }
        } else if (keyword.equals("stable")) {
            if (value.equals("yes")) {
                this.stable = Boolean.TRUE;
            } else if (value.equals("no")) {
                this.stable = Boolean.FALSE;
            }
        } else if (keyword.equals("metadata")) {
            if (value.equals("yes")) {
                this.metadata = Boolean.TRUE;
            } else if (value.equals("no")) {
                this.metadata = Boolean.FALSE;
            }
        } else if (keyword.equals("xinclude")) {
            if (value.equals("yes")) {
                this.xinclude = Boolean.TRUE;
            } else if (value.equals("no")) {
                this.xinclude = Boolean.FALSE;
            }
        } else if (keyword.equals("unparsed")) {
            if (value.equals("yes")) {
                this.unparsed = true;
            } else if (value.equals("no")) {
                this.unparsed = false;
            }
        } else if (keyword.equals("on-error")) {
            if (value.equals("warning")) {
                this.onError = 2;
            } else if (value.equals("ignore")) {
                this.onError = 3;
            } else if (value.equals("fail")) {
                this.onError = 1;
            }
        } else if (keyword.equals("parser") && config != null) {
            this.parserMaker = new Instantiator<XMLReader>(value, config);
        }
    }

    public static FilenameFilter makeGlobFilter(String value) {
        FastStringBuffer sb = new FastStringBuffer(value.length() + 6);
        sb.append('^');
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '.') {
                sb.append("\\.");
                continue;
            }
            if (c == '*') {
                sb.append(".*");
                continue;
            }
            if (c == '?') {
                sb.append(".?");
                continue;
            }
            sb.append(c);
        }
        sb.append('$');
        String s2 = sb.toString();
        Pattern pattern = Pattern.compile(s2);
        return new RegexFilter(pattern);
    }

    public int getStripSpace() {
        return this.strip;
    }

    public Integer getValidationMode() {
        return this.validation;
    }

    public FilenameFilter getFilenameFilter() {
        return this.filter;
    }

    public Boolean getRecurse() {
        return this.recurse;
    }

    public Integer getOnError() {
        return this.onError;
    }

    public Boolean getXInclude() {
        return this.xinclude;
    }

    public Boolean getMetaData() {
        return this.metadata;
    }

    public boolean isUnparsed() {
        return this.unparsed;
    }

    public Boolean getStable() {
        return this.stable;
    }

    public Maker<XMLReader> getXMLReaderMaker() {
        return this.parserMaker;
    }

    public static class RegexFilter
    implements FilenameFilter {
        private Pattern pattern;

        public RegexFilter(Pattern regex) {
            this.pattern = regex;
        }

        public boolean accept(File dir, String name) {
            return new File(dir, name).isDirectory() || this.pattern.matcher(name).matches();
        }

        public boolean matches(String name) {
            return this.pattern.matcher(name).matches();
        }
    }
}

