/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Tokenizer;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.functions.Doc;
import net.sf.saxon.functions.KeyFn;
import net.sf.saxon.functions.SuperId;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternMaker;
import net.sf.saxon.pattern.PatternParser;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;

public class PatternParser20
extends XPathParser
implements PatternParser {
    int inPredicate = 0;

    public Pattern parsePattern(String pattern, StaticContext env, int lineNumber) throws XPathException {
        this.env = env;
        this.language = 1;
        Expression exp = this.parse(pattern, 0, 0, env);
        exp.setRetainedStaticContext(env.makeRetainedStaticContext());
        ExpressionVisitor visitor = ExpressionVisitor.make(env);
        ContextItemStaticInfo cit = new ContextItemStaticInfo(AnyItemType.getInstance(), true);
        Pattern pat = PatternMaker.fromExpression(exp.simplify().typeCheck(visitor, cit), env.getConfiguration(), false);
        if (exp instanceof FilterExpression && pat instanceof NodeTestPattern) {
            ((NodeTestPattern)pat).setPriority(0.5);
        }
        return pat;
    }

    protected void customizeTokenizer(Tokenizer t2) {
        t2.disallowUnionKeyword = true;
    }

    public Expression parseExpression() throws XPathException {
        if (this.inPredicate > 0) {
            return super.parseExpression();
        }
        return this.parseBinaryExpression(this.parsePathExpression(), 10);
    }

    protected Expression parseBasicStep(boolean firstInPattern) throws XPathException {
        if (this.inPredicate > 0) {
            return super.parseBasicStep(firstInPattern);
        }
        switch (this.t.currentToken) {
            case 21: {
                this.grumble("A variable reference is not allowed in an XSLT pattern (except in a predicate)");
                return null;
            }
            case 5: {
                this.grumble("Parentheses are not allowed in an XSLT 2.0 pattern");
                return null;
            }
            case 43: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 202: 
            case 205: 
            case 206: 
            case 209: 
            case 217: {
                this.grumble("Token " + this.currentTokenDisplay() + " not allowed here in an XSLT 2.0 pattern");
                return null;
            }
            case 35: {
                if (!firstInPattern) {
                    this.grumble("In an XSLT pattern, a function call is allowed only as the first step in a path");
                }
                return super.parseBasicStep(firstInPattern);
            }
        }
        return super.parseBasicStep(firstInPattern);
    }

    protected void testPermittedAxis(byte axis, String errorCode) throws XPathException {
        if (this.inPredicate == 0 && axis != 3 && axis != 2) {
            this.grumble("Unless XSLT 3.0 is enabled, the only axes allowed in a pattern are the child and attribute axes");
        }
    }

    protected Expression parsePredicate() throws XPathException {
        boolean disallow = this.t.disallowUnionKeyword;
        this.t.disallowUnionKeyword = false;
        ++this.inPredicate;
        Expression exp = this.parseExpression();
        --this.inPredicate;
        this.t.disallowUnionKeyword = disallow;
        return exp;
    }

    public Expression parseFunctionCall(Expression prefixArgument) throws XPathException {
        Expression fn = super.parseFunctionCall(prefixArgument);
        if (this.inPredicate > 0) {
            return fn;
        }
        if (fn.isCallOn(SuperId.class)) {
            SystemFunctionCall fnc = (SystemFunctionCall)fn;
            if (fnc.getArity() == 1 || fnc.getArity() == 2 && fnc.getArg(1) instanceof RootExpression) {
                Expression arg = fnc.getArg(0);
                if (!(arg instanceof VariableReference) && !(arg instanceof StringLiteral)) {
                    this.grumble("Argument to id() in a pattern must be a variable reference or string literal");
                }
            } else {
                this.grumble("id() in an XSLT 2.0 pattern must have only one argument");
            }
        } else if (fn.isCallOn(KeyFn.class)) {
            SystemFunctionCall fnc = (SystemFunctionCall)fn;
            if (fnc.getArity() == 2 || fnc.getArity() == 3 && fnc.getArg(2) instanceof RootExpression) {
                Expression arg1;
                Expression arg0 = fnc.getArg(0);
                if (!(arg0 instanceof StringLiteral)) {
                    this.grumble("First argument to key() in an XSLT 2.0 pattern must be a string literal");
                }
                if (!((arg1 = fnc.getArg(1)) instanceof VariableReference) && !(arg1 instanceof Literal)) {
                    this.grumble("Second argument to id() in an XSLT 2.0 pattern must be a variable reference or literal");
                }
            } else {
                this.grumble("key() in an XSLT 2.0 pattern must have exactly two arguments");
            }
        } else if (fn.isCallOn(Doc.class)) {
            this.grumble("The doc() function is not allowed in an XSLT 2.0 pattern");
        } else {
            this.grumble("The " + fn.toString() + " function is not allowed at the head of a pattern");
        }
        return fn;
    }

    public Expression parseFunctionArgument() throws XPathException {
        if (this.inPredicate > 0) {
            return super.parseFunctionArgument();
        }
        switch (this.t.currentToken) {
            case 21: {
                return this.parseVariableReference();
            }
            case 202: {
                return this.parseStringLiteral(true);
            }
            case 209: {
                return this.parseNumericLiteral(true);
            }
        }
        this.grumble("A function argument in an XSLT pattern must be a variable reference or literal");
        return null;
    }

    public Expression makeTracer(int startOffset, Expression exp, int construct, StructuredQName qName) {
        return exp;
    }
}

