/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import opendap.dap.Alias;
import opendap.dap.Attribute;
import opendap.dap.AttributeExistsException;
import opendap.dap.DAPNode;
import opendap.dap.DASException;
import opendap.dap.NoSuchAttributeException;
import opendap.dap.parsers.DDSXMLParser;
import opendap.util.Debug;
import opendap.util.SortedTable;

public class AttributeTable
extends DAPNode {
    private SortedTable _attr = new SortedTable();

    public AttributeTable() {
    }

    public AttributeTable(String clearname) {
        super(clearname);
    }

    public int size() {
        return this._attr == null ? 0 : this._attr.size();
    }

    public final Enumeration getNames() {
        return this._attr.keys();
    }

    public final Attribute getAttribute(String clearname) {
        Attribute a = (Attribute)this._attr.get(clearname);
        return a;
    }

    public final boolean hasAttribute(String clearname) {
        Attribute a = (Attribute)this._attr.get(clearname);
        return a != null;
    }

    public final void appendAttribute(String clearname, int type, String value, boolean check) throws DASException {
        Attribute a = (Attribute)this._attr.get(clearname);
        if (a != null && type != a.getType()) {
            throw new AttributeExistsException("The Attribute `" + clearname + "' was previously defined with a different type.");
        }
        if (a != null) {
            a.appendValue(value, check);
        } else {
            a = new Attribute(type, clearname, value, check);
            this._attr.put(clearname, a);
        }
    }

    public final void appendAttribute(String clearname, int type, String value) throws DASException {
        this.appendAttribute(clearname, type, value, true);
    }

    public final AttributeTable appendContainer(String clearname) {
        if (this._attr.get(clearname) != null) {
            return null;
        }
        AttributeTable at = new AttributeTable(clearname);
        Attribute a = new Attribute(clearname, at);
        this._attr.put(clearname, a);
        return at;
    }

    public final void addContainer(String clearname, AttributeTable at) throws AttributeExistsException {
        if (this._attr.get(clearname) != null) {
            throw new AttributeExistsException("The Attribute '" + clearname + "' already exists in the container '" + this.getEncodedName() + "'");
        }
        Attribute a = new Attribute(clearname, at);
        this._attr.put(clearname, a);
    }

    public final void addAlias(String alias, String attributeName) throws NoSuchAttributeException, AttributeExistsException {
        if (this._attr.get(alias) != null) {
            throw new AttributeExistsException("Could not alias `" + alias + "' to `" + attributeName + "'. It is a duplicat name in this AttributeTable");
        }
        if (Debug.isSet("AttributTable")) {
            log.debug("Adding alias '" + alias + "' to AttributeTable '" + this.getClearName() + "'");
        }
        Alias newAlias = new Alias(alias, attributeName);
        this._attr.put(alias, newAlias);
    }

    public final void delAttribute(String clearname) {
        this._attr.remove(clearname);
    }

    public final void delAttribute(String clearname, int i) throws DASException {
        if (i == -1) {
            this._attr.remove(clearname);
        } else {
            Attribute a = (Attribute)this._attr.get(clearname);
            if (a != null) {
                if (a.isContainer()) {
                    this._attr.remove(clearname);
                } else {
                    a.deleteValueAt(i);
                }
            }
        }
    }

    public void print(PrintWriter os, String pad) {
        if (Debug.isSet("AttributTable")) {
            os.println("Entered AttributeTable.print()");
        }
        os.println(pad + this.getEncodedName() + " {");
        Enumeration e = this.getNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Attribute a = this.getAttribute(name);
            if (a == null) continue;
            a.print(os, pad + "    ");
        }
        os.println(pad + "}");
        if (Debug.isSet("AttributTable")) {
            os.println("Leaving AttributeTable.print()");
        }
        os.flush();
    }

    public final void print(OutputStream os, String pad) {
        this.print(new PrintWriter(new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8))), pad);
    }

    public final void print(PrintStream os) {
        this.print(os, "");
    }

    public final void print(PrintWriter os) {
        this.print(os, "");
    }

    public final void print(OutputStream os) {
        this.print(os, "");
    }

    public void printXML(OutputStream os, String pad) {
        PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8)));
        this.printXML(pw, pad);
        pw.flush();
    }

    public void printXML(PrintWriter pw) {
        this.printXML(pw, "");
    }

    public void printXML(PrintWriter pw, String pad) {
        this.printXML(pw, pad, false);
    }

    public void printXML(PrintWriter pw, String pad, boolean constrained) {
        if (Debug.isSet("AttributTable")) {
            pw.println("Entered AttributeTable.print()");
        }
        pw.println(pad + "<Attribute name=\"" + DDSXMLParser.normalizeToXML(this.getEncodedName()) + "\" type=\"Container\">");
        Enumeration e = this.getNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Attribute a = this.getAttribute(name);
            if (a == null) continue;
            a.printXML(pw, pad + "\t", constrained);
        }
        pw.println(pad + "</Attribute>");
        if (Debug.isSet("AttributTable")) {
            pw.println("Leaving AttributeTable.print()");
        }
        pw.flush();
    }

    @Override
    public DAPNode cloneDAG(DAPNode.CloneMap map) throws CloneNotSupportedException {
        AttributeTable at = (AttributeTable)super.cloneDAG(map);
        at._attr = new SortedTable();
        for (int i = 0; i < this._attr.size(); ++i) {
            String key = (String)this._attr.getKey(i);
            Attribute element = (Attribute)this._attr.elementAt(i);
            at._attr.put(key, (Attribute)AttributeTable.cloneDAG(map, element));
        }
        return at;
    }
}

