/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage;

import com.google.common.math.DoubleMath;
import java.util.Arrays;
import javax.annotation.Nonnull;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.RangeIterator;
import ucar.nc2.constants.AxisType;
import ucar.nc2.ft2.coverage.CoverageCoordAxis;
import ucar.nc2.ft2.coverage.CoverageCoordAxis1D;
import ucar.nc2.ft2.coverage.CoverageCoordAxisBuilder;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.util.Optional;

class CoordAxisHelper {
    private final CoverageCoordAxis1D axis;
    private static final int MULTIPLE_HITS = -2;

    CoordAxisHelper(CoverageCoordAxis1D axis) {
        this.axis = axis;
    }

    int findCoordElement(double[] target, boolean bounded) {
        switch (this.axis.getSpacing()) {
            case regularInterval: {
                return this.findCoordElementRegular((target[0] + target[1]) / 2.0, bounded);
            }
            case contiguousInterval: {
                return this.findCoordElementContiguous((target[0] + target[1]) / 2.0, bounded);
            }
            case discontiguousInterval: {
                return this.findCoordElementDiscontiguousInterval(target, bounded);
            }
        }
        throw new IllegalStateException("unknown spacing" + (Object)((Object)this.axis.getSpacing()));
    }

    int findCoordElement(double target, boolean bounded) {
        switch (this.axis.getSpacing()) {
            case regularInterval: 
            case regularPoint: {
                return this.findCoordElementRegular(target, bounded);
            }
            case contiguousInterval: 
            case irregularPoint: {
                return this.findCoordElementContiguous(target, bounded);
            }
            case discontiguousInterval: {
                return this.findCoordElementDiscontiguousInterval(target, bounded);
            }
        }
        throw new IllegalStateException("unknown spacing" + (Object)((Object)this.axis.getSpacing()));
    }

    private int findCoordElementRegular(double coordValue, boolean bounded) {
        int n = this.axis.getNcoords();
        if (n == 1 && bounded) {
            return 0;
        }
        double distance = coordValue - this.axis.getCoordEdge1(0);
        double exactNumSteps = distance / this.axis.getResolution();
        int index = (int)Math.floor(exactNumSteps);
        if (bounded && index < 0) {
            return 0;
        }
        if (bounded && index >= n) {
            return n - 1;
        }
        if (index >= 0 && index < n) {
            double lower = this.axis.getCoordEdge1(index);
            double upper = this.axis.getCoordEdge2(index);
            if (this.axis.isAscending()) {
                assert (lower <= coordValue) : lower + " should be <= " + coordValue;
                assert (upper >= coordValue) : upper + " should be >= " + coordValue;
            } else {
                assert (lower >= coordValue) : lower + " should be >= " + coordValue;
                assert (upper <= coordValue) : upper + " should be <= " + coordValue;
            }
        }
        return index;
    }

    private int findCoordElementContiguous(double target, boolean bounded) {
        int n = this.axis.getNcoords();
        int low = 0;
        int high = n - 1;
        if (this.axis.isAscending()) {
            if (target < this.axis.getCoordEdge1(0)) {
                return bounded ? 0 : -1;
            }
            if (target > this.axis.getCoordEdgeLast()) {
                return bounded ? n - 1 : n;
            }
            while (high > low + 1) {
                int mid = (low + high) / 2;
                if (this.intervalContains(target, mid, true)) {
                    return mid;
                }
                if (this.axis.getCoordEdge2(mid) < target) {
                    low = mid;
                    continue;
                }
                high = mid;
            }
            return this.intervalContains(target, low, true) ? low : high;
        }
        if (target > this.axis.getCoordEdge1(0)) {
            return bounded ? 0 : -1;
        }
        if (target < this.axis.getCoordEdgeLast()) {
            return bounded ? n - 1 : n;
        }
        while (high > low + 1) {
            int mid = (low + high) / 2;
            if (this.intervalContains(target, mid, false)) {
                return mid;
            }
            if (this.axis.getCoordEdge2(mid) < target) {
                high = mid;
                continue;
            }
            low = mid;
        }
        return this.intervalContains(target, low, false) ? low : high;
    }

    private int findCoordElementDiscontiguousInterval(double[] target, boolean bounded) {
        double lowerIndex;
        int n = this.axis.getNcoords();
        double upperIndex = target[1] > target[0] ? target[1] : target[0];
        double d = lowerIndex = upperIndex == target[1] ? target[0] : target[1];
        if (lowerIndex < this.axis.getCoordEdge1(0)) {
            return bounded ? 0 : -1;
        }
        if (upperIndex > this.axis.getCoordEdgeLast()) {
            return bounded ? n - 1 : n;
        }
        int index = -1;
        for (int i = 0; i < this.axis.getNcoords(); ++i) {
            double edge1 = this.axis.getCoordEdge1(i);
            double edge2 = this.axis.getCoordEdge2(i);
            if (!DoubleMath.fuzzyEquals(edge1, target[0], 1.0E-8) || !DoubleMath.fuzzyEquals(edge2, target[1], 1.0E-8)) continue;
            return i;
        }
        if (bounded) {
            index = this.findCoordElementDiscontiguousInterval(lowerIndex + (upperIndex - lowerIndex) / 2.0, bounded);
        }
        return index;
    }

    private int findCoordElementDiscontiguousInterval(double target, boolean bounded) {
        int idx = this.findSingleHit(target);
        if (idx == -2) {
            return this.findClosestDiscontiguousInterval(target);
        }
        if (bounded && idx >= this.axis.getNcoords()) {
            return -1;
        }
        return idx;
    }

    boolean intervalContains(double target, int coordIdx) {
        double midVal2;
        double midVal1 = this.axis.getCoordEdge1(coordIdx);
        boolean ascending = midVal1 < (midVal2 = this.axis.getCoordEdge2(coordIdx));
        return this.intervalContains(target, coordIdx, ascending);
    }

    private boolean intervalContains(double target, int coordIdx, boolean ascending) {
        double lowerVal = ascending ? this.axis.getCoordEdge1(coordIdx) : this.axis.getCoordEdge2(coordIdx);
        double upperVal = ascending ? this.axis.getCoordEdge2(coordIdx) : this.axis.getCoordEdge1(coordIdx);
        return lowerVal <= target && target <= upperVal;
    }

    private int findSingleHit(double target) {
        double firstCoord1 = this.axis.getCoordEdge1(0);
        double firstCoord2 = this.axis.getCoordEdge2(0);
        if (this.axis.isAscending() && target < Math.min(firstCoord1, firstCoord2) || !this.axis.isAscending() && target > Math.max(firstCoord1, firstCoord2)) {
            return -1;
        }
        int idxFound = -1;
        int n = this.axis.getNcoords();
        for (int i = 0; i < n; ++i) {
            if (!this.intervalContains(target, i)) continue;
            if (idxFound >= 0) {
                return -2;
            }
            idxFound = i;
        }
        return idxFound > -1 ? idxFound : n;
    }

    private int findClosestDiscontiguousInterval(double target) {
        boolean isTemporal = this.axis.getAxisType().equals((Object)AxisType.Time);
        return isTemporal ? this.findClosestDiscontiguousTimeInterval(target) : this.findClosestDiscontiguousNonTimeInterval(target);
    }

    private int findClosestDiscontiguousTimeInterval(double target) {
        double minDiff = Double.MAX_VALUE;
        double useValue = Double.MIN_VALUE;
        int idxFound = -1;
        for (int i = 0; i < this.axis.getNcoords(); ++i) {
            boolean tiebreaker;
            double coord;
            if (!this.intervalContains(target, i) || !((coord = this.axis.getCoordEdge2(i)) >= target)) continue;
            double width = coord - this.axis.getCoordEdge1(i);
            double diff = Math.abs(coord - target);
            boolean bl = tiebreaker = diff == minDiff && width != 0.0 && width < useValue;
            if (!(diff < minDiff) && !tiebreaker) continue;
            minDiff = diff;
            idxFound = i;
            useValue = width;
        }
        return idxFound;
    }

    private int findClosestDiscontiguousNonTimeInterval(double target) {
        int idxFound = -1;
        double minDiff = Double.MAX_VALUE;
        double useValue = Double.MIN_VALUE;
        for (int i = 0; i < this.axis.getNcoords(); ++i) {
            boolean tiebreaker;
            if (!this.intervalContains(target, i)) continue;
            double coord = this.axis.getCoordMidpoint(i);
            double diff = Math.abs(coord - target);
            boolean bl = tiebreaker = diff == minDiff && coord > useValue;
            if (!(diff < minDiff) && !tiebreaker) continue;
            minDiff = diff;
            idxFound = i;
            useValue = coord;
        }
        return idxFound;
    }

    public Optional<CoverageCoordAxisBuilder> subset(double minValue, double maxValue, int stride) {
        return this.subsetValues(minValue, maxValue, stride);
    }

    @Nonnull
    public CoverageCoordAxisBuilder subsetClosest(double want) {
        return this.subsetValuesClosest(want);
    }

    @Nonnull
    public CoverageCoordAxisBuilder subsetLatest() {
        return this.subsetValuesLatest();
    }

    @Nonnull
    public CoverageCoordAxisBuilder subsetClosest(CalendarDate date) {
        double want = this.axis.convert(date);
        return this.isDiscontiguousInterval() ? this.subsetClosestDiscontiguousInterval(date) : this.subsetValuesClosest(want);
    }

    @Nonnull
    private CoverageCoordAxisBuilder subsetClosestDiscontiguousInterval(CalendarDate date) {
        double target = this.axis.convert(date);
        double maxDateToSearch = 0.0;
        int intervals = 0;
        for (int i = 0; i < this.axis.getNcoords(); ++i) {
            double bound2;
            double intervalEnd;
            if (!this.intervalContains(target, i)) continue;
            ++intervals;
            double bound1 = this.axis.getCoordEdge1(i);
            double d = intervalEnd = bound1 < (bound2 = this.axis.getCoordEdge2(i)) ? bound2 : bound1;
            if (!(intervalEnd > maxDateToSearch)) continue;
            maxDateToSearch = intervalEnd;
        }
        Optional<Object> multipleIntervalBuilder = Optional.empty("");
        if (intervals > 0) {
            multipleIntervalBuilder = this.subset(target, maxDateToSearch, 1);
        }
        return multipleIntervalBuilder.isPresent() ? (CoverageCoordAxisBuilder)multipleIntervalBuilder.get() : this.subsetValuesClosest(this.axis.convert(date));
    }

    @Nonnull
    public CoverageCoordAxisBuilder subsetClosest(CalendarDate[] date) {
        double[] want = new double[]{this.axis.convert(date[0]), this.axis.convert(date[1])};
        return this.subsetValuesClosest(want);
    }

    public Optional<CoverageCoordAxisBuilder> subset(CalendarDateRange dateRange, int stride) {
        double min2 = this.axis.convert(dateRange.getStart());
        double max = this.axis.convert(dateRange.getEnd());
        return this.subsetValues(min2, max, stride);
    }

    private Optional<CoverageCoordAxisBuilder> subsetValues(double minValue, double maxValue, int stride) {
        int count;
        double lower = this.axis.isAscending() ? Math.min(minValue, maxValue) : Math.max(minValue, maxValue);
        double upper = this.axis.isAscending() ? Math.max(minValue, maxValue) : Math.min(minValue, maxValue);
        int minIndex = this.findCoordElement(lower, false);
        int maxIndex = this.findCoordElement(upper, false);
        if (minIndex >= this.axis.getNcoords()) {
            return Optional.empty(String.format("no points in subset: lower %f > end %f", lower, this.axis.getEndValue()));
        }
        if (maxIndex < 0) {
            return Optional.empty(String.format("no points in subset: upper %f < start %f", upper, this.axis.getStartValue()));
        }
        if (minIndex < 0) {
            minIndex = 0;
        }
        if (maxIndex >= this.axis.getNcoords()) {
            maxIndex = this.axis.getNcoords() - 1;
        }
        if ((count = maxIndex - minIndex + 1) <= 0) {
            throw new IllegalArgumentException("no points in subset");
        }
        try {
            return Optional.of(this.subsetByIndex(new Range(minIndex, maxIndex, stride)));
        }
        catch (InvalidRangeException e) {
            return Optional.empty(e.getMessage());
        }
    }

    public Optional<RangeIterator> makeRange(double minValue, double maxValue, int stride) {
        int count;
        double lower = this.axis.isAscending() ? Math.min(minValue, maxValue) : Math.max(minValue, maxValue);
        double upper = this.axis.isAscending() ? Math.max(minValue, maxValue) : Math.min(minValue, maxValue);
        int minIndex = this.findCoordElement(lower, false);
        int maxIndex = this.findCoordElement(upper, false);
        if (minIndex >= this.axis.getNcoords()) {
            return Optional.empty(String.format("no points in subset: lower %f > end %f", lower, this.axis.getEndValue()));
        }
        if (maxIndex < 0) {
            return Optional.empty(String.format("no points in subset: upper %f < start %f", upper, this.axis.getStartValue()));
        }
        if (minIndex < 0) {
            minIndex = 0;
        }
        if (maxIndex >= this.axis.getNcoords()) {
            maxIndex = this.axis.getNcoords() - 1;
        }
        if ((count = maxIndex - minIndex + 1) <= 0) {
            return Optional.empty("no points in subset");
        }
        try {
            return Optional.of(new Range(minIndex, maxIndex, stride));
        }
        catch (InvalidRangeException e) {
            return Optional.empty(e.getMessage());
        }
    }

    @Nonnull
    CoverageCoordAxisBuilder subsetByIndex(Range range) throws InvalidRangeException {
        int ncoords = range.length();
        if (range.last() >= this.axis.getNcoords()) {
            throw new InvalidRangeException("range.last() >= axis.getNcoords()");
        }
        double resolution = 0.0;
        int count2 = 0;
        double[] values = this.axis.getValues();
        double[] subsetValues = null;
        switch (this.axis.getSpacing()) {
            case regularInterval: 
            case regularPoint: {
                resolution = (double)range.stride() * this.axis.getResolution();
                break;
            }
            case irregularPoint: {
                subsetValues = new double[ncoords];
                for (int i : range) {
                    subsetValues[count2++] = values[i];
                }
                break;
            }
            case contiguousInterval: {
                subsetValues = new double[ncoords + 1];
                for (int i : range) {
                    subsetValues[count2++] = values[i];
                }
                subsetValues[count2] = values[range.last() + 1];
                break;
            }
            case discontiguousInterval: {
                subsetValues = new double[2 * ncoords];
                for (int i : range) {
                    subsetValues[count2++] = values[2 * i];
                    subsetValues[count2++] = values[2 * i + 1];
                }
                break;
            }
        }
        CoverageCoordAxisBuilder builder = new CoverageCoordAxisBuilder(this.axis);
        builder.subset(ncoords, this.axis.getCoord(range.first()), this.axis.getCoord(range.last()), resolution, subsetValues);
        builder.setRange(range);
        return builder;
    }

    @Nonnull
    private CoverageCoordAxisBuilder subsetValuesClosest(double[] want) {
        int closest_index = this.findCoordElement(want, true);
        CoverageCoordAxisBuilder builder = new CoverageCoordAxisBuilder(this.axis);
        if (this.axis.spacing == CoverageCoordAxis.Spacing.regularInterval) {
            double val1 = this.axis.getCoordEdge1(closest_index);
            double val2 = this.axis.getCoordEdge2(closest_index);
            builder.subset(1, val1, val2, val2 - val1, null);
        } else {
            builder.subset(1, 0.0, 0.0, 0.0, this.makeValues(closest_index));
        }
        try {
            builder.setRange(new Range(closest_index, closest_index));
        }
        catch (InvalidRangeException e) {
            throw new RuntimeException(e);
        }
        return builder;
    }

    @Nonnull
    private CoverageCoordAxisBuilder subsetValuesClosest(double want) {
        int closest_index = this.findCoordElement(want, true);
        CoverageCoordAxisBuilder builder = new CoverageCoordAxisBuilder(this.axis);
        if (this.axis.spacing == CoverageCoordAxis.Spacing.regularPoint) {
            double val = this.axis.getCoordMidpoint(closest_index);
            builder.subset(1, val, val, 0.0, null);
        } else if (this.axis.spacing == CoverageCoordAxis.Spacing.regularInterval) {
            double val1 = this.axis.getCoordEdge1(closest_index);
            double val2 = this.axis.getCoordEdge2(closest_index);
            builder.subset(1, val1, val2, val2 - val1, null);
        } else {
            builder.subset(1, 0.0, 0.0, 0.0, this.makeValues(closest_index));
        }
        try {
            builder.setRange(new Range(closest_index, closest_index));
        }
        catch (InvalidRangeException e) {
            throw new RuntimeException(e);
        }
        return builder;
    }

    Optional<CoverageCoordAxisBuilder> subsetContaining(double want) {
        int index = this.findCoordElement(want, false);
        if (index < 0 || index >= this.axis.getNcoords()) {
            return Optional.empty(String.format("value %f not in axis %s", want, this.axis.getName()));
        }
        double val = this.axis.getCoordMidpoint(index);
        CoverageCoordAxisBuilder builder = new CoverageCoordAxisBuilder(this.axis);
        builder.subset(1, val, val, 0.0, this.makeValues(index));
        try {
            builder.setRange(new Range(index, index));
        }
        catch (InvalidRangeException e) {
            throw new RuntimeException(e);
        }
        return Optional.of(builder);
    }

    @Nonnull
    private CoverageCoordAxisBuilder subsetValuesLatest() {
        int last = this.axis.getNcoords() - 1;
        double val = this.axis.getCoordMidpoint(last);
        CoverageCoordAxisBuilder builder = new CoverageCoordAxisBuilder(this.axis);
        builder.subset(1, val, val, 0.0, this.makeValues(last));
        try {
            builder.setRange(new Range(last, last));
        }
        catch (InvalidRangeException e) {
            throw new RuntimeException(e);
        }
        return builder;
    }

    private double[] makeValues(int index) {
        double[] subsetValues = null;
        switch (this.axis.getSpacing()) {
            case irregularPoint: {
                subsetValues = new double[]{this.axis.getCoordMidpoint(index)};
                break;
            }
            case contiguousInterval: 
            case discontiguousInterval: {
                subsetValues = new double[]{this.axis.getCoordEdge1(index), this.axis.getCoordEdge2(index)};
            }
        }
        return subsetValues;
    }

    int search(double want) {
        if (this.axis.getNcoords() == 1) {
            return DoubleMath.fuzzyEquals(want, this.axis.getStartValue(), 1.0E-8) ? 0 : -1;
        }
        if (this.axis.isRegular()) {
            double ival;
            double fval = (want - this.axis.getStartValue()) / this.axis.getResolution();
            return DoubleMath.fuzzyEquals(fval, ival = Math.rint(fval), 1.0E-8) ? (int)ival : (int)(-ival) - 1;
        }
        return Arrays.binarySearch(this.axis.getValues(), want);
    }

    private boolean isDiscontiguousInterval() {
        CoverageCoordAxis.Spacing spacing = this.axis.getSpacing();
        if (spacing != null) {
            return spacing.equals((Object)CoverageCoordAxis.Spacing.discontiguousInterval);
        }
        return false;
    }
}

