/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Collection;
import net.sf.saxon.expr.BooleanExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OrExpression;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.BooleanValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndExpression
extends BooleanExpression {
    public AndExpression(Expression p1, Expression p2) {
        super(p1, 10, p2);
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        Expression t2 = super.optimize(visitor, contextInfo);
        if (t2 != this) {
            return t2;
        }
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        if (Literal.isConstantBoolean(this.getLhsExpression(), false) || Literal.isConstantBoolean(this.getRhsExpression(), false)) {
            return Literal.makeLiteral(BooleanValue.FALSE);
        }
        if (Literal.isConstantBoolean(this.getLhsExpression(), true)) {
            return this.forceToBoolean(this.getRhsExpression());
        }
        if (Literal.isConstantBoolean(this.getRhsExpression(), true)) {
            return this.forceToBoolean(this.getLhsExpression());
        }
        if (this.getRhsExpression() instanceof UserFunctionCall && th.isSubType(this.getRhsExpression().getItemType(), BuiltInAtomicType.BOOLEAN) && !ExpressionTool.isLoopingSubexpression(this, null)) {
            Expression cond = Choose.makeConditional(this.getLhsExpression(), this.getRhsExpression(), Literal.makeLiteral(BooleanValue.FALSE));
            ExpressionTool.copyLocationInfo(this, cond);
            return cond;
        }
        return this;
    }

    @Override
    public int getCost() {
        return this.getLhsExpression().getCost() + this.getRhsExpression().getCost() / 2;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        AndExpression a2 = new AndExpression(this.getLhsExpression().copy(rebindings), this.getRhsExpression().copy(rebindings));
        ExpressionTool.copyLocationInfo(this, a2);
        return a2;
    }

    @Override
    public Expression negate() {
        Expression not0 = SystemFunction.makeCall("not", this.getRetainedStaticContext(), this.getLhsExpression());
        Expression not1 = SystemFunction.makeCall("not", this.getRetainedStaticContext(), this.getRhsExpression());
        return new OrExpression(not0, not1);
    }

    @Override
    protected String tag() {
        return "and";
    }

    @Override
    public boolean effectiveBooleanValue(XPathContext c) throws XPathException {
        return this.getLhsExpression().effectiveBooleanValue(c) && this.getRhsExpression().effectiveBooleanValue(c);
    }

    public static Expression distribute(Collection<Expression> exprs) {
        Expression result = null;
        if (exprs != null) {
            boolean first = true;
            for (Expression e : exprs) {
                if (first) {
                    first = false;
                    result = e;
                    continue;
                }
                result = new AndExpression(result, e);
            }
        }
        return result;
    }
}

