/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TypeCheckingFilter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.CardinalityCheckingIterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.SingletonAtomizer;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.IntegerValue;

public final class CardinalityChecker
extends UnaryExpression {
    private int requiredCardinality = -1;
    private RoleDiagnostic role;

    private CardinalityChecker(Expression sequence, int cardinality, RoleDiagnostic role) {
        super(sequence);
        this.requiredCardinality = cardinality;
        this.role = role;
    }

    public static Expression makeCardinalityChecker(Expression sequence, int cardinality, RoleDiagnostic role) {
        UnaryExpression result;
        if (sequence instanceof Literal && Cardinality.subsumes(cardinality, SequenceTool.getCardinality(((Literal)sequence).getValue()))) {
            return sequence;
        }
        if (sequence instanceof Atomizer && !Cardinality.allowsMany(cardinality)) {
            Expression base = ((Atomizer)sequence).getBaseExpression();
            result = new SingletonAtomizer(base, role, Cardinality.allowsZero(cardinality));
        } else {
            result = new CardinalityChecker(sequence, cardinality, role);
        }
        ExpressionTool.copyLocationInfo(sequence, result);
        return result;
    }

    protected OperandRole getOperandRole() {
        return OperandRole.SAME_FOCUS_ACTION;
    }

    public int getRequiredCardinality() {
        return this.requiredCardinality;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.typeCheckChildren(visitor, contextInfo);
        Expression base = this.getBaseExpression();
        if (this.requiredCardinality == 57344 || Cardinality.subsumes(this.requiredCardinality, base.getCardinality())) {
            return base;
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.optimizeChildren(visitor, contextInfo);
        Expression base = this.getBaseExpression();
        if (this.requiredCardinality == 57344 || Cardinality.subsumes(this.requiredCardinality, base.getCardinality())) {
            return base;
        }
        if ((base.getCardinality() & this.requiredCardinality) == 0) {
            XPathException err = new XPathException("The " + this.role.getMessage() + " does not satisfy the cardinality constraints", this.role.getErrorCode());
            err.setLocation(this.getLocation());
            err.setIsTypeError(this.role.isTypeError());
            throw err;
        }
        if (base instanceof ItemChecker) {
            ItemChecker checker = (ItemChecker)base;
            Expression other = checker.getBaseExpression();
            this.setBaseExpression(other);
            checker.setBaseExpression(this);
            checker.setParentExpression(null);
            return checker;
        }
        return this;
    }

    public void setErrorCode(String code) {
        this.role.setErrorCode(code);
    }

    public RoleDiagnostic getRoleLocator() {
        return this.role;
    }

    public int getImplementationMethod() {
        int m4 = 22;
        if (!Cardinality.allowsMany(this.requiredCardinality)) {
            m4 |= 1;
        }
        return m4;
    }

    public IntegerValue[] getIntegerBounds() {
        return this.getBaseExpression().getIntegerBounds();
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator base = this.getBaseExpression().iterate(context);
        if ((base.getProperties() & 2) != 0) {
            int count = ((LastPositionFinder)((Object)base)).getLength();
            if (count == 0 && !Cardinality.allowsZero(this.requiredCardinality)) {
                this.typeError("An empty sequence is not allowed as the " + this.role.getMessage(), this.role.getErrorCode(), context);
            } else if (count == 1 && this.requiredCardinality == 8192) {
                this.typeError("The only value allowed for the " + this.role.getMessage() + " is an empty sequence", this.role.getErrorCode(), context);
            } else if (count > 1 && !Cardinality.allowsMany(this.requiredCardinality)) {
                this.typeError("A sequence of more than one item is not allowed as the " + this.role.getMessage() + CardinalityChecker.depictSequenceStart(base.getAnother(), 2), this.role.getErrorCode(), context);
            }
            return base;
        }
        return new CardinalityCheckingIterator(base, this.requiredCardinality, this.role, this.getLocation());
    }

    public static String depictSequenceStart(SequenceIterator seq, int max) {
        try {
            FastStringBuffer sb = new FastStringBuffer(64);
            int count = 0;
            sb.append(" (");
            while (true) {
                Item next;
                if ((next = seq.next()) == null) {
                    sb.append(") ");
                    return sb.toString();
                }
                if (count++ > 0) {
                    sb.append(", ");
                }
                if (count > max) {
                    sb.append("...) ");
                    return sb.toString();
                }
                sb.append(Err.depict(next));
            }
        }
        catch (XPathException e) {
            return "";
        }
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        SequenceIterator iter = this.getBaseExpression().iterate(context);
        Item first = iter.next();
        if (first == null) {
            if (!Cardinality.allowsZero(this.requiredCardinality)) {
                this.typeError("An empty sequence is not allowed as the " + this.role.getMessage(), this.role.getErrorCode(), context);
            }
            return null;
        }
        if (this.requiredCardinality == 8192) {
            this.typeError("An empty sequence is required as the " + this.role.getMessage(), this.role.getErrorCode(), context);
            return null;
        }
        Item second = iter.next();
        if (second != null) {
            this.typeError("A sequence of more than one item is not allowed as the " + this.role.getMessage() + CardinalityChecker.depictSequenceStart(iter.getAnother(), 2), this.role.getErrorCode(), context);
            return null;
        }
        return first;
    }

    public void process(XPathContext context) throws XPathException {
        Expression next = this.getBaseExpression();
        ItemType type = Type.ITEM_TYPE;
        if (next instanceof ItemChecker) {
            type = ((ItemChecker)next).getRequiredType();
            next = ((ItemChecker)next).getBaseExpression();
        }
        if ((next.getImplementationMethod() & 4) != 0 && !(type instanceof DocumentNodeTest)) {
            SequenceReceiver out = context.getReceiver();
            TypeCheckingFilter filter = new TypeCheckingFilter(out);
            filter.setRequiredType(type, this.requiredCardinality, this.role, this.getLocation());
            context.setReceiver(filter);
            next.process(context);
            try {
                filter.close();
            }
            catch (XPathException e) {
                e.maybeSetLocation(this.getLocation());
                throw e;
            }
            context.setReceiver(out);
        } else {
            super.process(context);
        }
    }

    public ItemType getItemType() {
        return this.getBaseExpression().getItemType();
    }

    public int computeCardinality() {
        return this.requiredCardinality;
    }

    public int computeSpecialProperties() {
        return this.getBaseExpression().getSpecialProperties();
    }

    public Expression copy(RebindingMap rebindings) {
        CardinalityChecker c2 = new CardinalityChecker(this.getBaseExpression().copy(rebindings), this.requiredCardinality, this.role);
        ExpressionTool.copyLocationInfo(this, c2);
        return c2;
    }

    public boolean equals(Object other) {
        return super.equals(other) && this.requiredCardinality == ((CardinalityChecker)other).requiredCardinality;
    }

    public int hashCode() {
        return super.hashCode() ^ this.requiredCardinality;
    }

    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("check", this);
        String occ = Cardinality.getOccurrenceIndicator(this.requiredCardinality);
        if (occ.equals("")) {
            occ = "1";
        }
        out.emitAttribute("card", occ);
        out.emitAttribute("diag", this.role.save());
        this.getBaseExpression().export(out);
        out.endElement();
    }

    public String toString() {
        Expression operand = this.getBaseExpression();
        switch (this.requiredCardinality) {
            case 16384: {
                return "exactly-one(" + operand.toString() + ")";
            }
            case 24576: {
                return "zero-or-one(" + operand.toString() + ")";
            }
            case 49152: {
                return "one-or-more(" + operand.toString() + ")";
            }
            case 8192: {
                return "must-be-empty(" + operand.toString() + ")";
            }
        }
        return "check(" + operand.toString() + ")";
    }

    public String getExpressionName() {
        return "CheckCardinality";
    }

    public String toShortString() {
        return this.getBaseExpression().toShortString();
    }

    public void setLocation(Location id) {
        super.setLocation(id);
    }
}

