/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.Cardinality;

public abstract class StaticProperty {
    public static final int DEPENDS_ON_CURRENT_ITEM = 1;
    public static final int DEPENDS_ON_CONTEXT_ITEM = 2;
    public static final int DEPENDS_ON_POSITION = 4;
    public static final int DEPENDS_ON_LAST = 8;
    public static final int DEPENDS_ON_CONTEXT_DOCUMENT = 16;
    public static final int DEPENDS_ON_CURRENT_GROUP = 32;
    public static final int DEPENDS_ON_REGEX_GROUP = 64;
    public static final int DEPENDS_ON_LOCAL_VARIABLES = 128;
    public static final int DEPENDS_ON_USER_FUNCTIONS = 256;
    public static final int DEPENDS_ON_ASSIGNABLE_GLOBALS = 512;
    public static final int DEPENDS_ON_RUNTIME_ENVIRONMENT = 1024;
    public static final int DEPENDS_ON_XSLT_CONTEXT = 609;
    public static final int DEPENDS_ON_FOCUS = 30;
    public static final int DEPENDS_ON_NON_DOCUMENT_FOCUS = 14;
    public static final int ALLOWS_ZERO = 8192;
    public static final int ALLOWS_ONE = 16384;
    public static final int ALLOWS_MANY = 32768;
    public static final int CARDINALITY_MASK = 57344;
    public static final int ALLOWS_ONE_OR_MORE = 49152;
    public static final int ALLOWS_ZERO_OR_MORE = 57344;
    public static final int ALLOWS_ZERO_OR_ONE = 24576;
    public static final int EXACTLY_ONE = 16384;
    public static final int EMPTY = 8192;
    public static final int CONTEXT_DOCUMENT_NODESET = 65536;
    public static final int ORDERED_NODESET = 131072;
    public static final int REVERSE_DOCUMENT_ORDER = 262144;
    public static final int PEER_NODESET = 524288;
    public static final int SUBTREE_NODESET = 0x100000;
    public static final int ATTRIBUTE_NS_NODESET = 0x200000;
    public static final int NON_CREATIVE = 0x400000;
    public static final int SINGLE_DOCUMENT_NODESET = 0x800000;
    public static final int HAS_SIDE_EFFECTS = 0x1000000;
    public static final int NOT_UNTYPED_ATOMIC = 0x2000000;
    public static final int ALL_NODES_UNTYPED = 0x4000000;
    public static final int MUST_MAINTAIN_POSITION = 0x8000000;
    public static final int DEPENDENCY_MASK = 16779263;
    public static final int SPECIAL_PROPERTY_MASK = 0xFFF0000;
    public static final int NODESET_PROPERTIES = 79626240;

    public static int getCardinalityCode(int cardinality) {
        return (cardinality & 0xE000) >> 13;
    }

    private StaticProperty() {
    }

    public static String display(int props) {
        FastStringBuffer s2 = new FastStringBuffer(128);
        s2.append("D(");
        if ((props & 1) != 0) {
            s2.append("U");
        }
        if ((props & 2) != 0) {
            s2.append("C");
        }
        if ((props & 4) != 0) {
            s2.append("P");
        }
        if ((props & 8) != 0) {
            s2.append("L");
        }
        if ((props & 0x10) != 0) {
            s2.append("D");
        }
        if ((props & 0x80) != 0) {
            s2.append("V");
        }
        if ((props & 0x200) != 0) {
            s2.append("A");
        }
        if ((props & 0x40) != 0) {
            s2.append("R");
        }
        if ((props & 0x400) != 0) {
            s2.append("E");
        }
        s2.append(") C(");
        boolean m4 = Cardinality.allowsMany(props);
        boolean z = Cardinality.allowsZero(props);
        if (m4 && z) {
            s2.append("*");
        } else if (m4) {
            s2.append("+");
        } else if (z) {
            s2.append("?");
        } else {
            s2.append("1");
        }
        s2.append(") S(");
        if ((props & 0x1000000) != 0) {
            s2.append("E");
        }
        if ((props & 0x8000000) != 0) {
            s2.append("M");
        }
        if ((props & 0x400000) != 0) {
            s2.append("N");
        }
        if ((props & 0x2000000) != 0) {
            s2.append("T");
        }
        if ((props & 0x20000) != 0) {
            s2.append("O");
        }
        if ((props & 0x80000) != 0) {
            s2.append("P");
        }
        if ((props & 0x40000) != 0) {
            s2.append("R");
        }
        if ((props & 0x800000) != 0) {
            s2.append("S");
        }
        if ((props & 0x100000) != 0) {
            s2.append("D");
        }
        s2.append(")");
        return s2.toString();
    }
}

