/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.ArrayList;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.ITemplateCall;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.TemplateRule;
import net.sf.saxon.expr.instruct.WithParam;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.Rule;
import net.sf.saxon.trans.XPathException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplyImports
extends Instruction
implements ITemplateCall {
    private WithParam[] actualParams;
    private WithParam[] tunnelParams;
    boolean allowAnyItem = false;

    @Override
    public int getInstructionNameCode() {
        return 132;
    }

    @Override
    public int getImplementationMethod() {
        return super.getImplementationMethod() | 8;
    }

    @Override
    public WithParam[] getActualParams() {
        return this.actualParams;
    }

    @Override
    public WithParam[] getTunnelParams() {
        return this.tunnelParams;
    }

    public void setActualParams(WithParam[] params) {
        this.actualParams = params;
    }

    public void setTunnelParams(WithParam[] params) {
        this.tunnelParams = params;
    }

    @Override
    public Iterable<Operand> operands() {
        ArrayList<Operand> operanda = new ArrayList<Operand>(this.actualParams.length + this.tunnelParams.length);
        WithParam.gatherOperands(this, this.actualParams, operanda);
        WithParam.gatherOperands(this, this.tunnelParams, operanda);
        return operanda;
    }

    public boolean isAllowAnyItem() {
        return this.allowAnyItem;
    }

    public void setAllowAnyItem(boolean allowAny) {
        this.allowAnyItem = allowAny;
    }

    @Override
    public Expression simplify() throws XPathException {
        WithParam.simplify(this.getActualParams());
        WithParam.simplify(this.getTunnelParams());
        this.allowAnyItem = this.getPackageData().getXPathVersion() >= 30;
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        WithParam.typeCheck(this.actualParams, visitor, contextInfo);
        WithParam.typeCheck(this.tunnelParams, visitor, contextInfo);
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        WithParam.optimize(visitor, this.actualParams, contextInfo);
        WithParam.optimize(visitor, this.tunnelParams, contextInfo);
        return this;
    }

    @Override
    public int getIntrinsicDependencies() {
        return 2;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        ApplyImports ai2 = new ApplyImports();
        ai2.setActualParams(WithParam.copy(ai2, this.actualParams, rebindings));
        ai2.setTunnelParams(WithParam.copy(ai2, this.tunnelParams, rebindings));
        ExpressionTool.copyLocationInfo(this, ai2);
        ai2.allowAnyItem = this.allowAnyItem;
        return ai2;
    }

    @Override
    public final boolean createsNewNodes() {
        return true;
    }

    @Override
    protected void promoteChildren(PromotionOffer offer) throws XPathException {
        WithParam.promoteParams(this.actualParams, offer);
        WithParam.promoteParams(this.tunnelParams, offer);
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        if (pathMapNodeSet == null) {
            ContextItemExpression cie = new ContextItemExpression();
            pathMapNodeSet = new PathMap.PathMapNodeSet(pathMap.makeNewRoot(cie));
        }
        pathMapNodeSet.addDescendants();
        return new PathMap.PathMapNodeSet(pathMap.makeNewRoot(this));
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        assert (controller != null);
        ParameterSet params = ApplyImports.assembleParams(context, this.getActualParams());
        ParameterSet tunnels = ApplyImports.assembleTunnelParams(context, this.getTunnelParams());
        Rule currentTemplateRule = context.getCurrentTemplateRule();
        if (currentTemplateRule == null) {
            XPathException e = new XPathException("There is no current template rule");
            e.setXPathContext(context);
            e.setErrorCode("XTDE0560");
            e.setLocation(this.getLocation());
            throw e;
        }
        int min2 = currentTemplateRule.getMinImportPrecedence();
        int max = currentTemplateRule.getPrecedence() - 1;
        Component<? extends Mode> modeComponent = context.getCurrentMode();
        if (modeComponent == null) {
            throw new AssertionError((Object)"Current mode is null");
        }
        Item currentItem = context.getCurrentIterator().current();
        Mode mode = modeComponent.getCode();
        Rule rule = mode.getRule(currentItem, min2, max, context);
        if (rule == null) {
            mode.getBuiltInRuleSet().process(currentItem, params, tunnels, context, this.getLocation());
        } else {
            XPathContextMajor c2 = context.newContext();
            TemplateRule nh = (TemplateRule)rule.getAction();
            c2.setOrigin(this);
            c2.setLocalParameters(params);
            c2.setTunnelParameters(tunnels);
            c2.openStackFrame(nh.getStackFrameMap());
            c2.setCurrentTemplateRule(rule);
            c2.setCurrentComponent(modeComponent);
            nh.apply(c2);
        }
        return null;
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("applyImports", this);
        if (this.allowAnyItem) {
            out.emitAttribute("flags", "i");
        }
        if (this.getActualParams().length != 0) {
            WithParam.exportParameters(this.getActualParams(), out, false);
        }
        if (this.getTunnelParams().length != 0) {
            WithParam.exportParameters(this.getTunnelParams(), out, true);
        }
        out.endElement();
    }
}

