/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.writer2;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataComposite;
import ucar.ma2.StructureDataFromMember;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.Dimension;
import ucar.nc2.Structure;
import ucar.nc2.VariableSimpleBuilder;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.CF;
import ucar.nc2.dataset.conv.CF1Convention;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.ProfileFeature;
import ucar.nc2.ft.point.writer2.CFPointWriterConfig;
import ucar.nc2.ft.point.writer2.WriterCFPointAbstract;
import ucar.nc2.time.CalendarDateUnit;

class WriterCFProfileCollection
extends WriterCFPointAbstract {
    private Structure profileStruct;
    private HashSet<String> featureVarMap = new HashSet();
    private int profileRecno;
    private int obsRecno;

    WriterCFProfileCollection(String fileOut, AttributeContainer globalAtts, List<VariableSimpleIF> dataVars, CalendarDateUnit timeUnit, String altUnits, CFPointWriterConfig config) throws IOException {
        super(fileOut, globalAtts, dataVars, timeUnit, altUnits, config);
        this.writerb.addAttribute(new Attribute("DSG_representation", "Contiguous ragged array representation of profiles, H.3.4"));
        this.writerb.addAttribute(new Attribute("featureType", CF.FeatureType.profile.name()));
    }

    @Override
    void finishBuilding() throws IOException {
        super.finishBuilding();
        this.profileStruct = this.findStructure("profile");
    }

    int writeProfile(ProfileFeature profile) throws IOException {
        if (this.id_strlen == 0) {
            this.id_strlen = profile.getName().length() * 2;
        }
        int count = 0;
        for (PointFeature pf : profile) {
            this.writeObsData(pf);
            ++count;
        }
        this.writeProfileData(profile, count);
        return count;
    }

    protected void writeHeader(List<ProfileFeature> profiles) throws IOException {
        ArrayList<VariableSimpleIF> coords = new ArrayList<VariableSimpleIF>();
        ArrayList<StructureData> profileData = new ArrayList<StructureData>();
        for (ProfileFeature profile : profiles) {
            profileData.add(profile.getFeatureData());
            coords.add(VariableSimpleBuilder.makeScalar(profile.getTimeName(), "time of measurement", profile.getTimeUnit().getUdUnit(), DataType.DOUBLE).addAttribute("calendar", profile.getTimeUnit().getCalendar().toString()).build());
            if (!this.useAlt) continue;
            this.altitudeCoordinateName = profile.getAltName();
            coords.add(VariableSimpleBuilder.makeScalar(this.altitudeCoordinateName, "obs altitude", this.altUnits, DataType.DOUBLE).addAttribute("standard_name", "altitude").addAttribute("positive", CF1Convention.getZisPositive(this.altitudeCoordinateName, this.altUnits)).build());
        }
        super.writeHeader(coords, profiles, profileData, null);
    }

    @Override
    void makeFeatureVariables(List<StructureData> featureDataStruct, boolean isExtended) {
        Dimension profileDim = this.writerb.addDimension("profile", this.nfeatures);
        ArrayList<VariableSimpleIF> profileVars = new ArrayList<VariableSimpleIF>();
        profileVars.add(VariableSimpleBuilder.makeScalar("latitude", "profile latitude", "degrees_north", DataType.DOUBLE).build());
        profileVars.add(VariableSimpleBuilder.makeScalar("longitude", "profile longitude", "degrees_east", DataType.DOUBLE).build());
        profileVars.add(VariableSimpleBuilder.makeString("profileId", "profile identifier", null, this.id_strlen).addAttribute("cf_role", "profile_id").build());
        profileVars.add(VariableSimpleBuilder.makeScalar("nobs", "number of obs for this profile", null, DataType.INT).addAttribute("sample_dimension", "obs").build());
        profileVars.add(VariableSimpleBuilder.makeScalar("profileTime", "nominal time of profile", this.timeUnit.getUdUnit(), DataType.DOUBLE).addAttribute("calendar", this.timeUnit.getCalendar().toString()).build());
        for (StructureData featureData : featureDataStruct) {
            for (StructureMembers.Member m4 : featureData.getMembers()) {
                VariableSimpleIF dv = this.findDataVar(m4.getName());
                if (dv == null) continue;
                profileVars.add(dv);
            }
        }
        if (isExtended) {
            Structure.Builder structb = this.writerb.addStructure("profile", "profile");
            this.addCoordinatesExtended(structb, profileVars);
        } else {
            this.addCoordinatesClassic(profileDim, profileVars, this.featureVarMap);
        }
    }

    private void writeProfileData(ProfileFeature profile, int nobs) throws IOException {
        this.trackBB(profile.getLatLon(), profile.getTime());
        StructureMembers.Builder smb = StructureMembers.builder().setName("Coords");
        smb.addMemberScalar("latitude", null, null, DataType.DOUBLE, profile.getLatLon().getLatitude());
        smb.addMemberScalar("longitude", null, null, DataType.DOUBLE, profile.getLatLon().getLongitude());
        if (profile.getTime() != null) {
            smb.addMemberScalar("profileTime", null, null, DataType.DOUBLE, this.timeUnit.makeOffsetFromRefDate(profile.getTime()));
        }
        smb.addMemberString("profileId", null, null, profile.getName().trim(), this.id_strlen);
        smb.addMemberScalar("nobs", null, null, DataType.INT, nobs);
        StructureDataFromMember profileCoords = new StructureDataFromMember(smb.build());
        StructureDataComposite sdall = StructureDataComposite.create(ImmutableList.of(profileCoords, profile.getFeatureData()));
        this.profileRecno = super.writeStructureData(this.profileRecno, this.profileStruct, sdall, this.featureVarMap);
    }

    private void writeObsData(PointFeature pf) throws IOException {
        StructureMembers.Builder smb = StructureMembers.builder().setName("Coords");
        smb.addMemberScalar(pf.getFeatureCollection().getTimeName(), null, null, DataType.DOUBLE, pf.getObservationTime());
        if (this.useAlt) {
            smb.addMemberScalar(pf.getFeatureCollection().getAltName(), null, null, DataType.DOUBLE, pf.getLocation().getAltitude());
        }
        StructureDataFromMember coords = new StructureDataFromMember(smb.build());
        StructureDataComposite sdall = StructureDataComposite.create(ImmutableList.of(coords, pf.getFeatureData()));
        this.obsRecno = super.writeStructureData(this.obsRecno, this.record, sdall, this.dataMap);
    }
}

