/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.eds.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtility {
    private static Logger logger = LoggerFactory.getLogger(FileUtility.class);
    private Writer writer = null;
    private File file = null;

    public FileUtility(String fileName) {
        this.file = new File(fileName);
    }

    public boolean exists() {
        return this.file.exists();
    }

    public boolean mkdirs() {
        return this.file.mkdirs();
    }

    public String[] fileListing(final String strFilter) {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.contains(strFilter);
            }
        };
        String[] children = this.file.list(filter);
        return children;
    }

    public String readFile() throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(this.file));
        String line = null;
        StringBuilder stringBuilder = new StringBuilder();
        String ls = System.getProperty("line.separator");
        while ((line = reader.readLine()) != null) {
            stringBuilder.append(line);
            stringBuilder.append(ls);
        }
        return stringBuilder.toString();
    }

    public boolean openFileWriter() {
        try {
            this.writer = new BufferedWriter(new FileWriter(this.file));
            return true;
        }
        catch (IOException ioe) {
            logger.error("Exception opening file writer:", (Throwable)ioe);
            this.close();
            return false;
        }
    }

    public boolean writeln(String text) {
        try {
            this.writer.write(text + "\n");
            return true;
        }
        catch (IOException ioe) {
            logger.error("Error writing to file.", (Throwable)ioe);
            this.close();
            return false;
        }
    }

    public boolean write(String text) {
        try {
            this.writer.write(text);
            return true;
        }
        catch (IOException e) {
            logger.error("Error writing to file.", (Throwable)e);
            this.close();
            return false;
        }
    }

    public void close() {
        try {
            if (this.writer != null) {
                this.writer.flush();
                this.writer.close();
            }
        }
        catch (IOException e) {
            logger.error("Error closing file.", (Throwable)e);
        }
    }

    public boolean deleteFile() {
        return this.file.delete();
    }
}

