/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.metadata.nciso.util;

import com.google.common.escape.Escaper;
import com.google.common.html.HtmlEscapers;
import com.google.common.xml.XmlEscapers;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.client.catalog.Access;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.Documentation;
import thredds.client.catalog.Property;
import thredds.client.catalog.Service;
import thredds.client.catalog.ServiceType;
import thredds.client.catalog.ThreddsMetadata;
import thredds.server.metadata.nciso.bean.Extent;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;
import ucar.nc2.units.TimeDuration;

public class NCMLModifier {
    private static Logger logger = LoggerFactory.getLogger(NCMLModifier.class);
    private String _openDapService = null;
    private String _version = "2.4";
    private static DecimalFormat dFmt = new DecimalFormat(".#####");
    private Escaper xmlEscaper = XmlEscapers.xmlAttributeEscaper();
    private Escaper htmlEscaper = HtmlEscapers.htmlEscaper();

    public static String format(Double dbl) {
        return dFmt.format(dbl);
    }

    public void addCFMetadata(Extent ext, Element groupElem) {
        if (ext._minLon != null) {
            this.addElem(groupElem, "geospatial_lon_min", NCMLModifier.format(ext._minLon), "float");
        }
        if (ext._minLat != null) {
            this.addElem(groupElem, "geospatial_lat_min", NCMLModifier.format(ext._minLat), "float");
        }
        if (ext._maxLon != null) {
            this.addElem(groupElem, "geospatial_lon_max", NCMLModifier.format(ext._maxLon), "float");
        }
        if (ext._maxLat != null) {
            this.addElem(groupElem, "geospatial_lat_max", NCMLModifier.format(ext._maxLat), "float");
        }
        if (ext._lonUnits != null) {
            this.addElem(groupElem, "geospatial_lon_units", ext._lonUnits);
        }
        if (ext._latUnits != null) {
            this.addElem(groupElem, "geospatial_lat_units", ext._latUnits);
        }
        if (ext._lonRes != null) {
            this.addElem(groupElem, "geospatial_lon_resolution", ext._lonRes.toString());
        }
        if (ext._latRes != null) {
            this.addElem(groupElem, "geospatial_lat_resolution", ext._latRes.toString());
        }
        if (ext._minHeight != null) {
            this.addElem(groupElem, "geospatial_vertical_min", ext._minHeight.toString());
        }
        if (ext._maxHeight != null) {
            this.addElem(groupElem, "geospatial_vertical_max", ext._maxHeight.toString());
        }
        if (ext._heightUnits != null) {
            this.addElem(groupElem, "geospatial_vertical_units", ext._heightUnits);
        }
        if (ext._heightRes != null) {
            this.addElem(groupElem, "geospatial_vertical_resolution", ext._heightRes.toString());
        }
        if (ext._vOrientation != null) {
            this.addElem(groupElem, "geospatial_vertical_positive", ext._vOrientation);
        }
        if (ext._minTime != null) {
            this.addElem(groupElem, "time_coverage_start", ext._minTime.toString());
        }
        if (ext._maxTime != null) {
            this.addElem(groupElem, "time_coverage_end", ext._maxTime.toString());
        }
        if (ext._timeUnits != null) {
            this.addElem(groupElem, "time_coverage_units", ext._timeUnits.toString());
        }
        if (ext._timeRes != null) {
            this.addElem(groupElem, "time_coverage_resolution", ext._timeRes.toString());
        }
        if (ext._timeRes != null) {
            this.addElem(groupElem, "time_coverage_duration", ext._timeDuration.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addThreddsMetadata(Dataset ids, Element groupElem) throws Exception {
        List<Property> props;
        List<ThreddsMetadata.MetadataOther> metadata;
        DateRange dateRange;
        ThreddsMetadata.GeospatialCoverage geospatialCoverage;
        List<ThreddsMetadata.VariableGroup> list;
        List<ThreddsMetadata.Source> list2;
        List<ThreddsMetadata.Source> list3;
        List<ThreddsMetadata.Vocab> list4;
        List<DateType> list5;
        List<ThreddsMetadata.Vocab> list6;
        List<ThreddsMetadata.Contributor> contributors;
        List<Access> access;
        List<Documentation> docs;
        if (ids == null) {
            return;
        }
        if (ids.getID() != null) {
            this.addElem(groupElem, "id", ids.getID());
        }
        if (ids.getName() != null) {
            this.addElem(groupElem, "full_name", ids.getName());
        }
        if (ids.getDataFormatType() != null) {
            this.addElem(groupElem, "data_format_type", this.xmlEscaper.escape(ids.getDataFormatType().toString()));
        }
        if (ids.getDataFormatType() != null && ids.getFeatureType() != FeatureType.ANY) {
            this.addElem(groupElem, "data_type", this.xmlEscaper.escape(ids.getDataFormatName()));
        }
        if (ids.getCollectionType() != null) {
            this.addElem(groupElem, "collection_type", this.xmlEscaper.escape(ids.getCollectionType().toString()));
        }
        if (ids.getAuthority() != null) {
            this.addElem(groupElem, "authority", this.xmlEscaper.escape(ids.getAuthority()));
        }
        if ((docs = ids.getDocumentation()).size() > 0) {
            Element docsGrp = this.doAddGroupElem(groupElem, "documentation");
            for (Documentation documentation : docs) {
                void var9_30;
                Element element = this.doAddGroupElem(docsGrp, "document");
                String string = documentation.getType() == null ? "" : this.xmlEscaper.escape(documentation.getType());
                String string2 = documentation.getInlineContent();
                Object var10_45 = null;
                Object var11_67 = null;
                if (string2 != null && string2.length() > 0) {
                    String string3 = this.xmlEscaper.escape(string2);
                }
                this.addElem(element, "inline", (String)var9_30, string);
                if (!documentation.hasXlink()) continue;
                String string4 = documentation.getXlinkHref();
                String string5 = documentation.getXlinkTitle();
                this.addElem(element, "xlink", string4, string);
            }
        }
        if ((access = ids.getAccess()).size() > 0) {
            Element servicesGrp = this.doAddGroupElem(groupElem, "services");
            for (Access access2 : access) {
                String string;
                Service service = access2.getService();
                String string6 = string = access2.getStandardUrlName();
                ServiceType serviceType = service.getType();
                logger.debug("THREDDS service type=" + String.valueOf((Object)serviceType));
                if (serviceType == ServiceType.OPENDAP || serviceType == ServiceType.DODS) {
                    this.addElem(servicesGrp, "opendap_service", string6);
                    this._openDapService = string6;
                    continue;
                }
                if (serviceType == ServiceType.HTTPServer) {
                    this.addElem(servicesGrp, "httpserver_service", string6);
                    continue;
                }
                if (serviceType == ServiceType.WCS) {
                    String string7 = string6 + "?service=WCS&version=1.0.0&request=GetCapabilities";
                    this.addElem(servicesGrp, "wcs_service", string7);
                    continue;
                }
                if (serviceType == ServiceType.WMS) {
                    String string8 = string6 + "?service=WMS&version=1.3.0&request=GetCapabilities";
                    this.addElem(servicesGrp, "wms_service", string8);
                    continue;
                }
                if (serviceType == ServiceType.NetcdfSubset) {
                    String string9 = string6 + "/dataset.html";
                    this.addElem(servicesGrp, "nccs_service", string9);
                    continue;
                }
                if (serviceType == ServiceType.CdmRemote || serviceType == ServiceType.CdmrFeature) {
                    String string10 = string6 + "?req=form";
                    this.addElem(servicesGrp, "cdmremote_service", string10);
                    continue;
                }
                if (!serviceType.toString().equals("SOS")) continue;
                String string11 = string6 + "?service=SOS&version=1.0.0&request=GetCapabilities";
                this.addElem(servicesGrp, "sos_service", string11);
            }
        }
        if ((contributors = ids.getContributors()).size() > 0) {
            Element element = this.doAddGroupElem(groupElem, "contributors");
            for (ThreddsMetadata.Contributor contributor : contributors) {
                Element element2 = this.doAddGroupElem(element, "contributor");
                String string = contributor.getRole() == null ? "" : this.htmlEscaper.escape(contributor.getRole());
                this.addElem(element2, "role", string);
                String string12 = contributor.getName() == null ? "" : this.xmlEscaper.escape(contributor.getName());
                this.addElem(element2, "name", string12);
            }
        }
        if ((list6 = ids.getKeywords()).size() > 0) {
            Element element = this.doAddGroupElem(groupElem, "keywords");
            for (ThreddsMetadata.Vocab vocab : list6) {
                String string = vocab.getVocabulary() == null ? "" : this.xmlEscaper.escape(vocab.getVocabulary());
                String string13 = this.xmlEscaper.escape(vocab.getText());
                this.addElem(element, "keyword", string13);
                if (string.equals("")) continue;
                this.addElem(element, "vocab", string);
            }
        }
        if ((list5 = ids.getDates()).size() > 0) {
            Element element = this.doAddGroupElem(groupElem, "dates");
            for (DateType dateType : list5) {
                String string = dateType.getType() == null ? "" : this.xmlEscaper.escape(dateType.getType());
                String string14 = this.xmlEscaper.escape(dateType.getText());
                this.addElem(element, "date", string14, string);
            }
        }
        if ((list4 = ids.getProjects()).size() > 0) {
            Element element = this.doAddGroupElem(groupElem, "projects");
            for (ThreddsMetadata.Vocab vocab : list4) {
                String string = vocab.getVocabulary() == null ? "" : this.xmlEscaper.escape(vocab.getVocabulary());
                String string15 = this.xmlEscaper.escape(vocab.getText());
                this.addElem(element, "project", string15);
                if (string.equals("")) continue;
                this.addElem(element, "vocab", string);
            }
        }
        if ((list3 = ids.getCreators()).size() > 0) {
            Element element = this.doAddGroupElem(groupElem, "creators");
            for (ThreddsMetadata.Source source : list3) {
                Element element3 = this.doAddGroupElem(element, "creator");
                String name = this.xmlEscaper.escape(source.getName());
                String email = this.xmlEscaper.escape(source.getEmail());
                String url = source.getUrl() != null ? "" : source.getUrl();
                this.addElem(element3, "name", name);
                this.addElem(element3, "email", email);
                this.addElem(element3, "url", url);
            }
        }
        if ((list2 = ids.getPublishers()).size() > 0) {
            Element element = this.doAddGroupElem(groupElem, "publishers");
            for (ThreddsMetadata.Source source : list2) {
                Element publisherGrp = this.doAddGroupElem(element, "publisher");
                String name = this.xmlEscaper.escape(source.getName());
                String email = this.xmlEscaper.escape(source.getEmail());
                String url = source.getUrl() != null ? "" : source.getUrl();
                this.addElem(publisherGrp, "name", name);
                this.addElem(publisherGrp, "email", email);
                this.addElem(publisherGrp, "url", url);
            }
        }
        if ((list = ids.getVariables()).size() > 0) {
            for (ThreddsMetadata.VariableGroup variableGroup : list) {
                String uri = variableGroup.getVocabUri() == null ? "" : variableGroup.getVocabUri().toString();
                this.addElem(groupElem, "standard_name_vocabulary", variableGroup.getVocabulary(), uri);
            }
        }
        if ((geospatialCoverage = ids.getGeospatialCoverage()) != null && geospatialCoverage.isValid()) {
            List<ThreddsMetadata.Vocab> list7;
            this.addElem(groupElem, "geospatial_lon_min", Double.toString(geospatialCoverage.getBoundingBox().getLonMin()));
            this.addElem(groupElem, "geospatial_lat_min", Double.toString(geospatialCoverage.getBoundingBox().getLatMin()));
            this.addElem(groupElem, "geospatial_lon_max", Double.toString(geospatialCoverage.getBoundingBox().getLonMax()));
            this.addElem(groupElem, "geospatial_lat_max", Double.toString(geospatialCoverage.getBoundingBox().getLatMax()));
            if (geospatialCoverage.getUpDownRange() != null) {
                double d = 0.0;
                double maxHeight = 0.0;
                if (geospatialCoverage.isZPositiveUp()) {
                    d = geospatialCoverage.getHeightStart();
                    maxHeight = d + geospatialCoverage.getHeightExtent();
                } else {
                    d = geospatialCoverage.getHeightStart() * -1.0;
                    maxHeight = d - geospatialCoverage.getHeightExtent();
                }
                double heightRes = geospatialCoverage.getHeightResolution();
                String heightUnits = geospatialCoverage.getUpDownRange().getUnits();
                this.addElem(groupElem, "geospatial_vertical_min", Double.toString(d));
                this.addElem(groupElem, "geospatial_vertical_max", Double.toString(maxHeight));
                if (heightUnits != null) {
                    this.addElem(groupElem, "geospatial_vertical_units", heightUnits);
                }
                this.addElem(groupElem, "geospatial_vertical_resolution", Double.toString(heightRes));
                this.addElem(groupElem, "geospatial_vertical_positive", geospatialCoverage.getZPositive());
            }
            if ((list7 = geospatialCoverage.getNames()) != null && list7.size() > 0) {
                Element vocabGrp = this.doAddGroupElem(groupElem, "vocab");
                for (ThreddsMetadata.Vocab elem : list7) {
                    this.addElem(vocabGrp, "name", this.xmlEscaper.escape(elem.getText()));
                }
            }
        }
        if ((dateRange = ids.getTimeCoverage()) != null) {
            DateType end;
            DateType start = dateRange.getStart();
            if (start != null && !start.isBlank()) {
                this.addElem(groupElem, "time_coverage_start", start.toDateTimeString());
            }
            if ((end = dateRange.getEnd()) != null && !end.isBlank()) {
                this.addElem(groupElem, "time_coverage_end", end.toDateTimeString());
            }
            TimeDuration resolution = dateRange.getResolution();
            if (dateRange.useResolution() && resolution != null && !resolution.isBlank()) {
                this.addElem(groupElem, "time_coverage_resolution", this.xmlEscaper.escape(resolution.toString()));
            }
            TimeDuration duration = dateRange.getDuration();
            if (dateRange.useDuration() && duration != null && !duration.isBlank()) {
                this.addElem(groupElem, "time_coverage_duration", this.xmlEscaper.escape(duration.toString()));
            }
        }
        if ((metadata = ids.getMetadataOther()).size() > 0) {
            Element metaGrp = this.doAddGroupElem(groupElem, "metadata");
            for (ThreddsMetadata.MetadataOther m : metadata) {
                String type = m.getType() == null ? "" : m.getType();
                Object title = m.getTitle() == null ? "Type " + type : m.getTitle();
                this.addElem(metaGrp, (String)title, m.getXlinkHref());
            }
        }
        if ((props = ids.getProperties()).size() > 0) {
            Element propsGrp = this.doAddGroupElem(groupElem, "properties");
            for (Property p : props) {
                this.addElem(propsGrp, p.getName(), p.getValue());
            }
        }
    }

    public void addNcIsoMetadata(Element groupElem) {
        Date dateStamp = Calendar.getInstance().getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String metadata_creation_date = sdf.format(dateStamp);
        this.addElem(groupElem, "metadata_creation", metadata_creation_date);
        this.addElem(groupElem, "nciso_version", this.getVersion());
    }

    String getVersion() {
        try {
            Properties properties = new Properties();
            properties.load(this.getClass().getClassLoader().getResourceAsStream("project.properties"));
            String version = properties.getProperty("version");
            return version == null ? this._version : version;
        }
        catch (IOException e) {
            return this._version;
        }
    }

    private Element newGroupElement() {
        return new Element("group");
    }

    private Element newAttributeElement() {
        return new Element("attribute");
    }

    public Element doAddGroupElem(Element rootElem, String name) {
        Namespace ns = Namespace.getNamespace("http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2");
        Element groupElem = this.newGroupElement();
        groupElem.setAttribute("name", name);
        groupElem.setNamespace(ns);
        rootElem.addContent(groupElem);
        return groupElem;
    }

    private void doAddElem(Element groupElem, String name, String value, String type) {
        Namespace ns = Namespace.getNamespace("http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2");
        Element elem = this.newAttributeElement();
        elem.setAttribute("name", name);
        elem.setAttribute("value", value);
        if (type != null) {
            elem.setAttribute("type", type);
        }
        elem.setNamespace(ns);
        groupElem.addContent(elem);
    }

    private void addElem(Element rootElem, String name, String value) {
        this.doAddElem(rootElem, name, value, null);
    }

    private void addElem(Element rootElem, String name, String value, String type) {
        this.doAddElem(rootElem, name, value, type);
    }

    public String getOpenDapService() {
        return this._openDapService;
    }
}

